/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.deps.ModuleResolver;
import javax.annotation.Nullable;

public class LegacyModuleResolver
extends ModuleResolver {
    public LegacyModuleResolver(ImmutableSet<String> modulePaths, ImmutableList<String> moduleRootPaths, ErrorHandler errorHandler) {
        super(modulePaths, moduleRootPaths, errorHandler);
    }

    @Override
    @Nullable
    public String resolveJsModule(String scriptAddress, String moduleAddress, String sourcename, int lineno, int colno) {
        String loadAddress;
        if (!moduleAddress.endsWith(".js")) {
            moduleAddress = moduleAddress + ".js";
        }
        if ((loadAddress = this.locate(scriptAddress, moduleAddress)) == null) {
            this.errorHandler.report(CheckLevel.WARNING, JSError.make(sourcename, lineno, colno, ModuleLoader.LOAD_WARNING, moduleAddress));
            return this.canonicalizePath(scriptAddress, moduleAddress);
        }
        return loadAddress;
    }
}

