/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.rhino.FunctionTypeI;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ObjectTypeI;
import com.google.javascript.rhino.TypeI;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

class TypeMismatch
implements Serializable {
    final TypeI typeA;
    final TypeI typeB;
    final JSError src;

    TypeMismatch(TypeI a, TypeI b, JSError src) {
        this.typeA = a;
        this.typeB = b;
        this.src = src;
    }

    static void registerIfMismatch(List<TypeMismatch> mismatches, List<TypeMismatch> implicitInterfaceUses, TypeI found, TypeI required, JSError error) {
        if (found != null && required != null && !found.isSubtypeWithoutStructuralTyping(required)) {
            TypeMismatch.registerMismatch(mismatches, implicitInterfaceUses, found, required, error);
        }
    }

    static void registerMismatch(List<TypeMismatch> mismatches, List<TypeMismatch> implicitInterfaceUses, TypeI found, TypeI required, JSError error) {
        if ((found = TypeMismatch.removeNullUndefinedAndTemplates(found)).isSubtypeOf(required = TypeMismatch.removeNullUndefinedAndTemplates(required)) || required.isSubtypeOf(found)) {
            boolean strictMismatch;
            boolean bl = strictMismatch = !found.isSubtypeWithoutStructuralTyping(required) && !required.isSubtypeWithoutStructuralTyping(found);
            if (strictMismatch) {
                implicitInterfaceUses.add(new TypeMismatch(found, required, error));
            }
            return;
        }
        mismatches.add(new TypeMismatch(found, required, error));
        if (found.isFunctionType() && required.isFunctionType()) {
            FunctionTypeI fnTypeA = found.toMaybeFunctionType();
            FunctionTypeI fnTypeB = required.toMaybeFunctionType();
            Iterator<TypeI> paramItA = fnTypeA.getParameterTypes().iterator();
            Iterator<TypeI> paramItB = fnTypeB.getParameterTypes().iterator();
            while (paramItA.hasNext() && paramItB.hasNext()) {
                TypeMismatch.registerIfMismatch(mismatches, implicitInterfaceUses, paramItA.next(), paramItB.next(), error);
            }
            TypeMismatch.registerIfMismatch(mismatches, implicitInterfaceUses, fnTypeA.getReturnType(), fnTypeB.getReturnType(), error);
        }
    }

    static void recordImplicitUseOfNativeObject(List<TypeMismatch> mismatches, Node src, TypeI sourceType, TypeI targetType) {
        sourceType = sourceType.restrictByNotNullOrUndefined();
        targetType = targetType.restrictByNotNullOrUndefined();
        if (sourceType.isInstanceofObject() && !targetType.isInstanceofObject() && !targetType.isUnknownType()) {
            String msg = "Implicit use of Object type: " + sourceType + " as type: " + targetType;
            JSError err = JSError.make(src, TypeValidator.TYPE_MISMATCH_WARNING, msg);
            mismatches.add(new TypeMismatch(sourceType, targetType, err));
        }
    }

    static void recordImplicitInterfaceUses(List<TypeMismatch> implicitInterfaceUses, Node src, TypeI sourceType, TypeI targetType) {
        boolean mismatch;
        sourceType = TypeMismatch.removeNullUndefinedAndTemplates(sourceType);
        if ((targetType = TypeMismatch.removeNullUndefinedAndTemplates(targetType)).isUnknownType()) {
            return;
        }
        boolean strictMismatch = !sourceType.isSubtypeWithoutStructuralTyping(targetType) && !targetType.isSubtypeWithoutStructuralTyping(sourceType);
        boolean bl = mismatch = !sourceType.isSubtypeOf(targetType) && !targetType.isSubtypeOf(sourceType);
        if (strictMismatch || mismatch) {
            JSError err = JSError.make(src, TypeValidator.TYPE_MISMATCH_WARNING, "");
            implicitInterfaceUses.add(new TypeMismatch(sourceType, targetType, err));
        }
    }

    private static TypeI removeNullUndefinedAndTemplates(TypeI t) {
        TypeI result = t.restrictByNotNullOrUndefined();
        ObjectTypeI obj = result.toMaybeObjectType();
        if (obj != null && obj.isGenericObjectType()) {
            return obj.instantiateGenericsWithUnknown();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof TypeMismatch) {
            TypeMismatch that = (TypeMismatch)object;
            return that.typeA.equals(this.typeA) && that.typeB.equals(this.typeB) || that.typeB.equals(this.typeA) && that.typeA.equals(this.typeB);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.typeA, this.typeB);
    }

    public String toString() {
        return "(" + this.typeA + ", " + this.typeB + ")";
    }
}

