/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

class StripCode
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Set<String> stripTypes;
    private final Set<String> stripNameSuffixes;
    private final Set<String> stripTypePrefixes;
    private final Set<String> stripNamePrefixes;
    private final Set<Var> varsToRemove;
    static final DiagnosticType STRIP_TYPE_INHERIT_ERROR = DiagnosticType.error("JSC_STRIP_TYPE_INHERIT_ERROR", "Non-strip type {0} cannot inherit from strip type {1}");
    static final DiagnosticType STRIP_ASSIGNMENT_ERROR = DiagnosticType.error("JSC_STRIP_ASSIGNMENT_ERROR", "Unable to strip assignment to {0}");

    StripCode(AbstractCompiler compiler, Set<String> stripTypes, Set<String> stripNameSuffixes, Set<String> stripTypePrefixes, Set<String> stripNamePrefixes) {
        this.compiler = compiler;
        this.stripTypes = new HashSet<String>(stripTypes);
        this.stripNameSuffixes = new HashSet<String>(stripNameSuffixes);
        this.stripTypePrefixes = new HashSet<String>(stripTypePrefixes);
        this.stripNamePrefixes = new HashSet<String>(stripNamePrefixes);
        this.varsToRemove = new HashSet<Var>();
    }

    public void enableTweakStripping() {
        this.stripTypes.add("goog.tweak");
    }

    @Override
    public void process(Node externs, Node root) {
        for (String type : this.stripTypes) {
            this.stripTypePrefixes.add(type + ".");
        }
        NodeTraversal.traverseEs6(this.compiler, root, new Strip());
    }

    private class Strip
    extends NodeTraversal.AbstractPostOrderCallback {
        private Strip() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case VAR: {
                    this.removeVarDeclarationsByNameOrRvalue(t, n, parent);
                    break;
                }
                case NAME: {
                    this.maybeRemoveReferenceToRemovedVariable(t, n, parent);
                    break;
                }
                case ASSIGN: 
                case ASSIGN_BITOR: 
                case ASSIGN_BITXOR: 
                case ASSIGN_BITAND: 
                case ASSIGN_LSH: 
                case ASSIGN_RSH: 
                case ASSIGN_URSH: 
                case ASSIGN_ADD: 
                case ASSIGN_SUB: 
                case ASSIGN_MUL: 
                case ASSIGN_DIV: 
                case ASSIGN_MOD: {
                    this.maybeEliminateAssignmentByLvalueName(t, n, parent);
                    break;
                }
                case CALL: 
                case NEW: {
                    this.maybeRemoveCall(t, n, parent);
                    break;
                }
                case OBJECTLIT: {
                    this.eliminateKeysWithStripNamesFromObjLit(t, n);
                    break;
                }
                case EXPR_RESULT: {
                    this.maybeEliminateExpressionByName(t, n, parent);
                    break;
                }
            }
        }

        void removeVarDeclarationsByNameOrRvalue(NodeTraversal t, Node n, Node parent) {
            Node next = null;
            Node nameNode = n.getFirstChild();
            while (nameNode != null) {
                next = nameNode.getNext();
                String name = nameNode.getString();
                if (this.isStripName(name) || this.isCallWhoseReturnValueShouldBeStripped(nameNode.getFirstChild())) {
                    Scope scope = t.getScope();
                    StripCode.this.varsToRemove.add(scope.getVar(name));
                    n.removeChild(nameNode);
                    t.reportCodeChange();
                }
                nameNode = next;
            }
            if (!n.hasChildren()) {
                this.replaceWithEmpty(n, parent);
                t.reportCodeChange();
            }
        }

        void maybeRemoveReferenceToRemovedVariable(NodeTraversal t, Node n, Node parent) {
            switch (parent.getToken()) {
                case VAR: {
                    break;
                }
                case GETPROP: 
                case GETELEM: {
                    if (parent.getFirstChild() != n || !this.isReferenceToRemovedVar(t, n)) break;
                    this.replaceHighestNestedCallWithNull(t, parent, parent.getParent());
                    break;
                }
                case ASSIGN: 
                case ASSIGN_BITOR: 
                case ASSIGN_BITXOR: 
                case ASSIGN_BITAND: 
                case ASSIGN_LSH: 
                case ASSIGN_RSH: 
                case ASSIGN_URSH: 
                case ASSIGN_ADD: 
                case ASSIGN_SUB: 
                case ASSIGN_MUL: 
                case ASSIGN_DIV: 
                case ASSIGN_MOD: {
                    if (!this.isReferenceToRemovedVar(t, n)) break;
                    if (parent.getFirstChild() == n) {
                        Node grandparent = parent.getParent();
                        if (grandparent.isExprResult()) {
                            Node greatGrandparent = grandparent.getParent();
                            this.replaceWithEmpty(grandparent, greatGrandparent);
                            t.reportCodeChange();
                            break;
                        }
                        Node rvalue = n.getNext();
                        parent.removeChild(rvalue);
                        grandparent.replaceChild(parent, rvalue);
                        t.reportCodeChange();
                        break;
                    }
                    this.replaceWithNull(n, parent);
                    t.reportCodeChange();
                    break;
                }
                default: {
                    if (!this.isReferenceToRemovedVar(t, n)) break;
                    this.replaceWithNull(n, parent);
                    t.reportCodeChange();
                }
            }
        }

        void replaceHighestNestedCallWithNull(NodeTraversal t, Node node, Node parent) {
            Node ancestor = parent;
            Node ancestorChild = node;
            while (true) {
                Node ancestorParent = ancestor.getParent();
                if (ancestor.getFirstChild() != ancestorChild) {
                    this.replaceWithNull(ancestorChild, ancestor);
                    break;
                }
                if (ancestor.isExprResult()) {
                    this.replaceWithEmpty(ancestor, ancestorParent);
                    break;
                }
                if (ancestor.isAssign()) {
                    ancestorParent.replaceChild(ancestor, ancestor.getLastChild().detach());
                    break;
                }
                if (!NodeUtil.isGet(ancestor) && !ancestor.isCall()) {
                    this.replaceWithNull(ancestorChild, ancestor);
                    break;
                }
                ancestorChild = ancestor;
                ancestor = ancestorParent;
            }
            t.reportCodeChange();
        }

        void maybeEliminateAssignmentByLvalueName(NodeTraversal t, Node n, Node parent) {
            Node lvalue = n.getFirstChild();
            if (this.nameIncludesFieldNameToStrip(lvalue) || this.qualifiedNameBeginsWithStripType(lvalue)) {
                if (parent.isExprResult()) {
                    Node grandparent = parent.getParent();
                    this.replaceWithEmpty(parent, grandparent);
                    StripCode.this.compiler.reportChangeToEnclosingScope(grandparent);
                } else {
                    t.report(n, STRIP_ASSIGNMENT_ERROR, lvalue.getQualifiedName());
                }
            }
        }

        void maybeEliminateExpressionByName(NodeTraversal t, Node n, Node parent) {
            Node expression = n.getFirstChild();
            if (this.nameIncludesFieldNameToStrip(expression) || this.qualifiedNameBeginsWithStripType(expression)) {
                if (parent.isExprResult()) {
                    Node grandparent = parent.getParent();
                    this.replaceWithEmpty(parent, grandparent);
                    StripCode.this.compiler.reportChangeToEnclosingScope(grandparent);
                } else {
                    this.replaceWithEmpty(n, parent);
                    StripCode.this.compiler.reportChangeToEnclosingScope(parent);
                }
            }
        }

        void maybeRemoveCall(NodeTraversal t, Node n, Node parent) {
            if (this.isMethodOrCtorCallThatTriggersRemoval(t, n, parent)) {
                this.replaceHighestNestedCallWithNull(t, n, parent);
            }
        }

        void eliminateKeysWithStripNamesFromObjLit(NodeTraversal t, Node n) {
            Node key = n.getFirstChild();
            while (key != null) {
                if (this.isStripName(key.getString())) {
                    Node next = key.getNext();
                    n.removeChild(key);
                    NodeUtil.markFunctionsDeleted(key, StripCode.this.compiler);
                    key = next;
                    StripCode.this.compiler.reportChangeToEnclosingScope(n);
                    continue;
                }
                key = key.getNext();
            }
        }

        boolean isCallWhoseReturnValueShouldBeStripped(@Nullable Node n) {
            return !(n == null || !n.isCall() && !n.isNew() || !n.hasChildren() || !this.qualifiedNameBeginsWithStripType(n.getFirstChild()) && !this.nameIncludesFieldNameToStrip(n.getFirstChild()));
        }

        boolean qualifiedNameBeginsWithStripType(Node n) {
            String name = n.getQualifiedName();
            return this.qualifiedNameBeginsWithStripType(name);
        }

        boolean qualifiedNameBeginsWithStripType(String name) {
            if (name != null) {
                for (String type : StripCode.this.stripTypes) {
                    if (!name.equals(type)) continue;
                    return true;
                }
                for (String type : StripCode.this.stripTypePrefixes) {
                    if (!name.startsWith(type)) continue;
                    return true;
                }
            }
            return false;
        }

        boolean isReferenceToRemovedVar(NodeTraversal t, Node n) {
            String name = n.getString();
            Scope scope = t.getScope();
            Var var = scope.getVar(name);
            return StripCode.this.varsToRemove.contains(var);
        }

        boolean isMethodOrCtorCallThatTriggersRemoval(NodeTraversal t, Node n, Node parent) {
            Node grandparent;
            Node function = n.getFirstChild();
            if (function == null || !function.isGetProp()) {
                return false;
            }
            if (parent != null && parent.isName() && (grandparent = parent.getParent()) != null && grandparent.isVar()) {
                return false;
            }
            Node callee = function.getFirstChild();
            return this.nameIncludesFieldNameToStrip(callee) || this.nameIncludesFieldNameToStrip(function) || this.qualifiedNameBeginsWithStripType(function) || this.actsOnStripType(t, n);
        }

        boolean nameIncludesFieldNameToStrip(@Nullable Node n) {
            if (n != null && n.isGetProp()) {
                Node propNode = n.getLastChild();
                return this.isStripName(propNode.getString()) || this.nameIncludesFieldNameToStrip(n.getFirstChild());
            }
            return false;
        }

        private boolean actsOnStripType(NodeTraversal t, Node callNode) {
            CodingConvention.SubclassRelationship classes = StripCode.this.compiler.getCodingConvention().getClassesDefinedByCall(callNode);
            if (classes != null) {
                if (this.qualifiedNameBeginsWithStripType(classes.subclassName)) {
                    return true;
                }
                if (this.qualifiedNameBeginsWithStripType(classes.superclassName)) {
                    t.report(callNode, STRIP_TYPE_INHERIT_ERROR, classes.subclassName, classes.superclassName);
                }
            }
            return false;
        }

        boolean isStripName(String name) {
            if (StripCode.this.stripNameSuffixes.contains(name) || StripCode.this.stripNamePrefixes.contains(name)) {
                return true;
            }
            if (name.isEmpty() || Character.isUpperCase(name.charAt(0))) {
                return false;
            }
            String lcName = name.toLowerCase();
            for (String stripName : StripCode.this.stripNamePrefixes) {
                if (!lcName.startsWith(stripName.toLowerCase())) continue;
                return true;
            }
            for (String stripName : StripCode.this.stripNameSuffixes) {
                if (!lcName.endsWith(stripName.toLowerCase())) continue;
                return true;
            }
            return false;
        }

        void replaceWithNull(Node n, Node parent) {
            parent.replaceChild(n, IR.nullNode());
        }

        void replaceWithEmpty(Node n, Node parent) {
            NodeUtil.removeChild(parent, n);
            NodeUtil.markFunctionsDeleted(n, StripCode.this.compiler);
        }
    }
}

