/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeI;
import java.util.HashSet;

class StrictModeCheck
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType USE_OF_WITH = DiagnosticType.warning("JSC_USE_OF_WITH", "The 'with' statement cannot be used in strict mode.");
    static final DiagnosticType EVAL_DECLARATION = DiagnosticType.warning("JSC_EVAL_DECLARATION", "\"eval\" cannot be redeclared in strict mode");
    static final DiagnosticType EVAL_ASSIGNMENT = DiagnosticType.warning("JSC_EVAL_ASSIGNMENT", "the \"eval\" object cannot be reassigned in strict mode");
    static final DiagnosticType ARGUMENTS_DECLARATION = DiagnosticType.warning("JSC_ARGUMENTS_DECLARATION", "\"arguments\" cannot be redeclared in strict mode");
    static final DiagnosticType ARGUMENTS_ASSIGNMENT = DiagnosticType.warning("JSC_ARGUMENTS_ASSIGNMENT", "the \"arguments\" object cannot be reassigned in strict mode");
    static final DiagnosticType ARGUMENTS_CALLEE_FORBIDDEN = DiagnosticType.warning("JSC_ARGUMENTS_CALLEE_FORBIDDEN", "\"arguments.callee\" cannot be used in strict mode");
    static final DiagnosticType ARGUMENTS_CALLER_FORBIDDEN = DiagnosticType.warning("JSC_ARGUMENTS_CALLER_FORBIDDEN", "\"arguments.caller\" cannot be used in strict mode");
    static final DiagnosticType FUNCTION_CALLER_FORBIDDEN = DiagnosticType.warning("JSC_FUNCTION_CALLER_FORBIDDEN", "A function''s \"caller\" property cannot be used in strict mode");
    static final DiagnosticType FUNCTION_ARGUMENTS_PROP_FORBIDDEN = DiagnosticType.warning("JSC_FUNCTION_ARGUMENTS_PROP_FORBIDDEN", "A function''s \"arguments\" property cannot be used in strict mode");
    static final DiagnosticType DELETE_VARIABLE = DiagnosticType.warning("JSC_DELETE_VARIABLE", "variables, functions, and arguments cannot be deleted in strict mode");
    static final DiagnosticType DUPLICATE_OBJECT_KEY = DiagnosticType.error("JSC_DUPLICATE_OBJECT_KEY", "Object literal contains illegal duplicate key \"{0}\", disallowed in strict mode");
    static final DiagnosticType DUPLICATE_CLASS_METHODS = DiagnosticType.error("JSC_DUPLICATE_CLASS_METHODS", "Class contain duplicate method name \"{0}\"");
    static final DiagnosticType BAD_FUNCTION_DECLARATION = DiagnosticType.error("JSC_BAD_FUNCTION_DECLARATION", "functions can only be declared at top level or immediately within another function in strict mode");
    private final AbstractCompiler compiler;

    StrictModeCheck(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseRootsEs6(this.compiler, this, externs, root);
        NodeTraversal.traverseEs6(this.compiler, root, new NonExternChecks());
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isFunction()) {
            StrictModeCheck.checkFunctionUse(t, n);
        } else if (n.isAssign()) {
            StrictModeCheck.checkAssignment(t, n);
        } else if (n.isDelProp()) {
            StrictModeCheck.checkDelete(t, n);
        } else if (n.isObjectLit()) {
            StrictModeCheck.checkObjectLiteralOrClass(t, n);
        } else if (n.isClass()) {
            StrictModeCheck.checkObjectLiteralOrClass(t, n.getLastChild());
        } else if (n.isWith()) {
            StrictModeCheck.checkWith(t, n);
        }
    }

    private static void checkWith(NodeTraversal t, Node n) {
        boolean allowWith;
        JSDocInfo info = n.getJSDocInfo();
        boolean bl = allowWith = info != null && info.getSuppressions().contains("with");
        if (!allowWith) {
            t.report(n, USE_OF_WITH, new String[0]);
        }
    }

    private static void checkFunctionUse(NodeTraversal t, Node n) {
        if (NodeUtil.isFunctionDeclaration(n) && !NodeUtil.isHoistedFunctionDeclaration(n)) {
            t.report(n, BAD_FUNCTION_DECLARATION, new String[0]);
        }
    }

    private static boolean isDeclaration(Node n) {
        switch (n.getParent().getToken()) {
            case LET: 
            case CONST: 
            case VAR: 
            case FUNCTION: 
            case CATCH: {
                return true;
            }
            case PARAM_LIST: {
                return n.getGrandparent().isFunction();
            }
        }
        return false;
    }

    private static void checkAssignment(NodeTraversal t, Node n) {
        if (n.getFirstChild().isName()) {
            if ("arguments".equals(n.getFirstChild().getString())) {
                t.report(n, ARGUMENTS_ASSIGNMENT, new String[0]);
            } else if ("eval".equals(n.getFirstChild().getString())) {
                t.report(n, EVAL_ASSIGNMENT, new String[0]);
            }
        }
    }

    private static void checkDelete(NodeTraversal t, Node n) {
        Var v;
        if (n.getFirstChild().isName() && (v = t.getScope().getVar(n.getFirstChild().getString())) != null) {
            t.report(n, DELETE_VARIABLE, new String[0]);
        }
    }

    private static void checkObjectLiteralOrClass(NodeTraversal t, Node n) {
        HashSet<String> getters = new HashSet<String>();
        HashSet<String> setters = new HashSet<String>();
        for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
            String keyName = key.getString();
            if (!key.isSetterDef() && !getters.add(keyName)) {
                if (n.isClassMembers()) {
                    t.report(key, DUPLICATE_CLASS_METHODS, keyName);
                } else {
                    t.report(key, DUPLICATE_OBJECT_KEY, keyName);
                }
            }
            if (key.isGetterDef() || setters.add(keyName)) continue;
            if (n.isClassMembers()) {
                t.report(key, DUPLICATE_CLASS_METHODS, keyName);
                continue;
            }
            t.report(key, DUPLICATE_OBJECT_KEY, keyName);
        }
    }

    private static boolean isFunctionType(Node n) {
        TypeI type = n.getTypeI();
        return type != null && type.isFunctionType();
    }

    private static class NonExternChecks
    extends NodeTraversal.AbstractPostOrderCallback {
        private NonExternChecks() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName() && StrictModeCheck.isDeclaration(n)) {
                this.checkDeclaration(t, n);
            } else if (n.isGetProp()) {
                this.checkGetProp(t, n);
            }
        }

        private void checkDeclaration(NodeTraversal t, Node n) {
            if ("eval".equals(n.getString())) {
                t.report(n, EVAL_DECLARATION, new String[0]);
            } else if ("arguments".equals(n.getString())) {
                t.report(n, ARGUMENTS_DECLARATION, new String[0]);
            }
        }

        private void checkGetProp(NodeTraversal t, Node n) {
            Node target = n.getFirstChild();
            Node prop = n.getLastChild();
            if (prop.getString().equals("callee")) {
                if (target.isName() && target.getString().equals("arguments")) {
                    t.report(n, ARGUMENTS_CALLEE_FORBIDDEN, new String[0]);
                }
            } else if (prop.getString().equals("caller")) {
                if (target.isName() && target.getString().equals("arguments")) {
                    t.report(n, ARGUMENTS_CALLER_FORBIDDEN, new String[0]);
                } else if (StrictModeCheck.isFunctionType(target)) {
                    t.report(n, FUNCTION_CALLER_FORBIDDEN, new String[0]);
                }
            } else if (prop.getString().equals("arguments") && StrictModeCheck.isFunctionType(target)) {
                t.report(n, FUNCTION_ARGUMENTS_PROP_FORBIDDEN, new String[0]);
            }
        }
    }
}

