/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class Scope
implements StaticScope,
Serializable {
    protected final Map<String, Var> vars = new LinkedHashMap<String, Var>();
    protected Scope parent;
    protected int depth;
    protected final Node rootNode;
    private Var arguments;

    Scope(Scope parent, Node rootNode) {
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkArgument((boolean)NodeUtil.createsScope(rootNode), (Object)rootNode);
        Preconditions.checkArgument((rootNode != parent.rootNode ? 1 : 0) != 0, (String)"rootNode should not be the parent's root node", (Object)rootNode);
        this.parent = parent;
        this.rootNode = rootNode;
        this.depth = parent.depth + 1;
    }

    protected Scope(Node rootNode) {
        Preconditions.checkArgument((NodeUtil.createsScope(rootNode) || rootNode.isScript() || rootNode.isRoot() ? 1 : 0) != 0, (Object)rootNode);
        this.parent = null;
        this.rootNode = rootNode;
        this.depth = 0;
    }

    public String toString() {
        return "Scope@" + this.rootNode;
    }

    static Scope createGlobalScope(Node rootNode) {
        Preconditions.checkArgument((rootNode.isRoot() || rootNode.isScript() ? 1 : 0) != 0, (Object)rootNode);
        return new Scope(rootNode);
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public Node getRootNode() {
        return this.rootNode;
    }

    public Scope getParent() {
        return this.parent;
    }

    Scope getGlobalScope() {
        Scope result = this;
        while (result.getParent() != null) {
            result = result.getParent();
        }
        return result;
    }

    @Override
    public StaticScope getParentScope() {
        return this.parent;
    }

    Var declare(String name, Node nameNode, CompilerInput input) {
        Preconditions.checkState((name != null && !name.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((this.vars.get(name) == null ? 1 : 0) != 0);
        Var var = new Var(name, nameNode, this, this.vars.size(), input);
        this.vars.put(name, var);
        return var;
    }

    void undeclare(Var var) {
        Preconditions.checkState((var.scope == this ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.vars.get(var.name).equals(var));
        this.undeclareInteral(var);
    }

    void undeclareInteral(Var var) {
        this.vars.remove(var.name);
    }

    @Override
    public Var getSlot(String name) {
        return this.getVar(name);
    }

    @Override
    public Var getOwnSlot(String name) {
        return this.vars.get(name);
    }

    public Var getVar(String name) {
        Scope scope = this;
        while (scope != null) {
            Var var = scope.vars.get(name);
            if (var != null) {
                return var;
            }
            if ("arguments".equals(name) && NodeUtil.isVanillaFunction(scope.getRootNode())) {
                return scope.getArgumentsVar();
            }
            scope = scope.parent;
        }
        return null;
    }

    public Var getArgumentsVar() {
        if (this.isGlobal() || this.isModuleScope()) {
            throw new IllegalStateException("No arguments var for scope: " + this);
        }
        if (!this.isFunctionScope() || this.rootNode.isArrowFunction()) {
            return this.parent.getArgumentsVar();
        }
        if (this.arguments == null) {
            this.arguments = Var.makeArgumentsVar(this);
        }
        return this.arguments;
    }

    @Deprecated
    public boolean isDeclaredSloppy(String name, boolean recurse) {
        Preconditions.checkState((!recurse ? 1 : 0) != 0);
        if (!this.isDeclared(name, false)) {
            if (this.parent != null && this.isFunctionBlockScope()) {
                return this.parent.isDeclared(name, false);
            }
            return false;
        }
        return true;
    }

    public boolean isDeclared(String name, boolean recurse) {
        Scope scope = this;
        while (true) {
            if (scope.vars.containsKey(name)) {
                return true;
            }
            if (scope.parent == null || !recurse) break;
            scope = scope.parent;
        }
        return false;
    }

    public Iterable<? extends Var> getVarIterable() {
        return this.vars.values();
    }

    public Iterable<? extends Var> getAllSymbols() {
        return Collections.unmodifiableCollection(this.vars.values());
    }

    public int getVarCount() {
        return this.vars.size();
    }

    public boolean isGlobal() {
        return this.parent == null;
    }

    public boolean isLocal() {
        return this.parent != null;
    }

    public boolean isBlockScope() {
        return NodeUtil.createsBlockScope(this.rootNode);
    }

    public boolean isFunctionBlockScope() {
        return NodeUtil.isFunctionBlock(this.getRootNode());
    }

    public boolean isFunctionScope() {
        return this.getRootNode().isFunction();
    }

    public boolean isModuleScope() {
        return this.getRootNode().isModuleBody();
    }

    public boolean isCatchScope() {
        return this.getRootNode().isNormalBlock() && this.getRootNode().hasOneChild() && this.getRootNode().getFirstChild().isCatch();
    }

    boolean isHoistScope() {
        return this.isFunctionScope() || this.isFunctionBlockScope() || this.isGlobal() || this.isModuleScope();
    }

    public Scope getClosestHoistScope() {
        Scope current = this;
        while (current != null) {
            if (current.isHoistScope()) {
                return current;
            }
            current = current.parent;
        }
        return null;
    }
}

