/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolymerPass;
import com.google.javascript.jscomp.PolymerPassErrors;
import com.google.javascript.jscomp.PolymerPassStaticUtils;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;

final class PolymerPassSuppressBehaviors
extends NodeTraversal.AbstractPostOrderCallback {
    private final AbstractCompiler compiler;

    PolymerPassSuppressBehaviors(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (PolymerPassSuppressBehaviors.isBehavior(n)) {
            if (!NodeUtil.isNameDeclaration(n) && !n.isAssign()) {
                this.compiler.report(JSError.make(n, PolymerPassErrors.POLYMER_UNQUALIFIED_BEHAVIOR, new String[0]));
                return;
            }
            JSDocInfoBuilder newDocs = JSDocInfoBuilder.maybeCopyFrom(n.getJSDocInfo());
            newDocs.recordNoCollapse();
            n.setJSDocInfo(newDocs.build());
            Node behaviorValue = n.getSecondChild();
            if (NodeUtil.isNameDeclaration(n)) {
                behaviorValue = n.getFirstFirstChild();
            }
            this.suppressBehavior(behaviorValue);
        }
    }

    private void suppressBehavior(Node behaviorValue) {
        if (behaviorValue == null) {
            this.compiler.report(JSError.make(behaviorValue, PolymerPassErrors.POLYMER_UNQUALIFIED_BEHAVIOR, new String[0]));
            return;
        }
        if (behaviorValue.isArrayLit()) {
            for (Node child : behaviorValue.children()) {
                this.suppressBehavior(child);
            }
        } else if (behaviorValue.isObjectLit()) {
            this.stripPropertyTypes(behaviorValue);
            this.addBehaviorSuppressions(behaviorValue);
        }
    }

    private static boolean isBehavior(Node value) {
        return value.getJSDocInfo() != null && value.getJSDocInfo().isPolymerBehavior();
    }

    private void stripPropertyTypes(Node behaviorValue) {
        ImmutableList<PolymerPass.MemberDefinition> properties = PolymerPassStaticUtils.extractProperties(behaviorValue, this.compiler);
        for (PolymerPass.MemberDefinition property : properties) {
            property.name.removeProp(29);
        }
    }

    private void suppressDefaultValues(Node behaviorValue) {
        for (PolymerPass.MemberDefinition property : PolymerPassStaticUtils.extractProperties(behaviorValue, this.compiler)) {
            Node defaultValue;
            if (!property.value.isObjectLit() || (defaultValue = NodeUtil.getFirstPropMatchingKey(property.value, "value")) == null || !defaultValue.isFunction()) continue;
            Node defaultValueKey = defaultValue.getParent();
            JSDocInfoBuilder suppressDoc = JSDocInfoBuilder.maybeCopyFrom(defaultValueKey.getJSDocInfo());
            suppressDoc.addSuppression("checkTypes");
            suppressDoc.addSuppression("globalThis");
            suppressDoc.addSuppression("visibility");
            defaultValueKey.setJSDocInfo(suppressDoc.build());
        }
    }

    private void addBehaviorSuppressions(Node behaviorValue) {
        for (Node keyNode : behaviorValue.children()) {
            if (!keyNode.getFirstChild().isFunction()) continue;
            keyNode.removeProp(29);
            JSDocInfoBuilder suppressDoc = new JSDocInfoBuilder(true);
            suppressDoc.addSuppression("checkTypes");
            suppressDoc.addSuppression("globalThis");
            suppressDoc.addSuppression("visibility");
            keyNode.setJSDocInfo(suppressDoc.build());
        }
        this.suppressDefaultValues(behaviorValue);
    }
}

