/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.RecentChange;
import com.google.javascript.rhino.Node;

class PeepholeOptimizationsPass
implements CompilerPass {
    private AbstractCompiler compiler;
    private final AbstractPeepholeOptimization[] peepholeOptimizations;
    private boolean retraverseOnChange;
    private RecentChange handler;
    private NodeTraversal.FunctionCallback fnCallback;
    private PeepCallback peepCallback;
    private NodeTraversal traversal;

    PeepholeOptimizationsPass(AbstractCompiler compiler, AbstractPeepholeOptimization ... optimizations) {
        this.compiler = compiler;
        this.peepholeOptimizations = optimizations;
        this.retraverseOnChange = true;
        this.handler = new RecentChange();
        this.peepCallback = new PeepCallback();
        this.traversal = new NodeTraversal(compiler, this.peepCallback, new Es6SyntacticScopeCreator(compiler));
        this.fnCallback = new ChangedFunctionCallback();
    }

    void setRetraverseOnChange(boolean retraverse) {
        this.retraverseOnChange = retraverse;
    }

    @Override
    public void process(Node externs, Node root) {
        this.compiler.addChangeHandler(this.handler);
        this.beginTraversal(this.traversal);
        NodeTraversal.traverseChangedFunctions(this.compiler, this.fnCallback);
        this.endTraversal();
        this.compiler.removeChangeHandler(this.handler);
    }

    private void beginTraversal(NodeTraversal traversal) {
        for (AbstractPeepholeOptimization optimization : this.peepholeOptimizations) {
            optimization.beginTraversal(traversal);
        }
    }

    private void endTraversal() {
        for (AbstractPeepholeOptimization optimization : this.peepholeOptimizations) {
            optimization.endTraversal();
        }
    }

    private class PeepCallback
    extends NodeTraversal.AbstractShallowCallback {
        private PeepCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            Node currentNode = n;
            boolean codeChanged = false;
            do {
                codeChanged = false;
                for (AbstractPeepholeOptimization optim : PeepholeOptimizationsPass.this.peepholeOptimizations) {
                    Node newNode = optim.optimizeSubtree(currentNode);
                    if (newNode != currentNode) {
                        codeChanged = true;
                        currentNode = newNode;
                    }
                    if (currentNode != null) continue;
                    return;
                }
            } while (codeChanged);
        }
    }

    private class ChangedFunctionCallback
    implements NodeTraversal.FunctionCallback {
        private ChangedFunctionCallback() {
        }

        @Override
        public void enterFunction(AbstractCompiler compiler, Node root) {
            if (root.isFunction()) {
                root = root.getLastChild();
            }
            do {
                PeepholeOptimizationsPass.this.handler.reset();
                PeepholeOptimizationsPass.this.traversal.traverse(root);
            } while (PeepholeOptimizationsPass.this.retraverseOnChange && PeepholeOptimizationsPass.this.handler.hasCodeChanged());
        }
    }
}

