/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionSite;
import com.google.javascript.jscomp.DefinitionUseSiteFinder;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.UseSite;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;

class OptimizeReturns
implements OptimizeCalls.CallGraphCompilerPass,
CompilerPass {
    private AbstractCompiler compiler;

    OptimizeReturns(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    @VisibleForTesting
    public void process(Node externs, Node root) {
        DefinitionUseSiteFinder defFinder = new DefinitionUseSiteFinder(this.compiler);
        defFinder.process(externs, root);
        this.process(externs, root, defFinder);
    }

    @Override
    public void process(Node externs, Node root, DefinitionUseSiteFinder definitions) {
        ArrayList<Node> toOptimize = new ArrayList<Node>();
        for (DefinitionSite defSite : definitions.getDefinitionSites()) {
            if (defSite.inExterns || OptimizeReturns.callResultsMaybeUsed(definitions, defSite)) continue;
            toOptimize.add(defSite.definition.getRValue());
        }
        for (Node node : toOptimize) {
            this.rewriteReturns(definitions, node);
        }
    }

    private static boolean callResultsMaybeUsed(DefinitionUseSiteFinder defFinder, DefinitionSite definitionSite) {
        DefinitionsRemover.Definition definition = definitionSite.definition;
        Node rValue = definition.getRValue();
        if (rValue == null || !rValue.isFunction()) {
            return true;
        }
        if (!NodeUtil.isSimpleFunctionDeclaration(rValue)) {
            return true;
        }
        if (!defFinder.canModifyDefinition(definition)) {
            return true;
        }
        Collection<UseSite> useSites = defFinder.getUseSites(definition);
        for (UseSite site : useSites) {
            Node useNodeParent = site.node.getParent();
            if (OptimizeReturns.isCall(site)) {
                Node callNode = useNodeParent;
                Preconditions.checkState((boolean)callNode.isCall());
                if (!NodeUtil.isExpressionResultUsed(callNode)) continue;
                return true;
            }
            if (useNodeParent.isVar()) continue;
            return true;
        }
        return false;
    }

    private void rewriteReturns(final DefinitionUseSiteFinder defFinder, Node fnNode) {
        Preconditions.checkState((boolean)fnNode.isFunction());
        final Node body = fnNode.getLastChild();
        NodeUtil.visitPostOrder(body, new NodeUtil.Visitor(){

            @Override
            public void visit(Node node) {
                if (node.isReturn() && node.hasOneChild()) {
                    boolean keepValue = NodeUtil.mayHaveSideEffects(node.getFirstChild(), OptimizeReturns.this.compiler);
                    if (!keepValue) {
                        defFinder.removeReferences(node.getFirstChild());
                    }
                    Node result = node.removeFirstChild();
                    if (keepValue) {
                        node.getParent().addChildBefore(IR.exprResult(result).srcref(result), node);
                    }
                    OptimizeReturns.this.compiler.reportChangeToEnclosingScope(body);
                }
            }
        }, new NodeUtil.MatchShallowStatement());
    }

    private static boolean isCall(UseSite site) {
        Node node = site.node;
        Node parent = node.getParent();
        return parent.getFirstChild() == node && parent.isCall();
    }
}

