/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multiset;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TokenStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class MakeDeclaredNamesUnique
implements NodeTraversal.ScopedCallback {
    public static final String ARGUMENTS = "arguments";
    private final Deque<Renamer> nameStack = new ArrayDeque<Renamer>();
    private final Renamer rootRenamer;
    private final boolean markChanges;

    MakeDeclaredNamesUnique() {
        this(new ContextualRenamer(), true);
    }

    MakeDeclaredNamesUnique(Renamer renamer) {
        this(renamer, true);
    }

    MakeDeclaredNamesUnique(Renamer renamer, boolean markChanges) {
        this.rootRenamer = renamer;
        this.markChanges = markChanges;
    }

    static CompilerPass getContextualRenameInverter(AbstractCompiler compiler) {
        return new ContextualRenameInverter(compiler, true);
    }

    @Override
    public void enterScope(NodeTraversal t) {
        Renamer renamer;
        Node declarationRoot = t.getScopeRoot();
        if (NodeUtil.isFunctionBlock(declarationRoot)) {
            return;
        }
        if (this.nameStack.isEmpty()) {
            Preconditions.checkState((!declarationRoot.isFunction() || !(this.rootRenamer instanceof ContextualRenamer) ? 1 : 0) != 0);
            Preconditions.checkState((boolean)t.inGlobalScope());
            renamer = this.rootRenamer;
        } else {
            renamer = this.nameStack.peek().createForChildScope(!NodeUtil.createsBlockScope(declarationRoot));
        }
        if (!declarationRoot.isFunction()) {
            this.findDeclaredNames(t, declarationRoot, renamer, false);
        }
        this.nameStack.push(renamer);
    }

    @Override
    public void exitScope(NodeTraversal t) {
        if (NodeUtil.isFunctionBlock(t.getScopeRoot())) {
            return;
        }
        if (!t.inGlobalScope()) {
            this.nameStack.pop();
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case FUNCTION: {
                Renamer renamer = this.nameStack.peek().createForChildScope(false);
                String name = n.getFirstChild().getString();
                if (!name.isEmpty() && parent != null && !NodeUtil.isFunctionDeclaration(n)) {
                    renamer.addDeclaredName(name, false);
                }
                this.nameStack.push(renamer);
                break;
            }
            case PARAM_LIST: {
                Renamer renamer = this.nameStack.peek().createForChildScope(true);
                for (Node lhs : NodeUtil.getLhsNodesOfDeclaration(n)) {
                    renamer.addDeclaredName(lhs.getString(), true);
                }
                Node functionBody = n.getNext();
                this.findDeclaredNames(t, functionBody, renamer, false);
                this.nameStack.push(renamer);
                break;
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case NAME: {
                this.visitName(t, n, parent);
                break;
            }
            case STRING_KEY: {
                String newName = this.getReplacementName(n.getString());
                if (newName == null || n.hasChildren()) break;
                Node name = IR.name(n.getString()).useSourceInfoFrom(n);
                n.addChildToBack(name);
                this.visitName(t, name, n);
                break;
            }
            case FUNCTION: {
                this.nameStack.pop();
                this.nameStack.pop();
                break;
            }
            case PARAM_LIST: {
                break;
            }
        }
    }

    private void visitName(NodeTraversal t, Node n, Node parent) {
        String newName = this.getReplacementName(n.getString());
        if (newName != null) {
            Renamer renamer = this.nameStack.peek();
            if (renamer.stripConstIfReplaced()) {
                n.removeProp(43);
            }
            n.setString(newName);
            if (this.markChanges) {
                t.reportCodeChange();
                if (parent.isFunction() && NodeUtil.isFunctionDeclaration(parent)) {
                    t.getCompiler().reportChangeToEnclosingScope(parent);
                }
            }
        }
    }

    private String getReplacementName(String oldName) {
        for (Renamer names : this.nameStack) {
            String newName = names.getReplacementName(oldName);
            if (newName == null) continue;
            return newName;
        }
        return null;
    }

    private void findDeclaredNames(NodeTraversal t, Node n, Renamer renamer, boolean recursive) {
        Node parent = n.getParent();
        if (recursive && parent.isFunction() && n != parent.getFirstChild()) {
            return;
        }
        if (NodeUtil.isVarDeclaration(n)) {
            renamer.addDeclaredName(n.getString(), true);
        } else if (NodeUtil.isBlockScopedDeclaration(n)) {
            if (t.getScopeRoot() == NodeUtil.getEnclosingScopeRoot(n)) {
                renamer.addDeclaredName(n.getString(), false);
            } else if (t.getScopeRoot().isFunction() && NodeUtil.getEnclosingScopeRoot(n) == NodeUtil.getFunctionBody(t.getScopeRoot())) {
                renamer.addDeclaredName(n.getString(), false);
            }
        } else if (NodeUtil.isFunctionDeclaration(n)) {
            Node nameNode = n.getFirstChild();
            renamer.addDeclaredName(nameNode.getString(), true);
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.findDeclaredNames(t, c, renamer, true);
        }
    }

    static class WhitelistedRenamer
    implements Renamer {
        private Renamer delegate;
        private Set<String> whitelist;

        WhitelistedRenamer(Renamer delegate, Set<String> whitelist) {
            this.delegate = delegate;
            this.whitelist = whitelist;
        }

        @Override
        public void addDeclaredName(String name, boolean hoisted) {
            if (this.whitelist.contains(name)) {
                this.delegate.addDeclaredName(name, hoisted);
            }
        }

        @Override
        public String getReplacementName(String oldName) {
            return this.whitelist.contains(oldName) ? this.delegate.getReplacementName(oldName) : null;
        }

        @Override
        public boolean stripConstIfReplaced() {
            return this.delegate.stripConstIfReplaced();
        }

        @Override
        public Renamer createForChildScope(boolean hoistingTargetScope) {
            return new WhitelistedRenamer(this.delegate.createForChildScope(hoistingTargetScope), this.whitelist);
        }

        @Override
        public Renamer getHoistRenamer() {
            return this.delegate.getHoistRenamer();
        }
    }

    static class BoilerplateRenamer
    extends ContextualRenamer {
        private final Supplier<String> uniqueIdSupplier;
        private final String idPrefix;
        private final CodingConvention convention;

        BoilerplateRenamer(CodingConvention convention, Supplier<String> uniqueIdSupplier, String idPrefix) {
            this.convention = convention;
            this.uniqueIdSupplier = uniqueIdSupplier;
            this.idPrefix = idPrefix;
        }

        @Override
        public Renamer createForChildScope(boolean hoisted) {
            return new InlineRenamer(this.convention, this.uniqueIdSupplier, this.idPrefix, false, hoisted, this);
        }
    }

    static class InlineRenamer
    implements Renamer {
        private final Map<String, String> declarations = new HashMap<String, String>();
        private final Supplier<String> uniqueIdSupplier;
        private final String idPrefix;
        private final boolean removeConstness;
        private final CodingConvention convention;
        private final Renamer hoistRenamer;

        InlineRenamer(CodingConvention convention, Supplier<String> uniqueIdSupplier, String idPrefix, boolean removeConstness, boolean hoistingTargetScope, Renamer parent) {
            this.convention = convention;
            this.uniqueIdSupplier = uniqueIdSupplier;
            Preconditions.checkArgument((!idPrefix.isEmpty() ? 1 : 0) != 0);
            this.idPrefix = idPrefix;
            this.removeConstness = removeConstness;
            this.hoistRenamer = hoistingTargetScope ? this : parent.getHoistRenamer();
        }

        @Override
        public void addDeclaredName(String name, boolean hoisted) {
            Preconditions.checkState((!name.equals(MakeDeclaredNamesUnique.ARGUMENTS) ? 1 : 0) != 0);
            if (hoisted && this.hoistRenamer != this) {
                this.hoistRenamer.addDeclaredName(name, hoisted);
            } else if (!this.declarations.containsKey(name)) {
                this.declarations.put(name, this.getUniqueName(name));
            }
        }

        private String getUniqueName(String name) {
            if (name.isEmpty()) {
                return name;
            }
            if (name.contains("$jscomp$")) {
                name = name.substring(0, name.lastIndexOf("$jscomp$"));
            }
            if (this.convention.isExported(name)) {
                name = "JSCompiler_" + name;
            }
            return name + "$jscomp$" + this.idPrefix + (String)this.uniqueIdSupplier.get();
        }

        @Override
        public String getReplacementName(String oldName) {
            return this.declarations.get(oldName);
        }

        @Override
        public Renamer createForChildScope(boolean hoistingTargetScope) {
            return new InlineRenamer(this.convention, this.uniqueIdSupplier, this.idPrefix, this.removeConstness, hoistingTargetScope, this);
        }

        @Override
        public boolean stripConstIfReplaced() {
            return this.removeConstness;
        }

        @Override
        public Renamer getHoistRenamer() {
            return this.hoistRenamer;
        }
    }

    static class ContextualRenamer
    implements Renamer {
        private final Multiset<String> nameUsage;
        private final Map<String, String> declarations = new HashMap<String, String>();
        private final boolean global;
        private final Renamer hoistRenamer;
        static final String UNIQUE_ID_SEPARATOR = "$jscomp$";

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("nameUsage", this.nameUsage).add("declarations", this.declarations).add("global", this.global).toString();
        }

        ContextualRenamer() {
            this.global = true;
            this.nameUsage = HashMultiset.create();
            this.hoistRenamer = this;
        }

        private ContextualRenamer(Multiset<String> nameUsage, boolean hoistingTargetScope, Renamer parent) {
            this.global = false;
            this.nameUsage = nameUsage;
            this.hoistRenamer = hoistingTargetScope ? this : parent.getHoistRenamer();
        }

        @Override
        public Renamer createForChildScope(boolean hoistingTargetScope) {
            return new ContextualRenamer(this.nameUsage, hoistingTargetScope, this);
        }

        @Override
        public void addDeclaredName(String name, boolean hoisted) {
            if (hoisted && this.hoistRenamer != this) {
                this.hoistRenamer.addDeclaredName(name, true);
            } else if (!name.equals(MakeDeclaredNamesUnique.ARGUMENTS)) {
                if (this.global) {
                    this.reserveName(name);
                } else if (!this.declarations.containsKey(name)) {
                    int id = this.incrementNameCount(name);
                    String newName = null;
                    if (id != 0) {
                        newName = ContextualRenamer.getUniqueName(name, id);
                    }
                    this.declarations.put(name, newName);
                }
            }
        }

        @Override
        public String getReplacementName(String oldName) {
            return this.declarations.get(oldName);
        }

        private static String getUniqueName(String name, int id) {
            return name + UNIQUE_ID_SEPARATOR + id;
        }

        private void reserveName(String name) {
            this.nameUsage.setCount((Object)name, 0, 1);
        }

        private int incrementNameCount(String name) {
            return this.nameUsage.add((Object)name, 1);
        }

        @Override
        public boolean stripConstIfReplaced() {
            return false;
        }

        @Override
        public Renamer getHoistRenamer() {
            return this.hoistRenamer;
        }
    }

    static class ContextualRenameInverter
    implements NodeTraversal.ScopedCallback,
    CompilerPass {
        private final AbstractCompiler compiler;
        private Set<String> referencedNames = ImmutableSet.of();
        private Deque<Set<String>> referenceStack = new ArrayDeque<Set<String>>();
        private final ListMultimap<String, Node> nameMap = MultimapBuilder.hashKeys().arrayListValues().build();
        private final boolean markChanges;

        private ContextualRenameInverter(AbstractCompiler compiler, boolean markChanges) {
            this.compiler = compiler;
            this.markChanges = markChanges;
        }

        @Override
        public void process(Node externs, Node js) {
            NodeTraversal.traverseEs6(this.compiler, js, this);
        }

        public static String getOriginalName(String name) {
            int index = ContextualRenameInverter.indexOfSeparator(name);
            return index == -1 ? name : name.substring(0, index);
        }

        private static int indexOfSeparator(String name) {
            return name.lastIndexOf("$jscomp$");
        }

        private static boolean containsSeparator(String name) {
            return name.contains("$jscomp$");
        }

        @Override
        public void enterScope(NodeTraversal t) {
            if (t.inGlobalScope()) {
                return;
            }
            this.referenceStack.push(this.referencedNames);
            this.referencedNames = new HashSet<String>();
        }

        @Override
        public void exitScope(NodeTraversal t) {
            if (t.inGlobalScope()) {
                return;
            }
            for (Var var : t.getScope().getVarIterable()) {
                this.handleScopeVar(var);
            }
            Set<String> current = this.referencedNames;
            this.referencedNames = this.referenceStack.pop();
            if (!this.referenceStack.isEmpty()) {
                this.referencedNames.addAll(current);
            }
        }

        void handleScopeVar(Var v) {
            String name = v.getName();
            if (ContextualRenameInverter.containsSeparator(name) && !ContextualRenameInverter.getOriginalName(name).isEmpty()) {
                String newName = this.findReplacementName(name);
                this.referencedNames.remove(name);
                this.referencedNames.add(newName);
                List references = this.nameMap.get((Object)name);
                for (Node n : references) {
                    Preconditions.checkState((boolean)n.isName(), (Object)n);
                    n.setString(newName);
                    if (!this.markChanges) continue;
                    this.compiler.reportChangeToEnclosingScope(n);
                    Node parent = n.getParent();
                    if (!parent.isFunction() || !NodeUtil.isFunctionDeclaration(parent)) continue;
                    this.compiler.reportChangeToEnclosingScope(parent);
                }
                this.nameMap.removeAll((Object)name);
            }
        }

        private String findReplacementName(String name) {
            String original;
            String newName = original = ContextualRenameInverter.getOriginalName(name);
            int i = 0;
            while (!this.isValidName(newName)) {
                newName = original + "$jscomp$" + i++;
            }
            return newName;
        }

        private boolean isValidName(String name) {
            return TokenStream.isJSIdentifier(name) && !this.referencedNames.contains(name) && !name.equals(MakeDeclaredNamesUnique.ARGUMENTS);
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node node, Node parent) {
            if (t.inGlobalScope()) {
                return;
            }
            if (NodeUtil.isReferenceName(node)) {
                String name = node.getString();
                this.referencedNames.add(name);
                if (ContextualRenameInverter.containsSeparator(name)) {
                    this.addCandidateNameReference(name, node);
                }
            }
        }

        private void addCandidateNameReference(String name, Node n) {
            this.nameMap.put((Object)name, (Object)n);
        }
    }

    static interface Renamer {
        public void addDeclaredName(String var1, boolean var2);

        public String getReplacementName(String var1);

        public boolean stripConstIfReplaced();

        public Renamer createForChildScope(boolean var1);

        public Renamer getHoistRenamer();
    }
}

