/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.debugging.sourcemap.proto.Mapping;
import com.google.javascript.jscomp.AbstractMessageFormatter;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Region;
import com.google.javascript.jscomp.SourceExcerptProvider;
import com.google.javascript.rhino.TokenUtil;

public final class LightweightMessageFormatter
extends AbstractMessageFormatter {
    private final SourceExcerptProvider.SourceExcerpt excerpt;
    private static final SourceExcerptProvider.ExcerptFormatter excerptFormatter = new LineNumberingFormatter();
    private boolean includeLocation = true;
    private boolean includeLevel = true;

    private LightweightMessageFormatter() {
        super(null);
        this.excerpt = SourceExcerptProvider.SourceExcerpt.LINE;
    }

    public LightweightMessageFormatter(SourceExcerptProvider source) {
        this(source, SourceExcerptProvider.SourceExcerpt.LINE);
    }

    public LightweightMessageFormatter(SourceExcerptProvider source, SourceExcerptProvider.SourceExcerpt excerpt) {
        super(source);
        Preconditions.checkNotNull((Object)source);
        this.excerpt = excerpt;
    }

    public static LightweightMessageFormatter withoutSource() {
        return new LightweightMessageFormatter();
    }

    public LightweightMessageFormatter setIncludeLocation(boolean includeLocation) {
        this.includeLocation = includeLocation;
        return this;
    }

    public LightweightMessageFormatter setIncludeLevel(boolean includeLevel) {
        this.includeLevel = includeLevel;
        return this;
    }

    @Override
    public String formatError(JSError error) {
        return this.format(error, false);
    }

    @Override
    public String formatWarning(JSError warning) {
        return this.format(warning, true);
    }

    private String format(JSError error, boolean warning) {
        String sourceExcerpt;
        SourceExcerptProvider source = this.getSource();
        String sourceName = error.sourceName;
        int lineNumber = error.lineNumber;
        int charno = error.getCharno();
        StringBuilder b = new StringBuilder();
        StringBuilder boldLine = new StringBuilder();
        String nonMappedPosition = LightweightMessageFormatter.formatPosition(sourceName, lineNumber);
        if (this.includeLocation) {
            Mapping.OriginalMapping mapping;
            Mapping.OriginalMapping originalMapping = mapping = source == null ? null : source.getSourceMapping(error.sourceName, error.lineNumber, error.getCharno());
            if (mapping == null) {
                boldLine.append(nonMappedPosition);
            } else {
                sourceName = mapping.getOriginalFile();
                lineNumber = mapping.getLineNumber();
                charno = mapping.getColumnPosition();
                b.append(nonMappedPosition);
                b.append("\nOriginally at:\n");
                boldLine.append(LightweightMessageFormatter.formatPosition(sourceName, lineNumber));
            }
        }
        String string = sourceExcerpt = source == null ? null : this.excerpt.get(source, sourceName, lineNumber, excerptFormatter);
        if (this.includeLevel) {
            boldLine.append(this.getLevelName(warning ? CheckLevel.WARNING : CheckLevel.ERROR));
            boldLine.append(" - ");
        }
        boldLine.append(error.description);
        b.append(this.maybeEmbolden(boldLine.toString()));
        b.append('\n');
        if (sourceExcerpt != null) {
            b.append(sourceExcerpt);
            b.append('\n');
            if (this.excerpt.equals((Object)SourceExcerptProvider.SourceExcerpt.LINE) && 0 <= charno && charno <= sourceExcerpt.length()) {
                for (int i = 0; i < charno; ++i) {
                    char c = sourceExcerpt.charAt(i);
                    if (TokenUtil.isWhitespace(c)) {
                        b.append(c);
                        continue;
                    }
                    b.append(' ');
                }
                if (error.node == null) {
                    b.append("^");
                } else {
                    int length = Math.max(1, Math.min(error.node.getLength(), sourceExcerpt.length() - charno));
                    for (int i = 0; i < length; ++i) {
                        b.append("^");
                    }
                }
                b.append("\n");
            }
        }
        return b.toString();
    }

    private static String formatPosition(String sourceName, int lineNumber) {
        StringBuilder b = new StringBuilder();
        if (sourceName != null) {
            b.append(sourceName);
            if (lineNumber > 0) {
                b.append(':');
                b.append(lineNumber);
            }
            b.append(": ");
        }
        return b.toString();
    }

    static class LineNumberingFormatter
    implements SourceExcerptProvider.ExcerptFormatter {
        LineNumberingFormatter() {
        }

        @Override
        public String formatLine(String line, int lineNumber) {
            return line;
        }

        @Override
        public String formatRegion(Region region) {
            if (region == null) {
                return null;
            }
            String code = region.getSourceExcerpt();
            if (code.isEmpty()) {
                return null;
            }
            int numberLength = Integer.toString(region.getEndingLineNumber()).length();
            StringBuilder builder = new StringBuilder(code.length() * 2);
            int start = 0;
            int end = code.indexOf(10, start);
            int lineNumber = region.getBeginningLineNumber();
            while (start >= 0) {
                String line;
                if (end < 0) {
                    line = code.substring(start);
                    if (line.isEmpty()) {
                        return builder.substring(0, builder.length() - 1);
                    }
                } else {
                    line = code.substring(start, end);
                }
                builder.append("  ");
                int spaces = numberLength - Integer.toString(lineNumber).length();
                builder.append(Strings.repeat((String)" ", (int)spaces));
                builder.append(lineNumber);
                builder.append("| ");
                if (end < 0) {
                    builder.append(line);
                    start = -1;
                    continue;
                }
                builder.append(line);
                builder.append('\n');
                start = end + 1;
                end = code.indexOf(10, start);
                ++lineNumber;
            }
            return builder.toString();
        }
    }
}

