/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GwtProperties {
    private static final Pattern PROP_DEF = Pattern.compile("^(\\w+(\\.\\w+)*)\\s*[:= ]");
    private static final Pattern PROP_LINE = Pattern.compile("^\\s*(.*?)(\\\\?)$");
    private final Map<String, String> contents;

    private GwtProperties(Map<String, String> contents) {
        this.contents = contents;
    }

    public String getProperty(String key) {
        return this.contents.get(key);
    }

    public Collection<String> propertyNames() {
        return this.contents.keySet();
    }

    public static GwtProperties load(String source) {
        String[] lines = source.split("\r?\n");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < lines.length; ++i) {
            Matcher m;
            String line = lines[i];
            if (line.isEmpty() || line.startsWith("#") || line.startsWith("!") || !(m = PROP_DEF.matcher(line)).find()) continue;
            String key = m.group(1);
            String data = "";
            line = line.substring(m.group(0).length());
            while (true) {
                Matcher lineMatch;
                if (!(lineMatch = PROP_LINE.matcher(line)).matches()) {
                    throw new RuntimeException("Properties parser failed on line: " + line);
                }
                data = data + lineMatch.group(1);
                boolean isLastLine = lineMatch.group(2).isEmpty();
                if (isLastLine || i + 1 == lines.length) break;
                line = lines[++i];
            }
            builder.put((Object)key, (Object)data);
        }
        return new GwtProperties((Map<String, String>)builder.build());
    }
}

