/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefaultNameGenerator;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NTIScope;
import com.google.javascript.jscomp.NewTypeInference;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TypeMismatch;
import com.google.javascript.jscomp.newtypes.Declaration;
import com.google.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.javascript.jscomp.newtypes.DeclaredTypeRegistry;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.FunctionNamespace;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypeCreatorFromJSDoc;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.Namespace;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectKind;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.RawNominalType;
import com.google.javascript.jscomp.newtypes.Typedef;
import com.google.javascript.jscomp.newtypes.UniqueNameGenerator;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ObjectTypeI;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.TypeIEnv;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class GlobalTypeInfo
implements CompilerPass,
TypeIRegistry {
    static final DiagnosticType DUPLICATE_JSDOC = DiagnosticType.warning("JSC_NTI_DUPLICATE_JSDOC", "Found two JsDoc comments for variable: {0}.\n");
    static final DiagnosticType REDECLARED_PROPERTY = DiagnosticType.warning("JSC_NTI_REDECLARED_PROPERTY", "Found two declarations for property {0} on {1}.\n");
    static final DiagnosticType INVALID_PROP_OVERRIDE = DiagnosticType.warning("JSC_NTI_INVALID_PROP_OVERRIDE", "Invalid redeclaration of property {0}.\ninherited type  : {1}\noverriding type : {2}\n");
    static final DiagnosticType CTOR_IN_DIFFERENT_SCOPE = DiagnosticType.warning("JSC_NTI_CTOR_IN_DIFFERENT_SCOPE", "Modifying the prototype is only allowed if the constructor is in the same scope\n");
    static final DiagnosticType UNRECOGNIZED_TYPE_NAME = DiagnosticType.warning("JSC_NTI_UNRECOGNIZED_TYPE_NAME", "Type annotation references non-existent type {0}.");
    static final DiagnosticType STRUCT_WITHOUT_CTOR_OR_INTERF = DiagnosticType.warning("JSC_NTI_STRUCT_WITHOUT_CTOR_OR_INTERF", "@struct used without @constructor, @interface, or @record.");
    static final DiagnosticType DICT_WITHOUT_CTOR = DiagnosticType.warning("JSC_NTI_DICT_WITHOUT_CTOR", "@dict used without @constructor.");
    static final DiagnosticType EXPECTED_CONSTRUCTOR = DiagnosticType.warning("JSC_NTI_EXPECTED_CONSTRUCTOR", "Expected constructor name but found {0}.");
    static final DiagnosticType EXPECTED_INTERFACE = DiagnosticType.warning("JSC_NTI_EXPECTED_INTERFACE", "Expected interface name but found {0}.");
    static final DiagnosticType INEXISTENT_PARAM = DiagnosticType.warning("JSC_NTI_INEXISTENT_PARAM", "parameter {0} does not appear in {1}''s parameter list");
    static final DiagnosticType CONST_WITHOUT_INITIALIZER = DiagnosticType.warning("JSC_NTI_CONST_WITHOUT_INITIALIZER", "Constants must be initialized when they are defined.");
    static final DiagnosticType COULD_NOT_INFER_CONST_TYPE = DiagnosticType.warning("JSC_NTI_COULD_NOT_INFER_CONST_TYPE", "All constants must be typed. The compiler could not infer the type of constant {0}. Please use an explicit type annotation. For more information, see:\nhttps://github.com/google/closure-compiler/wiki/Using-NTI-(new-type-inference)#warnings-about-uninferred-constants");
    static final DiagnosticType MISPLACED_CONST_ANNOTATION = DiagnosticType.warning("JSC_NTI_MISPLACED_CONST_ANNOTATION", "This property cannot be @const. The @const annotation is only allowed for properties of namespaces, prototype properties, static properties of constructors, and properties of the form this.prop declared inside constructors and prototype methods.");
    static final DiagnosticType CANNOT_OVERRIDE_FINAL_METHOD = DiagnosticType.warning("JSC_NTI_CANNOT_OVERRIDE_FINAL_METHOD", "Final method {0} cannot be overriden.");
    static final DiagnosticType CANNOT_INIT_TYPEDEF = DiagnosticType.warning("JSC_NTI_CANNOT_INIT_TYPEDEF", "A typedef variable represents a type name; it cannot be assigned a value.");
    static final DiagnosticType ANONYMOUS_NOMINAL_TYPE = DiagnosticType.warning("JSC_NTI_ANONYMOUS_NOMINAL_TYPE", "Must specify a name when defining a class or interface.");
    static final DiagnosticType MALFORMED_ENUM = DiagnosticType.warning("JSC_NTI_MALFORMED_ENUM", "An enum must be initialized to a non-empty object literal.");
    static final DiagnosticType DUPLICATE_PROP_IN_ENUM = DiagnosticType.warning("JSC_NTI_DUPLICATE_PROP_IN_ENUM", "Property {0} appears twice in the enum declaration.");
    static final DiagnosticType LENDS_ON_BAD_TYPE = DiagnosticType.warning("JSC_NTI_LENDS_ON_BAD_TYPE", "May only lend properties to namespaces, constructors and their prototypes. Found {0}.");
    static final DiagnosticType FUNCTION_CONSTRUCTOR_NOT_DEFINED = DiagnosticType.error("JSC_NTI_FUNCTION_CONSTRUCTOR_NOT_DEFINED", "You must provide externs that define the built-in Function constructor.");
    static final DiagnosticType INVALID_INTERFACE_PROP_INITIALIZER = DiagnosticType.warning("JSC_NTI_INVALID_INTERFACE_PROP_INITIALIZER", "Invalid initialization of interface property.");
    static final DiagnosticType SETTER_WITH_RETURN = DiagnosticType.warning("JSC_NTI_SETTER_WITH_RETURN", "Cannot declare a return type on a setter.");
    static final DiagnosticType WRONG_PARAMETER_COUNT = DiagnosticType.warning("JSC_NTI_WRONG_PARAMETER_COUNT", "Function definition does not have the declared number of parameters.\nExpected: {0}\nFound: {1}");
    static final DiagnosticType CANNOT_ADD_PROPERTIES_TO_TYPEDEF = DiagnosticType.warning("JSC_NTI_CANNOT_ADD_PROPERTIES_TO_TYPEDEF", "A typedef should only be used in type annotations, not as a value. Adding properties to typedefs is not allowed.");
    static final DiagnosticType SUPER_INTERFACES_HAVE_INCOMPATIBLE_PROPERTIES = DiagnosticType.warning("JSC_NTI_SUPER_INTERFACES_HAVE_INCOMPATIBLE_PROPERTIES", "Interface {0} has a property {1} with incompatible types in its super interfaces: {2}");
    static final DiagnosticType ONE_TYPE_FOR_MANY_VARS = DiagnosticType.warning("JSC_NTI_ONE_TYPE_FOR_MANY_VARS", "Having one type annotation for multiple variables is not allowed.");
    static final DiagnosticType UNKNOWN_OVERRIDE = DiagnosticType.warning("JSC_NTI_UNKNOWN_OVERRIDE", "property {0} not defined on any supertype of {1}");
    static final DiagnosticType INTERFACE_METHOD_NOT_IMPLEMENTED = DiagnosticType.warning("JSC_NTI_INTERFACE_METHOD_NOT_IMPLEMENTED", "property {0} on interface {1} is not implemented by type {2}");
    static final DiagnosticType INTERFACE_METHOD_NOT_EMPTY = DiagnosticType.warning("JSC_NTI_INTERFACE_METHOD_NOT_EMPTY", "interface member functions must have an empty body");
    static final DiagnosticType ABSTRACT_METHOD_IN_CONCRETE_CLASS = DiagnosticType.warning("JSC_NTI_ABSTRACT_METHOD_IN_CONCRETE_CLASS", "Abstract methods can only appear in abstract classes. Please declare class {0} as @abstract");
    static final DiagnosticType ABSTRACT_METHOD_IN_INTERFACE = DiagnosticType.warning("JSC_NTI_ABSTRACT_METHOD_IN_INTERFACE", "Abstract methods cannot appear in interfaces");
    static final DiagnosticType ABSTRACT_METHOD_NOT_IMPLEMENTED_IN_CONCRETE_CLASS = DiagnosticType.warning("JSC_NTI_ABSTRACT_METHOD_NOT_IMPLEMENTED_IN_CONCRETE_CLASS", "Abstract method {0} from superclass {1} not implemented");
    static final DiagnosticGroup COMPATIBLE_DIAGNOSTICS = new DiagnosticGroup(ABSTRACT_METHOD_IN_CONCRETE_CLASS, CANNOT_OVERRIDE_FINAL_METHOD, DICT_WITHOUT_CTOR, DUPLICATE_PROP_IN_ENUM, EXPECTED_CONSTRUCTOR, EXPECTED_INTERFACE, FUNCTION_CONSTRUCTOR_NOT_DEFINED, INEXISTENT_PARAM, INTERFACE_METHOD_NOT_IMPLEMENTED, INTERFACE_METHOD_NOT_EMPTY, INVALID_INTERFACE_PROP_INITIALIZER, INVALID_PROP_OVERRIDE, LENDS_ON_BAD_TYPE, ONE_TYPE_FOR_MANY_VARS, REDECLARED_PROPERTY, STRUCT_WITHOUT_CTOR_OR_INTERF, SUPER_INTERFACES_HAVE_INCOMPATIBLE_PROPERTIES, UNKNOWN_OVERRIDE, UNRECOGNIZED_TYPE_NAME, WRONG_PARAMETER_COUNT);
    static final DiagnosticGroup NEW_DIAGNOSTICS = new DiagnosticGroup(ABSTRACT_METHOD_IN_INTERFACE, ABSTRACT_METHOD_NOT_IMPLEMENTED_IN_CONCRETE_CLASS, ANONYMOUS_NOMINAL_TYPE, CANNOT_ADD_PROPERTIES_TO_TYPEDEF, CANNOT_INIT_TYPEDEF, CONST_WITHOUT_INITIALIZER, COULD_NOT_INFER_CONST_TYPE, CTOR_IN_DIFFERENT_SCOPE, DUPLICATE_JSDOC, MALFORMED_ENUM, MISPLACED_CONST_ANNOTATION, SETTER_WITH_RETURN);
    private final List<NTIScope> scopes = new ArrayList<NTIScope>();
    private NTIScope globalScope;
    private NewTypeInference.WarningReporter warnings;
    private final List<TypeMismatch> mismatches;
    private final List<TypeMismatch> implicitInterfaceUses;
    private final JSTypeCreatorFromJSDoc typeParser;
    private final transient AbstractCompiler compiler;
    private final CodingConvention convention;
    private final Map<Node, String> anonFunNames = new LinkedHashMap<Node, String>();
    private static final String ANON_FUN_PREFIX = "%anon_fun";
    private static final QualifiedName CONST_INFERENCE_MARKER = new QualifiedName("jscomp$infer$const$property");
    private static final String WINDOW_INSTANCE = "window";
    private static final String WINDOW_CLASS = "Window";
    private DefaultNameGenerator funNameGen;
    private UniqueNameGenerator varNameGen;
    private Map<Node, RawNominalType> nominaltypesByNode = new LinkedHashMap<Node, RawNominalType>();
    private HashBasedTable<RawNominalType, String, PropertyDef> propertyDefs = HashBasedTable.create();
    private final Map<Node, JSType> castTypes = new LinkedHashMap<Node, JSType>();
    private final Map<Node, JSType> declaredObjLitProps = new LinkedHashMap<Node, JSType>();
    private final JSTypes commonTypes;
    private final Set<String> unknownTypeNames;
    private final Set<String> allPropertyNames = new LinkedHashSet<String>();
    private final Set<String> externPropertyNames = new LinkedHashSet<String>();
    private Collection<RawNominalType> rawNominalTypes;

    GlobalTypeInfo(AbstractCompiler compiler, Set<String> unknownTypeNames) {
        boolean inCompatibilityMode = compiler.getOptions().disables(DiagnosticGroups.NEW_CHECK_TYPES_EXTRA_CHECKS);
        this.warnings = new NewTypeInference.WarningReporter(compiler);
        this.mismatches = new ArrayList<TypeMismatch>();
        this.implicitInterfaceUses = new ArrayList<TypeMismatch>();
        this.compiler = compiler;
        this.unknownTypeNames = unknownTypeNames;
        this.convention = compiler.getCodingConvention();
        this.varNameGen = new UniqueNameGenerator();
        this.funNameGen = new DefaultNameGenerator((Set<String>)ImmutableSet.of(), "", null);
        this.commonTypes = JSTypes.init(inCompatibilityMode);
        class CallBack
        implements Function<String, Void>,
        Serializable {
            CallBack() {
            }

            public Void apply(String pname) {
                GlobalTypeInfo.this.allPropertyNames.add(pname);
                GlobalTypeInfo.this.externPropertyNames.add(pname);
                return null;
            }
        }
        this.typeParser = new JSTypeCreatorFromJSDoc(this.commonTypes, this.convention, this.varNameGen, new CallBack());
        this.allPropertyNames.add("prototype");
    }

    Collection<NTIScope> getScopes() {
        return this.scopes;
    }

    NTIScope getGlobalScope() {
        return this.globalScope;
    }

    JSTypes getCommonTypes() {
        return this.commonTypes;
    }

    List<TypeMismatch> getMismatches() {
        return this.mismatches;
    }

    List<TypeMismatch> getImplicitInterfaceUses() {
        return this.implicitInterfaceUses;
    }

    JSType getCastType(Node n) {
        JSType t = this.castTypes.get(n);
        Preconditions.checkNotNull((Object)t);
        return t;
    }

    JSType getPropDeclaredType(Node n) {
        return this.declaredObjLitProps.get(n);
    }

    boolean isPropertyDefined(String pname) {
        return this.allPropertyNames.contains(pname);
    }

    void recordPropertyName(String pname, Node defSite) {
        this.allPropertyNames.add(pname);
        if (defSite.isFromExterns()) {
            this.externPropertyNames.add(pname);
        }
    }

    String getFunInternalName(Node n) {
        Preconditions.checkArgument((boolean)n.isFunction());
        if (this.anonFunNames.containsKey(n)) {
            return this.anonFunNames.get(n);
        }
        Node fnNameNode = NodeUtil.getNameNode(n);
        Preconditions.checkState((fnNameNode != null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)fnNameNode.isName());
        return fnNameNode.getString();
    }

    @Override
    public void process(Node externs, Node root) {
        JSType globalThisType;
        Preconditions.checkNotNull((Object)this.warnings, (Object)"Cannot rerun GlobalTypeInfo.process");
        Preconditions.checkArgument((externs == null || externs.isRoot() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)root.isRoot(), (String)"Root must be ROOT, but is %s", (Object)((Object)root.getToken()));
        this.compiler.setMostRecentTypechecker(AbstractCompiler.MostRecentTypechecker.NTI);
        this.globalScope = new NTIScope(root, null, (List<String>)ImmutableList.of(), this.commonTypes);
        this.globalScope.addUnknownTypeNames(this.unknownTypeNames);
        this.scopes.add(this.globalScope);
        CollectNamedTypes rootCnt = new CollectNamedTypes(this.globalScope);
        if (externs != null) {
            NodeTraversal.traverseEs6(this.compiler, externs, rootCnt);
        }
        NodeTraversal.traverseEs6(this.compiler, root, rootCnt);
        this.globalScope.resolveTypedefs(this.typeParser);
        this.globalScope.resolveEnums(this.typeParser);
        for (int i = 1; i < this.scopes.size(); ++i) {
            NTIScope s = this.scopes.get(i);
            CollectNamedTypes cnt = new CollectNamedTypes(s);
            NodeTraversal.traverseEs6(this.compiler, s.getBody(), cnt);
            s.resolveTypedefs(this.typeParser);
            s.resolveEnums(this.typeParser);
            if (!NewTypeInference.measureMem) continue;
            NewTypeInference.updatePeakMem();
        }
        if (this.commonTypes.getFunctionType() == null) {
            this.warnings.add(JSError.make(root, FUNCTION_CONSTRUCTOR_NOT_DEFINED, new String[0]));
            return;
        }
        ProcessScope rootPs = new ProcessScope(this.globalScope);
        if (externs != null) {
            NodeTraversal.traverseEs6(this.compiler, externs, rootPs);
        }
        NodeTraversal.traverseEs6(this.compiler, root, rootPs);
        rootPs.finishProcessingScope();
        for (int i = 1; i < this.scopes.size(); ++i) {
            NTIScope s = this.scopes.get(i);
            ProcessScope processScope = new ProcessScope(s);
            NodeTraversal.traverseEs6(this.compiler, s.getBody(), processScope);
            processScope.finishProcessingScope();
            if (!NewTypeInference.measureMem) continue;
            NewTypeInference.updatePeakMem();
        }
        RawNominalType win = null;
        for (Map.Entry entry : this.nominaltypesByNode.entrySet()) {
            RawNominalType rawType = (RawNominalType)entry.getValue();
            if (rawType.getName().equals(WINDOW_CLASS) && ((Node)entry.getKey()).isFromExterns()) {
                win = rawType;
                continue;
            }
            this.checkAndFreezeNominalType(rawType);
        }
        if (win != null) {
            Namespace namespace = this.globalScope.getNamespace(WINDOW_INSTANCE);
            if (namespace != null && !win.isFrozen()) {
                namespace.copyWindowProperties(this.commonTypes, win);
            }
            this.checkAndFreezeNominalType(win);
            globalThisType = win.getInstanceAsJSType();
        } else {
            globalThisType = this.commonTypes.getTopObject().withLoose();
        }
        this.commonTypes.setGlobalThis(globalThisType);
        this.globalScope.setDeclaredType(new FunctionTypeBuilder(this.commonTypes).addReceiverType(globalThisType).buildDeclaration());
        Preconditions.checkState((this.rawNominalTypes == null ? 1 : 0) != 0);
        this.rawNominalTypes = new ArrayList<RawNominalType>(this.nominaltypesByNode.values());
        this.nominaltypesByNode = null;
        this.propertyDefs = null;
        for (NTIScope s : this.scopes) {
            s.freezeScope();
        }
        NodeTraversal.traverseEs6(this.compiler, externs, new NodeTraversal.AbstractShallowCallback(){

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (n.isQualifiedName()) {
                    Declaration d = GlobalTypeInfo.this.globalScope.getDeclaration(QualifiedName.fromNode(n), false);
                    JSType type = GlobalTypeInfo.this.simpleInferDeclaration(d);
                    n.setTypeI(type);
                }
            }
        });
        Map<Node, String> map = this.typeParser.getUnknownTypesMap();
        for (Map.Entry<Node, String> unknownTypeEntry : map.entrySet()) {
            this.warnings.add(JSError.make(unknownTypeEntry.getKey(), UNRECOGNIZED_TYPE_NAME, unknownTypeEntry.getValue()));
        }
        for (JSError warning : this.typeParser.getWarnings()) {
            this.warnings.add(warning);
        }
        this.warnings = null;
        this.varNameGen = null;
        this.funNameGen = null;
        Collections.reverse(this.scopes);
        this.compiler.setExternProperties((Set<String>)ImmutableSet.copyOf(this.externPropertyNames));
    }

    private JSType simpleInferDeclaration(Declaration decl) {
        if (decl == null) {
            return null;
        }
        if (decl.getNominal() != null) {
            FunctionType ctorFn = decl.getNominal().getConstructorFunction();
            if (ctorFn == null) {
                return null;
            }
            return this.commonTypes.fromFunctionType(ctorFn).withProperty(CONST_INFERENCE_MARKER, this.commonTypes.UNKNOWN);
        }
        if (decl.getTypeOfSimpleDecl() != null) {
            return decl.getTypeOfSimpleDecl();
        }
        NTIScope funScope = (NTIScope)decl.getFunctionScope();
        if (funScope != null) {
            DeclaredFunctionType dft = funScope.getDeclaredFunctionType();
            if (dft == null) {
                return null;
            }
            return this.commonTypes.fromFunctionType(dft.toFunctionType());
        }
        return null;
    }

    private Collection<PropertyDef> getPropDefsFromInterface(NominalType nominalType, String pname) {
        Preconditions.checkArgument((boolean)nominalType.isFrozen());
        Preconditions.checkArgument((nominalType.isInterface() || nominalType.isBuiltinObject() ? 1 : 0) != 0);
        if (nominalType.getPropDeclaredType(pname) == null) {
            return ImmutableSet.of();
        }
        if (this.propertyDefs.get((Object)nominalType.getId(), (Object)pname) != null) {
            PropertyDef propDef = (PropertyDef)this.propertyDefs.get((Object)nominalType.getId(), (Object)pname);
            return ImmutableSet.of((Object)(nominalType.isGeneric() ? propDef.substituteNominalGenerics(nominalType) : propDef));
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (NominalType interf : nominalType.getInstantiatedInterfaces()) {
            result.addAll(this.getPropDefsFromInterface(interf, pname));
        }
        return result.build();
    }

    private PropertyDef getPropDefFromClass(NominalType nominalType, String pname) {
        while (nominalType.getPropDeclaredType(pname) != null) {
            Preconditions.checkArgument((boolean)nominalType.isFrozen());
            Preconditions.checkArgument((boolean)nominalType.isClass());
            if (this.propertyDefs.get((Object)nominalType.getId(), (Object)pname) != null) {
                PropertyDef propDef = (PropertyDef)this.propertyDefs.get((Object)nominalType.getId(), (Object)pname);
                return nominalType.isGeneric() ? propDef.substituteNominalGenerics(nominalType) : propDef;
            }
            nominalType = nominalType.getInstantiatedSuperclass();
        }
        return null;
    }

    private void checkAndFreezeNominalType(RawNominalType rawType) {
        NominalType literalObj;
        if (rawType.isFrozen()) {
            return;
        }
        NominalType superClass = rawType.getSuperClass();
        Set<String> nonInheritedPropNames = rawType.getAllOwnProps();
        if (superClass != null && !superClass.isFrozen()) {
            this.checkAndFreezeNominalType(superClass.getRawNominalType());
        }
        for (NominalType superInterf : rawType.getInterfaces()) {
            if (superInterf.isFrozen()) continue;
            this.checkAndFreezeNominalType(superInterf.getRawNominalType());
        }
        LinkedHashMultimap propMethodTypesToProcess = LinkedHashMultimap.create();
        LinkedHashMultimap propTypesToProcess = LinkedHashMultimap.create();
        if (superClass != null) {
            Preconditions.checkState((boolean)superClass.isFrozen());
            for (String pname : superClass.getAllPropsOfClass()) {
                if (superClass.isAbstractClass() && superClass.hasAbstractMethod(pname) && !rawType.isAbstractClass() && !rawType.mayHaveOwnProp(pname)) {
                    this.warnings.add(JSError.make(rawType.getDefSite(), ABSTRACT_METHOD_NOT_IMPLEMENTED_IN_CONCRETE_CLASS, pname, superClass.getName()));
                }
                nonInheritedPropNames.remove(pname);
                this.checkSuperProperty(rawType, superClass, pname, (Multimap<String, DeclaredFunctionType>)propMethodTypesToProcess, (Multimap<String, JSType>)propTypesToProcess);
            }
        }
        for (NominalType superInterf : rawType.getInterfaces()) {
            Preconditions.checkState((boolean)superInterf.isFrozen());
            for (String pname : superInterf.getAllPropsOfInterface()) {
                nonInheritedPropNames.remove(pname);
                this.checkSuperProperty(rawType, superInterf, pname, (Multimap<String, DeclaredFunctionType>)propMethodTypesToProcess, (Multimap<String, JSType>)propTypesToProcess);
            }
        }
        for (String pname : propMethodTypesToProcess.keySet()) {
            Collection methodTypes = propMethodTypesToProcess.get((Object)pname);
            Preconditions.checkState((!methodTypes.isEmpty() ? 1 : 0) != 0);
            PropertyDef localPropDef = (PropertyDef)this.propertyDefs.get((Object)rawType, (Object)pname);
            Object superMethodType = DeclaredFunctionType.meet(methodTypes);
            DeclaredFunctionType localMethodType = localPropDef.methodType;
            boolean getsTypeFromParent = GlobalTypeInfo.getsTypeInfoFromParentMethod(localPropDef);
            if (superMethodType == null) {
                superMethodType = (DeclaredFunctionType)methodTypes.iterator().next();
                this.warnings.add(JSError.make(localPropDef.defSite, SUPER_INTERFACES_HAVE_INCOMPATIBLE_PROPERTIES, rawType.getName(), pname, methodTypes.toString()));
            } else if (getsTypeFromParent && localMethodType.getMaxArity() > ((DeclaredFunctionType)superMethodType).getMaxArity()) {
                this.warnings.add(JSError.make(localPropDef.defSite, INVALID_PROP_OVERRIDE, pname, ((DeclaredFunctionType)superMethodType).toFunctionType().toString(), localMethodType.toFunctionType().toString()));
            }
            DeclaredFunctionType updatedMethodType = localMethodType.withTypeInfoFromSuper((DeclaredFunctionType)superMethodType, getsTypeFromParent);
            localPropDef.updateMethodType(updatedMethodType);
            propTypesToProcess.put((Object)pname, (Object)this.commonTypes.fromFunctionType(updatedMethodType.toFunctionType()));
        }
        block5: for (String pname : propTypesToProcess.keySet()) {
            Collection defs = propTypesToProcess.get((Object)pname);
            Preconditions.checkState((!defs.isEmpty() ? 1 : 0) != 0);
            JSType resultType = this.commonTypes.TOP;
            for (JSType inheritedType : defs) {
                if (!(resultType = JSType.meet(resultType, inheritedType)).isBottom()) {
                    resultType = inheritedType;
                    continue;
                }
                this.warnings.add(JSError.make(rawType.getDefSite(), SUPER_INTERFACES_HAVE_INCOMPATIBLE_PROPERTIES, rawType.getName(), pname, defs.toString()));
                continue block5;
            }
            rawType.addProtoProperty(pname, null, resultType, false);
        }
        if (rawType.inheritsFromIObject()) {
            JSType wrapped = rawType.getInstanceAsJSType();
            if (wrapped.getIndexType() == null) {
                this.warnings.add(JSError.make(rawType.getDefSite(), SUPER_INTERFACES_HAVE_INCOMPATIBLE_PROPERTIES, rawType.getName(), "IObject<K,V>#index", "the keys K have types that can't be joined."));
            } else if (wrapped.getIndexedType() == null) {
                this.warnings.add(JSError.make(rawType.getDefSite(), SUPER_INTERFACES_HAVE_INCOMPATIBLE_PROPERTIES, rawType.getName(), "IObject<K,V>#index", "the values V should have a common subtype."));
            }
        }
        for (String pname : nonInheritedPropNames) {
            Node propDefsite;
            JSDocInfo jsdoc;
            PropertyDef propDef = (PropertyDef)this.propertyDefs.get((Object)rawType, (Object)pname);
            Preconditions.checkState((propDef != null || rawType.getName().equals(WINDOW_CLASS) ? 1 : 0) != 0);
            if (propDef == null || (jsdoc = NodeUtil.getBestJSDocInfo(propDefsite = propDef.defSite)) == null || !jsdoc.isOverride()) continue;
            this.warnings.add(JSError.make(propDefsite, UNKNOWN_OVERRIDE, pname, rawType.getName()));
        }
        rawType.freeze();
        if (rawType.isBuiltinObject() && !(literalObj = this.commonTypes.getLiteralObjNominalType()).isFrozen()) {
            literalObj.getRawNominalType().freeze();
        }
    }

    private void checkSuperProperty(RawNominalType current, NominalType superType, String pname, Multimap<String, DeclaredFunctionType> propMethodTypesToProcess, Multimap<String, JSType> propTypesToProcess) {
        JSType localPropType;
        ImmutableSet inheritedPropDefs;
        JSType inheritedPropType = superType.getPropDeclaredType(pname);
        if (inheritedPropType == null) {
            return;
        }
        if (superType.isInterface()) {
            inheritedPropDefs = this.getPropDefsFromInterface(superType, pname);
            if (GlobalTypeInfo.isCtorDefinedByCall(NodeUtil.getBestLValue(current.getDefSite()))) {
                for (PropertyDef inheritedDef : inheritedPropDefs) {
                    if (current.mayHaveProp(pname)) continue;
                    this.propertyDefs.put((Object)current, (Object)pname, (Object)inheritedDef);
                }
            }
        } else {
            PropertyDef propdef = (PropertyDef)Preconditions.checkNotNull((Object)this.getPropDefFromClass(superType, pname));
            inheritedPropDefs = ImmutableSet.of((Object)propdef);
        }
        if (superType.isInterface() && current.isClass() && !GlobalTypeInfo.isCtorDefinedByCall(NodeUtil.getBestLValue(current.getDefSite())) && !current.mayHaveProp(pname)) {
            this.warnings.add(JSError.make(((PropertyDef)inheritedPropDefs.iterator().next()).defSite, INTERFACE_METHOD_NOT_IMPLEMENTED, pname, superType.toString(), current.toString()));
            return;
        }
        PropertyDef localPropDef = (PropertyDef)this.propertyDefs.get((Object)current, (Object)pname);
        JSType jSType = localPropType = localPropDef == null ? null : current.getInstancePropDeclaredType(pname);
        if (localPropDef != null && superType.isClass() && localPropType != null && localPropType.getFunType() != null && superType.hasConstantProp(pname)) {
            this.warnings.add(JSError.make(localPropDef.defSite, CANNOT_OVERRIDE_FINAL_METHOD, pname));
            return;
        }
        if (localPropType == null && superType.isInterface()) {
            propTypesToProcess.put((Object)pname, (Object)inheritedPropType);
        } else if (localPropType != null && !GlobalTypeInfo.getsTypeInfoFromParentMethod(localPropDef) && !this.isValidOverride(localPropType, inheritedPropType)) {
            this.warnings.add(JSError.make(localPropDef.defSite, INVALID_PROP_OVERRIDE, pname, inheritedPropType.toString(), localPropType.toString()));
        } else if (localPropType != null && localPropDef.methodType != null) {
            for (PropertyDef inheritedPropDef : inheritedPropDefs) {
                if (inheritedPropDef.methodType == null) continue;
                propMethodTypesToProcess.put((Object)pname, (Object)inheritedPropDef.methodType);
            }
        }
    }

    private boolean isValidOverride(JSType localPropType, JSType inheritedPropType) {
        FunctionType localFunType = localPropType.getFunType();
        FunctionType inheritedFunType = inheritedPropType.getFunType();
        if (localFunType == null) {
            return localPropType.isSubtypeOf(inheritedPropType);
        }
        if (inheritedFunType == null) {
            return false;
        }
        return localFunType.isValidOverride(inheritedFunType);
    }

    private static boolean getsTypeInfoFromParentMethod(PropertyDef pd) {
        if (pd == null || pd.methodType == null) {
            return false;
        }
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(pd.defSite);
        if (jsdoc == null) {
            return true;
        }
        return (jsdoc.isOverride() || jsdoc.isExport()) && !jsdoc.containsFunctionDeclaration();
    }

    private JSType getDeclaredTypeOfNode(JSDocInfo jsdoc, NTIScope s) {
        return this.typeParser.getDeclaredTypeOfNode(jsdoc, null, s);
    }

    private JSType getVarTypeFromAnnotation(Node nameNode, NTIScope currentScope) {
        Preconditions.checkArgument((boolean)nameNode.getParent().isVar());
        Node varNode = nameNode.getParent();
        JSType varType = this.getDeclaredTypeOfNode(varNode.getJSDocInfo(), currentScope);
        if (varNode.hasMoreThanOneChild() && varType != null) {
            this.warnings.add(JSError.make(varNode, ONE_TYPE_FOR_MANY_VARS, new String[0]));
        }
        String varName = nameNode.getString();
        JSType nameNodeType = this.getDeclaredTypeOfNode(nameNode.getJSDocInfo(), currentScope);
        if (nameNodeType != null) {
            if (varType != null) {
                this.warnings.add(JSError.make(nameNode, DUPLICATE_JSDOC, varName));
            }
            return nameNodeType;
        }
        return varType;
    }

    private static boolean isPropertyDeclarationOnThis(Node n, NTIScope s) {
        Node parent = n.getParent();
        return n.isGetProp() && n.getFirstChild().isThis() && (parent.isAssign() && parent.getFirstChild().equals(n) || parent.isExprResult()) && (s.isConstructor() || s.isInterface() || s.isPrototypeMethod());
    }

    private static boolean isPrototypeProperty(Node getProp) {
        if (!getProp.isGetProp()) {
            return false;
        }
        Node recv = getProp.getFirstChild();
        return recv.isGetProp() && recv.getLastChild().getString().equals("prototype");
    }

    private static boolean isPrototypePropertyDeclaration(Node n) {
        if (NodeUtil.isExprAssign(n) && GlobalTypeInfo.isPrototypeProperty(n.getFirstFirstChild()) && n.getFirstFirstChild().isQualifiedName()) {
            return true;
        }
        if (n.isObjectLit()) {
            Node parent = n.getParent();
            if (parent.isAssign() && parent.getParent().isExprResult() && parent.getFirstChild().isGetProp() && parent.getFirstChild().getLastChild().getString().equals("prototype")) {
                return true;
            }
            JSDocInfo jsdoc = n.getJSDocInfo();
            return jsdoc != null && jsdoc.getLendsName() != null && jsdoc.getLendsName().endsWith("prototype");
        }
        return false;
    }

    private static boolean isAnnotatedAsConst(Node defSite) {
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(defSite);
        return jsdoc != null && jsdoc.hasConstAnnotation() && !jsdoc.isConstructor();
    }

    private static Node fromDefsiteToName(Node defSite) {
        if (defSite.isGetProp()) {
            return defSite.getLastChild();
        }
        if (defSite.isName() || defSite.isStringKey() || defSite.isGetterDef() || defSite.isSetterDef()) {
            return defSite;
        }
        throw new RuntimeException("Unknown defsite: " + (Object)((Object)defSite.getToken()));
    }

    private boolean isConst(Node defSite) {
        return GlobalTypeInfo.isAnnotatedAsConst(defSite) || !defSite.isFromExterns() && NodeUtil.isConstantByConvention(this.convention, GlobalTypeInfo.fromDefsiteToName(defSite));
    }

    static boolean isCtorDefinedByCall(Node qnameNode) {
        if (!qnameNode.isName() && !qnameNode.isGetProp()) {
            return false;
        }
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
        Node rhs = NodeUtil.getRValueOfLValue(qnameNode);
        return jsdoc != null && jsdoc.isConstructor() && rhs != null && rhs.isCall();
    }

    private static boolean isCtorWithoutFunctionLiteral(Node qnameNode) {
        if (!qnameNode.isFromExterns()) {
            return false;
        }
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
        if (jsdoc == null || !jsdoc.isConstructor()) {
            return false;
        }
        if (qnameNode.isName()) {
            return qnameNode.getParent().isVar() && !qnameNode.hasChildren();
        }
        if (qnameNode.isGetProp()) {
            return qnameNode.getParent().isExprResult();
        }
        return false;
    }

    @Override
    public TypeI createTypeFromCommentNode(Node n) {
        return this.typeParser.getTypeOfCommentNode(n, null, this.globalScope);
    }

    public JSType getNativeFunctionType(JSTypeNative typeId) {
        return this.getNativeType(typeId);
    }

    public JSType getNativeObjectType(JSTypeNative typeId) {
        return this.getNativeType(typeId);
    }

    public JSType getNativeType(JSTypeNative typeId) {
        return this.commonTypes.getNativeType(typeId);
    }

    @Override
    public String getReadableTypeName(Node n) {
        return n.getTypeI().getDisplayName();
    }

    public JSType getType(String typeName) {
        switch (typeName) {
            case "boolean": {
                return this.commonTypes.BOOLEAN;
            }
            case "number": {
                return this.commonTypes.NUMBER;
            }
            case "string": {
                return this.commonTypes.STRING;
            }
            case "null": {
                return this.commonTypes.NULL;
            }
            case "undefined": 
            case "void": {
                return this.commonTypes.UNDEFINED;
            }
        }
        return this.globalScope.getType(typeName);
    }

    @Override
    public TypeI createUnionType(List<? extends TypeI> members) {
        Preconditions.checkArgument((!members.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create union type with no members");
        JSType result = this.commonTypes.BOTTOM;
        for (TypeI typeI : members) {
            result = JSType.join(result, (JSType)typeI);
        }
        return result;
    }

    @Override
    public TypeI evaluateTypeExpression(JSTypeExpression expr, TypeIEnv<TypeI> typeEnv) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypeI evaluateTypeExpressionInGlobalScope(JSTypeExpression expr) {
        return this.createTypeFromCommentNode(expr.getRoot());
    }

    @Override
    public TypeI createRecordType(Map<String, ? extends TypeI> props) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypeI instantiateGenericType(ObjectTypeI genericType, ImmutableList<? extends TypeI> typeArgs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypeI buildRecordTypeFromObject(ObjectTypeI obj) {
        throw new UnsupportedOperationException();
    }

    @GwtIncompatible(value="ObjectInputStream")
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        for (RawNominalType rawNominalType : this.rawNominalTypes) {
            rawNominalType.unfreezeForDeserialization();
        }
        for (RawNominalType rawNominalType : this.rawNominalTypes) {
            rawNominalType.fixSubtypesAfterDeserialization();
        }
        for (RawNominalType rawNominalType : this.rawNominalTypes) {
            rawNominalType.refreezeAfterDeserialization();
        }
    }

    private static class PropertyDef {
        final Node defSite;
        DeclaredFunctionType methodType;
        final NTIScope methodScope;

        PropertyDef(Node defSite, DeclaredFunctionType methodType, NTIScope methodScope) {
            Preconditions.checkNotNull((Object)defSite);
            Preconditions.checkArgument((defSite.isGetProp() || NodeUtil.isObjectLitKey(defSite) ? 1 : 0) != 0);
            this.defSite = defSite;
            this.methodType = methodType;
            this.methodScope = methodScope;
        }

        PropertyDef substituteNominalGenerics(NominalType nt) {
            Preconditions.checkArgument((boolean)nt.isGeneric(), (Object)nt);
            if (this.methodType == null) {
                return this;
            }
            return new PropertyDef(this.defSite, this.methodType.substituteNominalGenerics(nt), this.methodScope);
        }

        void updateMethodType(DeclaredFunctionType updatedType) {
            this.methodType = updatedType;
            if (this.methodScope != null) {
                this.methodScope.setDeclaredType(updatedType);
            }
        }

        public String toString() {
            return "PropertyDef(" + this.defSite + ", " + this.methodType + ")";
        }
    }

    private static class PropertyType {
        JSType declType = null;
        JSType inferredFunType = null;

        private PropertyType() {
        }
    }

    private class ProcessScope
    extends NodeTraversal.AbstractShallowCallback {
        private final NTIScope currentScope;
        private Set<Node> lendsObjlits = new LinkedHashSet<Node>();

        ProcessScope(NTIScope currentScope) {
            this.currentScope = currentScope;
        }

        void finishProcessingScope() {
            for (Node objlit : this.lendsObjlits) {
                this.processLendsNode(objlit);
            }
            this.lendsObjlits = null;
        }

        void processLendsNode(Node objlit) {
            JSDocInfo jsdoc = objlit.getJSDocInfo();
            String lendsName = jsdoc.getLendsName();
            Preconditions.checkNotNull((Object)lendsName);
            QualifiedName lendsQname = QualifiedName.fromQualifiedString(lendsName);
            if (this.currentScope.isNamespace(lendsQname)) {
                this.processLendsToNamespace(lendsQname, lendsName, objlit);
            } else {
                RawNominalType rawType = this.checkValidLendsToPrototypeAndGetClass(lendsQname, lendsName, objlit);
                if (rawType != null) {
                    for (Node prop : objlit.children()) {
                        String pname = NodeUtil.getObjectLitKeyName(prop);
                        this.mayAddPropToPrototype(rawType, pname, prop, prop.getFirstChild());
                    }
                } else {
                    for (Node prop : objlit.children()) {
                        Node propInit = prop.getFirstChild();
                        if (!propInit.isFunction()) continue;
                        this.visitFunctionLate(propInit, null);
                    }
                }
            }
        }

        void processLendsToNamespace(QualifiedName lendsQname, String lendsName, Node objlit) {
            RawNominalType rawType = this.currentScope.getNominalType(lendsQname);
            if (rawType != null && rawType.isInterface()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(objlit, LENDS_ON_BAD_TYPE, lendsName));
                return;
            }
            Namespace borrowerNamespace = this.currentScope.getNamespace(lendsQname);
            for (Node prop : objlit.children()) {
                String pname = NodeUtil.getObjectLitKeyName(prop);
                JSType propDeclType = (JSType)GlobalTypeInfo.this.declaredObjLitProps.get(prop);
                if (propDeclType != null) {
                    borrowerNamespace.addProperty(pname, prop, propDeclType, false);
                    continue;
                }
                JSType t = this.simpleInferExprType(prop.getFirstChild());
                if (t == null) {
                    t = ((GlobalTypeInfo)GlobalTypeInfo.this).commonTypes.UNKNOWN;
                }
                borrowerNamespace.addProperty(pname, prop, t, false);
            }
        }

        RawNominalType checkValidLendsToPrototypeAndGetClass(QualifiedName lendsQname, String lendsName, Node objlit) {
            if (!lendsQname.getRightmostName().equals("prototype")) {
                GlobalTypeInfo.this.warnings.add(JSError.make(objlit, LENDS_ON_BAD_TYPE, lendsName));
                return null;
            }
            QualifiedName recv = lendsQname.getAllButRightmost();
            RawNominalType rawType = this.currentScope.getNominalType(recv);
            if (rawType == null || rawType.isInterface()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(objlit, LENDS_ON_BAD_TYPE, lendsName));
            }
            return rawType;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case FUNCTION: {
                    Node grandparent = parent.getParent();
                    if (grandparent != null && (GlobalTypeInfo.isPrototypePropertyDeclaration(grandparent) || GlobalTypeInfo.isPropertyDeclarationOnThis(parent.getFirstChild(), this.currentScope))) break;
                    RawNominalType ownerType = this.maybeGetOwnerType(n, parent);
                    this.visitFunctionLate(n, ownerType);
                    break;
                }
                case NAME: {
                    String name = n.getString();
                    if (name == null || parent.isFunction()) {
                        return;
                    }
                    if (parent.isVar() || parent.isCatch()) {
                        this.visitVar(n, parent);
                        break;
                    }
                    if (this.currentScope.isOuterVarEarly(name)) {
                        this.currentScope.addOuterVar(name);
                        break;
                    }
                    if (this.currentScope.getTypedef(name) != null || name.equals(this.currentScope.getName()) || this.currentScope.isDefinedLocally(name, false)) break;
                    break;
                }
                case GETPROP: {
                    if (NodeUtil.isPropertyTest(GlobalTypeInfo.this.compiler, n) || this.isPropertyAbsentTest(n)) {
                        GlobalTypeInfo.this.recordPropertyName(n.getLastChild().getString(), n);
                    }
                    if (n.getFirstChild().isName() && n.getFirstChild().getString().startsWith("$jscomp$destructuring$")) {
                        GlobalTypeInfo.this.recordPropertyName(n.getLastChild().getString(), n);
                    }
                    if (!parent.isExprResult() || !n.isQualifiedName()) break;
                    this.visitPropertyDeclaration(n);
                    break;
                }
                case ASSIGN: {
                    Node lvalue = n.getFirstChild();
                    if (!lvalue.isGetProp() || !lvalue.isQualifiedName()) break;
                    this.visitPropertyDeclaration(lvalue);
                    break;
                }
                case CAST: {
                    GlobalTypeInfo.this.castTypes.put(n, GlobalTypeInfo.this.getDeclaredTypeOfNode(n.getJSDocInfo(), this.currentScope));
                    break;
                }
                case OBJECTLIT: {
                    this.visitObjectLit(n, parent);
                    break;
                }
                case CALL: {
                    this.visitCall(n);
                    break;
                }
            }
        }

        private boolean isPropertyAbsentTest(Node propAccessNode) {
            Node parent = propAccessNode.getParent();
            if (parent.getToken() == Token.EQ || parent.getToken() == Token.SHEQ) {
                Node other = parent.getFirstChild() == propAccessNode ? parent.getSecondChild() : parent.getFirstChild();
                return NodeUtil.isUndefined(other);
            }
            return parent.isNot() && parent.getParent().isIf();
        }

        private void visitVar(Node nameNode, Node parent) {
            String name = nameNode.getString();
            boolean isDefinedLocally = this.currentScope.isDefinedLocally(name, false);
            if (GlobalTypeInfo.isCtorDefinedByCall(nameNode)) {
                this.computeFnDeclaredType(NodeUtil.getBestJSDocInfo(nameNode), name, nameNode.getFirstChild(), null, this.currentScope);
                return;
            }
            if (GlobalTypeInfo.isCtorWithoutFunctionLiteral(nameNode)) {
                this.computeFnDeclaredType(NodeUtil.getBestJSDocInfo(nameNode), name, nameNode, null, this.currentScope);
                return;
            }
            if (isDefinedLocally && this.currentScope.isNamespace(name)) {
                return;
            }
            if (NodeUtil.isTypedefDecl(nameNode) || NodeUtil.isEnumDecl(nameNode)) {
                if (!isDefinedLocally) {
                    this.currentScope.addLocal(name, ((GlobalTypeInfo)GlobalTypeInfo.this).commonTypes.UNKNOWN, false, nameNode.isFromExterns());
                }
                return;
            }
            Node initializer = nameNode.getFirstChild();
            if (initializer != null && initializer.isFunction()) {
                return;
            }
            if (parent.isCatch()) {
                this.currentScope.addLocal(name, ((GlobalTypeInfo)GlobalTypeInfo.this).commonTypes.UNKNOWN, false, false);
            } else {
                boolean isConst = GlobalTypeInfo.this.isConst(nameNode);
                JSType declType = GlobalTypeInfo.this.getVarTypeFromAnnotation(nameNode, this.currentScope);
                if (declType == null) {
                    declType = this.mayInferFromRhsIfConst(nameNode);
                }
                this.currentScope.addLocal(name, declType, isConst, nameNode.isFromExterns());
            }
        }

        private void visitObjectLit(Node objLitNode, Node parent) {
            block5: {
                Node maybeLvalue;
                block4: {
                    JSDocInfo jsdoc = objLitNode.getJSDocInfo();
                    if (jsdoc != null && jsdoc.getLendsName() != null) {
                        this.lendsObjlits.add(objLitNode);
                    }
                    Node node = maybeLvalue = parent.isAssign() ? parent.getFirstChild() : parent;
                    if (!NodeUtil.isNamespaceDecl(maybeLvalue) || !this.currentScope.isNamespace(maybeLvalue)) break block4;
                    for (Node prop : objLitNode.children()) {
                        GlobalTypeInfo.this.recordPropertyName(prop.getString(), prop);
                        this.visitNamespacePropertyDeclaration(prop, maybeLvalue, prop.getString());
                    }
                    break block5;
                }
                if (NodeUtil.isEnumDecl(maybeLvalue) || NodeUtil.isPrototypeAssignment(maybeLvalue)) break block5;
                for (Node prop : objLitNode.children()) {
                    GlobalTypeInfo.this.recordPropertyName(prop.getString(), prop);
                    if (prop.getJSDocInfo() != null) {
                        GlobalTypeInfo.this.declaredObjLitProps.put(prop, GlobalTypeInfo.this.getDeclaredTypeOfNode(prop.getJSDocInfo(), this.currentScope));
                    }
                    if (!GlobalTypeInfo.isAnnotatedAsConst(prop)) continue;
                    GlobalTypeInfo.this.warnings.add(JSError.make(prop, MISPLACED_CONST_ANNOTATION, new String[0]));
                }
            }
        }

        private void visitCall(Node call) {
            String className = GlobalTypeInfo.this.convention.getSingletonGetterClassName(call);
            if (className == null) {
                return;
            }
            QualifiedName qname = QualifiedName.fromQualifiedString(className);
            RawNominalType rawType = this.currentScope.getNominalType(qname);
            if (rawType != null) {
                JSType instanceType = rawType.getInstanceAsJSType();
                FunctionType getInstanceFunType = new FunctionTypeBuilder(GlobalTypeInfo.this.commonTypes).addRetType(instanceType).buildFunction();
                JSType getInstanceType = GlobalTypeInfo.this.commonTypes.fromFunctionType(getInstanceFunType);
                GlobalTypeInfo.this.convention.applySingletonGetterNew(rawType, getInstanceType, instanceType);
            }
        }

        private void visitPropertyDeclaration(Node getProp) {
            GlobalTypeInfo.this.recordPropertyName(getProp.getLastChild().getString(), getProp);
            if (GlobalTypeInfo.isPropertyDeclarationOnThis(getProp, this.currentScope)) {
                this.visitPropertyDeclarationOnThis(getProp);
            } else if (GlobalTypeInfo.isPrototypeProperty(getProp)) {
                this.visitPrototypePropertyDeclaration(getProp);
            } else if (NodeUtil.isPrototypeAssignment(getProp)) {
                getProp.putBooleanProp(76, true);
                this.visitPrototypeAssignment(getProp);
            } else if (this.isStaticCtorProp(getProp, this.currentScope)) {
                this.visitConstructorPropertyDeclaration(getProp);
            } else if (this.currentScope.isNamespace(getProp.getFirstChild())) {
                this.visitNamespacePropertyDeclaration(getProp);
            } else {
                this.visitOtherPropertyDeclaration(getProp);
            }
        }

        private boolean isStaticCtorProp(Node getProp, NTIScope s) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            if (!getProp.isQualifiedName()) {
                return false;
            }
            Node receiverObj = getProp.getFirstChild();
            if (!s.isLocalFunDef(receiverObj.getQualifiedName())) {
                return false;
            }
            return null != this.currentScope.getNominalType(QualifiedName.fromNode(receiverObj));
        }

        private NTIScope visitFunctionLate(Node fn, RawNominalType ownerType) {
            Preconditions.checkArgument((boolean)fn.isFunction());
            String internalName = GlobalTypeInfo.this.getFunInternalName(fn);
            NTIScope fnScope = this.currentScope.getScope(internalName);
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(fn);
            DeclaredFunctionType declFunType = fnScope.getDeclaredFunctionType();
            if (declFunType == null) {
                declFunType = this.computeFnDeclaredType(jsdoc, internalName, fn, ownerType, this.currentScope);
                fnScope.setDeclaredType(declFunType);
            }
            return fnScope;
        }

        PropertyType getPropTypeHelper(JSDocInfo jsdoc, Node declNode, RawNominalType thisType) {
            Node initializer = NodeUtil.getRValueOfLValue(declNode);
            PropertyType result = new PropertyType();
            DeclaredFunctionType dft = null;
            if (initializer != null && initializer.isFunction()) {
                dft = this.visitFunctionLate(initializer, thisType).getDeclaredFunctionType();
            }
            if (jsdoc != null && jsdoc.hasType()) {
                result.declType = GlobalTypeInfo.this.getDeclaredTypeOfNode(jsdoc, this.currentScope);
            } else if (jsdoc != null && jsdoc.containsFunctionDeclaration() && (initializer == null || !initializer.isFunction())) {
                Preconditions.checkState((boolean)declNode.isGetProp());
                dft = this.computeFnDeclaredType(jsdoc, declNode.getLastChild().getString(), declNode, null, this.currentScope);
                result.declType = GlobalTypeInfo.this.commonTypes.fromFunctionType(dft.toFunctionType());
            } else if (initializer != null && initializer.isFunction()) {
                JSType funType = GlobalTypeInfo.this.commonTypes.fromFunctionType(dft.toFunctionType());
                if (jsdoc != null && jsdoc.containsFunctionDeclaration() || NodeUtil.functionHasInlineJsdocs(initializer)) {
                    result.declType = funType;
                } else {
                    result.inferredFunType = funType;
                }
            }
            return result;
        }

        private void visitPrototypePropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            Node ctorNameNode = NodeUtil.getPrototypeClassName(getProp);
            QualifiedName ctorQname = QualifiedName.fromNode(ctorNameNode);
            RawNominalType ownerType = this.currentScope.getNominalType(ctorQname);
            if (ownerType != null && !this.currentScope.isDefined(ctorNameNode)) {
                GlobalTypeInfo.this.warnings.add(JSError.make(getProp, CTOR_IN_DIFFERENT_SCOPE, new String[0]));
            }
            this.visitPrototypePropertyDeclaration(getProp, ownerType);
        }

        private void visitPrototypePropertyDeclaration(Node getProp, RawNominalType ownerType) {
            Node initializer;
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            Node parent = getProp.getParent();
            Node node = initializer = parent.isAssign() ? parent.getLastChild() : null;
            if (ownerType == null) {
                if (initializer != null && initializer.isFunction()) {
                    this.visitFunctionLate(initializer, null);
                }
                return;
            }
            if (initializer != null && initializer.isFunction()) {
                parent.putBooleanProp(76, true);
            }
            this.mayWarnAboutInterfacePropInit(ownerType, initializer);
            this.mayAddPropToPrototype(ownerType, getProp.getLastChild().getString(), getProp, initializer);
        }

        private void mayWarnAboutInterfacePropInit(RawNominalType rawType, Node initializer) {
            if (rawType.isInterface() && initializer != null) {
                String abstractMethodName = GlobalTypeInfo.this.convention.getAbstractMethodName();
                if (initializer.isFunction() && !NodeUtil.isEmptyFunctionExpression(initializer)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(initializer, INTERFACE_METHOD_NOT_EMPTY, new String[0]));
                } else if (!initializer.isFunction() && !initializer.matchesQualifiedName(abstractMethodName)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(initializer, INVALID_INTERFACE_PROP_INITIALIZER, new String[0]));
                }
            }
        }

        private void visitPrototypeAssignment(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            Node protoObjNode = getProp.getParent().getLastChild();
            if (!protoObjNode.isObjectLit()) {
                return;
            }
            Node ctorNameNode = NodeUtil.getPrototypeClassName(getProp);
            QualifiedName ctorQname = QualifiedName.fromNode(ctorNameNode);
            RawNominalType rawType = this.currentScope.getNominalType(ctorQname);
            if (rawType == null) {
                for (Node objLitChild : protoObjNode.children()) {
                    Node initializer = objLitChild.getLastChild();
                    if (initializer == null || !initializer.isFunction()) continue;
                    this.visitFunctionLate(initializer, null);
                }
                return;
            }
            getProp.putBooleanProp(76, true);
            for (Node objLitChild : protoObjNode.children()) {
                this.mayAddPropToPrototype(rawType, objLitChild.getString(), objLitChild, objLitChild.getLastChild());
            }
        }

        private void visitConstructorPropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            this.mayVisitWeirdCtorDefinition(getProp);
            if (this.isNamedType(getProp)) {
                return;
            }
            String ctorName = getProp.getFirstChild().getQualifiedName();
            QualifiedName ctorQname = QualifiedName.fromNode(getProp.getFirstChild());
            Preconditions.checkState((boolean)this.currentScope.isLocalFunDef(ctorName));
            RawNominalType classType = this.currentScope.getNominalType(ctorQname);
            String pname = getProp.getLastChild().getString();
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(getProp);
            JSType propDeclType = GlobalTypeInfo.this.getDeclaredTypeOfNode(jsdoc, this.currentScope);
            boolean isConst = GlobalTypeInfo.this.isConst(getProp);
            if (propDeclType != null || isConst) {
                JSType previousPropType = classType.getCtorPropDeclaredType(pname);
                if (classType.hasCtorProp(pname) && previousPropType != null && !this.suppressDupPropWarning(jsdoc, propDeclType, previousPropType)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(getProp, REDECLARED_PROPERTY, pname, "type " + classType));
                    return;
                }
                if (propDeclType == null) {
                    propDeclType = this.mayInferFromRhsIfConst(getProp);
                }
                classType.addCtorProperty(pname, getProp, propDeclType, isConst);
                getProp.putBooleanProp(76, true);
                if (isConst) {
                    getProp.putBooleanProp(77, true);
                }
            } else {
                JSType inferredType = null;
                Node initializer = NodeUtil.getRValueOfLValue(getProp);
                if (initializer != null) {
                    inferredType = this.simpleInferExprType(initializer);
                }
                if (inferredType == null) {
                    inferredType = ((GlobalTypeInfo)GlobalTypeInfo.this).commonTypes.UNKNOWN;
                }
                classType.addUndeclaredCtorProperty(pname, getProp, inferredType);
            }
        }

        private void mayVisitWeirdCtorDefinition(Node getProp) {
            if (GlobalTypeInfo.isCtorDefinedByCall(getProp)) {
                this.computeFnDeclaredType(NodeUtil.getBestJSDocInfo(getProp), getProp.getQualifiedName(), getProp.getNext(), null, this.currentScope);
                return;
            }
            if (GlobalTypeInfo.isCtorWithoutFunctionLiteral(getProp)) {
                this.computeFnDeclaredType(NodeUtil.getBestJSDocInfo(getProp), getProp.getQualifiedName(), getProp, null, this.currentScope);
                return;
            }
        }

        private void visitNamespacePropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            this.mayVisitWeirdCtorDefinition(getProp);
            if (this.isNamedType(getProp)) {
                return;
            }
            Node recv = getProp.getFirstChild();
            String pname = getProp.getLastChild().getString();
            this.visitNamespacePropertyDeclaration(getProp, recv, pname);
        }

        private void visitNamespacePropertyDeclaration(Node declNode, Node recv, String pname) {
            Preconditions.checkArgument((declNode.isGetProp() || declNode.isStringKey() || declNode.isGetterDef() || declNode.isSetterDef() ? 1 : 0) != 0, (Object)declNode);
            Preconditions.checkArgument((boolean)this.currentScope.isNamespace(recv));
            if (declNode.isGetterDef()) {
                pname = JSType.createGetterPropName(pname);
            } else if (declNode.isSetterDef()) {
                pname = JSType.createSetterPropName(pname);
            }
            if (declNode.isStringKey() && this.currentScope.isNamespace(declNode.getFirstChild())) {
                return;
            }
            EnumType et = this.currentScope.getEnum(QualifiedName.fromNode(recv));
            if (et != null && et.enumLiteralHasKey(pname)) {
                return;
            }
            Namespace ns = this.currentScope.getNamespace(QualifiedName.fromNode(recv));
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(declNode);
            PropertyType pt = this.getPropTypeHelper(jsdoc, declNode, null);
            JSType propDeclType = pt.declType;
            JSType propInferredFunType = pt.inferredFunType;
            boolean isConst = GlobalTypeInfo.this.isConst(declNode);
            if (propDeclType != null || isConst) {
                JSType previousPropType = ns.getPropDeclaredType(pname);
                if (ns.hasSubnamespace(new QualifiedName(pname)) || ns.hasProp(pname) && previousPropType != null && !this.suppressDupPropWarning(jsdoc, propDeclType, previousPropType)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(declNode, REDECLARED_PROPERTY, pname, "namespace " + ns));
                    declNode.getParent().putBooleanProp(76, true);
                    return;
                }
                if (propDeclType == null) {
                    propDeclType = this.mayInferFromRhsIfConst(declNode);
                }
                ns.addProperty(pname, declNode, propDeclType, isConst);
                declNode.putBooleanProp(76, true);
                if (declNode.isGetProp() && isConst) {
                    declNode.putBooleanProp(77, true);
                }
            } else if (propInferredFunType != null) {
                ns.addUndeclaredProperty(pname, declNode, propInferredFunType, false);
            } else {
                JSType t;
                Node initializer = NodeUtil.getRValueOfLValue(declNode);
                JSType jSType = t = initializer == null ? null : this.simpleInferExprType(initializer);
                if (t == null) {
                    t = ((GlobalTypeInfo)GlobalTypeInfo.this).commonTypes.UNKNOWN;
                }
                ns.addUndeclaredProperty(pname, declNode, t, false);
            }
        }

        private void visitPropertyDeclarationOnThis(Node getProp) {
            Node initializer;
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            JSType t = this.currentScope.getDeclaredFunctionType().getThisType();
            NominalType thisType = t == null ? null : t.getNominalTypeIfSingletonObj();
            Node parent = getProp.getParent();
            Node node = initializer = parent.isAssign() ? parent.getLastChild() : null;
            if (thisType == null) {
                if (initializer != null && initializer.isFunction()) {
                    this.visitFunctionLate(initializer, null);
                }
                return;
            }
            RawNominalType rawType = thisType.getRawNominalType();
            if (rawType.isInterface()) {
                this.visitPrototypePropertyDeclaration(getProp, rawType);
                return;
            }
            String pname = getProp.getLastChild().getString();
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(getProp);
            PropertyType pt = this.getPropTypeHelper(jsdoc, getProp, rawType);
            JSType propDeclType = pt.declType;
            JSType propInferredFunType = pt.inferredFunType;
            boolean isConst = GlobalTypeInfo.this.isConst(getProp);
            if (initializer != null && initializer.isFunction()) {
                parent.putBooleanProp(76, true);
            }
            if (propDeclType != null || isConst) {
                this.mayWarnAboutExistingProp(rawType, pname, getProp, propDeclType);
                if (propDeclType == null) {
                    propDeclType = this.mayInferFromRhsIfConst(getProp);
                }
                if (this.mayAddPropToType(getProp, rawType)) {
                    rawType.addClassProperty(pname, getProp, propDeclType, isConst);
                }
                if (isConst) {
                    getProp.putBooleanProp(77, true);
                }
            } else if (this.mayAddPropToType(getProp, rawType)) {
                if (propInferredFunType != null) {
                    rawType.addUndeclaredClassProperty(pname, propInferredFunType, getProp);
                } else {
                    rawType.addUndeclaredClassProperty(pname, ((GlobalTypeInfo)GlobalTypeInfo.this).commonTypes.UNKNOWN, getProp);
                }
            }
            if (!GlobalTypeInfo.this.propertyDefs.contains((Object)rawType, (Object)pname)) {
                GlobalTypeInfo.this.propertyDefs.put((Object)rawType, (Object)pname, (Object)new PropertyDef(getProp, null, null));
            }
        }

        private boolean isTranspiledLoopVariable(Node getProp) {
            Node recv = getProp.getFirstChild();
            return recv.isName() && recv.getString().startsWith("$jscomp$loop$");
        }

        private void visitOtherPropertyDeclaration(Node getProp) {
            Node recv;
            QualifiedName recvQname;
            Declaration d;
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            Preconditions.checkArgument((boolean)getProp.isQualifiedName());
            if (GlobalTypeInfo.isCtorWithoutFunctionLiteral(getProp)) {
                this.computeFnDeclaredType(NodeUtil.getBestJSDocInfo(getProp), getProp.getQualifiedName(), getProp, null, this.currentScope);
                return;
            }
            if (GlobalTypeInfo.isAnnotatedAsConst(getProp) && !this.isTranspiledLoopVariable(getProp)) {
                GlobalTypeInfo.this.warnings.add(JSError.make(getProp, MISPLACED_CONST_ANNOTATION, new String[0]));
            }
            if ((d = this.currentScope.getDeclaration(recvQname = QualifiedName.fromNode(recv = getProp.getFirstChild()), false)) != null && d.getTypedef() != null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(getProp, CANNOT_ADD_PROPERTIES_TO_TYPEDEF, new String[0]));
                getProp.getParent().putBooleanProp(76, true);
                return;
            }
            JSType recvType = this.simpleInferExprType(recv);
            if (recvType == null) {
                return;
            }
            NominalType nt = (recvType = recvType.removeType(((GlobalTypeInfo)GlobalTypeInfo.this).commonTypes.NULL_OR_UNDEFINED)).getNominalTypeIfSingletonObj();
            if (nt == null || nt.equals(GlobalTypeInfo.this.commonTypes.getObjectType())) {
                return;
            }
            RawNominalType rawType = nt.getRawNominalType();
            String pname = getProp.getLastChild().getString();
            JSType declType = GlobalTypeInfo.this.getDeclaredTypeOfNode(NodeUtil.getBestJSDocInfo(getProp), this.currentScope);
            if (declType != null) {
                declType = declType.substituteGenericsWithUnknown();
                JSType prevType = rawType.getInstancePropDeclaredType(pname);
                if (nt.isFunction() && prevType != null) {
                    if ((declType = JSType.join(declType, prevType)).isBottom()) {
                        declType = ((GlobalTypeInfo)GlobalTypeInfo.this).commonTypes.UNKNOWN;
                    }
                } else if (this.mayWarnAboutExistingProp(rawType, pname, getProp, declType)) {
                    return;
                }
                rawType.addPropertyWhichMayNotBeOnAllInstances(pname, declType);
            } else if (!rawType.mayHaveProp(pname)) {
                rawType.addPropertyWhichMayNotBeOnAllInstances(pname, null);
            }
        }

        boolean mayWarnAboutNoInit(Node constExpr) {
            if (constExpr.isFromExterns()) {
                return false;
            }
            Node initializer = NodeUtil.getRValueOfLValue(constExpr);
            if (initializer == null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(constExpr, CONST_WITHOUT_INITIALIZER, new String[0]));
                return true;
            }
            return false;
        }

        private JSType mayInferFromRhsIfConst(Node lvalueNode) {
            JSDocInfo info = NodeUtil.getBestJSDocInfo(lvalueNode);
            if (info != null && info.containsFunctionDeclaration()) {
                return null;
            }
            if (GlobalTypeInfo.this.isConst(lvalueNode) && !this.mayWarnAboutNoInit(lvalueNode)) {
                return this.inferConstTypeFromRhs(lvalueNode);
            }
            return null;
        }

        private JSType inferConstTypeFromRhs(Node constExpr) {
            boolean isUnescapedVar;
            if (constExpr.isFromExterns()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(constExpr, COULD_NOT_INFER_CONST_TYPE, this.getNodeNameForConstWarning(constExpr)));
                return null;
            }
            Node rhs = NodeUtil.getRValueOfLValue(constExpr);
            JSType rhsType = this.simpleInferExprType(rhs);
            boolean bl = isUnescapedVar = constExpr.isName() && constExpr.getParent().isVar() && !this.currentScope.isEscapedVar(constExpr.getString());
            if ((rhsType == null || rhsType.isUnknown()) && !isUnescapedVar) {
                GlobalTypeInfo.this.warnings.add(JSError.make(constExpr, COULD_NOT_INFER_CONST_TYPE, this.getNodeNameForConstWarning(constExpr)));
                return null;
            }
            return rhsType;
        }

        private String getNodeNameForConstWarning(Node constExpr) {
            Preconditions.checkArgument((constExpr.isQualifiedName() || constExpr.isStringKey() ? 1 : 0) != 0, (Object)constExpr);
            return constExpr.isQualifiedName() ? constExpr.getQualifiedName() : constExpr.getString();
        }

        private FunctionType simpleInferFunctionType(Node n) {
            JSType t;
            if (n.isQualifiedName()) {
                Declaration decl = this.currentScope.getDeclaration(QualifiedName.fromNode(n), false);
                if (decl == null) {
                    JSType t2 = this.simpleInferExprTypeRecur(n);
                    if (t2 != null) {
                        return t2.getFunTypeIfSingletonObj();
                    }
                } else {
                    if (decl.getNominal() != null) {
                        return decl.getNominal().getConstructorFunction();
                    }
                    if (decl.getFunctionScope() != null) {
                        DeclaredFunctionType funType = decl.getFunctionScope().getDeclaredFunctionType();
                        if (funType != null) {
                            return funType.toFunctionType();
                        }
                    } else if (decl.getNamespace() != null) {
                        Namespace ns = decl.getNamespace();
                        if (ns instanceof FunctionNamespace) {
                            DeclaredFunctionType funType = ((FunctionNamespace)ns).getScope().getDeclaredFunctionType();
                            return ((DeclaredFunctionType)Preconditions.checkNotNull((Object)funType)).toFunctionType();
                        }
                    } else if (decl.getTypeOfSimpleDecl() != null) {
                        return decl.getTypeOfSimpleDecl().getFunTypeIfSingletonObj();
                    }
                }
            }
            return (t = this.simpleInferExprTypeRecur(n)) == null ? null : t.getFunTypeIfSingletonObj();
        }

        private JSType simpleInferCallNewType(Node n) {
            Node callee = n.getFirstChild();
            if (callee.matchesQualifiedName("goog.getMsg")) {
                return ((GlobalTypeInfo)GlobalTypeInfo.this).commonTypes.STRING;
            }
            FunctionType funType = this.simpleInferFunctionType(callee);
            if (funType == null) {
                return null;
            }
            if (funType.isGeneric() && (funType = this.getInstantiatedCalleeType(n, funType, true)) == null) {
                return null;
            }
            JSType retType = n.isNew() ? funType.getThisType() : funType.getReturnType();
            return retType;
        }

        private JSType simpleInferExprType(Node n) {
            JSType t = this.simpleInferExprTypeRecur(n);
            if (t == null || t.mayHaveProp(CONST_INFERENCE_MARKER)) {
                return null;
            }
            return t;
        }

        private JSType simpleInferExprTypeRecur(Node n) {
            switch (n.getToken()) {
                case REGEXP: {
                    return GlobalTypeInfo.this.commonTypes.getRegexpType();
                }
                case CAST: {
                    return (JSType)GlobalTypeInfo.this.castTypes.get(n);
                }
                case ARRAYLIT: {
                    if (!n.hasChildren()) {
                        return GlobalTypeInfo.this.commonTypes.getArrayInstance();
                    }
                    Node child = n.getFirstChild();
                    JSType arrayType = this.simpleInferExprTypeRecur(child);
                    if (arrayType == null) {
                        return null;
                    }
                    while (null != (child = child.getNext())) {
                        if (arrayType.equals(this.simpleInferExprTypeRecur(child))) continue;
                        return null;
                    }
                    return GlobalTypeInfo.this.commonTypes.getArrayInstance(arrayType);
                }
                case TRUE: 
                case FALSE: {
                    return ((GlobalTypeInfo)GlobalTypeInfo.this).commonTypes.BOOLEAN;
                }
                case THIS: {
                    return this.currentScope.getDeclaredTypeOf("this");
                }
                case NAME: {
                    return GlobalTypeInfo.this.simpleInferDeclaration(this.currentScope.getDeclaration(n.getString(), false));
                }
                case OBJECTLIT: {
                    JSType objLitType = GlobalTypeInfo.this.commonTypes.getEmptyObjectLiteral();
                    for (Node prop : n.children()) {
                        JSType propType = this.simpleInferExprTypeRecur(prop.getFirstChild());
                        if (propType == null) {
                            return null;
                        }
                        objLitType = objLitType.withProperty(new QualifiedName(NodeUtil.getObjectLitKeyName(prop)), propType);
                    }
                    return objLitType;
                }
                case GETPROP: {
                    return this.simpleInferPropAccessType(n.getFirstChild(), n.getLastChild().getString());
                }
                case GETELEM: {
                    return this.simpleInferGetelemType(n);
                }
                case ASSIGN: 
                case COMMA: {
                    return this.simpleInferExprTypeRecur(n.getLastChild());
                }
                case CALL: 
                case NEW: {
                    return this.simpleInferCallNewType(n);
                }
                case AND: 
                case OR: {
                    return this.simpleInferAndOrType(n);
                }
                case HOOK: {
                    JSType lhs = this.simpleInferExprTypeRecur(n.getSecondChild());
                    JSType rhs = this.simpleInferExprTypeRecur(n.getLastChild());
                    return lhs == null || rhs == null ? null : JSType.join(lhs, rhs);
                }
                case FUNCTION: {
                    NTIScope s = this.currentScope.getScope(GlobalTypeInfo.this.getFunInternalName(n));
                    DeclaredFunctionType dft = s.getDeclaredFunctionType();
                    return dft == null ? null : GlobalTypeInfo.this.commonTypes.fromFunctionType(dft.toFunctionType());
                }
            }
            switch (NodeUtil.getKnownValueType(n)) {
                case NULL: {
                    return ((GlobalTypeInfo)GlobalTypeInfo.this).commonTypes.NULL;
                }
                case VOID: {
                    return ((GlobalTypeInfo)GlobalTypeInfo.this).commonTypes.UNDEFINED;
                }
                case NUMBER: {
                    return ((GlobalTypeInfo)GlobalTypeInfo.this).commonTypes.NUMBER;
                }
                case STRING: {
                    return ((GlobalTypeInfo)GlobalTypeInfo.this).commonTypes.STRING;
                }
                case BOOLEAN: {
                    return ((GlobalTypeInfo)GlobalTypeInfo.this).commonTypes.BOOLEAN;
                }
            }
            return null;
        }

        private JSType simpleInferPrototypeProperty(Node recv, String pname) {
            Namespace ns;
            QualifiedName recvQname = QualifiedName.fromNode(recv);
            Declaration decl = this.currentScope.getDeclaration(recvQname, false);
            if (decl != null && (ns = decl.getNamespace()) instanceof RawNominalType) {
                return ((RawNominalType)ns).getProtoPropDeclaredType(pname);
            }
            return null;
        }

        private JSType simpleInferPropAccessType(Node recv, String pname) {
            FunctionType ft;
            QualifiedName recvQname;
            Declaration decl;
            if (recv.isGetProp() && recv.getLastChild().getString().equals("prototype")) {
                return this.simpleInferPrototypeProperty(recv.getFirstChild(), pname);
            }
            QualifiedName propQname = new QualifiedName(pname);
            JSType recvType = null;
            if (recv.isQualifiedName() && (decl = this.currentScope.getDeclaration(recvQname = QualifiedName.fromNode(recv), false)) != null) {
                EnumType et = decl.getEnum();
                if (et != null && et.enumLiteralHasKey(pname)) {
                    return et.getEnumeratedType();
                }
                Namespace ns = decl.getNamespace();
                if (ns != null) {
                    return GlobalTypeInfo.this.simpleInferDeclaration(ns.getDeclaration(propQname));
                }
                recvType = decl.getTypeOfSimpleDecl();
            }
            if (recvType == null) {
                recvType = this.simpleInferExprTypeRecur(recv);
            }
            if (recvType == null) {
                return null;
            }
            if (recvType.isScalar()) {
                recvType = recvType.autobox();
            }
            if ((ft = recvType.getFunTypeIfSingletonObj()) != null && pname.equals("call")) {
                return GlobalTypeInfo.this.commonTypes.fromFunctionType(ft.transformByCallProperty());
            }
            if (ft != null && pname.equals("apply")) {
                return GlobalTypeInfo.this.commonTypes.fromFunctionType(ft.transformByApplyProperty());
            }
            if (recvType.mayHaveProp(propQname)) {
                return recvType.getProp(propQname);
            }
            return null;
        }

        private JSType simpleInferGetelemType(Node n) {
            JSType propType;
            JSType indexType;
            JSType propType2;
            Preconditions.checkState((boolean)n.isGetElem());
            Node recv = n.getFirstChild();
            Node propNode = n.getLastChild();
            if (propNode.isString() && (propType2 = this.simpleInferPropAccessType(recv, propNode.getString())) != null) {
                return propType2;
            }
            JSType recvType = this.simpleInferExprTypeRecur(recv);
            if (recvType != null && (indexType = recvType.getIndexType()) != null && (propType = this.simpleInferExprTypeRecur(propNode)) != null && propType.isSubtypeOf(indexType)) {
                return recvType.getIndexedType();
            }
            return null;
        }

        private JSType simpleInferAndOrType(Node n) {
            Preconditions.checkState((n.isOr() || n.isAnd() ? 1 : 0) != 0);
            JSType lhs = this.simpleInferExprTypeRecur(n.getFirstChild());
            if (lhs == null) {
                return null;
            }
            JSType rhs = this.simpleInferExprTypeRecur(n.getSecondChild());
            if (rhs == null) {
                return null;
            }
            if (lhs.equals(rhs)) {
                return lhs;
            }
            if (n.isAnd()) {
                return JSType.join(lhs.specialize(((GlobalTypeInfo)GlobalTypeInfo.this).commonTypes.FALSY), rhs);
            }
            return JSType.join(lhs.specialize(((GlobalTypeInfo)GlobalTypeInfo.this).commonTypes.TRUTHY), rhs);
        }

        private boolean mayAddPropToType(Node getProp, RawNominalType rawType) {
            if (!rawType.isStruct()) {
                return true;
            }
            Node parent = getProp.getParent();
            return (parent.isAssign() && getProp == parent.getFirstChild() || parent.isExprResult()) && this.currentScope.isConstructor();
        }

        private boolean mayWarnAboutExistingProp(RawNominalType classType, String pname, Node propCreationNode, JSType typeInJsdoc) {
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(propCreationNode);
            JSType previousPropType = classType.getInstancePropDeclaredType(pname);
            if (classType.mayHaveOwnProp(pname) && previousPropType != null && !this.suppressDupPropWarning(jsdoc, typeInJsdoc, previousPropType)) {
                GlobalTypeInfo.this.warnings.add(JSError.make(propCreationNode, REDECLARED_PROPERTY, pname, "type " + classType));
                return true;
            }
            return false;
        }

        private boolean suppressDupPropWarning(JSDocInfo propCreationJsdoc, JSType typeInJsdoc, JSType previousType) {
            if (propCreationJsdoc == null || !propCreationJsdoc.getSuppressions().contains("duplicate")) {
                return false;
            }
            return typeInJsdoc == null || typeInJsdoc.equals(previousType);
        }

        private DeclaredFunctionType computeFnDeclaredType(JSDocInfo fnDoc, String functionName, Node declNode, RawNominalType ownerType, NTIScope parentScope) {
            DeclaredFunctionType t;
            Preconditions.checkArgument((declNode.isFunction() || declNode.isQualifiedName() || declNode.isCall() ? 1 : 0) != 0);
            if (fnDoc == null && !NodeUtil.functionHasInlineJsdocs(declNode) && (t = this.getDeclaredFunctionTypeFromContext(functionName, declNode, parentScope)) != null) {
                return t;
            }
            RawNominalType ctorType = (RawNominalType)GlobalTypeInfo.this.nominaltypesByNode.get(declNode);
            JSTypeCreatorFromJSDoc.FunctionAndSlotType result = GlobalTypeInfo.this.typeParser.getFunctionType(fnDoc, functionName, declNode, ctorType, ownerType, parentScope);
            Node qnameNode = declNode.isQualifiedName() ? declNode : (declNode.isFunction() ? NodeUtil.getNameNode(declNode) : NodeUtil.getBestLValue(declNode));
            if (result.slotType != null && qnameNode != null && qnameNode.isName()) {
                parentScope.addLocal(qnameNode.getString(), result.slotType, false, qnameNode.isFromExterns());
            }
            if (ctorType != null) {
                FunctionType ft = result.functionType.toFunctionType();
                ctorType.setCtorFunction(ft);
                if (ctorType.isBuiltinObject()) {
                    GlobalTypeInfo.this.commonTypes.getLiteralObjNominalType().getRawNominalType().setCtorFunction(ft);
                }
            }
            if (declNode.isFunction()) {
                this.maybeWarnFunctionDeclaration(declNode, result.functionType);
            }
            return result.functionType;
        }

        private void maybeWarnFunctionDeclaration(Node funNode, DeclaredFunctionType funType) {
            JSType returnType;
            if (funNode.getParent().isSetterDef() && (returnType = funType.getReturnType()) != null && !returnType.isUnknown() && !returnType.isUndefined()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(funNode, SETTER_WITH_RETURN, new String[0]));
            }
            int declaredArity = funType.getOptionalArity();
            int parameterCount = funNode.getSecondChild().getChildCount();
            if (!funType.hasRestFormals() && parameterCount != declaredArity) {
                GlobalTypeInfo.this.warnings.add(JSError.make(funNode, WRONG_PARAMETER_COUNT, String.valueOf(declaredArity), String.valueOf(parameterCount)));
            }
        }

        private DeclaredFunctionType computeFnDeclaredTypeFromCallee(Node declNode, JSType declaredTypeAsJSType) {
            Preconditions.checkArgument((boolean)declNode.isFunction());
            Preconditions.checkArgument((boolean)declNode.getParent().isCall());
            if (declaredTypeAsJSType == null) {
                return null;
            }
            FunctionType funType = declaredTypeAsJSType.getFunType();
            if (funType == null || funType.isUniqueConstructor() || funType.isInterfaceDefinition()) {
                return null;
            }
            DeclaredFunctionType declType = funType.toDeclaredFunctionType();
            if (declType == null) {
                return null;
            }
            int numFormals = declNode.getSecondChild().getChildCount();
            int optArity = declType.getOptionalArity();
            boolean hasRestFormals = declType.hasRestFormals();
            if (hasRestFormals && numFormals <= optArity + 1 || !hasRestFormals && numFormals <= optArity) {
                return declType;
            }
            return null;
        }

        private DeclaredFunctionType getDeclaredFunctionTypeFromContext(String functionName, Node declNode, NTIScope parentScope) {
            Node maybeBind;
            Node parent = declNode.getParent();
            Node node = maybeBind = parent.isCall() ? parent.getFirstChild() : parent;
            if (NodeUtil.isFunctionBind(maybeBind) && !NodeUtil.isGoogPartial(maybeBind)) {
                JSType recvType;
                Node call = maybeBind.getParent();
                CodingConvention.Bind bindComponents = GlobalTypeInfo.this.convention.describeFunctionBind(call, true, false);
                JSType jSType = recvType = bindComponents.thisValue == null ? null : this.simpleInferExprType(bindComponents.thisValue);
                if (recvType == null) {
                    return null;
                }
                DeclaredFunctionType allButRecvType = ((GlobalTypeInfo)GlobalTypeInfo.this).typeParser.getFunctionType(null, (String)functionName, (Node)declNode, null, null, (DeclaredTypeRegistry)parentScope).functionType;
                return allButRecvType.withReceiverType(recvType);
            }
            if (parent.isCall() && declNode != parent.getFirstChild()) {
                FunctionType calleeFunType;
                Node callee = parent.getFirstChild();
                JSType calleeType = this.simpleInferExprType(callee);
                FunctionType functionType = calleeFunType = calleeType == null ? null : calleeType.getFunType();
                if (calleeFunType != null) {
                    if (calleeFunType.isGeneric() && (calleeFunType = this.getInstantiatedCalleeType(parent, calleeFunType, false)) == null) {
                        return null;
                    }
                    int index = parent.getIndexOfChild(declNode) - 1;
                    JSType callbackType = calleeFunType.getFormalType(index);
                    DeclaredFunctionType t = this.computeFnDeclaredTypeFromCallee(declNode, callbackType);
                    if (t != null) {
                        return t;
                    }
                }
            }
            return null;
        }

        private FunctionType getInstantiatedCalleeType(Node call, FunctionType calleeType, boolean bailForUntypedArguments) {
            Node recv;
            QualifiedName recvQname;
            Declaration decl;
            Node callee = call.getFirstChild();
            Preconditions.checkArgument((boolean)calleeType.isGeneric(), (String)"Expected generic type for %s but found %s", (Object)callee, (Object)calleeType);
            JSType recvType = null;
            if (callee.isGetProp() && callee.getFirstChild().isQualifiedName() && (decl = this.currentScope.getDeclaration(recvQname = QualifiedName.fromNode(recv = callee.getFirstChild()), false)) != null) {
                recvType = decl.getTypeOfSimpleDecl();
            }
            ImmutableList.Builder argTypes = ImmutableList.builder();
            for (Node argNode = call.getSecondChild(); argNode != null; argNode = argNode.getNext()) {
                JSType t = this.simpleInferExprTypeRecur(argNode);
                if (t == null) {
                    if (bailForUntypedArguments && !argNode.isFunction()) {
                        return null;
                    }
                    t = ((GlobalTypeInfo)GlobalTypeInfo.this).commonTypes.BOTTOM;
                }
                argTypes.add((Object)t);
            }
            return calleeType.instantiateGenericsFromArgumentTypes(recvType, (List<JSType>)argTypes.build());
        }

        private void mayAddPropToPrototype(RawNominalType rawType, String pname, Node defSite, Node initializer) {
            FunctionType ft;
            NTIScope methodScope = null;
            DeclaredFunctionType methodType = null;
            JSType propDeclType = null;
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(defSite);
            if (initializer != null && initializer.isFunction()) {
                methodScope = this.visitFunctionLate(initializer, rawType);
                methodType = methodScope.getDeclaredFunctionType();
                if (defSite.isGetterDef()) {
                    pname = JSType.createGetterPropName(pname);
                } else if (defSite.isSetterDef()) {
                    pname = JSType.createSetterPropName(pname);
                }
            } else if (jsdoc != null && jsdoc.containsFunctionDeclaration() && !defSite.isStringKey()) {
                methodType = this.computeFnDeclaredType(jsdoc, pname, defSite, rawType, this.currentScope);
            }
            if (jsdoc != null && jsdoc.hasType()) {
                propDeclType = GlobalTypeInfo.this.typeParser.getDeclaredTypeOfNode(jsdoc, rawType, this.currentScope);
            } else if (methodType != null) {
                propDeclType = GlobalTypeInfo.this.commonTypes.fromFunctionType(methodType.toFunctionType());
            }
            if (defSite.isGetterDef() && (ft = propDeclType.getFunTypeIfSingletonObj()) != null) {
                propDeclType = ft.getReturnType();
            }
            GlobalTypeInfo.this.propertyDefs.put((Object)rawType, (Object)pname, (Object)new PropertyDef(defSite, methodType, methodScope));
            if (methodType != null && methodType.isAbstract() && !rawType.isAbstractClass()) {
                if (rawType.isClass()) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(defSite, ABSTRACT_METHOD_IN_CONCRETE_CLASS, rawType.getName()));
                } else if (rawType.isInterface()) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(defSite, ABSTRACT_METHOD_IN_INTERFACE, new String[0]));
                }
            }
            boolean isConst = GlobalTypeInfo.this.isConst(defSite);
            if (propDeclType != null || isConst) {
                if (this.mayWarnAboutExistingProp(rawType, pname, defSite, propDeclType)) {
                    return;
                }
                if (propDeclType == null) {
                    propDeclType = this.mayInferFromRhsIfConst(defSite);
                }
                rawType.addProtoProperty(pname, defSite, propDeclType, isConst);
                if (defSite.isGetProp()) {
                    defSite.putBooleanProp(76, true);
                    if (isConst) {
                        defSite.putBooleanProp(77, true);
                    }
                }
            } else {
                JSType inferredType = null;
                if (initializer != null) {
                    inferredType = this.simpleInferExprType(initializer);
                }
                if (inferredType == null) {
                    inferredType = ((GlobalTypeInfo)GlobalTypeInfo.this).commonTypes.UNKNOWN;
                }
                rawType.addUndeclaredProtoProperty(pname, defSite, inferredType);
            }
        }

        private RawNominalType maybeGetOwnerType(Node funNode, Node parent) {
            QualifiedName qname;
            Node recv;
            Preconditions.checkArgument((boolean)funNode.isFunction());
            if (parent.isAssign() && parent.getFirstChild().isGetElem() && (recv = parent.getFirstFirstChild()).isGetProp() && recv.getLastChild().getString().equals("prototype") && (qname = QualifiedName.fromNode(recv.getFirstChild())) != null) {
                return this.currentScope.getNominalType(qname);
            }
            return null;
        }

        private boolean isNamedType(Node getProp) {
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(getProp);
            if (jsdoc != null && jsdoc.hasType() && !jsdoc.containsFunctionDeclaration()) {
                return false;
            }
            return this.currentScope.isNamespace(getProp) || NodeUtil.isTypedefDecl(getProp);
        }
    }

    private class CollectNamedTypes
    extends NodeTraversal.AbstractShallowCallback {
        private final NTIScope currentScope;

        CollectNamedTypes(NTIScope s) {
            this.currentScope = s;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            block0 : switch (n.getToken()) {
                case FUNCTION: {
                    this.visitFunctionEarly(n);
                    break;
                }
                case VAR: {
                    Node nameNode = n.getFirstChild();
                    String varName = nameNode.getString();
                    if (NodeUtil.isNamespaceDecl(nameNode)) {
                        this.visitObjlitNamespace(nameNode);
                    } else if (NodeUtil.isTypedefDecl(nameNode)) {
                        this.visitTypedef(nameNode);
                    } else if (NodeUtil.isEnumDecl(nameNode)) {
                        this.visitEnum(nameNode);
                    } else if (this.isAliasedNamespaceDefinition(nameNode)) {
                        this.visitAliasedNamespace(nameNode);
                    } else if (varName.equals(GlobalTypeInfo.WINDOW_INSTANCE) && nameNode.isFromExterns()) {
                        this.visitWindowVar(nameNode);
                    } else if (GlobalTypeInfo.isCtorDefinedByCall(nameNode)) {
                        this.visitNewCtorDefinedByCall(nameNode);
                    } else if (GlobalTypeInfo.isCtorWithoutFunctionLiteral(nameNode)) {
                        this.visitNewCtorWithoutFunctionLiteral(nameNode);
                    }
                    if (n.isFromExterns() || this.currentScope.isDefinedLocally(varName, false)) break;
                    this.currentScope.addLocal(varName, ((GlobalTypeInfo)GlobalTypeInfo.this).commonTypes.UNKNOWN, false, false);
                    break;
                }
                case NAME: {
                    if (!this.currentScope.isFunction()) break;
                    NTIScope.mayRecordEscapedVar(this.currentScope, n.getString());
                    break;
                }
                case EXPR_RESULT: {
                    Node expr = n.getFirstChild();
                    switch (expr.getToken()) {
                        case ASSIGN: {
                            Node lhs = expr.getFirstChild();
                            if (GlobalTypeInfo.isCtorDefinedByCall(lhs)) {
                                this.visitNewCtorDefinedByCall(lhs);
                                return;
                            }
                            if (!lhs.isGetProp()) {
                                return;
                            }
                            expr = lhs;
                        }
                        case GETPROP: {
                            if (GlobalTypeInfo.isCtorWithoutFunctionLiteral(expr)) {
                                this.visitNewCtorWithoutFunctionLiteral(expr);
                                return;
                            }
                            if (GlobalTypeInfo.isPrototypeProperty(expr) || NodeUtil.referencesThis(expr) || !expr.isQualifiedName()) {
                                return;
                            }
                            this.processQualifiedDefinition(expr);
                            break block0;
                        }
                    }
                    break;
                }
            }
        }

        private void visitWindowVar(Node nameNode) {
            NominalType maybeWin;
            JSType typeInJsdoc = GlobalTypeInfo.this.getVarTypeFromAnnotation(nameNode, this.currentScope);
            if (!this.currentScope.isDefinedLocally(GlobalTypeInfo.WINDOW_INSTANCE, false)) {
                this.currentScope.addLocal(GlobalTypeInfo.WINDOW_INSTANCE, typeInJsdoc, false, true);
                return;
            }
            NominalType nominalType = maybeWin = typeInJsdoc == null ? null : typeInJsdoc.getNominalTypeIfSingletonObj();
            if (maybeWin != null && maybeWin.getName().equals(GlobalTypeInfo.WINDOW_CLASS)) {
                this.currentScope.addLocal(GlobalTypeInfo.WINDOW_INSTANCE, typeInJsdoc, false, true);
            }
        }

        private void processQualifiedDefinition(Node qnameNode) {
            Preconditions.checkArgument((boolean)qnameNode.isGetProp());
            Preconditions.checkArgument((boolean)qnameNode.isQualifiedName());
            Node recv = qnameNode.getFirstChild();
            if (!(this.currentScope.isNamespace(recv) || this.mayCreateFunctionNamespace(recv) || this.mayCreateWindowNamespace(recv))) {
                return;
            }
            if (NodeUtil.isNamespaceDecl(qnameNode)) {
                this.visitObjlitNamespace(qnameNode);
            } else if (NodeUtil.isTypedefDecl(qnameNode)) {
                this.visitTypedef(qnameNode);
            } else if (NodeUtil.isEnumDecl(qnameNode)) {
                this.visitEnum(qnameNode);
            } else if (this.isAliasedNamespaceDefinition(qnameNode)) {
                this.visitAliasedNamespace(qnameNode);
            } else if (this.isAliasingGlobalThis(qnameNode)) {
                this.visitGlobalThisAlias(qnameNode);
            } else if (this.isQualifiedFunctionDefinition(qnameNode)) {
                this.maybeAddFunctionToNamespace(qnameNode);
            }
        }

        private boolean isAliasingGlobalThis(Node qnameNode) {
            return GlobalTypeInfo.this.convention.isAliasingGlobalThis(qnameNode.getParent()) && this.currentScope.isTopLevel();
        }

        private void visitGlobalThisAlias(Node qnameNode) {
            Namespace ns = GlobalTypeInfo.this.globalScope.getNamespace(GlobalTypeInfo.WINDOW_INSTANCE);
            if (ns != null) {
                qnameNode.getParent().putBooleanProp(76, true);
                this.currentScope.addNamespace(qnameNode, ns);
            }
        }

        private boolean isAliasedNamespaceDefinition(Node qnameNode) {
            Node rhs = NodeUtil.getRValueOfLValue(qnameNode);
            if (rhs == null || !rhs.isQualifiedName()) {
                return false;
            }
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
            if (jsdoc == null) {
                return (qnameNode.isFromExterns() || qnameNode.isGetProp() && qnameNode.getLastChild().getString().equals("default") && this.currentScope.isNamespace(qnameNode.getFirstChild())) && (qnameNode.getParent().isVar() || !qnameNode.isName()) && this.currentScope.isNamespace(rhs);
            }
            return jsdoc.isConstructorOrInterface() || jsdoc.hasConstAnnotation();
        }

        private boolean isQualifiedFunctionDefinition(Node qnameNode) {
            Preconditions.checkArgument((boolean)qnameNode.isGetProp());
            Preconditions.checkArgument((boolean)qnameNode.isQualifiedName());
            Node parent = qnameNode.getParent();
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
            return parent.isAssign() && parent.getParent().isExprResult() && parent.getLastChild().isFunction() && (jsdoc == null || jsdoc.containsFunctionDeclaration());
        }

        private boolean mayCreateFunctionNamespace(Node qnameNode) {
            if (!qnameNode.isQualifiedName()) {
                return false;
            }
            QualifiedName qname = QualifiedName.fromNode(qnameNode);
            Preconditions.checkState((!this.currentScope.isNamespace(qname) ? 1 : 0) != 0);
            if (!this.currentScope.isKnownFunction(qname)) {
                return false;
            }
            if (qnameNode.isGetProp()) {
                this.markAssignNodeAsAnalyzed(qnameNode.getGrandparent());
            }
            NTIScope s = qnameNode.isName() ? this.currentScope.getScope(qnameNode.getString()).getParent() : this.currentScope;
            s.addFunNamespace(qnameNode);
            return true;
        }

        private boolean mayCreateWindowNamespace(Node qnameNode) {
            if (qnameNode.isName() && qnameNode.getString().equals(GlobalTypeInfo.WINDOW_INSTANCE) && this.currentScope.isGlobalVar(GlobalTypeInfo.WINDOW_INSTANCE)) {
                GlobalTypeInfo.this.globalScope.addNamespaceLit(qnameNode);
                return true;
            }
            return false;
        }

        private void visitObjlitNamespace(Node qnameNode) {
            if (qnameNode.isGetProp()) {
                this.markAssignNodeAsAnalyzed(qnameNode.getParent());
            }
            if (this.currentScope.isDefined(qnameNode)) {
                if (qnameNode.isGetProp() && !NodeUtil.getRValueOfLValue(qnameNode).isOr()) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(qnameNode, REDECLARED_PROPERTY, qnameNode.getLastChild().getString(), qnameNode.getFirstChild().getQualifiedName()));
                }
                return;
            }
            this.currentScope.addNamespaceLit(qnameNode);
            Node maybeObjlit = NodeUtil.getRValueOfLValue(qnameNode);
            if (maybeObjlit.isOr()) {
                maybeObjlit = maybeObjlit.getLastChild();
            }
            Preconditions.checkState((boolean)maybeObjlit.isObjectLit(), (String)"Expected object literal, found %s", (Object)maybeObjlit);
            for (Node propNode : maybeObjlit.children()) {
                if (!this.isAliasedNamespaceDefinition(propNode)) continue;
                Node fakeGetprop = IR.getprop(qnameNode.cloneTree(), IR.string(propNode.getString()));
                IR.assign(fakeGetprop, propNode.getFirstChild().cloneTree());
                this.visitAliasedNamespace(fakeGetprop);
            }
        }

        private void markAssignNodeAsAnalyzed(Node maybeAssign) {
            if (maybeAssign.isAssign()) {
                maybeAssign.putBooleanProp(76, true);
            } else {
                Preconditions.checkState((boolean)maybeAssign.isExprResult());
            }
        }

        private void visitTypedef(Node qnameNode) {
            Preconditions.checkState((boolean)qnameNode.isQualifiedName());
            qnameNode.putBooleanProp(76, true);
            if (NodeUtil.getRValueOfLValue(qnameNode) != null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(qnameNode, CANNOT_INIT_TYPEDEF, new String[0]));
            }
            if (this.currentScope.isDefined(qnameNode)) {
                return;
            }
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
            Typedef td = Typedef.make(jsdoc.getTypedefType());
            this.currentScope.addTypedef(qnameNode, td);
        }

        private void visitEnum(Node qnameNode) {
            EnumType et;
            Preconditions.checkState((boolean)qnameNode.isQualifiedName());
            qnameNode.putBooleanProp(76, true);
            if (this.currentScope.isDefined(qnameNode)) {
                return;
            }
            Node init = NodeUtil.getRValueOfLValue(qnameNode);
            if (init != null && init.isQualifiedName() && (et = this.currentScope.getEnum(QualifiedName.fromNode(init))) != null) {
                this.currentScope.addNamespace(qnameNode, et);
                return;
            }
            if (init == null || !init.isObjectLit() || init.getFirstChild() == null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(qnameNode, MALFORMED_ENUM, new String[0]));
                return;
            }
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
            LinkedHashSet<String> propNames = new LinkedHashSet<String>();
            for (Node prop : init.children()) {
                String pname = NodeUtil.getObjectLitKeyName(prop);
                if (propNames.contains(pname)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(qnameNode, DUPLICATE_PROP_IN_ENUM, pname));
                }
                GlobalTypeInfo.this.recordPropertyName(pname, qnameNode);
                propNames.add(pname);
            }
            this.currentScope.addNamespace(qnameNode, EnumType.make(GlobalTypeInfo.this.commonTypes, qnameNode.getQualifiedName(), qnameNode, jsdoc.getEnumParameterType(), (Collection<String>)ImmutableSet.copyOf(propNames)));
        }

        private void visitFunctionEarly(Node fn) {
            boolean isRedeclaration;
            JSDocInfo fnDoc = NodeUtil.getBestJSDocInfo(fn);
            Node nameNode = NodeUtil.getNameNode(fn);
            String internalName = this.createFunctionInternalName(fn, nameNode);
            if (nameNode == null || !nameNode.isQualifiedName()) {
                isRedeclaration = false;
            } else if (nameNode.isName()) {
                isRedeclaration = this.currentScope.isDefinedLocally(nameNode.getString(), false);
            } else {
                Preconditions.checkState((boolean)nameNode.isGetProp(), (String)"Expected getprop, found %s", (Object)((Object)nameNode.getToken()));
                isRedeclaration = this.currentScope.isDefined(nameNode);
                if (isRedeclaration && fnDoc != null) {
                    nameNode.getParent().putBooleanProp(76, true);
                    GlobalTypeInfo.this.warnings.add(JSError.make(nameNode, REDECLARED_PROPERTY, nameNode.getLastChild().getString(), nameNode.getFirstChild().getQualifiedName()));
                }
            }
            NTIScope fnScope = new NTIScope(fn, this.currentScope, this.collectFormals(fn, fnDoc), GlobalTypeInfo.this.commonTypes);
            if (!fn.isFromExterns()) {
                GlobalTypeInfo.this.scopes.add(fnScope);
            }
            this.currentScope.addLocalFunDef(internalName, fnScope);
            this.maybeRecordNominalType(fn, nameNode, fnDoc, isRedeclaration);
        }

        private String createFunctionInternalName(Node fn, Node nameNode) {
            String internalName = null;
            if (nameNode == null || !nameNode.isName() || nameNode.getParent().isAssign()) {
                internalName = GlobalTypeInfo.ANON_FUN_PREFIX + GlobalTypeInfo.this.funNameGen.generateNextName();
                GlobalTypeInfo.this.anonFunNames.put(fn, internalName);
            } else if (this.currentScope.isDefinedLocally(nameNode.getString(), false)) {
                String fnName = nameNode.getString();
                Preconditions.checkState((!fnName.contains(".") ? 1 : 0) != 0);
                internalName = GlobalTypeInfo.ANON_FUN_PREFIX + GlobalTypeInfo.this.funNameGen.generateNextName();
                GlobalTypeInfo.this.anonFunNames.put(fn, internalName);
            } else {
                internalName = nameNode.getString();
            }
            return internalName;
        }

        private ArrayList<String> collectFormals(Node fn, JSDocInfo fnDoc) {
            Preconditions.checkArgument((boolean)fn.isFunction());
            ArrayList<String> formals = new ArrayList<String>();
            ArrayList<String> tmpRestFormals = new ArrayList<String>();
            for (Node param = NodeUtil.getFunctionParameters(fn).getFirstChild(); param != null; param = param.getNext()) {
                if (JSTypeCreatorFromJSDoc.isRestArg(fnDoc, param.getString()) && param.getNext() == null) {
                    tmpRestFormals.add(param.getString());
                    continue;
                }
                formals.add(param.getString());
            }
            if (fnDoc != null) {
                for (String formalInJsdoc : fnDoc.getParameterNames()) {
                    if (formals.contains(formalInJsdoc) || tmpRestFormals.contains(formalInJsdoc)) continue;
                    String functionName = NodeUtil.getNearestFunctionName(fn);
                    GlobalTypeInfo.this.warnings.add(JSError.make(fn, INEXISTENT_PARAM, formalInJsdoc, functionName));
                }
            }
            return formals;
        }

        private void maybeRecordNominalType(Node defSite, Node nameNode, JSDocInfo fnDoc, boolean isRedeclaration) {
            Preconditions.checkState((nameNode == null || nameNode.isQualifiedName() ? 1 : 0) != 0);
            if (fnDoc == null) {
                return;
            }
            if (fnDoc.isConstructorOrInterface()) {
                RawNominalType rawType;
                ObjectKind objKind;
                if (nameNode == null) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(defSite, ANONYMOUS_NOMINAL_TYPE, new String[0]));
                    nameNode = IR.name(GlobalTypeInfo.ANON_FUN_PREFIX + GlobalTypeInfo.this.funNameGen.generateNextName());
                    nameNode.useSourceInfoFrom(defSite);
                }
                String qname = nameNode.getQualifiedName();
                ImmutableList.Builder builder = ImmutableList.builder();
                for (String typeParam : fnDoc.getTemplateTypeNames()) {
                    builder.add((Object)GlobalTypeInfo.this.varNameGen.getNextName(typeParam));
                }
                ImmutableList typeParameters = builder.build();
                ObjectKind objectKind = fnDoc.makesStructs() ? ObjectKind.STRUCT : (objKind = fnDoc.makesDicts() ? ObjectKind.DICT : ObjectKind.UNRESTRICTED);
                if (fnDoc.isConstructor()) {
                    rawType = RawNominalType.makeClass(GlobalTypeInfo.this.commonTypes, defSite, qname, (ImmutableList<String>)typeParameters, objKind, fnDoc.isAbstract());
                } else if (fnDoc.usesImplicitMatch()) {
                    rawType = RawNominalType.makeStructuralInterface(GlobalTypeInfo.this.commonTypes, defSite, qname, (ImmutableList<String>)typeParameters, objKind);
                } else {
                    Preconditions.checkState((boolean)fnDoc.isInterface());
                    rawType = RawNominalType.makeNominalInterface(GlobalTypeInfo.this.commonTypes, defSite, qname, (ImmutableList<String>)typeParameters, objKind);
                }
                GlobalTypeInfo.this.nominaltypesByNode.put(defSite, rawType);
                if (isRedeclaration) {
                    return;
                }
                Node firstChild = nameNode.getFirstChild();
                if (nameNode.isName() || this.currentScope.isNamespace(firstChild) || this.mayCreateFunctionNamespace(firstChild) || this.mayCreateWindowNamespace(firstChild)) {
                    if (nameNode.isGetProp()) {
                        if (defSite.isFunction()) {
                            defSite.getParent().putBooleanProp(76, true);
                        } else {
                            defSite.getParent().getFirstChild().putBooleanProp(76, true);
                        }
                    } else if (this.currentScope.isTopLevel()) {
                        this.maybeRecordBuiltinType(qname, rawType);
                    }
                    this.currentScope.addNamespace(nameNode, rawType);
                }
            } else if (fnDoc.makesStructs()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(defSite, STRUCT_WITHOUT_CTOR_OR_INTERF, new String[0]));
            }
            if (fnDoc.makesDicts() && !fnDoc.isConstructor()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(defSite, DICT_WITHOUT_CTOR, new String[0]));
            }
        }

        private void maybeRecordBuiltinType(String name, RawNominalType rawType) {
            switch (name) {
                case "Arguments": {
                    GlobalTypeInfo.this.commonTypes.setArgumentsType(rawType);
                    break;
                }
                case "Function": {
                    GlobalTypeInfo.this.commonTypes.setFunctionType(rawType);
                    break;
                }
                case "Object": {
                    GlobalTypeInfo.this.commonTypes.setObjectType(rawType);
                    RawNominalType objLitRawType = RawNominalType.makeClass(GlobalTypeInfo.this.commonTypes, rawType.getDefSite(), "Object{}", (ImmutableList<String>)ImmutableList.of(), ObjectKind.UNRESTRICTED, false);
                    objLitRawType.addSuperClass(rawType.getAsNominalType());
                    GlobalTypeInfo.this.commonTypes.setLiteralObjNominalType(objLitRawType);
                    break;
                }
                case "Number": {
                    GlobalTypeInfo.this.commonTypes.setNumberInstance(rawType.getInstanceAsJSType());
                    break;
                }
                case "String": {
                    GlobalTypeInfo.this.commonTypes.setStringInstance(rawType.getInstanceAsJSType());
                    break;
                }
                case "Boolean": {
                    GlobalTypeInfo.this.commonTypes.setBooleanInstance(rawType.getInstanceAsJSType());
                    break;
                }
                case "RegExp": {
                    GlobalTypeInfo.this.commonTypes.setRegexpInstance(rawType.getInstanceAsJSType());
                    break;
                }
                case "Array": {
                    GlobalTypeInfo.this.commonTypes.setArrayType(rawType);
                    break;
                }
                case "IObject": {
                    GlobalTypeInfo.this.commonTypes.setIObjectType(rawType);
                    break;
                }
                case "IArrayLike": {
                    GlobalTypeInfo.this.commonTypes.setIArrayLikeType(rawType);
                    break;
                }
                case "Iterable": {
                    GlobalTypeInfo.this.commonTypes.setIterableType(rawType);
                    break;
                }
            }
        }

        private void visitAliasedNamespace(Node lhs) {
            if (this.currentScope.isDefined(lhs)) {
                return;
            }
            Node rhs = NodeUtil.getRValueOfLValue(lhs);
            QualifiedName rhsQname = QualifiedName.fromNode(rhs);
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(lhs);
            Namespace ns = this.currentScope.getNamespace(rhsQname);
            if (jsdoc != null && jsdoc.isConstructorOrInterface()) {
                RawNominalType rawType;
                RawNominalType rawNominalType = rawType = ns instanceof RawNominalType ? (RawNominalType)ns : null;
                if (jsdoc.isConstructor() && (rawType == null || rawType.isInterface())) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(rhs, EXPECTED_CONSTRUCTOR, rhsQname.toString()));
                    return;
                }
                if (jsdoc.isInterface() && (rawType == null || rawType.isClass())) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(rhs, EXPECTED_INTERFACE, rhsQname.toString()));
                    return;
                }
            }
            if (ns != null) {
                lhs.getParent().putBooleanProp(76, true);
                this.currentScope.addNamespace(lhs, ns);
            }
        }

        private void maybeAddFunctionToNamespace(Node funQname) {
            Namespace ns = this.currentScope.getNamespace(QualifiedName.fromNode(funQname.getFirstChild()));
            String internalName = GlobalTypeInfo.this.getFunInternalName(funQname.getParent().getLastChild());
            NTIScope s = this.currentScope.getScope(internalName);
            QualifiedName pname = new QualifiedName(funQname.getLastChild().getString());
            if (!ns.isDefined(pname)) {
                ns.addNamespace(pname, new FunctionNamespace(GlobalTypeInfo.this.commonTypes, funQname.getQualifiedName(), s, funQname));
            }
        }

        private void visitNewCtorDefinedByCall(Node qnameNode) {
            Preconditions.checkState((qnameNode.isName() || qnameNode.isGetProp() ? 1 : 0) != 0);
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
            Node rhs = NodeUtil.getRValueOfLValue(qnameNode);
            this.maybeRecordNominalType(rhs, qnameNode, jsdoc, false);
        }

        private void visitNewCtorWithoutFunctionLiteral(Node qnameNode) {
            Preconditions.checkState((qnameNode.isName() || qnameNode.isGetProp() ? 1 : 0) != 0);
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
            this.maybeRecordNominalType(qnameNode, qnameNode, jsdoc, false);
        }
    }
}

