/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.List;

class GatherSideEffectSubexpressionsCallback
implements NodeTraversal.Callback {
    private static final ImmutableSet<Token> FORBIDDEN_TYPES = ImmutableSet.of((Object)((Object)Token.BLOCK), (Object)((Object)Token.SCRIPT), (Object)((Object)Token.VAR), (Object)((Object)Token.EXPR_RESULT), (Object)((Object)Token.RETURN));
    private final AbstractCompiler compiler;
    private final SideEffectAccumulator accumulator;

    GatherSideEffectSubexpressionsCallback(AbstractCompiler compiler, SideEffectAccumulator accumulator) {
        this.compiler = compiler;
        this.accumulator = accumulator;
    }

    private boolean isClassDefiningCall(Node callNode) {
        CodingConvention.SubclassRelationship classes = this.compiler.getCodingConvention().getClassesDefinedByCall(callNode);
        return classes != null;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal traversal, Node node, Node parent) {
        if (FORBIDDEN_TYPES.contains((Object)node.getToken()) || NodeUtil.isControlStructure(node)) {
            throw new IllegalArgumentException((Object)((Object)node.getToken()) + " nodes are not supported.");
        }
        if (node.isFunction()) {
            return false;
        }
        if (node.isHook()) {
            return this.processHook(node);
        }
        if (node.isAnd() || node.isOr()) {
            return this.processShortCircuitExpression(node);
        }
        if (!NodeUtil.nodeTypeMayHaveSideEffects(node, this.compiler)) {
            return true;
        }
        if (node.isCall()) {
            return this.processFunctionCall(node);
        }
        if (node.isNew()) {
            return this.processConstructorCall(node);
        }
        this.accumulator.keepSubTree(node);
        return false;
    }

    boolean processShortCircuitExpression(Node node) {
        Preconditions.checkArgument((node.isAnd() || node.isOr() ? 1 : 0) != 0, (String)"Expected: AND or OR, Got: %s", (Object)((Object)node.getToken()));
        Node left = node.getFirstChild();
        Node right = left.getNext();
        if (NodeUtil.mayHaveSideEffects(right, this.compiler)) {
            this.accumulator.keepSimplifiedShortCircuitExpression(node);
            return false;
        }
        return true;
    }

    boolean processHook(Node node) {
        Preconditions.checkArgument((boolean)node.isHook(), (String)"Expected: HOOK, Got: %s", (Object)((Object)node.getToken()));
        Node condition = node.getFirstChild();
        Node ifBranch = condition.getNext();
        Node elseBranch = ifBranch.getNext();
        boolean thenHasSideEffects = NodeUtil.mayHaveSideEffects(ifBranch, this.compiler);
        boolean elseHasSideEffects = NodeUtil.mayHaveSideEffects(elseBranch, this.compiler);
        if (thenHasSideEffects || elseHasSideEffects) {
            this.accumulator.keepSimplifiedHookExpression(node, thenHasSideEffects, elseHasSideEffects);
            return false;
        }
        return true;
    }

    boolean processFunctionCall(Node node) {
        Preconditions.checkArgument((boolean)node.isCall(), (String)"Expected: CALL, Got: %s", (Object)((Object)node.getToken()));
        Node functionName = node.getFirstChild();
        if ((functionName.isName() || functionName.isGetProp()) && !this.accumulator.classDefiningCallsHaveSideEffects() && this.isClassDefiningCall(node)) {
            return true;
        }
        if (!NodeUtil.functionCallHasSideEffects(node)) {
            return true;
        }
        this.accumulator.keepSubTree(node);
        return false;
    }

    boolean processConstructorCall(Node node) {
        Preconditions.checkArgument((boolean)node.isNew(), (String)"Expected: NEW, Got: %s", (Object)((Object)node.getToken()));
        if (!NodeUtil.constructorCallHasSideEffects(node)) {
            return true;
        }
        this.accumulator.keepSubTree(node);
        return false;
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
    }

    static final class GetReplacementSideEffectSubexpressions
    implements SideEffectAccumulator {
        private final AbstractCompiler compiler;
        private final List<Node> replacements;

        GetReplacementSideEffectSubexpressions(AbstractCompiler compiler, List<Node> replacements) {
            this.compiler = compiler;
            this.replacements = replacements;
        }

        @Override
        public boolean classDefiningCallsHaveSideEffects() {
            return true;
        }

        @Override
        public void keepSubTree(Node original) {
            if (original.getParent() != null) {
                original.detach();
            }
            this.replacements.add(original);
        }

        @Override
        public void keepSimplifiedShortCircuitExpression(Node original) {
            Preconditions.checkArgument((original.isAnd() || original.isOr() ? 1 : 0) != 0, (String)"Expected: AND or OR, Got: %s", (Object)((Object)original.getToken()));
            Node left = original.getFirstChild();
            Node right = left.getNext();
            Node simplifiedRight = this.simplifyShortCircuitBranch(right);
            original.detachChildren();
            original.addChildToBack(left);
            original.addChildToBack(simplifiedRight);
            this.keepSubTree(original);
        }

        @Override
        public void keepSimplifiedHookExpression(Node hook, boolean thenHasSideEffects, boolean elseHasSideEffects) {
            Preconditions.checkArgument((boolean)hook.isHook(), (String)"Expected: HOOK, Got: %s", (Object)((Object)hook.getToken()));
            Node condition = hook.getFirstChild();
            Node thenBranch = condition.getNext();
            Node elseBranch = thenBranch.getNext();
            if (thenHasSideEffects && elseHasSideEffects) {
                hook.detachChildren();
                hook.addChildToBack(condition);
                hook.addChildToBack(this.simplifyShortCircuitBranch(thenBranch));
                hook.addChildToBack(this.simplifyShortCircuitBranch(elseBranch));
                this.keepSubTree(hook);
            } else if (thenHasSideEffects || elseHasSideEffects) {
                Token type = thenHasSideEffects ? Token.AND : Token.OR;
                Node body = thenHasSideEffects ? thenBranch : elseBranch;
                Node simplified = new Node(type, condition.detach(), this.simplifyShortCircuitBranch(body)).useSourceInfoIfMissingFrom(hook);
                this.keepSubTree(simplified);
            } else {
                throw new IllegalArgumentException("keepSimplifiedHookExpression must keep at least 1 branch");
            }
        }

        private Node simplifyShortCircuitBranch(Node node) {
            ArrayList<Node> parts = new ArrayList<Node>();
            NodeTraversal.traverseEs6(this.compiler, node, new GatherSideEffectSubexpressionsCallback(this.compiler, new GetReplacementSideEffectSubexpressions(this.compiler, parts)));
            Node ret = null;
            for (Node part : parts) {
                if (ret != null) {
                    ret = IR.comma(ret, part).srcref(node);
                    continue;
                }
                ret = part;
            }
            if (ret == null) {
                throw new IllegalArgumentException("expected at least one side effect subexpression in short circuit branch.");
            }
            return ret;
        }
    }

    static interface SideEffectAccumulator {
        public boolean classDefiningCallsHaveSideEffects();

        public void keepSubTree(Node var1);

        public void keepSimplifiedShortCircuitExpression(Node var1);

        public void keepSimplifiedHookExpression(Node var1, boolean var2, boolean var3);
    }
}

