/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.parsing.JsDocInfoParser;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;

class Es6TemplateLiterals {
    private static final String TEMPLATELIT_VAR = "$jscomp$templatelit$";

    Es6TemplateLiterals() {
    }

    static void visitTemplateLiteral(NodeTraversal t, Node n) {
        int length = n.getChildCount();
        if (length == 0) {
            n.replaceWith(IR.string("\"\""));
        } else {
            Node first = n.removeFirstChild();
            Preconditions.checkState((boolean)first.isString());
            if (length == 1) {
                n.replaceWith(first);
            } else {
                Node add = IR.add(first, n.removeFirstChild().removeFirstChild());
                for (int i = 2; i < length; ++i) {
                    Node child = n.removeFirstChild();
                    if (child.isString()) {
                        if (child.getString().isEmpty()) continue;
                        if (i == 2 && first.getString().isEmpty()) {
                            add = add.getSecondChild().detach();
                        }
                    }
                    add = IR.add(add, child.isString() ? child : child.removeFirstChild());
                }
                n.replaceWith(add.useSourceInfoIfMissingFromForTree(n));
            }
        }
        t.reportCodeChange();
    }

    static void visitTaggedTemplateLiteral(NodeTraversal t, Node n) {
        Node templateLit = n.getLastChild();
        Node raw = Es6TemplateLiterals.createRawStringArray(templateLit);
        Node cooked = Es6TemplateLiterals.createCookedStringArray(templateLit);
        JSTypeExpression nonNullSiteObject = new JSTypeExpression(JsDocInfoParser.parseTypeString("!ITemplateArray"), "<Es6TemplateLiterals.java>");
        JSDocInfoBuilder info = new JSDocInfoBuilder(false);
        info.recordType(nonNullSiteObject);
        Node siteObject = IR.cast(cooked, info.build());
        Node callsiteId = IR.name(TEMPLATELIT_VAR + (String)t.getCompiler().getUniqueNameIdSupplier().get());
        Node var = IR.var(callsiteId, siteObject).useSourceInfoIfMissingFromForTree(n);
        Node script = NodeUtil.getEnclosingScript(n);
        script.addChildToFront(var);
        t.reportCodeChange(var);
        Node defineRaw = IR.exprResult(IR.assign(IR.getprop(callsiteId.cloneNode(), IR.string("raw")), raw)).useSourceInfoIfMissingFromForTree(n);
        script.addChildAfter(defineRaw, var);
        Node call = IR.call(n.removeFirstChild(), callsiteId.cloneNode());
        for (Node child = templateLit.getFirstChild(); child != null; child = child.getNext()) {
            if (child.isString()) continue;
            call.addChildToBack(child.removeFirstChild());
        }
        call.useSourceInfoIfMissingFromForTree(templateLit);
        call.putBooleanProp(50, !call.getFirstChild().isGetProp());
        n.replaceWith(call);
        t.reportCodeChange();
    }

    private static Node createRawStringArray(Node n) {
        Node array = IR.arraylit(new Node[0]);
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isString()) continue;
            array.addChildToBack(IR.string((String)child.getProp(71)));
        }
        return array;
    }

    private static Node createCookedStringArray(Node n) {
        Node array = IR.arraylit(new Node[0]);
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isString()) continue;
            Node string = IR.string(Es6TemplateLiterals.cookString((String)child.getProp(71)));
            array.addChildToBack(string);
        }
        return array;
    }

    private static String cookString(String s) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        block10: while (i < s.length()) {
            char c;
            if ((c = s.charAt(i++)) == '\\') {
                char c2 = s.charAt(i++);
                switch (c2) {
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'u': {
                        int unicodeValue = Integer.parseInt(s.substring(i, i + 4), 16);
                        sb.append((char)unicodeValue);
                        i += 4;
                        break;
                    }
                    case '\n': 
                    case '\u2028': 
                    case '\u2029': {
                        break;
                    }
                    case '\r': {
                        if (s.charAt(i + 1) != '\n') continue block10;
                        ++i;
                        break;
                    }
                    default: {
                        sb.append(c);
                        sb.append(c2);
                        break;
                    }
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

