/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.rhino.Node;

final class Es6SuperCheck
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType INVALID_SUPER_CALL = DiagnosticType.error("JSC_INVALID_SUPER_CALL", "super() not allowed except in the constructor of a subclass");
    static final DiagnosticType INVALID_SUPER_CALL_WITH_SUGGESTION = DiagnosticType.error("JSC_INVALID_SUPER_CALL_WITH_SUGGESTION", "super() not allowed here. Did you mean super.{0}?");
    private final AbstractCompiler compiler;

    Es6SuperCheck(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processCheck(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (!n.isSuper()) {
            return;
        }
        Node classNode = NodeUtil.getEnclosingClass(n);
        if (classNode == null || classNode.getSecondChild().isEmpty()) {
            t.report(n, INVALID_SUPER_CALL, new String[0]);
            return;
        }
        if (parent.isCall()) {
            Node fn = NodeUtil.getEnclosingFunction(parent);
            if (fn == null) {
                t.report(n, INVALID_SUPER_CALL, new String[0]);
                return;
            }
            Node memberDef = fn.getParent();
            if (memberDef.isMemberFunctionDef()) {
                if (!memberDef.matchesQualifiedName("constructor")) {
                    t.report(n, INVALID_SUPER_CALL_WITH_SUGGESTION, memberDef.getString());
                }
            } else {
                t.report(n, INVALID_SUPER_CALL, new String[0]);
            }
        }
    }
}

