/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import java.util.Collection;

class DisambiguatePrivateProperties
implements NodeTraversal.Callback,
CompilerPass {
    private final AbstractCompiler compiler;
    private final CodingConvention convention;
    private final ImmutableSet<String> blacklist;
    private String fileid;
    private int id = 0;

    DisambiguatePrivateProperties(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.convention = this.compiler.getCodingConvention();
        Collection<String> indirect = this.convention.getIndirectlyDeclaredProperties();
        this.blacklist = ImmutableSet.copyOf(indirect);
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            this.fileid = "$" + this.id++;
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case GETPROP: {
                this.maybeRename(n.getLastChild());
                break;
            }
            case STRING_KEY: 
            case GETTER_DEF: 
            case SETTER_DEF: 
            case MEMBER_FUNCTION_DEF: {
                this.maybeRename(n);
                break;
            }
        }
    }

    private void maybeRename(Node n) {
        String prop = n.getString();
        if (!n.getBooleanProp(36) && this.convention.isPrivate(prop) && !this.blacklist.contains((Object)prop)) {
            n.setString(prop + this.fileid);
            this.compiler.reportChangeToEnclosingScope(n);
        }
    }
}

