/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AnonymousFunctionNamingPolicy;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.VariableRenamingPolicy;

public enum CompilationLevel {
    WHITESPACE_ONLY,
    SIMPLE_OPTIMIZATIONS,
    ADVANCED_OPTIMIZATIONS;


    public static CompilationLevel fromString(String value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case "WHITESPACE_ONLY": 
            case "WHITESPACE": {
                return WHITESPACE_ONLY;
            }
            case "SIMPLE_OPTIMIZATIONS": 
            case "SIMPLE": {
                return SIMPLE_OPTIMIZATIONS;
            }
            case "ADVANCED_OPTIMIZATIONS": 
            case "ADVANCED": {
                return ADVANCED_OPTIMIZATIONS;
            }
        }
        return null;
    }

    public void setOptionsForCompilationLevel(CompilerOptions options) {
        switch (this) {
            case WHITESPACE_ONLY: {
                CompilationLevel.applyBasicCompilationOptions(options);
                break;
            }
            case SIMPLE_OPTIMIZATIONS: {
                CompilationLevel.applySafeCompilationOptions(options);
                break;
            }
            case ADVANCED_OPTIMIZATIONS: {
                CompilationLevel.applyFullCompilationOptions(options);
                break;
            }
            default: {
                throw new RuntimeException("Unknown compilation level.");
            }
        }
    }

    public void setDebugOptionsForCompilationLevel(CompilerOptions options) {
        options.setAnonymousFunctionNaming(AnonymousFunctionNamingPolicy.UNMAPPED);
        options.generatePseudoNames = true;
        options.removeClosureAsserts = false;
        options.removeJ2clAsserts = false;
        options.shadowVariables = false;
    }

    private static void applyBasicCompilationOptions(CompilerOptions options) {
        options.skipAllCompilerPasses();
    }

    private static void applySafeCompilationOptions(CompilerOptions options) {
        options.replaceIdGenerators = false;
        options.dependencyOptions.setDependencySorting(true);
        options.setClosurePass(true);
        options.setRenamingPolicy(VariableRenamingPolicy.LOCAL, PropertyRenamingPolicy.OFF);
        options.shadowVariables = true;
        options.setInlineVariables(CompilerOptions.Reach.LOCAL_ONLY);
        options.setFlowSensitiveInlineVariables(true);
        options.setInlineFunctions(CompilerOptions.Reach.LOCAL_ONLY);
        options.setAssumeClosuresOnlyCaptureReferences(false);
        options.setCheckGlobalThisLevel(CheckLevel.OFF);
        options.setFoldConstants(true);
        options.setCoalesceVariableNames(true);
        options.setDeadAssignmentElimination(true);
        options.setCollapseVariableDeclarations(true);
        options.convertToDottedProperties = true;
        options.labelRenaming = true;
        options.setRemoveDeadCode(true);
        options.setOptimizeArgumentsArray(true);
        options.setRemoveUnusedVariables(CompilerOptions.Reach.LOCAL_ONLY);
        options.collapseObjectLiterals = true;
        options.setProtectHiddenSideEffects(true);
    }

    private static void applyFullCompilationOptions(CompilerOptions options) {
        options.setCheckSymbols(true);
        options.setCheckTypes(true);
        options.dependencyOptions.setDependencySorting(true);
        options.setClosurePass(true);
        options.setFoldConstants(true);
        options.setCoalesceVariableNames(true);
        options.setDeadAssignmentElimination(true);
        options.setExtractPrototypeMemberDeclarations(true);
        options.setCollapseVariableDeclarations(true);
        options.setConvertToDottedProperties(true);
        options.setLabelRenaming(true);
        options.setRemoveDeadCode(true);
        options.setOptimizeArgumentsArray(true);
        options.setCollapseObjectLiterals(true);
        options.setProtectHiddenSideEffects(true);
        options.setRemoveClosureAsserts(true);
        options.setRemoveAbstractMethods(true);
        options.setRemoveSuperMethods(true);
        options.setReserveRawExports(true);
        options.setRenamingPolicy(VariableRenamingPolicy.ALL, PropertyRenamingPolicy.ALL_UNQUOTED);
        options.setShadowVariables(true);
        options.setRemoveUnusedPrototypeProperties(true);
        options.setRemoveUnusedPrototypePropertiesInExterns(false);
        options.setRemoveUnusedClassProperties(true);
        options.setCollapseAnonymousFunctions(true);
        options.setCollapseProperties(true);
        options.setCheckGlobalThisLevel(CheckLevel.WARNING);
        options.setRewriteFunctionExpressions(false);
        options.setSmartNameRemoval(true);
        options.setExtraSmartNameRemoval(true);
        options.setInlineConstantVars(true);
        options.setInlineFunctions(CompilerOptions.Reach.ALL);
        options.setAssumeClosuresOnlyCaptureReferences(false);
        options.setInlineVariables(CompilerOptions.Reach.ALL);
        options.setFlowSensitiveInlineVariables(true);
        options.setComputeFunctionSideEffects(true);
        options.setAssumeStrictThis(true);
        options.setRemoveUnusedVariables(CompilerOptions.Reach.ALL);
        options.setCrossModuleCodeMotion(true);
        options.setCrossModuleMethodMotion(true);
        options.setDevirtualizePrototypeMethods(true);
        options.setOptimizeParameters(true);
        options.setOptimizeReturns(true);
        options.setOptimizeCalls(true);
    }

    public void setTypeBasedOptimizationOptions(CompilerOptions options) {
        switch (this) {
            case ADVANCED_OPTIMIZATIONS: {
                options.setDisambiguateProperties(true);
                options.setAmbiguateProperties(true);
                options.setInlineProperties(true);
                options.setUseTypesForLocalOptimization(true);
                break;
            }
        }
    }

    public void setWrappedOutputOptimizations(CompilerOptions options) {
        options.reserveRawExports = false;
        switch (this) {
            case SIMPLE_OPTIMIZATIONS: {
                options.setVariableRenaming(VariableRenamingPolicy.ALL);
                options.setCollapseAnonymousFunctions(true);
                options.setInlineConstantVars(true);
                options.setInlineFunctions(CompilerOptions.Reach.ALL);
                options.setInlineVariables(CompilerOptions.Reach.ALL);
                options.setRemoveUnusedVariables(CompilerOptions.Reach.ALL);
                break;
            }
        }
    }
}

