/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.LiveVariablesAnalysis;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.Graph;
import com.google.javascript.jscomp.graph.GraphColoring;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.LinkedUndirectedGraph;
import com.google.javascript.jscomp.graph.UndiGraph;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;

class CoalesceVariableNames
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private final AbstractCompiler compiler;
    private final Deque<GraphColoring<Var, Void>> colorings;
    private final boolean usePseudoNames;
    private static final Comparator<Var> coloringTieBreaker = new Comparator<Var>(){

        @Override
        public int compare(Var v1, Var v2) {
            return v1.index - v2.index;
        }
    };

    CoalesceVariableNames(AbstractCompiler compiler, boolean usePseudoNames) {
        Preconditions.checkState((!compiler.getLifeCycleStage().isNormalized() ? 1 : 0) != 0);
        this.compiler = compiler;
        this.colorings = new LinkedList<GraphColoring<Var, Void>>();
        this.usePseudoNames = usePseudoNames;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal t = new NodeTraversal(this.compiler, this, SyntacticScopeCreator.makeUntyped(this.compiler));
        t.traverse(root);
    }

    private static boolean shouldOptimizeScope(Scope scope) {
        if (scope.isGlobal()) {
            return false;
        }
        return 100 >= scope.getVarCount();
    }

    @Override
    public void enterScope(NodeTraversal t) {
        Scope scope = t.getScope();
        if (!CoalesceVariableNames.shouldOptimizeScope(scope)) {
            return;
        }
        Preconditions.checkState((boolean)scope.isFunctionScope(), (Object)scope);
        ControlFlowGraph<Node> cfg = t.getControlFlowGraph();
        LiveVariablesAnalysis liveness = new LiveVariablesAnalysis(cfg, scope, this.compiler, t.getScopeCreator());
        if (this.compiler.getOptions().getLanguageOut() == CompilerOptions.LanguageMode.ECMASCRIPT3 && NodeUtil.getFunctionParameters(scope.getRootNode()).hasTwoChildren()) {
            liveness.markAllParametersEscaped();
        }
        liveness.analyze();
        UndiGraph<Var, Void> interferenceGraph = this.computeVariableNamesInterferenceGraph(t, cfg, liveness.getEscapedLocals());
        GraphColoring.GreedyGraphColoring<Var, Void> coloring = new GraphColoring.GreedyGraphColoring<Var, Void>(interferenceGraph, coloringTieBreaker);
        ((GraphColoring)coloring).color();
        this.colorings.push(coloring);
    }

    @Override
    public void exitScope(NodeTraversal t) {
        if (!CoalesceVariableNames.shouldOptimizeScope(t.getScope())) {
            return;
        }
        this.colorings.pop();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (this.colorings.isEmpty() || !n.isName() || parent.isFunction()) {
            return;
        }
        Var var = t.getScope().getVar(n.getString());
        GraphNode<Var, Void> vNode = this.colorings.peek().getGraph().getNode(var);
        if (vNode == null) {
            return;
        }
        Var coalescedVar = this.colorings.peek().getPartitionSuperNode(var);
        if (!this.usePseudoNames) {
            if (vNode.getValue().equals(coalescedVar)) {
                return;
            }
            n.setString(coalescedVar.name);
            this.compiler.reportChangeToEnclosingScope(n);
            if (parent.isVar()) {
                CoalesceVariableNames.removeVarDeclaration(n);
            }
        } else {
            String pseudoName = null;
            TreeSet<String> allMergedNames = new TreeSet<String>();
            for (Var var2 : t.getScope().getVarIterable()) {
                if (this.colorings.peek().getGraph().getNode(var2) == null || !coalescedVar.equals(this.colorings.peek().getPartitionSuperNode(var2))) continue;
                allMergedNames.add(var2.name);
            }
            if (allMergedNames.size() == 1) {
                return;
            }
            pseudoName = Joiner.on((String)"_").join(allMergedNames);
            while (t.getScope().isDeclared(pseudoName, true)) {
                pseudoName = pseudoName + "$";
            }
            n.setString(pseudoName);
            this.compiler.reportChangeToEnclosingScope(n);
            if (!vNode.getValue().equals(coalescedVar) && parent.isVar()) {
                CoalesceVariableNames.removeVarDeclaration(n);
            }
        }
    }

    private UndiGraph<Var, Void> computeVariableNamesInterferenceGraph(NodeTraversal t, ControlFlowGraph<Node> cfg, Set<Var> escaped) {
        LinkedUndirectedGraph<Var, Void> interferenceGraph = LinkedUndirectedGraph.create();
        Scope scope = t.getScope();
        for (Var var : scope.getVarIterable()) {
            if (escaped.contains(var) || var.getParentNode().isFunction()) continue;
            ((Graph)interferenceGraph).createNode(var);
        }
        for (Var var : scope.getVarIterable()) {
            block2: for (Var var2 : scope.getVarIterable()) {
                DataFlowAnalysis.FlowState state;
                if (var.index >= var2.index || !interferenceGraph.hasNode(var) || !interferenceGraph.hasNode(var2)) continue;
                if (var.getParentNode().isParamList() && var2.getParentNode().isParamList()) {
                    interferenceGraph.connectIfNotFound(var, null, var2);
                    continue;
                }
                for (DiGraph.DiGraphNode cfgNode : cfg.getDirectedGraphNodes()) {
                    if (cfg.isImplicitReturn(cfgNode) || (!((LiveVariablesAnalysis.LiveVariableLattice)(state = (DataFlowAnalysis.FlowState)cfgNode.getAnnotation()).getIn()).isLive(var) || !((LiveVariablesAnalysis.LiveVariableLattice)state.getIn()).isLive(var2)) && (!((LiveVariablesAnalysis.LiveVariableLattice)state.getOut()).isLive(var) || !((LiveVariablesAnalysis.LiveVariableLattice)state.getOut()).isLive(var2))) continue;
                    interferenceGraph.connectIfNotFound(var, null, var2);
                    continue block2;
                }
                for (DiGraph.DiGraphNode cfgNode : cfg.getDirectedGraphNodes()) {
                    if (cfg.isImplicitReturn(cfgNode)) continue;
                    state = (DataFlowAnalysis.FlowState)cfgNode.getAnnotation();
                    boolean v1OutLive = ((LiveVariablesAnalysis.LiveVariableLattice)state.getOut()).isLive(var);
                    boolean v2OutLive = ((LiveVariablesAnalysis.LiveVariableLattice)state.getOut()).isLive(var2);
                    CombinedLiveRangeChecker checker = new CombinedLiveRangeChecker(new LiveRangeChecker(var, v2OutLive ? null : var2), new LiveRangeChecker(var2, v1OutLive ? null : var));
                    NodeTraversal newTraversal = new NodeTraversal(this.compiler, checker, SyntacticScopeCreator.makeUntyped(this.compiler));
                    newTraversal.traverse((Node)cfgNode.getValue());
                    if (!checker.connectIfCrossed(interferenceGraph)) continue;
                    continue block2;
                }
            }
        }
        return interferenceGraph;
    }

    private static void removeVarDeclaration(Node name) {
        Node var = name.getParent();
        Node parent = var.getParent();
        if (parent.isForIn()) {
            var.removeChild(name);
            parent.replaceChild(var, name);
        } else if (var.hasOneChild()) {
            if (name.hasChildren()) {
                Node value = name.removeFirstChild();
                var.removeChild(name);
                Node assign = IR.assign(name, value).srcref(name);
                if (!parent.isVanillaFor()) {
                    assign = NodeUtil.newExpr(assign);
                }
                parent.replaceChild(var, assign);
            } else {
                NodeUtil.removeChild(parent, var);
            }
        } else if (!name.hasChildren()) {
            var.removeChild(name);
        }
    }

    private static class LiveRangeChecker
    extends ControlFlowGraph.AbstractCfgNodeTraversalCallback {
        boolean defFound = false;
        boolean crossed = false;
        private final Var def;
        private final Var use;

        public LiveRangeChecker(Var def, Var use) {
            this.def = def;
            this.use = use;
        }

        Var getDef() {
            return this.def;
        }

        public static boolean shouldVisit(Node n) {
            return n.isName() || n.hasChildren() && n.getFirstChild().isName();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!this.defFound && LiveRangeChecker.isAssignTo(this.def, n, parent)) {
                this.defFound = true;
            }
            if (this.defFound && (this.use == null || LiveRangeChecker.isReadFrom(this.use, n))) {
                this.crossed = true;
            }
        }

        private static boolean isAssignTo(Var var, Node n, Node parent) {
            if (n.isName()) {
                if (var.getName().equals(n.getString()) && parent != null) {
                    if (parent.isParamList()) {
                        return true;
                    }
                    if (parent.isVar()) {
                        return n.hasChildren();
                    }
                }
            } else if (NodeUtil.isAssignmentOp(n)) {
                Node name = n.getFirstChild();
                return name != null && name.isName() && var.getName().equals(name.getString());
            }
            return false;
        }

        private static boolean isReadFrom(Var var, Node name) {
            return name != null && name.isName() && var.getName().equals(name.getString()) && !NodeUtil.isVarOrSimpleAssignLhs(name, name.getParent());
        }
    }

    private static class CombinedLiveRangeChecker
    extends ControlFlowGraph.AbstractCfgNodeTraversalCallback {
        private final LiveRangeChecker callback1;
        private final LiveRangeChecker callback2;

        CombinedLiveRangeChecker(LiveRangeChecker callback1, LiveRangeChecker callback2) {
            this.callback1 = callback1;
            this.callback2 = callback2;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (LiveRangeChecker.shouldVisit(n)) {
                this.callback1.visit(t, n, parent);
                this.callback2.visit(t, n, parent);
            }
        }

        boolean connectIfCrossed(UndiGraph<Var, Void> interferenceGraph) {
            if (this.callback1.crossed || this.callback2.crossed) {
                Var v1 = this.callback1.getDef();
                Var v2 = this.callback2.getDef();
                interferenceGraph.connectIfNotFound(v1, null, v2);
                return true;
            }
            return false;
        }
    }
}

