/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CodingConventions;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.Collection;

@Immutable
public final class ChromeCodingConvention
extends CodingConventions.Proxy {
    private final ImmutableSet<String> indirectlyDeclaredProperties;

    public ChromeCodingConvention() {
        this(CodingConventions.getDefault());
    }

    public ChromeCodingConvention(CodingConvention wrapped) {
        super(wrapped);
        this.indirectlyDeclaredProperties = new ImmutableSet.Builder().add((Object[])new String[]{"instance_", "getInstance"}).addAll(wrapped.getIndirectlyDeclaredProperties()).build();
    }

    @Override
    public String getSingletonGetterClassName(Node callNode) {
        Node callArg = callNode.getFirstChild();
        if (!callArg.matchesQualifiedName("cr.addSingletonGetter") || callNode.getChildCount() != 2) {
            return super.getSingletonGetterClassName(callNode);
        }
        return callArg.getNext().getQualifiedName();
    }

    @Override
    public void applySingletonGetterOld(FunctionType functionType, FunctionType getterType, ObjectType objectType) {
        super.applySingletonGetterOld(functionType, getterType, objectType);
        functionType.defineDeclaredProperty("getInstance", getterType, functionType.getSource());
        functionType.defineDeclaredProperty("instance_", objectType, functionType.getSource());
    }

    @Override
    public Collection<String> getIndirectlyDeclaredProperties() {
        return this.indirectlyDeclaredProperties;
    }

    @Override
    public Collection<CodingConvention.AssertionFunctionSpec> getAssertionFunctions() {
        return ImmutableList.of((Object)new CodingConvention.AssertionFunctionSpec("assert"), (Object)new ClosureCodingConvention.AssertInstanceofSpec("cr.ui.decorate"));
    }

    @Override
    public boolean isFunctionCallThatAlwaysThrows(Node n) {
        return CodingConventions.defaultIsFunctionCallThatAlwaysThrows(n, "assertNotReached");
    }
}

