/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.List;

class AstChangeProxy {
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final AbstractCompiler compiler;

    AstChangeProxy(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    final void registerListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    final void unregisterListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyOfRemoval(Node node, Node parent) {
        for (ChangeListener listener : this.listeners) {
            listener.nodeRemoved(node, parent);
        }
    }

    final void removeChild(Node parent, Node node) {
        parent.removeChild(node);
        NodeUtil.markFunctionsDeleted(node, this.compiler);
        this.notifyOfRemoval(node, parent);
    }

    final void replaceWith(Node parent, Node node, Node replacement) {
        this.replaceWith(parent, node, (List<Node>)ImmutableList.of((Object)replacement));
    }

    final void replaceWith(Node parent, Node node, List<Node> replacements) {
        Preconditions.checkNotNull(replacements, (Object)"\"replacements\" is null.");
        int size = replacements.size();
        if (size == 1 && node.isEquivalentTo(replacements.get(0))) {
            return;
        }
        Token parentType = parent.getToken();
        Preconditions.checkState((size == 1 || parentType == Token.BLOCK || parentType == Token.SCRIPT || parentType == Token.LABEL ? 1 : 0) != 0);
        if (parentType == Token.LABEL && size != 1) {
            Node block = IR.block();
            for (Node newChild : replacements) {
                newChild.useSourceInfoIfMissingFrom(node);
                block.addChildToBack(newChild);
            }
            parent.replaceChild(node, block);
        } else {
            for (Node newChild : replacements) {
                newChild.useSourceInfoIfMissingFrom(node);
                parent.addChildBefore(newChild, node);
            }
            parent.removeChild(node);
        }
        NodeUtil.markFunctionsDeleted(node, this.compiler);
        this.notifyOfRemoval(node, parent);
    }

    static interface ChangeListener {
        public void nodeRemoved(Node var1, Node var2);
    }
}

