/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

class AnonymousFunctionNamingCallback
extends NodeTraversal.AbstractPostOrderCallback {
    private final FunctionNamer namer;

    AnonymousFunctionNamingCallback(FunctionNamer namer) {
        this.namer = namer;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case FUNCTION: {
                Node functionNameNode = n.getFirstChild();
                String functionName = functionNameNode.getString();
                if (!functionName.isEmpty()) break;
                if (parent.isAssign()) {
                    Node lhs = parent.getFirstChild();
                    String name = this.namer.getName(lhs);
                    this.namer.setFunctionName(name, n);
                    break;
                }
                if (!parent.isName()) break;
                String name = this.namer.getName(parent);
                this.namer.setFunctionName(name, n);
                break;
            }
            case ASSIGN: {
                Node lhs = n.getFirstChild();
                Node rhs = lhs.getNext();
                if (!rhs.isObjectLit()) break;
                this.nameObjectLiteralMethods(rhs, this.namer.getName(lhs));
                break;
            }
            case CLASS: {
                Node classMembersNode = n.getLastChild();
                this.nameClassMethods(classMembersNode, this.namer.getName(n));
                break;
            }
        }
    }

    private void nameObjectLiteralMethods(Node objectLiteral, String context) {
        for (Node keyNode = objectLiteral.getFirstChild(); keyNode != null; keyNode = keyNode.getNext()) {
            Node valueNode = keyNode.getFirstChild();
            if (!keyNode.isStringKey() && !keyNode.isMemberFunctionDef()) continue;
            String name = this.namer.getCombinedName(context, this.namer.getName(keyNode));
            Token type = valueNode.getToken();
            if (type == Token.FUNCTION) {
                Node functionNameNode = valueNode.getFirstChild();
                String functionName = functionNameNode.getString();
                if (!functionName.isEmpty()) continue;
                this.namer.setFunctionName(name, valueNode);
                continue;
            }
            if (type != Token.OBJECTLIT) continue;
            this.nameObjectLiteralMethods(valueNode, name);
        }
    }

    private void nameClassMethods(Node classMembersNode, String className) {
        for (Node methodNode : classMembersNode.children()) {
            if (!methodNode.isMemberFunctionDef()) continue;
            Node valueNode = methodNode.getFirstChild();
            String name = this.namer.getCombinedName(className, this.namer.getName(methodNode));
            this.namer.setFunctionName(name, valueNode);
        }
    }

    static interface FunctionNamer {
        public String getName(Node var1);

        public void setFunctionName(String var1, Node var2);

        public String getCombinedName(String var1, String var2);
    }
}

