/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefaultNameGenerator;
import com.google.javascript.jscomp.DisambiguateProperties;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TypeMismatch;
import com.google.javascript.jscomp.graph.AdjacencyGraph;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.GraphColoring;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.SubGraph;
import com.google.javascript.rhino.FunctionTypeI;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class AmbiguateProperties
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(AmbiguateProperties.class.getName());
    private final AbstractCompiler compiler;
    private final List<Node> stringNodesToRename = new ArrayList<Node>();
    private final char[] reservedFirstCharacters;
    private final char[] reservedNonFirstCharacters;
    private final Map<String, Property> propertyMap = new HashMap<String, Property>();
    private final Set<String> externedNames;
    private final Set<String> quotedNames = new HashSet<String>();
    private Map<String, String> renamingMap = null;
    private static final Comparator<Property> FREQUENCY_COMPARATOR = new Comparator<Property>(){

        @Override
        public int compare(Property p1, Property p2) {
            if (p1.numOccurrences != p2.numOccurrences) {
                return p2.numOccurrences - p1.numOccurrences;
            }
            return p1.oldName.compareTo(p2.oldName);
        }
    };
    private BiMap<JSType, Integer> intForType = HashBiMap.create();
    private Map<JSType, JSTypeBitSet> relatedBitsets = new HashMap<JSType, JSTypeBitSet>();
    private final Set<TypeI> invalidatingTypes;
    static final String SKIP_PREFIX = "JSAbstractCompiler";

    AmbiguateProperties(AbstractCompiler compiler, char[] reservedFirstCharacters, char[] reservedNonFirstCharacters) {
        Preconditions.checkState((boolean)compiler.getLifeCycleStage().isNormalized());
        this.compiler = compiler;
        this.reservedFirstCharacters = reservedFirstCharacters;
        this.reservedNonFirstCharacters = reservedNonFirstCharacters;
        JSTypeRegistry r = compiler.getTypeRegistry();
        this.invalidatingTypes = new HashSet<TypeI>((Collection<TypeI>)ImmutableSet.of((Object)r.getNativeType(JSTypeNative.ALL_TYPE), (Object)r.getNativeType(JSTypeNative.FUNCTION_FUNCTION_TYPE), (Object)r.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE), (Object)r.getNativeType(JSTypeNative.FUNCTION_PROTOTYPE), (Object)r.getNativeType(JSTypeNative.GLOBAL_THIS), (Object)r.getNativeType(JSTypeNative.OBJECT_TYPE), (Object[])new TypeI[]{r.getNativeType(JSTypeNative.OBJECT_PROTOTYPE), r.getNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE), r.getNativeType(JSTypeNative.TOP_LEVEL_PROTOTYPE)}));
        for (TypeMismatch mis : compiler.getTypeMismatches()) {
            this.addInvalidatingType(mis.typeA);
            this.addInvalidatingType(mis.typeB);
        }
        for (TypeMismatch mis : compiler.getImplicitInterfaceUses()) {
            this.addInvalidatingType(mis.typeA);
            this.addInvalidatingType(mis.typeB);
        }
        this.externedNames = compiler.getExternProperties();
    }

    static AmbiguateProperties makePassForTesting(AbstractCompiler compiler, char[] reservedFirstCharacters, char[] reservedNonFirstCharacters) {
        AmbiguateProperties ap = new AmbiguateProperties(compiler, reservedFirstCharacters, reservedNonFirstCharacters);
        ap.renamingMap = new HashMap<String, String>();
        return ap;
    }

    private void addInvalidatingType(TypeI type) {
        if ((type = type.restrictByNotNullOrUndefined()).isUnionType()) {
            for (TypeI typeI : type.getUnionMembers()) {
                this.addInvalidatingType(typeI);
            }
        }
        this.invalidatingTypes.add(type);
        ObjectType objType = (ObjectType)type.toMaybeObjectType();
        if (objType != null && objType.isInstanceType()) {
            this.invalidatingTypes.add(objType.getImplicitPrototype());
        }
    }

    Map<String, String> getRenamingMap() {
        Preconditions.checkNotNull(this.renamingMap);
        return this.renamingMap;
    }

    private int getIntForType(JSType type) {
        if (type != null && type.isTemplatizedType()) {
            type = type.toMaybeTemplatizedType().getReferencedType();
        }
        if (this.intForType.containsKey((Object)type)) {
            return (Integer)this.intForType.get((Object)type);
        }
        int newInt = this.intForType.size() + 1;
        this.intForType.put((Object)type, (Object)newInt);
        return newInt;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, new ProcessProperties());
        ImmutableSet.Builder reservedNames = ImmutableSet.builder().addAll(this.externedNames).addAll(this.quotedNames);
        int numRenamedPropertyNames = 0;
        int numSkippedPropertyNames = 0;
        ArrayList<PropertyGraphNode> nodes = new ArrayList<PropertyGraphNode>(this.propertyMap.size());
        for (Property prop : this.propertyMap.values()) {
            if (prop.skipAmbiguating) {
                ++numSkippedPropertyNames;
                reservedNames.add((Object)prop.oldName);
                continue;
            }
            ++numRenamedPropertyNames;
            nodes.add(new PropertyGraphNode(prop));
        }
        PropertyGraph graph = new PropertyGraph(nodes);
        GraphColoring.GreedyGraphColoring<Property, Void> coloring = new GraphColoring.GreedyGraphColoring<Property, Void>(graph, FREQUENCY_COMPARATOR);
        int numNewPropertyNames = ((GraphColoring)coloring).color();
        DefaultNameGenerator nameGen = new DefaultNameGenerator((Set<String>)reservedNames.build(), "", this.reservedFirstCharacters, this.reservedNonFirstCharacters);
        String[] colorMap = new String[numNewPropertyNames];
        for (int i = 0; i < numNewPropertyNames; ++i) {
            colorMap[i] = nameGen.generateNextName();
        }
        for (PropertyGraphNode node : graph.getNodes()) {
            node.getValue().newName = colorMap[node.getAnnotation().hashCode()];
            if (this.renamingMap == null) continue;
            this.renamingMap.put(node.getValue().oldName, node.getValue().newName);
        }
        for (Node n : this.stringNodesToRename) {
            String oldName = n.getString();
            Property p = this.propertyMap.get(oldName);
            if (p == null || p.newName == null) continue;
            Preconditions.checkState((boolean)oldName.equals(p.oldName));
            if (p.newName.equals(oldName)) continue;
            n.setString(p.newName);
            this.compiler.reportChangeToEnclosingScope(n);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Collapsed " + numRenamedPropertyNames + " properties into " + numNewPropertyNames + " and skipped renaming " + numSkippedPropertyNames + " properties.");
        }
    }

    private BitSet getRelatedTypesOnNonUnion(JSType type) {
        if (this.relatedBitsets.containsKey(type)) {
            return this.relatedBitsets.get(type);
        }
        throw new RuntimeException("Related types should have been computed for type: " + type + " but have not been.");
    }

    private void computeRelatedTypes(JSType type) {
        if (type.isUnionType() && (type = type.restrictByNotNullOrUndefined()).isUnionType()) {
            for (JSType alt : type.toMaybeUnionType().getAlternates()) {
                this.computeRelatedTypes(alt);
            }
            return;
        }
        if (this.relatedBitsets.containsKey(type)) {
            return;
        }
        JSTypeBitSet related = new JSTypeBitSet(this.intForType.size());
        this.relatedBitsets.put(type, related);
        related.set(this.getIntForType(type));
        if (type.isFunctionPrototypeType()) {
            this.addRelatedInstance(((ObjectType)type).getOwnerFunction(), related);
            return;
        }
        FunctionType constructor = type.toObjectType().getConstructor();
        if (constructor != null) {
            for (FunctionTypeI subType : constructor.getSubTypes()) {
                this.addRelatedInstance((FunctionType)subType, related);
            }
        }
    }

    private void addRelatedInstance(FunctionType constructor, JSTypeBitSet related) {
        if (constructor.hasInstanceType()) {
            ObjectType instanceType = constructor.getInstanceType();
            related.set(this.getIntForType(instanceType.getImplicitPrototype()));
            this.computeRelatedTypes(instanceType);
            related.or(this.relatedBitsets.get(instanceType));
        }
    }

    private boolean isInvalidatingType(JSType type) {
        if (type.isUnionType() && (type = type.restrictByNotNullOrUndefined()).isUnionType()) {
            for (JSType alt : type.toMaybeUnionType().getAlternates()) {
                if (!this.isInvalidatingType(alt)) continue;
                return true;
            }
            return false;
        }
        ObjectType objType = ObjectType.cast(type);
        return objType == null || this.invalidatingTypes.contains(objType) || !objType.hasReferenceName() || objType.isUnknownType() || objType.isEmptyType() || objType.isEnumType() || objType.autoboxesTo() != null;
    }

    private Property getProperty(String name) {
        Property prop = this.propertyMap.get(name);
        if (prop == null) {
            prop = new Property(name);
            this.propertyMap.put(name, prop);
        }
        return prop;
    }

    private JSType getJSType(Node n) {
        if (n == null) {
            return this.compiler.getTypeRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        JSType jsType = n.getJSType();
        if (jsType == null) {
            return this.compiler.getTypeRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return jsType;
    }

    private class JSTypeBitSet
    extends BitSet {
        private static final long serialVersionUID = 1L;

        private JSTypeBitSet(int size) {
            super(size);
        }

        private JSTypeBitSet() {
        }

        @Override
        public String toString() {
            int from = 0;
            int current = 0;
            ArrayList<String> types = new ArrayList<String>();
            while (-1 != (current = this.nextSetBit(from))) {
                types.add(((JSType)AmbiguateProperties.this.intForType.inverse().get((Object)current)).toString());
                from = current + 1;
            }
            return Joiner.on((String)" && ").join(types);
        }
    }

    private class Property {
        final String oldName;
        String newName;
        int numOccurrences;
        boolean skipAmbiguating;
        JSTypeBitSet relatedTypes;

        Property(String name) {
            this.relatedTypes = new JSTypeBitSet(AmbiguateProperties.this.intForType.size());
            this.oldName = name;
            if (name.startsWith(AmbiguateProperties.SKIP_PREFIX)) {
                this.skipAmbiguating = true;
            }
        }

        void addType(JSType newType) {
            if (this.skipAmbiguating) {
                return;
            }
            ++this.numOccurrences;
            if (newType.isUnionType() && (newType = newType.restrictByNotNullOrUndefined()).isUnionType()) {
                for (JSType alt : newType.toMaybeUnionType().getAlternatesWithoutStructuralTyping()) {
                    this.addNonUnionType(alt);
                }
                return;
            }
            this.addNonUnionType(newType);
        }

        private void addNonUnionType(JSType newType) {
            if (this.skipAmbiguating || AmbiguateProperties.this.isInvalidatingType(newType)) {
                this.skipAmbiguating = true;
                return;
            }
            if (!this.relatedTypes.get(AmbiguateProperties.this.getIntForType(newType))) {
                AmbiguateProperties.this.computeRelatedTypes(newType);
                this.relatedTypes.or(AmbiguateProperties.this.getRelatedTypesOnNonUnion(newType));
            }
        }
    }

    private class ProcessProperties
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessProperties() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case GETPROP: {
                    Node propNode = n.getSecondChild();
                    JSType jstype = AmbiguateProperties.this.getJSType(n.getFirstChild());
                    this.maybeMarkCandidate(propNode, jstype);
                    break;
                }
                case CALL: {
                    Node target = n.getFirstChild();
                    if (!target.isQualifiedName()) break;
                    String renameFunctionName = target.getOriginalQualifiedName();
                    if (renameFunctionName != null && AmbiguateProperties.this.compiler.getCodingConvention().isPropertyRenameFunction(renameFunctionName)) {
                        int childCount = n.getChildCount();
                        if (childCount != 2 && childCount != 3) {
                            AmbiguateProperties.this.compiler.report(JSError.make(n, DisambiguateProperties.Warnings.INVALID_RENAME_FUNCTION, renameFunctionName, " Must be called with 1 or 2 arguments."));
                            break;
                        }
                        Node propName = n.getSecondChild();
                        if (!propName.isString()) {
                            AmbiguateProperties.this.compiler.report(JSError.make(n, DisambiguateProperties.Warnings.INVALID_RENAME_FUNCTION, renameFunctionName, " The first argument must be a string literal."));
                            break;
                        }
                        if (propName.getString().contains(".")) {
                            AmbiguateProperties.this.compiler.report(JSError.make(n, DisambiguateProperties.Warnings.INVALID_RENAME_FUNCTION, renameFunctionName, " The first argument must not be a property path."));
                            break;
                        }
                        JSType jstype = AmbiguateProperties.this.getJSType(n.getSecondChild());
                        this.maybeMarkCandidate(propName, jstype);
                        break;
                    }
                    if (!NodeUtil.isObjectDefinePropertiesDefinition(n)) break;
                    Node typeObj = n.getSecondChild();
                    JSType jstype = AmbiguateProperties.this.getJSType(typeObj);
                    Node objectLiteral = typeObj.getNext();
                    if (!objectLiteral.isObjectLit()) break;
                    for (Node key : objectLiteral.children()) {
                        if (key.isQuotedString()) {
                            AmbiguateProperties.this.quotedNames.add(key.getString());
                            continue;
                        }
                        this.maybeMarkCandidate(key, jstype);
                    }
                    break;
                }
                case OBJECTLIT: {
                    if (n.getParent().isCall() && NodeUtil.isObjectDefinePropertiesDefinition(n.getParent())) break;
                    JSType jstype = AmbiguateProperties.this.getJSType(n);
                    for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
                        if (!key.isQuotedString()) {
                            this.maybeMarkCandidate(key, jstype);
                            continue;
                        }
                        AmbiguateProperties.this.quotedNames.add(key.getString());
                    }
                    break;
                }
                case GETELEM: {
                    Node child = n.getLastChild();
                    if (!child.isString()) break;
                    AmbiguateProperties.this.quotedNames.add(child.getString());
                    break;
                }
            }
        }

        private void maybeMarkCandidate(Node n, JSType type) {
            String name = n.getString();
            if (!AmbiguateProperties.this.externedNames.contains(name)) {
                AmbiguateProperties.this.stringNodesToRename.add(n);
                this.recordProperty(name, type);
            }
        }

        private Property recordProperty(String name, JSType type) {
            Property prop = AmbiguateProperties.this.getProperty(name);
            prop.addType(type);
            return prop;
        }
    }

    static class PropertyGraphNode
    implements GraphNode<Property, Void> {
        Property property;
        protected Annotation annotation;

        PropertyGraphNode(Property property) {
            this.property = property;
        }

        @Override
        public Property getValue() {
            return this.property;
        }

        public Annotation getAnnotation() {
            return this.annotation;
        }

        @Override
        public void setAnnotation(Annotation data) {
            this.annotation = data;
        }
    }

    class PropertySubGraph
    implements SubGraph<Property, Void> {
        JSTypeBitSet relatedTypes;

        PropertySubGraph() {
            this.relatedTypes = new JSTypeBitSet(AmbiguateProperties.this.intForType.size());
        }

        @Override
        public boolean isIndependentOf(Property prop) {
            return !this.relatedTypes.intersects(prop.relatedTypes);
        }

        @Override
        public void addNode(Property prop) {
            this.relatedTypes.or(prop.relatedTypes);
        }
    }

    class PropertyGraph
    implements AdjacencyGraph<Property, Void> {
        private final ArrayList<PropertyGraphNode> nodes;

        PropertyGraph(ArrayList<PropertyGraphNode> nodes) {
            this.nodes = nodes;
        }

        public List<PropertyGraphNode> getNodes() {
            return this.nodes;
        }

        @Override
        public GraphNode<Property, Void> getNode(Property property) {
            throw new RuntimeException("PropertyGraph#getNode is never called.");
        }

        @Override
        public SubGraph<Property, Void> newSubGraph() {
            return new PropertySubGraph();
        }

        @Override
        public void clearNodeAnnotations() {
            for (PropertyGraphNode node : this.nodes) {
                node.setAnnotation(null);
            }
        }

        @Override
        public int getWeight(Property value) {
            return value.numOccurrences;
        }
    }
}

