/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.SourcePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class ScopedAliases
implements HotSwapCompilerPass {
    static final String SCOPING_METHOD_NAME = "goog.scope";
    private final AbstractCompiler compiler;
    private final PreprocessorSymbolTable preprocessorSymbolTable;
    private final CompilerOptions.AliasTransformationHandler transformationHandler;
    static final DiagnosticType GOOG_SCOPE_MUST_BE_ALONE = DiagnosticType.error("JSC_GOOG_SCOPE_MUST_BE_ALONE", "The call to goog.scope must be alone in a single statement.");
    static final DiagnosticType GOOG_SCOPE_MUST_BE_IN_GLOBAL_SCOPE = DiagnosticType.error("JSC_GOOG_SCOPE_MUST_BE_IN_GLOBAL_SCOPE", "The call to goog.scope must be in the global scope.");
    static final DiagnosticType GOOG_SCOPE_HAS_BAD_PARAMETERS = DiagnosticType.error("JSC_GOOG_SCOPE_HAS_BAD_PARAMETERS", "The call to goog.scope must take only a single parameter.  It must be an anonymous function that itself takes no parameters.");
    static final DiagnosticType GOOG_SCOPE_REFERENCES_THIS = DiagnosticType.error("JSC_GOOG_SCOPE_REFERENCES_THIS", "The body of a goog.scope function cannot reference 'this'.");
    static final DiagnosticType GOOG_SCOPE_USES_RETURN = DiagnosticType.error("JSC_GOOG_SCOPE_USES_RETURN", "The body of a goog.scope function cannot use 'return'.");
    static final DiagnosticType GOOG_SCOPE_USES_THROW = DiagnosticType.error("JSC_GOOG_SCOPE_USES_THROW", "The body of a goog.scope function cannot use 'throw'.");
    static final DiagnosticType GOOG_SCOPE_ALIAS_REDEFINED = DiagnosticType.error("JSC_GOOG_SCOPE_ALIAS_REDEFINED", "The alias {0} is assigned a value more than once.");
    static final DiagnosticType GOOG_SCOPE_ALIAS_CYCLE = DiagnosticType.error("JSC_GOOG_SCOPE_ALIAS_CYCLE", "The aliases {0} has a cycle.");
    static final DiagnosticType GOOG_SCOPE_NON_ALIAS_LOCAL = DiagnosticType.error("JSC_GOOG_SCOPE_NON_ALIAS_LOCAL", "The local variable {0} is in a goog.scope and is not an alias.");
    static final DiagnosticType GOOG_SCOPE_INVALID_VARIABLE = DiagnosticType.error("JSC_GOOG_SCOPE_INVALID_VARIABLE", "The variable {0} cannot be declared in this scope");
    private Multiset<String> scopedAliasNames = HashMultiset.create();

    ScopedAliases(AbstractCompiler compiler, @Nullable PreprocessorSymbolTable preprocessorSymbolTable, CompilerOptions.AliasTransformationHandler transformationHandler) {
        this.compiler = compiler;
        this.preprocessorSymbolTable = preprocessorSymbolTable;
        this.transformationHandler = transformationHandler;
    }

    @Override
    public void process(Node externs, Node root) {
        this.hotSwapScript(root, null);
    }

    @Override
    public void hotSwapScript(Node root, Node originalRoot) {
        Traversal traversal = new Traversal();
        NodeTraversal.traverseEs6(this.compiler, root, traversal);
        if (!traversal.hasErrors()) {
            ArrayList aliasWorkQueue = new ArrayList(traversal.getAliasUsages());
            while (!aliasWorkQueue.isEmpty()) {
                ArrayList<AliasUsage> newQueue = new ArrayList<AliasUsage>();
                for (AliasUsage aliasUsage : aliasWorkQueue) {
                    if (aliasUsage.referencesOtherAlias()) {
                        newQueue.add(aliasUsage);
                        continue;
                    }
                    aliasUsage.applyAlias();
                }
                if (newQueue.size() == aliasWorkQueue.size()) {
                    Var cycleVar = ((AliasUsage)newQueue.get((int)0)).aliasVar;
                    this.compiler.report(JSError.make(cycleVar.getNode(), GOOG_SCOPE_ALIAS_CYCLE, cycleVar.getName()));
                    break;
                }
                aliasWorkQueue = newQueue;
            }
            for (Node aliasDefinition : traversal.getAliasDefinitionsInOrder()) {
                if (NodeUtil.isNameDeclaration(aliasDefinition.getParent()) && aliasDefinition.getParent().hasOneChild()) {
                    aliasDefinition.getParent().detachFromParent();
                    continue;
                }
                aliasDefinition.detachFromParent();
            }
            for (Node scopeCall : traversal.getScopeCalls()) {
                Node expressionWithScopeCall = scopeCall.getParent();
                Node scopeClosureBlock = scopeCall.getLastChild().getLastChild();
                scopeClosureBlock.detachFromParent();
                expressionWithScopeCall.getParent().replaceChild(expressionWithScopeCall, scopeClosureBlock);
                NodeUtil.tryMergeBlock(scopeClosureBlock);
            }
            if (!(traversal.getAliasUsages().isEmpty() && traversal.getAliasDefinitionsInOrder().isEmpty() && traversal.getScopeCalls().isEmpty())) {
                this.compiler.reportCodeChange();
            }
        }
    }

    private class Traversal
    extends NodeTraversal.AbstractPostOrderCallback
    implements NodeTraversal.ScopedCallback {
        private final List<Node> aliasDefinitionsInOrder = new ArrayList<Node>();
        private final List<Node> scopeCalls = new ArrayList<Node>();
        private final List<AliasUsage> aliasUsages = new ArrayList<AliasUsage>();
        private final Map<String, Var> aliases = new HashMap<String, Var>();
        private final Set<Node> injectedDecls = new HashSet<Node>();
        private final Set<String> forbiddenLocals = new HashSet<String>((Collection<String>)ImmutableSet.of((Object)"$jscomp"));
        private boolean hasNamespaceShadows = false;
        private boolean hasErrors = false;
        private CompilerOptions.AliasTransformation transformation = null;
        private Node scopeFunctionBody = null;

        private Traversal() {
        }

        Collection<Node> getAliasDefinitionsInOrder() {
            return this.aliasDefinitionsInOrder;
        }

        private List<AliasUsage> getAliasUsages() {
            return this.aliasUsages;
        }

        List<Node> getScopeCalls() {
            return this.scopeCalls;
        }

        boolean hasErrors() {
            return this.hasErrors;
        }

        private boolean inGoogScopeBody() {
            return this.scopeFunctionBody != null;
        }

        private boolean isGoogScopeFunctionBody(Node n) {
            return this.inGoogScopeBody() && n == this.scopeFunctionBody;
        }

        private boolean isCallToScopeMethod(Node n) {
            return n.isCall() && n.getFirstChild().matchesQualifiedName(ScopedAliases.SCOPING_METHOD_NAME);
        }

        private Node findScopeMethodCall(Node scopeRoot) {
            Node n = scopeRoot.getGrandparent();
            if (this.isCallToScopeMethod(n)) {
                return n;
            }
            return null;
        }

        @Override
        public void enterScope(NodeTraversal t) {
            Node scopeMethodCall;
            Scope hoistedScope;
            if (t.inGlobalHoistScope()) {
                return;
            }
            if (this.inGoogScopeBody() && this.isGoogScopeFunctionBody((hoistedScope = t.getClosestHoistScope()).getRootNode())) {
                this.findAliases(t, hoistedScope);
            }
            if ((scopeMethodCall = this.findScopeMethodCall(t.getScope().getRootNode())) != null) {
                this.transformation = ScopedAliases.this.transformationHandler.logAliasTransformation(scopeMethodCall.getSourceFileName(), this.getSourceRegion(scopeMethodCall));
                this.findAliases(t, t.getScope());
                this.scopeFunctionBody = scopeMethodCall.getLastChild().getLastChild();
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
            if (this.isGoogScopeFunctionBody(t.getScopeRoot())) {
                this.scopeFunctionBody = null;
                this.renameNamespaceShadows(t);
                this.injectedDecls.clear();
                this.aliases.clear();
                this.forbiddenLocals.clear();
                this.transformation = null;
                this.hasNamespaceShadows = false;
            } else if (this.inGoogScopeBody()) {
                this.findNamespaceShadows(t);
                this.reportInvalidVariables(t);
            }
        }

        private void reportInvalidVariables(NodeTraversal t) {
            Node scopeRoot = t.getScopeRoot();
            Node enclosingFunctionBody = t.getEnclosingFunction().getLastChild();
            if (this.isGoogScopeFunctionBody(enclosingFunctionBody) && scopeRoot.isBlock() && !scopeRoot.getParent().isFunction()) {
                for (Var v : t.getScope().getVarIterable()) {
                    Node parent = v.getNameNode().getParent();
                    if (!NodeUtil.isFunctionDeclaration(parent)) continue;
                    this.report(t, v.getNode(), GOOG_SCOPE_INVALID_VARIABLE, v.getName());
                }
            }
        }

        private SourcePosition<CompilerOptions.AliasTransformation> getSourceRegion(Node n) {
            Node testNode = n;
            Node next = null;
            while (next != null || testNode.isScript()) {
                next = testNode.getNext();
                testNode = testNode.getParent();
            }
            int endLine = next == null ? Integer.MAX_VALUE : next.getLineno();
            int endChar = next == null ? Integer.MAX_VALUE : next.getCharno();
            SourcePosition<CompilerOptions.AliasTransformation> pos = new SourcePosition<CompilerOptions.AliasTransformation>(){};
            pos.setPositionInformation(n.getLineno(), n.getCharno(), endLine, endChar);
            return pos;
        }

        private void report(NodeTraversal t, Node n, DiagnosticType error, String ... arguments) {
            ScopedAliases.this.compiler.report(t.makeError(n, error, arguments));
            this.hasErrors = true;
        }

        private void findAliases(NodeTraversal t, Scope scope) {
            for (Var v : scope.getVarIterable()) {
                Node n = v.getNode();
                Node parent = n.getParent();
                boolean isVar = NodeUtil.isNameDeclaration(parent) && parent.getParent().isBlock();
                boolean isFunctionDecl = NodeUtil.isFunctionDeclaration(parent);
                if (isVar && n.getFirstChild() != null && n.getFirstChild().isQualifiedName()) {
                    this.recordAlias(v);
                    continue;
                }
                if (v.isBleedingFunction() || parent.getType() == 83) continue;
                if (isVar || isFunctionDecl || NodeUtil.isClassDeclaration(parent)) {
                    boolean isHoisted = NodeUtil.isHoistedFunctionDeclaration(parent);
                    Node grandparent = parent.getParent();
                    Node value = v.getInitialValue();
                    Node varNode = null;
                    if (n.getJSDocInfo() != null) {
                        JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(parent.getJSDocInfo());
                        if (isFunctionDecl) {
                            builder.recordReturnType(n.getJSDocInfo().getType());
                        } else {
                            builder.recordType(n.getJSDocInfo().getType());
                        }
                        parent.setJSDocInfo(builder.build());
                        n.setJSDocInfo(null);
                    }
                    JSDocInfo varDocInfo = v.getJSDocInfo();
                    String name = n.getString();
                    int nameCount = ScopedAliases.this.scopedAliasNames.count((Object)name);
                    ScopedAliases.this.scopedAliasNames.add((Object)name);
                    String globalName = "$jscomp.scope." + name + (nameCount == 0 ? "" : "$jscomp$" + nameCount);
                    ScopedAliases.this.compiler.ensureLibraryInjected("base", true);
                    if (isFunctionDecl || NodeUtil.isClassDeclaration(parent)) {
                        Node newName = isFunctionDecl ? IR.name("") : IR.empty();
                        newName.useSourceInfoFrom(n);
                        value.replaceChild(n, newName);
                        varNode = IR.var(n).useSourceInfoFrom(n);
                        grandparent.replaceChild(parent, varNode);
                    } else {
                        if (value != null) {
                            value.detachFromParent();
                        }
                        varNode = parent;
                    }
                    if (value != null || varDocInfo != null) {
                        Node newDecl = NodeUtil.newQNameDeclaration(ScopedAliases.this.compiler, globalName, value, varDocInfo).useSourceInfoIfMissingFromForTree(n);
                        NodeUtil.setDebugInformation(newDecl.getFirstFirstChild(), n, name);
                        if (isHoisted) {
                            grandparent.addChildToFront(newDecl);
                        } else {
                            grandparent.addChildBefore(newDecl, varNode);
                        }
                        this.injectedDecls.add(newDecl.getFirstChild());
                    }
                    v.getNameNode().addChildToFront(NodeUtil.newQName(ScopedAliases.this.compiler, globalName, n, name));
                    this.recordAlias(v);
                    continue;
                }
                this.report(t, n, GOOG_SCOPE_NON_ALIAS_LOCAL, n.getString());
            }
        }

        private void recordAlias(Var aliasVar) {
            String qNameRoot;
            String name = aliasVar.getName();
            this.aliases.put(name, aliasVar);
            String qualifiedName = aliasVar.getInitialValue().getQualifiedName();
            this.transformation.addAlias(name, qualifiedName);
            int rootIndex = qualifiedName.indexOf(46);
            if (rootIndex != -1 && !this.aliases.containsKey(qNameRoot = qualifiedName.substring(0, rootIndex))) {
                this.forbiddenLocals.add(qNameRoot);
            }
        }

        private void findNamespaceShadows(NodeTraversal t) {
            if (this.hasNamespaceShadows) {
                return;
            }
            Scope scope = t.getScope();
            for (Var v : scope.getVarIterable()) {
                if (!this.forbiddenLocals.contains(v.getName())) continue;
                this.hasNamespaceShadows = true;
                return;
            }
        }

        private void renameNamespaceShadows(NodeTraversal t) {
            if (this.hasNamespaceShadows) {
                MakeDeclaredNamesUnique.WhitelistedRenamer renamer = new MakeDeclaredNamesUnique.WhitelistedRenamer(new MakeDeclaredNamesUnique.ContextualRenamer(), this.forbiddenLocals);
                for (String s : this.forbiddenLocals) {
                    renamer.addDeclaredName(s, false);
                }
                MakeDeclaredNamesUnique uniquifier = new MakeDeclaredNamesUnique(renamer);
                Node parent = t.getScopeRoot().getParent();
                NodeTraversal.traverseEs6(ScopedAliases.this.compiler, parent, uniquifier);
            }
        }

        private void validateScopeCall(NodeTraversal t, Node n, Node parent) {
            if (ScopedAliases.this.preprocessorSymbolTable != null) {
                ScopedAliases.this.preprocessorSymbolTable.addReference(n.getFirstChild());
            }
            if (!parent.isExprResult()) {
                this.report(t, n, GOOG_SCOPE_MUST_BE_ALONE, new String[0]);
            }
            if (t.getEnclosingFunction() != null) {
                this.report(t, n, GOOG_SCOPE_MUST_BE_IN_GLOBAL_SCOPE, new String[0]);
            }
            if (n.getChildCount() != 2) {
                this.report(t, n, GOOG_SCOPE_HAS_BAD_PARAMETERS, new String[0]);
            } else {
                Node anonymousFnNode = n.getSecondChild();
                if (!anonymousFnNode.isFunction() || NodeUtil.getName(anonymousFnNode) != null || NodeUtil.getFunctionParameters(anonymousFnNode).hasChildren()) {
                    this.report(t, anonymousFnNode, GOOG_SCOPE_HAS_BAD_PARAMETERS, new String[0]);
                } else {
                    this.scopeCalls.add(n);
                }
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (this.isCallToScopeMethod(n)) {
                this.validateScopeCall(t, n, n.getParent());
            }
            if (!this.inGoogScopeBody()) {
                return;
            }
            int type = n.getType();
            boolean isObjLitShorthand = type == 154 && !n.hasChildren();
            Var aliasVar = null;
            if (type == 38 || isObjLitShorthand) {
                String name = n.getString();
                Var lexicalVar = t.getScope().getVar(name);
                if (lexicalVar != null && lexicalVar == this.aliases.get(name)) {
                    aliasVar = lexicalVar;
                }
            }
            if (this.isGoogScopeFunctionBody(t.getEnclosingFunction().getLastChild())) {
                if (aliasVar != null && !isObjLitShorthand && NodeUtil.isLValue(n)) {
                    if (aliasVar.getNode() == n) {
                        this.aliasDefinitionsInOrder.add(n);
                        return;
                    }
                    this.report(t, n, GOOG_SCOPE_ALIAS_REDEFINED, n.getString());
                }
                if (type == 4) {
                    this.report(t, n, GOOG_SCOPE_USES_RETURN, new String[0]);
                } else if (type == 42) {
                    this.report(t, n, GOOG_SCOPE_REFERENCES_THIS, new String[0]);
                } else if (type == 49) {
                    this.report(t, n, GOOG_SCOPE_USES_THROW, new String[0]);
                }
            }
            if (this.inGoogScopeBody()) {
                JSDocInfo info;
                if (aliasVar != null) {
                    this.aliasUsages.add(new AliasedNode(aliasVar, n));
                }
                if ((info = n.getJSDocInfo()) != null && !this.injectedDecls.contains(n)) {
                    for (Node node : info.getTypeNodes()) {
                        this.fixTypeNode(node);
                    }
                }
            }
        }

        private void fixTypeNode(Node typeNode) {
            if (typeNode.isString()) {
                String baseName;
                Var aliasVar;
                String name = typeNode.getString();
                int endIndex = name.indexOf(46);
                if (endIndex == -1) {
                    endIndex = name.length();
                }
                if ((aliasVar = this.aliases.get(baseName = name.substring(0, endIndex))) != null) {
                    this.aliasUsages.add(new AliasedTypeNode(aliasVar, typeNode));
                }
            }
            for (Node child = typeNode.getFirstChild(); child != null; child = child.getNext()) {
                this.fixTypeNode(child);
            }
        }
    }

    private static class AliasedTypeNode
    extends AliasUsage {
        AliasedTypeNode(Var aliasVar, Node aliasReference) {
            super(aliasVar, aliasReference);
        }

        @Override
        public void applyAlias() {
            Node aliasDefinition = this.aliasVar.getInitialValue();
            String aliasName = this.aliasVar.getName();
            String typeName = this.aliasReference.getString();
            if (typeName.startsWith("$jscomp.scope.")) {
                return;
            }
            String aliasExpanded = (String)Preconditions.checkNotNull((Object)aliasDefinition.getQualifiedName());
            Preconditions.checkState((boolean)typeName.startsWith(aliasName), (String)"%s must start with %s", (Object[])new Object[]{typeName, aliasName});
            String replacement = aliasExpanded + typeName.substring(aliasName.length());
            this.aliasReference.setString(replacement);
        }
    }

    private static class AliasedNode
    extends AliasUsage {
        AliasedNode(Var aliasVar, Node aliasReference) {
            super(aliasVar, aliasReference);
        }

        @Override
        public void applyAlias() {
            Node aliasDefinition = this.aliasVar.getInitialValue();
            Node replacement = aliasDefinition.cloneTree();
            replacement.useSourceInfoFromForTree(this.aliasReference);
            if (this.aliasReference.getType() == 154) {
                Preconditions.checkState((!this.aliasReference.hasChildren() ? 1 : 0) != 0);
                this.aliasReference.addChildToFront(replacement);
            } else {
                this.aliasReference.getParent().replaceChild(this.aliasReference, replacement);
            }
        }
    }

    private static abstract class AliasUsage {
        final Var aliasVar;
        final Node aliasReference;

        AliasUsage(Var aliasVar, Node aliasReference) {
            this.aliasVar = aliasVar;
            this.aliasReference = aliasReference;
        }

        public boolean referencesOtherAlias() {
            Node aliasDefinition = this.aliasVar.getInitialValue();
            Node root = NodeUtil.getRootOfQualifiedName(aliasDefinition);
            Var otherAliasVar = this.aliasVar.getScope().getOwnSlot(root.getString());
            return otherAliasVar != null;
        }

        public abstract void applyAlias();
    }
}

