/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TokenStream;
import com.google.javascript.rhino.TokenUtil;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.TernaryValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class NodeUtil {
    static final long MAX_POSITIVE_INTEGER_NUMBER = 0x20000000000000L;
    static final String JSC_PROPERTY_NAME_FN = "JSCompiler_renameProperty";
    static final char LARGEST_BASIC_LATIN = '\u007f';
    private static final Set<String> CONSTRUCTORS_WITHOUT_SIDE_EFFECTS = ImmutableSet.of((Object)"Array", (Object)"Date", (Object)"Error", (Object)"Object", (Object)"RegExp", (Object)"XMLHttpRequest", (Object[])new String[0]);
    private static final Set<String> BUILTIN_FUNCTIONS_WITHOUT_SIDEEFFECTS = ImmutableSet.of((Object)"Object", (Object)"Array", (Object)"String", (Object)"Number", (Object)"Boolean", (Object)"RegExp", (Object[])new String[]{"Error"});
    private static final Set<String> OBJECT_METHODS_WITHOUT_SIDEEFFECTS = ImmutableSet.of((Object)"toString", (Object)"valueOf");
    private static final Set<String> REGEXP_METHODS = ImmutableSet.of((Object)"test", (Object)"exec");
    private static final Set<String> STRING_REGEXP_METHODS = ImmutableSet.of((Object)"match", (Object)"replace", (Object)"search", (Object)"split");
    static final Predicate<Node> IMMUTABLE_PREDICATE = new Predicate<Node>(){

        public boolean apply(Node n) {
            return NodeUtil.isImmutableValue(n);
        }
    };
    private static final Predicate<Node> isStatement = new Predicate<Node>(){

        public boolean apply(Node n) {
            return NodeUtil.isStatement(n);
        }
    };
    static final Predicate<Node> MATCH_NOT_FUNCTION = new MatchNotFunction();
    static final Predicate<Node> MATCH_NOT_CLASS = new MatchNotClass();
    static final Predicate<Node> MATCH_NOT_THIS_BINDING = new Predicate<Node>(){

        public boolean apply(Node n) {
            return !NodeUtil.isVanillaFunction(n);
        }
    };

    private NodeUtil() {
    }

    static boolean isImpureTrue(Node n) {
        return NodeUtil.getImpureBooleanValue(n) == TernaryValue.TRUE;
    }

    static TernaryValue getImpureBooleanValue(Node n) {
        switch (n.getType()) {
            case 85: 
            case 86: {
                return NodeUtil.getImpureBooleanValue(n.getLastChild());
            }
            case 26: {
                TernaryValue value = NodeUtil.getImpureBooleanValue(n.getLastChild());
                return value.not();
            }
            case 101: {
                TernaryValue lhs = NodeUtil.getImpureBooleanValue(n.getFirstChild());
                TernaryValue rhs = NodeUtil.getImpureBooleanValue(n.getLastChild());
                return lhs.and(rhs);
            }
            case 100: {
                TernaryValue lhs = NodeUtil.getImpureBooleanValue(n.getFirstChild());
                TernaryValue rhs = NodeUtil.getImpureBooleanValue(n.getLastChild());
                return lhs.or(rhs);
            }
            case 98: {
                TernaryValue trueValue = NodeUtil.getImpureBooleanValue(n.getSecondChild());
                TernaryValue falseValue = NodeUtil.getImpureBooleanValue(n.getLastChild());
                if (trueValue.equals((Object)falseValue)) {
                    return trueValue;
                }
                return TernaryValue.UNKNOWN;
            }
            case 30: 
            case 63: 
            case 64: {
                return TernaryValue.TRUE;
            }
            case 122: {
                return TernaryValue.FALSE;
            }
        }
        return NodeUtil.getPureBooleanValue(n);
    }

    static TernaryValue getPureBooleanValue(Node n) {
        switch (n.getType()) {
            case 177: {
                if (!n.hasOneChild()) break;
                return TernaryValue.forBoolean(!n.getFirstChild().getString().isEmpty());
            }
            case 40: {
                return TernaryValue.forBoolean(n.getString().length() > 0);
            }
            case 39: {
                return TernaryValue.forBoolean(n.getDouble() != 0.0);
            }
            case 26: {
                return NodeUtil.getPureBooleanValue(n.getLastChild()).not();
            }
            case 41: 
            case 43: {
                return TernaryValue.FALSE;
            }
            case 122: {
                if (NodeUtil.mayHaveSideEffects(n.getFirstChild())) break;
                return TernaryValue.FALSE;
            }
            case 38: {
                String name = n.getString();
                if ("undefined".equals(name) || "NaN".equals(name)) {
                    return TernaryValue.FALSE;
                }
                if (!"Infinity".equals(name)) break;
                return TernaryValue.TRUE;
            }
            case 44: 
            case 47: {
                return TernaryValue.TRUE;
            }
            case 30: 
            case 63: 
            case 64: 
            case 105: 
            case 158: {
                if (NodeUtil.mayHaveSideEffects(n)) break;
                return TernaryValue.TRUE;
            }
        }
        return TernaryValue.UNKNOWN;
    }

    public static String getStringValue(Node n) {
        switch (n.getType()) {
            case 40: 
            case 154: {
                return n.getString();
            }
            case 38: {
                String name = n.getString();
                if (!"undefined".equals(name) && !"Infinity".equals(name) && !"NaN".equals(name)) break;
                return name;
            }
            case 39: {
                return NodeUtil.getStringValue(n.getDouble());
            }
            case 43: {
                return "false";
            }
            case 44: {
                return "true";
            }
            case 41: {
                return "null";
            }
            case 122: {
                return "undefined";
            }
            case 26: {
                TernaryValue child = NodeUtil.getPureBooleanValue(n.getFirstChild());
                if (child == TernaryValue.UNKNOWN) break;
                return child.toBoolean(true) ? "false" : "true";
            }
            case 63: {
                return NodeUtil.arrayToString(n);
            }
            case 64: {
                return "[object Object]";
            }
        }
        return null;
    }

    static String getStringValue(double value) {
        long longValue = (long)value;
        if ((double)longValue == value) {
            return Long.toString(longValue);
        }
        return Double.toString(value);
    }

    static String getArrayElementStringValue(Node n) {
        return NodeUtil.isNullOrUndefined(n) || n.isEmpty() ? "" : NodeUtil.getStringValue(n);
    }

    static String arrayToString(Node literal) {
        Node first = literal.getFirstChild();
        StringBuilder result = new StringBuilder();
        for (Node n = first; n != null; n = n.getNext()) {
            String childValue = NodeUtil.getArrayElementStringValue(n);
            if (childValue == null) {
                return null;
            }
            if (n != first) {
                result.append(',');
            }
            result.append(childValue);
        }
        return result.toString();
    }

    public static Double getNumberValue(Node n) {
        return NodeUtil.getNumberValue(n, false);
    }

    static Double getNumberValue(Node n, boolean useType) {
        switch (n.getType()) {
            case 44: {
                return 1.0;
            }
            case 41: 
            case 43: {
                return 0.0;
            }
            case 39: {
                return n.getDouble();
            }
            case 122: {
                if (NodeUtil.mayHaveSideEffects(n.getFirstChild())) {
                    return null;
                }
                return Double.NaN;
            }
            case 38: {
                JSType type;
                String name = n.getString();
                if (name.equals("undefined")) {
                    return Double.NaN;
                }
                if (name.equals("NaN")) {
                    return Double.NaN;
                }
                if (name.equals("Infinity")) {
                    return Double.POSITIVE_INFINITY;
                }
                if (useType && (type = n.getJSType()) != null) {
                    if (type.isVoidType()) {
                        return Double.NaN;
                    }
                    if (type.isNullType()) {
                        return 0.0;
                    }
                }
                return null;
            }
            case 29: {
                if (n.getChildCount() == 1 && n.getFirstChild().isName() && n.getFirstChild().getString().equals("Infinity")) {
                    return Double.NEGATIVE_INFINITY;
                }
                return null;
            }
            case 26: {
                TernaryValue child = NodeUtil.getPureBooleanValue(n.getFirstChild());
                if (child == TernaryValue.UNKNOWN) break;
                return child.toBoolean(true) ? 0.0 : 1.0;
            }
            case 40: {
                return NodeUtil.getStringNumberValue(n.getString());
            }
            case 63: 
            case 64: {
                String value = NodeUtil.getStringValue(n);
                return value != null ? NodeUtil.getStringNumberValue(value) : null;
            }
        }
        return null;
    }

    static Double getStringNumberValue(String rawJsString) {
        if (rawJsString.contains("\u000b")) {
            return null;
        }
        String s = NodeUtil.trimJsWhiteSpace(rawJsString);
        if (s.isEmpty()) {
            return 0.0;
        }
        if (s.length() > 2 && s.charAt(0) == '0' && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
            try {
                return Integer.parseInt(s.substring(2), 16);
            }
            catch (NumberFormatException e) {
                return Double.NaN;
            }
        }
        if (!(s.length() <= 3 || s.charAt(0) != '-' && s.charAt(0) != '+' || s.charAt(1) != '0' || s.charAt(2) != 'x' && s.charAt(2) != 'X')) {
            return null;
        }
        if (s.equals("infinity") || s.equals("-infinity") || s.equals("+infinity")) {
            return null;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    static String trimJsWhiteSpace(String s) {
        int end;
        int start = 0;
        for (end = s.length(); end > 0 && TokenUtil.isStrWhiteSpaceChar(s.charAt(end - 1)) == TernaryValue.TRUE; --end) {
        }
        while (start < end && TokenUtil.isStrWhiteSpaceChar(s.charAt(start)) == TernaryValue.TRUE) {
            ++start;
        }
        return s.substring(start, end);
    }

    public static String getName(Node n) {
        Node nameNode = NodeUtil.getNameNode(n);
        return nameNode == null ? null : nameNode.getQualifiedName();
    }

    public static Node getNameNode(Node n) {
        Preconditions.checkState((n.isFunction() || n.isClass() ? 1 : 0) != 0);
        Node parent = n.getParent();
        switch (parent.getType()) {
            case 38: {
                return parent;
            }
            case 86: {
                Node firstChild = parent.getFirstChild();
                return firstChild.isQualifiedName() ? firstChild : null;
            }
        }
        Node funNameNode = n.getFirstChild();
        return funNameNode.isEmpty() || funNameNode.getString().isEmpty() ? null : funNameNode;
    }

    public static String getNearestFunctionName(Node n) {
        if (!n.isFunction()) {
            return null;
        }
        String name = NodeUtil.getName(n);
        if (name != null) {
            return name;
        }
        Node parent = n.getParent();
        switch (parent.getType()) {
            case 147: 
            case 148: 
            case 154: 
            case 160: {
                return parent.getString();
            }
            case 39: {
                return NodeUtil.getStringValue(parent);
            }
        }
        return null;
    }

    static boolean isImmutableValue(Node n) {
        switch (n.getType()) {
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: {
                return true;
            }
            case 26: 
            case 29: 
            case 122: 
            case 155: {
                return NodeUtil.isImmutableValue(n.getFirstChild());
            }
            case 38: {
                String name = n.getString();
                return "undefined".equals(name) || "Infinity".equals(name) || "NaN".equals(name);
            }
        }
        return false;
    }

    static boolean isSymmetricOperation(Node n) {
        switch (n.getType()) {
            case 12: 
            case 13: 
            case 23: 
            case 45: 
            case 46: {
                return true;
            }
        }
        return false;
    }

    static boolean isRelationalOperation(Node n) {
        switch (n.getType()) {
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    static boolean isAssignmentTarget(Node n) {
        Node parent = n.getParent();
        return NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == n || parent.isInc() || parent.isDec() || NodeUtil.isForIn(parent) && parent.getFirstChild() == n;
    }

    static int getInverseOperator(int type) {
        switch (type) {
            case 16: {
                return 14;
            }
            case 14: {
                return 16;
            }
            case 17: {
                return 15;
            }
            case 15: {
                return 17;
            }
        }
        return -1;
    }

    public static boolean isLiteralValue(Node n, boolean includeFunctions) {
        switch (n.getType()) {
            case 155: {
                return NodeUtil.isLiteralValue(n.getFirstChild(), includeFunctions);
            }
            case 63: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (child.isEmpty() || NodeUtil.isLiteralValue(child, includeFunctions)) continue;
                    return false;
                }
                return true;
            }
            case 47: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (NodeUtil.isLiteralValue(child, includeFunctions)) continue;
                    return false;
                }
                return true;
            }
            case 64: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (NodeUtil.isLiteralValue(child.getFirstChild(), includeFunctions)) continue;
                    return false;
                }
                return true;
            }
            case 105: {
                return includeFunctions && !NodeUtil.isFunctionDeclaration(n);
            }
        }
        return NodeUtil.isImmutableValue(n);
    }

    static boolean isValidDefineValue(Node val, Set<String> defines) {
        switch (val.getType()) {
            case 39: 
            case 40: 
            case 43: 
            case 44: {
                return true;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 45: 
            case 46: 
            case 100: 
            case 101: {
                return NodeUtil.isValidDefineValue(val.getFirstChild(), defines) && NodeUtil.isValidDefineValue(val.getLastChild(), defines);
            }
            case 26: 
            case 28: 
            case 29: {
                return NodeUtil.isValidDefineValue(val.getFirstChild(), defines);
            }
            case 33: 
            case 38: {
                if (!val.isQualifiedName()) break;
                return defines.contains(val.getQualifiedName());
            }
        }
        return false;
    }

    static boolean isEmptyBlock(Node block) {
        if (!block.isBlock()) {
            return false;
        }
        for (Node n = block.getFirstChild(); n != null; n = n.getNext()) {
            if (n.isEmpty()) continue;
            return false;
        }
        return true;
    }

    static boolean isSimpleOperator(Node n) {
        return NodeUtil.isSimpleOperatorType(n.getType());
    }

    static boolean isSimpleOperatorType(int type) {
        switch (type) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 35: 
            case 45: 
            case 46: 
            case 52: 
            case 85: 
            case 122: {
                return true;
            }
        }
        return false;
    }

    static boolean isTypedefDecl(Node n) {
        if (n.isVar() || n.isName() && n.getParent().isVar() || n.isGetProp() && n.getParent().isExprResult()) {
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(n);
            return jsdoc != null && jsdoc.hasTypedefType();
        }
        return false;
    }

    static boolean isEnumDecl(Node n) {
        if (n.isVar() || n.isName() && n.getParent().isVar() || n.isGetProp() && n.getParent().isAssign() && n.getGrandparent().isExprResult() || n.isAssign() && n.getParent().isExprResult()) {
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(n);
            return jsdoc != null && jsdoc.hasEnumParameterType();
        }
        return false;
    }

    static boolean isNamespaceDecl(Node n) {
        Node initializer;
        Node qnameNode;
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(n);
        if (jsdoc != null && !jsdoc.getTypeNodes().isEmpty()) {
            return false;
        }
        if (!(n.isFromExterns() || jsdoc != null && jsdoc.isConstant())) {
            return false;
        }
        if (n.getParent().isVar()) {
            qnameNode = n;
            initializer = n.getFirstChild();
        } else if (n.isExprResult()) {
            Node expr = n.getFirstChild();
            if (!expr.isAssign() || !expr.getFirstChild().isGetProp()) {
                return false;
            }
            qnameNode = expr.getFirstChild();
            initializer = expr.getLastChild();
        } else if (n.isGetProp()) {
            Node parent = n.getParent();
            if (!parent.isAssign() || !parent.getParent().isExprResult()) {
                return false;
            }
            qnameNode = n;
            initializer = parent.getLastChild();
        } else {
            return false;
        }
        if (initializer == null || qnameNode == null) {
            return false;
        }
        if (initializer.isObjectLit()) {
            return true;
        }
        return initializer.isOr() && qnameNode.matchesQualifiedName(initializer.getFirstChild()) && initializer.getLastChild().isObjectLit();
    }

    static Node newExpr(Node child) {
        return IR.exprResult(child).srcref(child);
    }

    static boolean mayEffectMutableState(Node n) {
        return NodeUtil.mayEffectMutableState(n, null);
    }

    static boolean mayEffectMutableState(Node n, AbstractCompiler compiler) {
        return NodeUtil.checkForStateChangeHelper(n, true, compiler);
    }

    public static boolean mayHaveSideEffects(Node n) {
        return NodeUtil.mayHaveSideEffects(n, null);
    }

    public static boolean mayHaveSideEffects(Node n, AbstractCompiler compiler) {
        return NodeUtil.checkForStateChangeHelper(n, false, compiler);
    }

    private static boolean checkForStateChangeHelper(Node n, boolean checkForNewObjects, AbstractCompiler compiler) {
        switch (n.getType()) {
            case 49: 
            case 164: {
                return true;
            }
            case 64: {
                if (checkForNewObjects) {
                    return true;
                }
                for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
                    for (Node c = key.getFirstChild(); c != null; c = c.getNext()) {
                        if (!NodeUtil.checkForStateChangeHelper(c, checkForNewObjects, compiler)) continue;
                        return true;
                    }
                }
                return false;
            }
            case 47: 
            case 63: {
                if (!checkForNewObjects) break;
                return true;
            }
            case 38: 
            case 118: {
                if (n.getFirstChild() == null) break;
                return true;
            }
            case 105: {
                return checkForNewObjects || !NodeUtil.isFunctionExpression(n);
            }
            case 158: {
                return checkForNewObjects || !NodeUtil.isClassExpression(n) || NodeUtil.checkForStateChangeHelper(n.getSecondChild(), checkForNewObjects, compiler);
            }
            case 30: {
                if (checkForNewObjects) {
                    return true;
                }
                if (!NodeUtil.constructorCallHasSideEffects(n)) break;
                return true;
            }
            case 37: {
                if (!NodeUtil.functionCallHasSideEffects(n, compiler)) break;
                return true;
            }
            case 176: {
                return NodeUtil.functionCallHasSideEffects(n, compiler);
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 51: 
            case 77: 
            case 83: 
            case 98: 
            case 100: 
            case 101: 
            case 108: 
            case 110: 
            case 124: 
            case 125: 
            case 130: 
            case 154: 
            case 155: 
            case 177: 
            case 178: {
                break;
            }
            default: {
                if (NodeUtil.isSimpleOperator(n)) break;
                if (NodeUtil.isAssignmentOp(n)) {
                    Node assignTarget = n.getFirstChild();
                    if (assignTarget.isName()) {
                        return true;
                    }
                    if (NodeUtil.checkForStateChangeHelper(n.getFirstChild(), checkForNewObjects, compiler) || NodeUtil.checkForStateChangeHelper(n.getLastChild(), checkForNewObjects, compiler)) {
                        return true;
                    }
                    if (NodeUtil.isGet(assignTarget)) {
                        Node current = assignTarget.getFirstChild();
                        if (NodeUtil.evaluatesToLocalValue(current)) {
                            return false;
                        }
                        while (NodeUtil.isGet(current)) {
                            current = current.getFirstChild();
                        }
                        return !NodeUtil.isLiteralValue(current, true);
                    }
                    return !NodeUtil.isLiteralValue(assignTarget, true);
                }
                return true;
            }
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (!NodeUtil.checkForStateChangeHelper(c, checkForNewObjects, compiler)) continue;
            return true;
        }
        return false;
    }

    static boolean constructorCallHasSideEffects(Node callNode) {
        if (!callNode.isNew()) {
            throw new IllegalStateException("Expected NEW node, got " + Token.name(callNode.getType()));
        }
        if (callNode.isNoSideEffectsCall()) {
            return false;
        }
        if (callNode.isOnlyModifiesArgumentsCall() && NodeUtil.allArgsUnescapedLocal(callNode)) {
            return false;
        }
        Node nameNode = callNode.getFirstChild();
        return !nameNode.isName() || !CONSTRUCTORS_WITHOUT_SIDE_EFFECTS.contains(nameNode.getString());
    }

    static boolean functionCallHasSideEffects(Node callNode) {
        return NodeUtil.functionCallHasSideEffects(callNode, null);
    }

    static boolean functionCallHasSideEffects(Node callNode, @Nullable AbstractCompiler compiler) {
        Preconditions.checkState((callNode.isCall() || callNode.isTaggedTemplateLit() ? 1 : 0) != 0, (Object)callNode);
        if (callNode.isNoSideEffectsCall()) {
            return false;
        }
        if (callNode.isOnlyModifiesArgumentsCall() && NodeUtil.allArgsUnescapedLocal(callNode)) {
            return false;
        }
        Node nameNode = callNode.getFirstChild();
        if (nameNode.isName()) {
            String name = nameNode.getString();
            if (BUILTIN_FUNCTIONS_WITHOUT_SIDEEFFECTS.contains(name)) {
                return false;
            }
        } else if (nameNode.isGetProp()) {
            if (callNode.hasOneChild() && OBJECT_METHODS_WITHOUT_SIDEEFFECTS.contains(nameNode.getLastChild().getString())) {
                return false;
            }
            if (callNode.isOnlyModifiesThisCall() && NodeUtil.evaluatesToLocalValue(nameNode.getFirstChild())) {
                return false;
            }
            if (nameNode.getFirstChild().isName() && nameNode.isQualifiedName() && nameNode.getFirstChild().getString().equals("Math")) {
                switch (nameNode.getLastChild().getString()) {
                    case "abs": 
                    case "acos": 
                    case "acosh": 
                    case "asin": 
                    case "asinh": 
                    case "atan": 
                    case "atanh": 
                    case "atan2": 
                    case "cbrt": 
                    case "ceil": 
                    case "cos": 
                    case "cosh": 
                    case "exp": 
                    case "expm1": 
                    case "floor": 
                    case "hypot": 
                    case "log": 
                    case "log10": 
                    case "log1p": 
                    case "log2": 
                    case "max": 
                    case "min": 
                    case "pow": 
                    case "round": 
                    case "sign": 
                    case "sin": 
                    case "sinh": 
                    case "sqrt": 
                    case "tan": 
                    case "tanh": 
                    case "trunc": {
                        return false;
                    }
                    case "random": {
                        return !callNode.hasOneChild();
                    }
                }
            }
            if (compiler != null && !compiler.hasRegExpGlobalReferences()) {
                if (nameNode.getFirstChild().isRegExp() && REGEXP_METHODS.contains(nameNode.getLastChild().getString())) {
                    return false;
                }
                if (nameNode.getFirstChild().isString()) {
                    String method = nameNode.getLastChild().getString();
                    Node param = nameNode.getNext();
                    if (param != null) {
                        if (param.isString()) {
                            if (STRING_REGEXP_METHODS.contains(method)) {
                                return false;
                            }
                        } else if (param.isRegExp()) {
                            if ("replace".equals(method)) {
                                return !param.getNext().isString();
                            }
                            if (STRING_REGEXP_METHODS.contains(method)) {
                                return false;
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    static boolean callHasLocalResult(Node n) {
        Preconditions.checkState((boolean)n.isCall(), (Object)n);
        return (n.getSideEffectFlags() & 0x10) > 0;
    }

    static boolean newHasLocalResult(Node n) {
        Preconditions.checkState((boolean)n.isNew(), (Object)n);
        return n.isOnlyModifiesThisCall();
    }

    static boolean nodeTypeMayHaveSideEffects(Node n) {
        return NodeUtil.nodeTypeMayHaveSideEffects(n, null);
    }

    static boolean nodeTypeMayHaveSideEffects(Node n, AbstractCompiler compiler) {
        if (NodeUtil.isAssignmentOp(n)) {
            return true;
        }
        switch (n.getType()) {
            case 31: 
            case 49: 
            case 102: 
            case 103: 
            case 164: {
                return true;
            }
            case 37: {
                return NodeUtil.functionCallHasSideEffects(n, compiler);
            }
            case 30: {
                return NodeUtil.constructorCallHasSideEffects(n);
            }
            case 38: {
                return n.hasChildren();
            }
        }
        return false;
    }

    static boolean allArgsUnescapedLocal(Node callOrNew) {
        for (Node arg = callOrNew.getSecondChild(); arg != null; arg = arg.getNext()) {
            if (NodeUtil.evaluatesToLocalValue(arg)) continue;
            return false;
        }
        return true;
    }

    static boolean canBeSideEffected(Node n) {
        Set<String> emptySet = Collections.emptySet();
        return NodeUtil.canBeSideEffected(n, emptySet, null);
    }

    static boolean canBeSideEffected(Node n, Set<String> knownConstants, Scope scope) {
        switch (n.getType()) {
            case 30: 
            case 37: 
            case 164: {
                return true;
            }
            case 38: {
                return !NodeUtil.isConstantVar(n, scope) && !knownConstants.contains(n.getString());
            }
            case 33: 
            case 35: {
                return true;
            }
            case 105: {
                Preconditions.checkState((boolean)NodeUtil.isFunctionExpression(n));
                return false;
            }
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (!NodeUtil.canBeSideEffected(c, knownConstants, scope)) continue;
            return true;
        }
        return false;
    }

    static int precedence(int type) {
        switch (type) {
            case 85: {
                return 0;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                return 1;
            }
            case 164: {
                return 2;
            }
            case 98: {
                return 3;
            }
            case 100: {
                return 4;
            }
            case 101: {
                return 5;
            }
            case 9: {
                return 6;
            }
            case 10: {
                return 7;
            }
            case 11: {
                return 8;
            }
            case 12: 
            case 13: 
            case 45: 
            case 46: {
                return 9;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 51: 
            case 52: {
                return 10;
            }
            case 18: 
            case 19: 
            case 20: {
                return 11;
            }
            case 21: 
            case 22: {
                return 12;
            }
            case 23: 
            case 24: 
            case 25: {
                return 13;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 102: 
            case 103: 
            case 122: {
                return 14;
            }
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 63: 
            case 64: 
            case 105: 
            case 124: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 161: 
            case 173: 
            case 174: 
            case 176: 
            case 177: 
            case 179: 
            case 205: 
            case 319: 
            case 320: 
            case 321: {
                return 15;
            }
            case 203: {
                return 16;
            }
            case 204: 
            case 215: {
                return 17;
            }
            case 200: 
            case 201: 
            case 202: 
            case 206: 
            case 208: 
            case 211: 
            case 213: 
            case 214: 
            case 216: {
                return 18;
            }
            case 155: {
                return 19;
            }
        }
        throw new IllegalStateException("Unknown precedence for " + Token.name(type) + " (type " + type + ")");
    }

    public static boolean isUndefined(Node n) {
        switch (n.getType()) {
            case 122: {
                return true;
            }
            case 38: {
                return n.getString().equals("undefined");
            }
        }
        return false;
    }

    public static boolean isNullOrUndefined(Node n) {
        return n.isNull() || NodeUtil.isUndefined(n);
    }

    static boolean isImmutableResult(Node n) {
        return NodeUtil.allResultsMatch(n, IMMUTABLE_PREDICATE);
    }

    static boolean allResultsMatch(Node n, Predicate<Node> p) {
        switch (n.getType()) {
            case 155: {
                return NodeUtil.allResultsMatch(n.getFirstChild(), p);
            }
            case 85: 
            case 86: {
                return NodeUtil.allResultsMatch(n.getLastChild(), p);
            }
            case 100: 
            case 101: {
                return NodeUtil.allResultsMatch(n.getFirstChild(), p) && NodeUtil.allResultsMatch(n.getLastChild(), p);
            }
            case 98: {
                return NodeUtil.allResultsMatch(n.getSecondChild(), p) && NodeUtil.allResultsMatch(n.getLastChild(), p);
            }
        }
        return p.apply((Object)n);
    }

    static ValueType getKnownValueType(Node n) {
        switch (n.getType()) {
            case 155: {
                return NodeUtil.getKnownValueType(n.getFirstChild());
            }
            case 85: 
            case 86: {
                return NodeUtil.getKnownValueType(n.getLastChild());
            }
            case 100: 
            case 101: {
                return NodeUtil.and(NodeUtil.getKnownValueType(n.getFirstChild()), NodeUtil.getKnownValueType(n.getLastChild()));
            }
            case 98: {
                return NodeUtil.and(NodeUtil.getKnownValueType(n.getSecondChild()), NodeUtil.getKnownValueType(n.getLastChild()));
            }
            case 21: {
                ValueType last = NodeUtil.getKnownValueType(n.getLastChild());
                if (last == ValueType.STRING) {
                    return ValueType.STRING;
                }
                ValueType first = NodeUtil.getKnownValueType(n.getFirstChild());
                if (first == ValueType.STRING) {
                    return ValueType.STRING;
                }
                if (first == ValueType.OBJECT || last == ValueType.OBJECT) {
                    return ValueType.UNDETERMINED;
                }
                if (!NodeUtil.mayBeString(first) && !NodeUtil.mayBeString(last)) {
                    return ValueType.NUMBER;
                }
                return ValueType.UNDETERMINED;
            }
            case 93: {
                ValueType last = NodeUtil.getKnownValueType(n.getLastChild());
                if (last == ValueType.STRING) {
                    return ValueType.STRING;
                }
                return ValueType.UNDETERMINED;
            }
            case 38: {
                String name = n.getString();
                if (name.equals("undefined")) {
                    return ValueType.VOID;
                }
                if (name.equals("NaN")) {
                    return ValueType.NUMBER;
                }
                if (name.equals("Infinity")) {
                    return ValueType.NUMBER;
                }
                return ValueType.UNDETERMINED;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 39: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 102: 
            case 103: {
                return ValueType.NUMBER;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 31: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 51: 
            case 52: {
                return ValueType.BOOLEAN;
            }
            case 32: 
            case 40: {
                return ValueType.STRING;
            }
            case 41: {
                return ValueType.NULL;
            }
            case 122: {
                return ValueType.VOID;
            }
            case 30: 
            case 47: 
            case 63: 
            case 64: 
            case 105: {
                return ValueType.OBJECT;
            }
        }
        return ValueType.UNDETERMINED;
    }

    static ValueType and(ValueType a, ValueType b) {
        return a == b ? a : ValueType.UNDETERMINED;
    }

    public static boolean isNumericResult(Node n) {
        return NodeUtil.getKnownValueType(n) == ValueType.NUMBER;
    }

    public static boolean isBooleanResult(Node n) {
        return NodeUtil.getKnownValueType(n) == ValueType.BOOLEAN;
    }

    public static boolean isStringResult(Node n) {
        return NodeUtil.getKnownValueType(n) == ValueType.STRING;
    }

    public static boolean isObjectResult(Node n) {
        return NodeUtil.getKnownValueType(n) == ValueType.OBJECT;
    }

    static boolean mayBeString(Node n) {
        return NodeUtil.mayBeString(n, false);
    }

    static boolean mayBeString(Node n, boolean useType) {
        JSType type;
        if (useType && (type = n.getJSType()) != null) {
            if (type.isStringValueType()) {
                return true;
            }
            if (type.isNumberValueType() || type.isBooleanValueType() || type.isNullType() || type.isVoidType()) {
                return false;
            }
        }
        return NodeUtil.mayBeString(NodeUtil.getKnownValueType(n));
    }

    static boolean mayBeString(ValueType type) {
        switch (type) {
            case BOOLEAN: 
            case NULL: 
            case NUMBER: 
            case VOID: {
                return false;
            }
            case OBJECT: 
            case STRING: 
            case UNDETERMINED: {
                return true;
            }
        }
        throw new IllegalStateException("unexpected");
    }

    static boolean mayBeObect(Node n) {
        return NodeUtil.mayBeObect(NodeUtil.getKnownValueType(n));
    }

    static boolean mayBeObect(ValueType type) {
        switch (type) {
            case BOOLEAN: 
            case NULL: 
            case NUMBER: 
            case VOID: 
            case STRING: {
                return false;
            }
            case OBJECT: 
            case UNDETERMINED: {
                return true;
            }
        }
        throw new IllegalStateException("unexpected");
    }

    static boolean isAssociative(int type) {
        switch (type) {
            case 9: 
            case 10: 
            case 11: 
            case 23: 
            case 100: 
            case 101: {
                return true;
            }
        }
        return false;
    }

    static boolean isCommutative(int type) {
        switch (type) {
            case 9: 
            case 10: 
            case 11: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAssignmentOp(Node n) {
        switch (n.getType()) {
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCompoundAssignementOp(Node n) {
        return NodeUtil.isAssignmentOp(n) && !n.isAssign();
    }

    static int getOpFromAssignmentOp(Node n) {
        switch (n.getType()) {
            case 87: {
                return 9;
            }
            case 88: {
                return 10;
            }
            case 89: {
                return 11;
            }
            case 90: {
                return 18;
            }
            case 91: {
                return 19;
            }
            case 92: {
                return 20;
            }
            case 93: {
                return 21;
            }
            case 94: {
                return 22;
            }
            case 95: {
                return 23;
            }
            case 96: {
                return 24;
            }
            case 97: {
                return 25;
            }
        }
        throw new IllegalArgumentException("Not an assignment op:" + n);
    }

    static boolean containsFunction(Node n) {
        return NodeUtil.containsType(n, 105);
    }

    static Node getEnclosingType(Node n, final int type) {
        return NodeUtil.getEnclosingNode(n, new Predicate<Node>(){

            public boolean apply(Node n) {
                return n.getType() == type;
            }
        });
    }

    static Node getEnclosingClassMemberFunction(Node n) {
        return NodeUtil.getEnclosingType(n, 160);
    }

    static Node getEnclosingClass(Node n) {
        return NodeUtil.getEnclosingType(n, 158);
    }

    public static Node getEnclosingFunction(Node n) {
        return NodeUtil.getEnclosingType(n, 105);
    }

    public static Node getEnclosingScript(Node n) {
        return NodeUtil.getEnclosingType(n, 132);
    }

    public static Node getEnclosingBlock(Node n) {
        return NodeUtil.getEnclosingType(n, 125);
    }

    public static boolean isInFunction(Node n) {
        return NodeUtil.getEnclosingFunction(n) != null;
    }

    public static Node getEnclosingStatement(Node n) {
        return NodeUtil.getEnclosingNode(n, isStatement);
    }

    public static Node getEnclosingNode(Node n, Predicate<Node> pred) {
        Node curr;
        for (curr = n; curr != null && !pred.apply((Object)curr); curr = curr.getParent()) {
        }
        return curr;
    }

    @Nullable
    static Node getFirstPropMatchingKey(Node objlit, String keyName) {
        Preconditions.checkState((boolean)objlit.isObjectLit());
        for (Node keyNode : objlit.children()) {
            if (!keyNode.isStringKey() && !keyNode.isMemberFunctionDef() || !keyNode.getString().equals(keyName)) continue;
            return keyNode.getFirstChild();
        }
        return null;
    }

    @Nullable
    static Node getFirstComputedPropMatchingKey(Node objlit, Node key) {
        Preconditions.checkState((boolean)objlit.isObjectLit());
        for (Node child : objlit.children()) {
            if (!child.isComputedProp() || !child.getFirstChild().isEquivalentTo(key)) continue;
            return child.getLastChild();
        }
        return null;
    }

    static boolean referencesThis(Node n) {
        Node start = n.isFunction() ? n.getLastChild() : n;
        return NodeUtil.containsType(start, 42, MATCH_NOT_THIS_BINDING);
    }

    static boolean referencesSuper(Node n) {
        for (Node curr = n.getFirstChild(); curr != null; curr = curr.getNext()) {
            if (!NodeUtil.containsType(curr, 161, MATCH_NOT_CLASS)) continue;
            return true;
        }
        return false;
    }

    public static boolean isGet(Node n) {
        return n.isGetProp() || n.isGetElem();
    }

    static boolean isVarDeclaration(Node n) {
        return n.isName() && n.getParent().isVar();
    }

    static boolean isBlockScopedDeclaration(Node n) {
        if (n.isName()) {
            switch (n.getParent().getType()) {
                case 120: 
                case 149: 
                case 162: {
                    return true;
                }
                case 158: {
                    return n.getParent().getFirstChild() == n;
                }
                case 105: {
                    return NodeUtil.isBlockScopedFunctionDeclaration(n.getParent());
                }
            }
        }
        return false;
    }

    public static boolean isNameDeclaration(Node n) {
        return n.isVar() || n.isLet() || n.isConst();
    }

    static boolean isDestructuringDeclaration(Node n) {
        if (NodeUtil.isNameDeclaration(n)) {
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                if (!c.isArrayPattern() && !c.isObjectPattern()) continue;
                return true;
            }
        }
        return false;
    }

    public static Node getAssignedValue(Node n) {
        Preconditions.checkState((boolean)n.isName(), (Object)n);
        Node parent = n.getParent();
        if (parent.isVar()) {
            return n.getFirstChild();
        }
        if (parent.isAssign() && parent.getFirstChild() == n) {
            return n.getNext();
        }
        return null;
    }

    static boolean isExprAssign(Node n) {
        return n.isExprResult() && n.getFirstChild().isAssign();
    }

    static boolean isExprCall(Node n) {
        return n.isExprResult() && n.getFirstChild().isCall();
    }

    static boolean isVanillaFunction(Node n) {
        return n.isFunction() && !n.isArrowFunction();
    }

    static boolean isVanillaFor(Node n) {
        return n.isFor() && n.getChildCount() == 4;
    }

    static boolean isEnhancedFor(Node n) {
        return n.isForOf() || NodeUtil.isForIn(n);
    }

    public static boolean isForIn(Node n) {
        return n.isFor() && n.getChildCount() == 3;
    }

    static boolean isLoopStructure(Node n) {
        switch (n.getType()) {
            case 113: 
            case 114: 
            case 115: 
            case 163: {
                return true;
            }
        }
        return false;
    }

    static Node getLoopCodeBlock(Node n) {
        switch (n.getType()) {
            case 113: 
            case 115: 
            case 163: {
                return n.getLastChild();
            }
            case 114: {
                return n.getFirstChild();
            }
        }
        return null;
    }

    static boolean isWithinLoop(Node n) {
        for (Node parent : n.getAncestors()) {
            if (NodeUtil.isLoopStructure(parent)) {
                return true;
            }
            if (!parent.isFunction()) continue;
            break;
        }
        return false;
    }

    public static boolean isControlStructure(Node n) {
        switch (n.getType()) {
            case 77: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 119: 
            case 120: 
            case 126: 
            case 163: {
                return true;
            }
        }
        return false;
    }

    static boolean isControlStructureCodeBlock(Node parent, Node n) {
        switch (parent.getType()) {
            case 114: {
                return parent.getFirstChild() == n;
            }
            case 77: {
                return parent.getFirstChild() == n || parent.getLastChild() == n;
            }
            case 113: 
            case 115: 
            case 119: 
            case 120: 
            case 126: 
            case 163: {
                return parent.getLastChild() == n;
            }
            case 108: 
            case 110: 
            case 111: {
                return parent.getFirstChild() != n;
            }
            case 112: {
                return true;
            }
        }
        Preconditions.checkState((boolean)NodeUtil.isControlStructure(parent));
        return false;
    }

    static Node getConditionExpression(Node n) {
        switch (n.getType()) {
            case 108: 
            case 113: {
                return n.getFirstChild();
            }
            case 114: {
                return n.getLastChild();
            }
            case 115: {
                return NodeUtil.isForIn(n) ? null : n.getSecondChild();
            }
            case 111: 
            case 163: {
                return null;
            }
        }
        throw new IllegalArgumentException(n + " does not have a condition.");
    }

    public static boolean isStatementBlock(Node n) {
        return n.isScript() || n.isBlock();
    }

    static boolean createsBlockScope(Node n) {
        switch (n.getType()) {
            case 125: {
                return !n.isSyntheticBlock() && n.getParent() != null && n.getGrandparent() != null && !n.getParent().isCatch();
            }
            case 110: 
            case 115: 
            case 158: 
            case 163: {
                return true;
            }
        }
        return false;
    }

    static boolean isValidCfgRoot(Node n) {
        switch (n.getType()) {
            case 105: 
            case 132: {
                return true;
            }
            case 125: {
                if (n.getParent() != null && n.getGrandparent() != null) break;
                return true;
            }
        }
        return false;
    }

    public static boolean isStatement(Node n) {
        return NodeUtil.isStatementParent(n.getParent());
    }

    static boolean isStatementParent(Node parent) {
        Preconditions.checkState((parent != null ? 1 : 0) != 0);
        switch (parent.getType()) {
            case 125: 
            case 126: 
            case 132: 
            case 322: {
                return true;
            }
        }
        return false;
    }

    private static boolean isDeclarationParent(Node parent) {
        switch (parent.getType()) {
            case 169: 
            case 318: {
                return true;
            }
        }
        return NodeUtil.isStatementParent(parent);
    }

    static boolean isSwitchCase(Node n) {
        return n.isCase() || n.isDefaultCase();
    }

    static boolean isReferenceName(Node n) {
        return n.isName() && !n.getString().isEmpty();
    }

    static boolean isTryFinallyNode(Node parent, Node child) {
        return parent.isTry() && parent.getChildCount() == 3 && child == parent.getLastChild();
    }

    static boolean isTryCatchNodeContainer(Node n) {
        Node parent = n.getParent();
        return parent.isTry() && parent.getSecondChild() == n;
    }

    public static void removeChild(Node parent, Node node) {
        if (NodeUtil.isTryFinallyNode(parent, node)) {
            if (NodeUtil.hasCatchHandler(NodeUtil.getCatchBlock(parent))) {
                parent.removeChild(node);
            } else {
                node.detachChildren();
            }
        } else if (node.isCatch()) {
            Node tryNode = node.getGrandparent();
            Preconditions.checkState((boolean)NodeUtil.hasFinally(tryNode));
            node.detachFromParent();
        } else if (NodeUtil.isTryCatchNodeContainer(node)) {
            Node tryNode = node.getParent();
            Preconditions.checkState((boolean)NodeUtil.hasFinally(tryNode));
            node.detachChildren();
        } else if (node.isBlock()) {
            node.detachChildren();
        } else if (NodeUtil.isStatementBlock(parent) || NodeUtil.isSwitchCase(node)) {
            parent.removeChild(node);
        } else if (parent.isVar()) {
            if (parent.hasMoreThanOneChild()) {
                parent.removeChild(node);
            } else {
                parent.removeChild(node);
                NodeUtil.removeChild(parent.getParent(), parent);
            }
        } else if (parent.isLabel() && node == parent.getLastChild()) {
            parent.removeChild(node);
            NodeUtil.removeChild(parent.getParent(), parent);
        } else if (parent.isFor() && parent.getChildCount() == 4) {
            parent.replaceChild(node, IR.empty());
        } else {
            throw new IllegalStateException("Invalid attempt to remove node: " + node + " of " + parent);
        }
    }

    static void maybeAddFinally(Node tryNode) {
        Preconditions.checkState((boolean)tryNode.isTry());
        if (!NodeUtil.hasFinally(tryNode)) {
            tryNode.addChildrenToBack(IR.block().srcref(tryNode));
        }
    }

    public static boolean tryMergeBlock(Node block) {
        Preconditions.checkState((boolean)block.isBlock());
        Node parent = block.getParent();
        if (NodeUtil.isStatementBlock(parent)) {
            Node previous = block;
            while (block.hasChildren()) {
                Node child = block.removeFirstChild();
                parent.addChildAfter(child, previous);
                previous = child;
            }
            parent.removeChild(block);
            return true;
        }
        return false;
    }

    public static boolean isCallOrNew(Node node) {
        return node.isCall() || node.isNew();
    }

    static Node getFunctionBody(Node fn) {
        Preconditions.checkArgument((boolean)fn.isFunction());
        return fn.getLastChild();
    }

    public static boolean isFunctionDeclaration(Node n) {
        return n.isFunction() && NodeUtil.isDeclarationParent(n.getParent());
    }

    public static boolean isClassDeclaration(Node n) {
        return n.isClass() && NodeUtil.isDeclarationParent(n.getParent());
    }

    public static boolean isHoistedFunctionDeclaration(Node n) {
        return NodeUtil.isFunctionDeclaration(n) && (n.getParent().isScript() || n.getGrandparent().isFunction());
    }

    static boolean isBlockScopedFunctionDeclaration(Node n) {
        if (!NodeUtil.isFunctionDeclaration(n)) {
            return false;
        }
        for (Node current = n.getParent(); current != null; current = current.getParent()) {
            switch (current.getType()) {
                case 125: {
                    return !current.getParent().isFunction();
                }
                case 105: 
                case 132: 
                case 169: 
                case 318: {
                    return false;
                }
            }
            Preconditions.checkState((boolean)current.isLabel());
        }
        return false;
    }

    static boolean isFunctionBlock(Node n) {
        return n.isBlock() && n.getParent() != null && n.getParent().isFunction();
    }

    static boolean isFunctionExpression(Node n) {
        return n.isFunction() && !NodeUtil.isStatement(n);
    }

    static boolean isClassExpression(Node n) {
        return n.isClass() && !NodeUtil.isStatement(n);
    }

    static boolean isBleedingFunctionName(Node n) {
        return n.isName() && !n.getString().isEmpty() && NodeUtil.isFunctionExpression(n.getParent());
    }

    static boolean isEmptyFunctionExpression(Node node) {
        return NodeUtil.isFunctionExpression(node) && NodeUtil.isEmptyBlock(node.getLastChild());
    }

    static boolean isVarArgsFunction(Node function) {
        Preconditions.checkArgument((boolean)function.isFunction());
        return NodeUtil.isNameReferenced(function.getLastChild(), "arguments", MATCH_NOT_THIS_BINDING);
    }

    static boolean isObjectCallMethod(Node callNode, String methodName) {
        Node last;
        Node functionIndentifyingExpression;
        if (callNode.isCall() && NodeUtil.isGet(functionIndentifyingExpression = callNode.getFirstChild()) && (last = functionIndentifyingExpression.getLastChild()) != null && last.isString()) {
            String propName = last.getString();
            return propName.equals(methodName);
        }
        return false;
    }

    static boolean isFunctionObjectCall(Node callNode) {
        return NodeUtil.isObjectCallMethod(callNode, "call");
    }

    static boolean isFunctionObjectApply(Node callNode) {
        return NodeUtil.isObjectCallMethod(callNode, "apply");
    }

    static boolean isGoogBind(Node n) {
        return n.isGetProp() && n.matchesQualifiedName("goog.bind");
    }

    static boolean isGoogPartial(Node n) {
        return n.isGetProp() && n.matchesQualifiedName("goog.partial");
    }

    static boolean isFunctionBind(Node expr) {
        if (!expr.isGetProp()) {
            return false;
        }
        if (NodeUtil.isGoogBind(expr) || NodeUtil.isGoogPartial(expr)) {
            return true;
        }
        return expr.getFirstChild().isFunction() && expr.getLastChild().getString().equals("bind");
    }

    static boolean isVarOrSimpleAssignLhs(Node n, Node parent) {
        return parent.isAssign() && parent.getFirstChild() == n || parent.isVar();
    }

    public static boolean isLValue(Node n) {
        Preconditions.checkArgument((n.isName() || n.isGetProp() || n.isGetElem() || n.isStringKey() ? 1 : 0) != 0, (Object)n);
        Node parent = n.getParent();
        if (parent == null) {
            return false;
        }
        return NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == n || NodeUtil.isForIn(parent) && parent.getFirstChild() == n || NodeUtil.isNameDeclaration(parent) || parent.isFunction() && parent.getFirstChild() == n || parent.isRest() || parent.isDefaultValue() && parent.getFirstChild() == n || parent.isDec() || parent.isInc() || parent.isParamList() || parent.isCatch() || NodeUtil.isImportedName(n) || NodeUtil.isLhsByDestructuring(n);
    }

    public static boolean isImportedName(Node n) {
        Node parent = n.getParent();
        return parent.isImport() || parent.isImportSpec() && parent.getLastChild() == n;
    }

    public static boolean isLhsByDestructuring(Node n) {
        Node parent = n.getParent();
        if (parent.isDestructuringPattern() || parent.isStringKey() && parent.getParent().isObjectPattern()) {
            if (n.isStringKey() && n.hasChildren()) {
                return false;
            }
            Node childNode = n;
            boolean isLastChildOfHighestPattern = false;
            for (Node currAncestor : n.getAncestors()) {
                if (currAncestor.isForOf() || currAncestor.isFor() || currAncestor.isAssign() || currAncestor.isDefaultValue()) {
                    return currAncestor.getFirstChild() == childNode;
                }
                if (currAncestor.isDestructuringPattern()) {
                    isLastChildOfHighestPattern = currAncestor.getLastChild() == childNode;
                }
                childNode = currAncestor;
            }
            return !isLastChildOfHighestPattern;
        }
        return false;
    }

    static boolean isObjectLitKey(Node node) {
        switch (node.getType()) {
            case 147: 
            case 148: 
            case 154: 
            case 160: {
                return true;
            }
        }
        return false;
    }

    static String getObjectLitKeyName(Node key) {
        switch (key.getType()) {
            case 147: 
            case 148: 
            case 154: 
            case 160: {
                return key.getString();
            }
        }
        throw new IllegalStateException("Unexpected node type: " + key);
    }

    static boolean isGetOrSetKey(Node node) {
        switch (node.getType()) {
            case 147: 
            case 148: {
                return true;
            }
        }
        return false;
    }

    public static String opToStr(int operator) {
        switch (operator) {
            case 9: {
                return "|";
            }
            case 100: {
                return "||";
            }
            case 10: {
                return "^";
            }
            case 101: {
                return "&&";
            }
            case 11: {
                return "&";
            }
            case 45: {
                return "===";
            }
            case 12: {
                return "==";
            }
            case 26: {
                return "!";
            }
            case 13: {
                return "!=";
            }
            case 46: {
                return "!==";
            }
            case 18: {
                return "<<";
            }
            case 51: {
                return "in";
            }
            case 15: {
                return "<=";
            }
            case 14: {
                return "<";
            }
            case 20: {
                return ">>>";
            }
            case 19: {
                return ">>";
            }
            case 17: {
                return ">=";
            }
            case 16: {
                return ">";
            }
            case 23: {
                return "*";
            }
            case 24: {
                return "/";
            }
            case 25: {
                return "%";
            }
            case 27: {
                return "~";
            }
            case 21: 
            case 28: {
                return "+";
            }
            case 22: 
            case 29: {
                return "-";
            }
            case 86: {
                return "=";
            }
            case 87: {
                return "|=";
            }
            case 88: {
                return "^=";
            }
            case 89: {
                return "&=";
            }
            case 90: {
                return "<<=";
            }
            case 91: {
                return ">>=";
            }
            case 92: {
                return ">>>=";
            }
            case 93: {
                return "+=";
            }
            case 94: {
                return "-=";
            }
            case 95: {
                return "*=";
            }
            case 96: {
                return "/=";
            }
            case 97: {
                return "%=";
            }
            case 122: {
                return "void";
            }
            case 32: {
                return "typeof";
            }
            case 52: {
                return "instanceof";
            }
        }
        return null;
    }

    static String opToStrNoFail(int operator) {
        String res = NodeUtil.opToStr(operator);
        if (res == null) {
            throw new Error("Unknown op " + operator + ": " + Token.name(operator));
        }
        return res;
    }

    static boolean containsType(Node node, int type, Predicate<Node> traverseChildrenPred) {
        return NodeUtil.has(node, new MatchNodeType(type), traverseChildrenPred);
    }

    public static boolean containsType(Node node, int type) {
        return NodeUtil.containsType(node, type, (Predicate<Node>)Predicates.alwaysTrue());
    }

    static void redeclareVarsInsideBranch(Node branch) {
        Collection<Node> vars = NodeUtil.getVarsDeclaredInBranch(branch);
        if (vars.isEmpty()) {
            return;
        }
        Node parent = NodeUtil.getAddingRoot(branch);
        for (Node nameNode : vars) {
            Node var = IR.var(IR.name(nameNode.getString()).srcref(nameNode)).srcref(nameNode);
            NodeUtil.copyNameAnnotations(nameNode, var.getFirstChild());
            parent.addChildToFront(var);
        }
    }

    static void copyNameAnnotations(Node source, Node destination) {
        if (source.getBooleanProp(43)) {
            destination.putBooleanProp(43, true);
        }
    }

    private static Node getAddingRoot(Node n) {
        Node addingRoot = null;
        Node ancestor = n;
        while (null != (ancestor = ancestor.getParent())) {
            int type = ancestor.getType();
            if (type == 132) {
                addingRoot = ancestor;
                break;
            }
            if (type != 105) continue;
            addingRoot = ancestor.getLastChild();
            break;
        }
        Preconditions.checkState((addingRoot.isBlock() || addingRoot.isScript() ? 1 : 0) != 0);
        Preconditions.checkState((addingRoot.getFirstChild() == null || !addingRoot.getFirstChild().isScript() ? 1 : 0) != 0);
        return addingRoot;
    }

    public static Node newQName(AbstractCompiler compiler, String name) {
        int endPos = name.indexOf(46);
        if (endPos == -1) {
            return NodeUtil.newName(compiler, name);
        }
        String nodeName = name.substring(0, endPos);
        Node node = "this".equals(nodeName) ? IR.thisNode() : NodeUtil.newName(compiler, nodeName);
        do {
            int startPos;
            String part = (endPos = name.indexOf(46, startPos = endPos + 1)) == -1 ? name.substring(startPos) : name.substring(startPos, endPos);
            Node propNode = IR.string(part);
            if (compiler.getCodingConvention().isConstantKey(part)) {
                propNode.putBooleanProp(43, true);
            }
            node = IR.getprop(node, propNode);
        } while (endPos != -1);
        return node;
    }

    public static Node newPropertyAccess(AbstractCompiler compiler, Node context, String name) {
        Node propNode = IR.getprop(context, IR.string(name));
        if (compiler.getCodingConvention().isConstantKey(name)) {
            propNode.putBooleanProp(43, true);
        }
        return propNode;
    }

    public static Node newQNameDeclaration(AbstractCompiler compiler, String name, Node value, JSDocInfo info) {
        Node result;
        Node nameNode = NodeUtil.newQName(compiler, name);
        if (nameNode.isName()) {
            result = value == null ? IR.var(nameNode) : IR.var(nameNode, value);
            result.setJSDocInfo(info);
        } else if (value != null) {
            result = IR.exprResult(IR.assign(nameNode, value));
            result.getFirstChild().setJSDocInfo(info);
        } else {
            result = IR.exprResult(nameNode);
            result.getFirstChild().setJSDocInfo(info);
        }
        return result;
    }

    static Node newQName(AbstractCompiler compiler, String name, Node basisNode, String originalName) {
        Node node = NodeUtil.newQName(compiler, name);
        NodeUtil.setDebugInformation(node, basisNode, originalName);
        return node;
    }

    static Node getRootOfQualifiedName(Node qName) {
        Node current = qName;
        while (!(current.isName() || current.isThis() || current.isSuper())) {
            Preconditions.checkState((boolean)current.isGetProp());
            current = current.getFirstChild();
        }
        return current;
    }

    static void setDebugInformation(Node node, Node basisNode, String originalName) {
        node.copyInformationFromForTree(basisNode);
        node.setOriginalName(originalName);
    }

    private static Node newName(AbstractCompiler compiler, String name) {
        Node nameNode = IR.name(name);
        if (compiler.getCodingConvention().isConstant(name)) {
            nameNode.putBooleanProp(43, true);
        }
        return nameNode;
    }

    static Node newName(AbstractCompiler compiler, String name, Node srcref) {
        return NodeUtil.newName(compiler, name).srcref(srcref);
    }

    static Node newName(AbstractCompiler compiler, String name, Node basisNode, String originalName) {
        Node nameNode = NodeUtil.newName(compiler, name, basisNode);
        nameNode.setOriginalName(originalName);
        return nameNode;
    }

    static boolean isLatin(String s) {
        int len = s.length();
        for (int index = 0; index < len; ++index) {
            char c = s.charAt(index);
            if (c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    static boolean isValidSimpleName(String name) {
        return TokenStream.isJSIdentifier(name) && !TokenStream.isKeyword(name) && NodeUtil.isLatin(name);
    }

    @Deprecated
    public static boolean isValidQualifiedName(String name) {
        return NodeUtil.isValidQualifiedName(CompilerOptions.LanguageMode.ECMASCRIPT3, name);
    }

    public static boolean isValidQualifiedName(CompilerOptions.LanguageMode mode, String name) {
        if (name.endsWith(".") || name.startsWith(".")) {
            return false;
        }
        List parts = Splitter.on((char)'.').splitToList((CharSequence)name);
        for (String part : parts) {
            if (NodeUtil.isValidPropertyName(mode, part)) continue;
            return false;
        }
        return NodeUtil.isValidSimpleName((String)parts.get(0));
    }

    static boolean isValidPropertyName(CompilerOptions.LanguageMode mode, String name) {
        if (NodeUtil.isValidSimpleName(name)) {
            return true;
        }
        return mode.isEs5OrHigher() && TokenStream.isKeyword(name);
    }

    static Collection<Node> getVarsDeclaredInBranch(Node root) {
        VarCollector collector = new VarCollector();
        NodeUtil.visitPreOrder(root, collector, MATCH_NOT_FUNCTION);
        return collector.vars.values();
    }

    static boolean isObjectDefinePropertiesDefinition(Node n) {
        return n.isCall() && n.getChildCount() == 3 && n.getFirstChild().matchesQualifiedName("Object.defineProperties");
    }

    static Iterable<Node> getObjectDefinedPropertiesKeys(Node definePropertiesCall) {
        Preconditions.checkArgument((boolean)NodeUtil.isObjectDefinePropertiesDefinition(definePropertiesCall));
        ArrayList<Node> properties = new ArrayList<Node>();
        Node objectLiteral = definePropertiesCall.getLastChild();
        for (Node key : objectLiteral.children()) {
            if (!key.isStringKey()) continue;
            properties.add(key);
        }
        return properties;
    }

    public static boolean isPrototypePropertyDeclaration(Node n) {
        return NodeUtil.isExprAssign(n) && NodeUtil.isPrototypeProperty(n.getFirstFirstChild());
    }

    static boolean isPrototypeProperty(Node n) {
        if (!n.isGetProp()) {
            return false;
        }
        n = n.getFirstChild();
        while (n.isGetProp()) {
            if (n.getLastChild().getString().equals("prototype")) {
                return n.isQualifiedName();
            }
            n = n.getFirstChild();
        }
        return false;
    }

    static boolean isPrototypeMethod(Node n) {
        if (!n.isFunction()) {
            return false;
        }
        Node assignNode = n.getParent();
        if (!assignNode.isAssign()) {
            return false;
        }
        return NodeUtil.isPrototypePropertyDeclaration(assignNode.getParent());
    }

    static boolean isPrototypeAssignment(Node getProp) {
        if (!getProp.isGetProp()) {
            return false;
        }
        Node parent = getProp.getParent();
        return parent.isAssign() && parent.getFirstChild() == getProp && parent.getFirstChild().getLastChild().getString().equals("prototype") && parent.getLastChild().isObjectLit();
    }

    static boolean isPropertyTest(AbstractCompiler compiler, Node propAccess) {
        Node parent = propAccess.getParent();
        switch (parent.getType()) {
            case 37: {
                return parent.getFirstChild() != propAccess && compiler.getCodingConvention().isPropertyTestFunction(parent);
            }
            case 108: 
            case 113: 
            case 114: 
            case 115: {
                return NodeUtil.getConditionExpression(parent) == propAccess;
            }
            case 32: 
            case 52: 
            case 100: 
            case 101: {
                return true;
            }
            case 13: 
            case 46: {
                Node other = parent.getFirstChild() == propAccess ? parent.getSecondChild() : parent.getFirstChild();
                return NodeUtil.isUndefined(other);
            }
            case 98: {
                return parent.getFirstChild() == propAccess;
            }
            case 26: {
                return parent.getParent().isOr() && parent.getParent().getFirstChild() == parent;
            }
            case 155: {
                return NodeUtil.isPropertyTest(compiler, parent);
            }
        }
        return false;
    }

    static Node getPrototypeClassName(Node qName) {
        Node cur = qName;
        while (cur.isGetProp()) {
            if (cur.getLastChild().getString().equals("prototype")) {
                return cur.getFirstChild();
            }
            cur = cur.getFirstChild();
        }
        return null;
    }

    static String getPrototypePropertyName(Node qName) {
        String qNameStr = qName.getQualifiedName();
        int prototypeIdx = qNameStr.lastIndexOf(".prototype.");
        int memberIndex = prototypeIdx + ".prototype".length() + 1;
        return qNameStr.substring(memberIndex);
    }

    static Node newUndefinedNode(Node srcReferenceNode) {
        Node node = IR.voidNode(IR.number(0.0));
        if (srcReferenceNode != null) {
            node.copyInformationFromForTree(srcReferenceNode);
        }
        return node;
    }

    static Node newVarNode(String name, Node value) {
        Node nodeName = IR.name(name);
        if (value != null) {
            Preconditions.checkState((value.getNext() == null ? 1 : 0) != 0);
            nodeName.addChildToBack(value);
            nodeName.srcref(value);
        }
        Node var = IR.var(nodeName).srcref(nodeName);
        return var;
    }

    static int getNodeTypeReferenceCount(Node node, int type, Predicate<Node> traverseChildrenPred) {
        return NodeUtil.getCount(node, new MatchNodeType(type), traverseChildrenPred);
    }

    static boolean isNameReferenced(Node node, String name, Predicate<Node> traverseChildrenPred) {
        return NodeUtil.has(node, new MatchNameNode(name), traverseChildrenPred);
    }

    static boolean isNameReferenced(Node node, String name) {
        return NodeUtil.isNameReferenced(node, name, (Predicate<Node>)Predicates.alwaysTrue());
    }

    static int getNameReferenceCount(Node node, String name) {
        return NodeUtil.getCount(node, new MatchNameNode(name), (Predicate<Node>)Predicates.alwaysTrue());
    }

    public static boolean has(Node node, Predicate<Node> pred, Predicate<Node> traverseChildrenPred) {
        if (pred.apply((Object)node)) {
            return true;
        }
        if (!traverseChildrenPred.apply((Object)node)) {
            return false;
        }
        for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
            if (!NodeUtil.has(c, pred, traverseChildrenPred)) continue;
            return true;
        }
        return false;
    }

    public static int getCount(Node n, Predicate<Node> pred, Predicate<Node> traverseChildrenPred) {
        int total = 0;
        if (pred.apply((Object)n)) {
            ++total;
        }
        if (traverseChildrenPred.apply((Object)n)) {
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                total += NodeUtil.getCount(c, pred, traverseChildrenPred);
            }
        }
        return total;
    }

    public static void visitPreOrder(Node node, Visitor visitor, Predicate<Node> traverseChildrenPred) {
        visitor.visit(node);
        if (traverseChildrenPred.apply((Object)node)) {
            for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
                NodeUtil.visitPreOrder(c, visitor, traverseChildrenPred);
            }
        }
    }

    public static void visitPostOrder(Node node, Visitor visitor, Predicate<Node> traverseChildrenPred) {
        if (traverseChildrenPred.apply((Object)node)) {
            for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
                NodeUtil.visitPostOrder(c, visitor, traverseChildrenPred);
            }
        }
        visitor.visit(node);
    }

    static boolean hasFinally(Node n) {
        Preconditions.checkArgument((boolean)n.isTry());
        return n.getChildCount() == 3;
    }

    static Node getCatchBlock(Node n) {
        Preconditions.checkArgument((boolean)n.isTry());
        return n.getSecondChild();
    }

    static boolean hasCatchHandler(Node n) {
        Preconditions.checkArgument((boolean)n.isBlock());
        return n.hasChildren() && n.getFirstChild().isCatch();
    }

    public static Node getFunctionParameters(Node fnNode) {
        Preconditions.checkArgument((boolean)fnNode.isFunction());
        return fnNode.getSecondChild();
    }

    static boolean isConstantVar(Node node, Scope scope) {
        if (NodeUtil.isConstantName(node)) {
            return true;
        }
        if (!node.isName() || scope == null) {
            return false;
        }
        Var var = scope.getVar(node.getString());
        return var != null && (var.isInferredConst() || var.isConst());
    }

    static boolean isConstantName(Node node) {
        return node.getBooleanProp(43);
    }

    static boolean isConstantByConvention(CodingConvention convention, Node node) {
        Node parent = node.getParent();
        if (parent.isGetProp() && node == parent.getLastChild()) {
            return convention.isConstantKey(node.getString());
        }
        if (NodeUtil.isObjectLitKey(node)) {
            return convention.isConstantKey(node.getString());
        }
        if (node.isName()) {
            return convention.isConstant(node.getString());
        }
        return false;
    }

    static boolean isConstantDeclaration(CodingConvention convention, JSDocInfo info, Node node) {
        if (info != null && info.isConstant()) {
            return true;
        }
        if (node.getBooleanProp(64)) {
            return true;
        }
        switch (node.getType()) {
            case 38: {
                return NodeUtil.isConstantByConvention(convention, node);
            }
            case 33: {
                return node.isQualifiedName() && NodeUtil.isConstantByConvention(convention, node.getLastChild());
            }
        }
        return false;
    }

    static boolean functionHasInlineJsdocs(Node fn) {
        if (!fn.isFunction()) {
            return false;
        }
        if (fn.getFirstChild().getJSDocInfo() != null) {
            return true;
        }
        for (Node param = fn.getSecondChild().getFirstChild(); param != null; param = param.getNext()) {
            if (param.getJSDocInfo() == null) continue;
            return true;
        }
        return false;
    }

    public static String getSourceName(Node n) {
        String sourceName = null;
        while (sourceName == null && n != null) {
            sourceName = n.getSourceFileName();
            n = n.getParent();
        }
        return sourceName;
    }

    public static StaticSourceFile getSourceFile(Node n) {
        StaticSourceFile sourceName = null;
        while (sourceName == null && n != null) {
            sourceName = n.getStaticSourceFile();
            n = n.getParent();
        }
        return sourceName;
    }

    public static InputId getInputId(Node n) {
        while (n != null && !n.isScript()) {
            n = n.getParent();
        }
        return n != null && n.isScript() ? n.getInputId() : null;
    }

    static Node newCallNode(Node callTarget, Node ... parameters) {
        boolean isFreeCall = !NodeUtil.isGet(callTarget);
        Node call = IR.call(callTarget, new Node[0]);
        call.putBooleanProp(50, isFreeCall);
        for (Node parameter : parameters) {
            call.addChildToBack(parameter);
        }
        return call;
    }

    static boolean evaluatesToLocalValue(Node value) {
        return NodeUtil.evaluatesToLocalValue(value, (Predicate<Node>)Predicates.alwaysFalse());
    }

    static boolean evaluatesToLocalValue(Node value, Predicate<Node> locals) {
        switch (value.getType()) {
            case 155: {
                return NodeUtil.evaluatesToLocalValue(value.getFirstChild(), locals);
            }
            case 86: {
                return NodeUtil.isImmutableValue(value.getLastChild()) || locals.apply((Object)value) && NodeUtil.evaluatesToLocalValue(value.getLastChild(), locals);
            }
            case 85: {
                return NodeUtil.evaluatesToLocalValue(value.getLastChild(), locals);
            }
            case 100: 
            case 101: {
                return NodeUtil.evaluatesToLocalValue(value.getFirstChild(), locals) && NodeUtil.evaluatesToLocalValue(value.getLastChild(), locals);
            }
            case 98: {
                return NodeUtil.evaluatesToLocalValue(value.getSecondChild(), locals) && NodeUtil.evaluatesToLocalValue(value.getLastChild(), locals);
            }
            case 102: 
            case 103: {
                return true;
            }
            case 42: {
                return locals.apply((Object)value);
            }
            case 38: {
                return NodeUtil.isImmutableValue(value) || locals.apply((Object)value);
            }
            case 33: 
            case 35: {
                return locals.apply((Object)value);
            }
            case 37: {
                return NodeUtil.callHasLocalResult(value) || NodeUtil.isToStringMethodCall(value) || locals.apply((Object)value);
            }
            case 30: {
                return NodeUtil.newHasLocalResult(value) || locals.apply((Object)value);
            }
            case 47: 
            case 63: 
            case 64: 
            case 105: {
                return true;
            }
            case 31: 
            case 51: {
                return true;
            }
        }
        if (NodeUtil.isAssignmentOp(value) || NodeUtil.isSimpleOperator(value) || NodeUtil.isImmutableValue(value)) {
            return true;
        }
        throw new IllegalStateException("Unexpected expression node" + value + "\n parent:" + value.getParent());
    }

    private static Node getNthSibling(Node first, int index) {
        Node sibling;
        for (sibling = first; index != 0 && sibling != null; sibling = sibling.getNext(), --index) {
        }
        return sibling;
    }

    static Node getArgumentForFunction(Node function, int index) {
        Preconditions.checkState((boolean)function.isFunction());
        return NodeUtil.getNthSibling(function.getSecondChild().getFirstChild(), index);
    }

    static Node getArgumentForCallOrNew(Node call, int index) {
        Preconditions.checkState((boolean)NodeUtil.isCallOrNew(call));
        return NodeUtil.getNthSibling(call.getSecondChild(), index);
    }

    static boolean isCallOrNewTarget(Node n) {
        Node parent = n.getParent();
        return parent != null && NodeUtil.isCallOrNew(parent) && parent.getFirstChild() == n;
    }

    static boolean isCallOrNewArgument(Node n) {
        Node parent = n.getParent();
        return parent != null && NodeUtil.isCallOrNew(parent) && parent.getFirstChild() != n;
    }

    private static boolean isToStringMethodCall(Node call) {
        Node getNode = call.getFirstChild();
        if (NodeUtil.isGet(getNode)) {
            Node propNode = getNode.getLastChild();
            return propNode.isString() && "toString".equals(propNode.getString());
        }
        return false;
    }

    @Nullable
    public static JSDocInfo getBestJSDocInfo(Node n) {
        if (n.isExprResult()) {
            return NodeUtil.getBestJSDocInfo(n.getFirstChild());
        }
        JSDocInfo info = n.getJSDocInfo();
        if (info == null) {
            Node parent = n.getParent();
            if (parent == null || n.isExprResult()) {
                return null;
            }
            if (parent.isName()) {
                return NodeUtil.getBestJSDocInfo(parent);
            }
            if (parent.isAssign()) {
                return NodeUtil.getBestJSDocInfo(parent);
            }
            if (NodeUtil.isObjectLitKey(parent)) {
                return parent.getJSDocInfo();
            }
            if ((parent.isFunction() || parent.isClass()) && n == parent.getFirstChild()) {
                return NodeUtil.getBestJSDocInfo(parent);
            }
            if (NodeUtil.isNameDeclaration(parent) && parent.hasOneChild()) {
                return parent.getJSDocInfo();
            }
            if (parent.isHook() && parent.getFirstChild() != n || parent.isOr() || parent.isAnd() || parent.isComma() && parent.getFirstChild() != n) {
                return NodeUtil.getBestJSDocInfo(parent);
            }
        }
        return info;
    }

    static Node getBestLValue(Node n) {
        Node parent = n.getParent();
        boolean isFunctionDeclaration = NodeUtil.isFunctionDeclaration(n);
        if (isFunctionDeclaration) {
            return n.getFirstChild();
        }
        if (parent.isName()) {
            return parent;
        }
        if (parent.isAssign()) {
            return parent.getFirstChild();
        }
        if (NodeUtil.isObjectLitKey(parent)) {
            return parent;
        }
        if (parent.isHook() && parent.getFirstChild() != n || parent.isOr() || parent.isAnd() || parent.isComma() && parent.getFirstChild() != n) {
            return NodeUtil.getBestLValue(parent);
        }
        if (parent.isCast()) {
            return NodeUtil.getBestLValue(parent);
        }
        return null;
    }

    static Node getRValueOfLValue(Node n) {
        Node parent = n.getParent();
        switch (parent.getType()) {
            case 86: {
                return n.getNext();
            }
            case 64: 
            case 118: 
            case 149: 
            case 162: {
                return n.getFirstChild();
            }
            case 105: 
            case 158: {
                return parent;
            }
        }
        return null;
    }

    static Node getBestLValueOwner(@Nullable Node lValue) {
        if (lValue == null || lValue.getParent() == null) {
            return null;
        }
        if (NodeUtil.isObjectLitKey(lValue)) {
            return NodeUtil.getBestLValue(lValue.getParent());
        }
        if (NodeUtil.isGet(lValue)) {
            return lValue.getFirstChild();
        }
        return null;
    }

    static String getBestLValueName(@Nullable Node lValue) {
        if (lValue == null || lValue.getParent() == null) {
            return null;
        }
        if (NodeUtil.isObjectLitKey(lValue)) {
            String ownerName;
            Node owner = NodeUtil.getBestLValue(lValue.getParent());
            if (owner != null && (ownerName = NodeUtil.getBestLValueName(owner)) != null) {
                return ownerName + "." + NodeUtil.getObjectLitKeyName(lValue);
            }
            return null;
        }
        return lValue.getQualifiedName();
    }

    static boolean isExpressionResultUsed(Node expr) {
        Node parent = expr.getParent();
        switch (parent.getType()) {
            case 125: 
            case 130: {
                return false;
            }
            case 155: {
                return NodeUtil.isExpressionResultUsed(parent);
            }
            case 98: 
            case 100: 
            case 101: {
                return expr == parent.getFirstChild() || NodeUtil.isExpressionResultUsed(parent);
            }
            case 85: {
                Node grandparent = parent.getParent();
                if (grandparent.isCall() && parent == grandparent.getFirstChild() && expr == parent.getFirstChild() && parent.getChildCount() == 2 && expr.getNext().isName() && "eval".equals(expr.getNext().getString())) {
                    return true;
                }
                return expr == parent.getFirstChild() ? false : NodeUtil.isExpressionResultUsed(parent);
            }
            case 115: {
                if (NodeUtil.isForIn(parent)) break;
                return parent.getSecondChild() == expr;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    static boolean isExecutedExactlyOnce(Node n) {
        do {
            Node parent = n.getParent();
            switch (parent.getType()) {
                case 98: 
                case 100: 
                case 101: 
                case 108: {
                    if (parent.getFirstChild() == n) break;
                    return false;
                }
                case 115: {
                    if (!(NodeUtil.isForIn(parent) ? parent.getSecondChild() != n : parent.getFirstChild() != n)) break;
                    return false;
                }
                case 113: 
                case 114: {
                    return false;
                }
                case 77: {
                    if (!NodeUtil.hasFinally(parent)) return false;
                    if (parent.getLastChild() == n) break;
                    return false;
                }
                case 111: 
                case 112: {
                    return false;
                }
                case 105: 
                case 132: {
                    return true;
                }
            }
        } while ((n = n.getParent()) != null);
        return true;
    }

    static Node booleanNode(boolean value) {
        return value ? IR.trueNode() : IR.falseNode();
    }

    static Node numberNode(double value, Node srcref) {
        Node result = Double.isNaN(value) ? IR.name("NaN") : (value == Double.POSITIVE_INFINITY ? IR.name("Infinity") : (value == Double.NEGATIVE_INFINITY ? IR.neg(IR.name("Infinity")) : IR.number(value)));
        if (srcref != null) {
            result.srcrefTree(srcref);
        }
        return result;
    }

    static boolean isNaN(Node n) {
        return n.isName() && n.getString().equals("NaN") || n.getType() == 24 && n.getFirstChild().isNumber() && n.getFirstChild().getDouble() == 0.0 && n.getLastChild().isNumber() && n.getLastChild().getDouble() == 0.0;
    }

    public static Map<Node, Node> mapMainToClone(Node main, Node clone) {
        Preconditions.checkState((boolean)main.isEquivalentTo(clone));
        HashMap<Node, Node> mtoc = new HashMap<Node, Node>();
        mtoc.put(main, clone);
        NodeUtil.mtocHelper(mtoc, main, clone);
        return mtoc;
    }

    private static void mtocHelper(Map<Node, Node> map, Node main, Node clone) {
        if (main.isFunction()) {
            map.put(main, clone);
        }
        Node mchild = main.getFirstChild();
        Node cchild = clone.getFirstChild();
        while (mchild != null) {
            NodeUtil.mtocHelper(map, mchild, cchild);
            mchild = mchild.getNext();
            cchild = cchild.getNext();
        }
    }

    public static void verifyScopeChanges(Map<Node, Node> map, Node main, boolean verifyUnchangedNodes) {
        final Map<Node, Node> mtoc = map;
        final boolean checkUnchanged = verifyUnchangedNodes;
        Node clone = mtoc.get(main);
        if (main.getChangeTime() > clone.getChangeTime()) {
            Preconditions.checkState((!NodeUtil.isEquivalentToExcludingFunctions(main, clone) ? 1 : 0) != 0);
        } else if (checkUnchanged) {
            Preconditions.checkState((boolean)NodeUtil.isEquivalentToExcludingFunctions(main, clone));
        }
        NodeUtil.visitPreOrder(main, new Visitor(){

            @Override
            public void visit(Node n) {
                if (n.isFunction() && mtoc.containsKey(n)) {
                    Node clone = (Node)mtoc.get(n);
                    if (n.getChangeTime() > clone.getChangeTime()) {
                        Preconditions.checkState((!NodeUtil.isEquivalentToExcludingFunctions(n, clone) ? 1 : 0) != 0);
                    } else if (checkUnchanged) {
                        Preconditions.checkState((boolean)NodeUtil.isEquivalentToExcludingFunctions(n, clone));
                    }
                }
            }
        }, (Predicate<Node>)Predicates.alwaysTrue());
    }

    static int countAstSizeUpToLimit(Node n, final int limit) {
        final int[] wrappedSize = new int[]{0};
        NodeUtil.visitPreOrder(n, new Visitor(){

            @Override
            public void visit(Node n) {
                wrappedSize[0] = wrappedSize[0] + 1;
            }
        }, new Predicate<Node>(){

            public boolean apply(Node n) {
                return wrappedSize[0] < limit;
            }
        });
        return wrappedSize[0];
    }

    private static boolean isEquivalentToExcludingFunctions(Node thisNode, Node thatNode) {
        if (thisNode == null || thatNode == null) {
            return thisNode == null && thatNode == null;
        }
        if (!thisNode.isEquivalentToShallow(thatNode)) {
            return false;
        }
        if (thisNode.getChildCount() != thatNode.getChildCount()) {
            return false;
        }
        Node thisChild = thisNode.getFirstChild();
        for (Node thatChild = thatNode.getFirstChild(); thisChild != null && thatChild != null; thisChild = thisChild.getNext(), thatChild = thatChild.getNext()) {
            if (thisChild.isFunction()) {
                return thatChild.isFunction();
            }
            if (NodeUtil.isEquivalentToExcludingFunctions(thisChild, thatChild)) continue;
            return false;
        }
        return true;
    }

    static JSDocInfo createConstantJsDoc() {
        JSDocInfoBuilder builder = new JSDocInfoBuilder(false);
        builder.recordConstancy();
        return builder.build();
    }

    static int toInt32(double d) {
        int id = (int)d;
        if ((double)id == d) {
            return id;
        }
        if (Double.isNaN(d) || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return 0;
        }
        d = d >= 0.0 ? Math.floor(d) : Math.ceil(d);
        double two32 = 4.294967296E9;
        long l = (long)(d %= two32);
        return (int)l;
    }

    private static boolean isGoogModuleCall(Node n) {
        if (NodeUtil.isExprCall(n)) {
            Node target = n.getFirstFirstChild();
            return target.matchesQualifiedName("goog.module");
        }
        return false;
    }

    static boolean isModuleFile(Node n) {
        return n.isScript() && n.hasChildren() && NodeUtil.isGoogModuleCall(n.getFirstChild());
    }

    public static interface Visitor {
        public void visit(Node var1);
    }

    static class MatchShallowStatement
    implements Predicate<Node> {
        MatchShallowStatement() {
        }

        public boolean apply(Node n) {
            Node parent = n.getParent();
            return n.isBlock() || !n.isFunction() && (parent == null || NodeUtil.isControlStructure(parent) || NodeUtil.isStatementBlock(parent));
        }
    }

    private static class MatchNotClass
    implements Predicate<Node> {
        private MatchNotClass() {
        }

        public boolean apply(Node n) {
            return !n.isClass();
        }
    }

    private static class MatchNotFunction
    implements Predicate<Node> {
        private MatchNotFunction() {
        }

        public boolean apply(Node n) {
            return !n.isFunction();
        }
    }

    static class MatchDeclaration
    implements Predicate<Node> {
        MatchDeclaration() {
        }

        public boolean apply(Node n) {
            return NodeUtil.isFunctionDeclaration(n) || n.isVar();
        }
    }

    static class MatchNodeType
    implements Predicate<Node> {
        final int type;

        MatchNodeType(int type) {
            this.type = type;
        }

        public boolean apply(Node n) {
            return n.getType() == this.type;
        }
    }

    private static class MatchNameNode
    implements Predicate<Node> {
        final String name;

        MatchNameNode(String name) {
            this.name = name;
        }

        public boolean apply(Node n) {
            return n.isName() && n.getString().equals(this.name);
        }
    }

    private static class VarCollector
    implements Visitor {
        final Map<String, Node> vars = new LinkedHashMap<String, Node>();

        private VarCollector() {
        }

        @Override
        public void visit(Node n) {
            String name;
            Node parent;
            if (n.isName() && (parent = n.getParent()) != null && parent.isVar() && !this.vars.containsKey(name = n.getString())) {
                this.vars.put(name, n);
            }
        }
    }

    static enum ValueType {
        UNDETERMINED,
        NULL,
        VOID,
        NUMBER,
        STRING,
        BOOLEAN,
        OBJECT;

    }
}

