/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalTypeInfo;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NTIScope;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.TypeEnv;
import com.google.javascript.jscomp.newtypes.UniqueNameGenerator;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TypeI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class NewTypeInference
implements CompilerPass {
    static final DiagnosticType MISTYPED_ASSIGN_RHS = DiagnosticType.warning("JSC_NTI_MISTYPED_ASSIGN_RHS", "The right side in the assignment is not a subtype of the left side.\nleft side  : {0}\nright side : {1}\n");
    static final DiagnosticType INVALID_OPERAND_TYPE = DiagnosticType.warning("JSC_NTI_INVALID_OPERAND_TYPE", "Invalid type(s) for operator {0}.\nexpected : {1}\nfound    : {2}\n");
    static final DiagnosticType RETURN_NONDECLARED_TYPE = DiagnosticType.warning("JSC_NTI_RETURN_NONDECLARED_TYPE", "Returned type does not match declared return type.\ndeclared : {0}\nfound    : {1}\n");
    static final DiagnosticType INVALID_INFERRED_RETURN_TYPE = DiagnosticType.warning("JSC_NTI_INVALID_INFERRED_RETURN_TYPE", "Function called in context that expects incompatible type.\nexpected : {0}\nfound    : {1}\n");
    static final DiagnosticType INVALID_ARGUMENT_TYPE = DiagnosticType.warning("JSC_NTI_INVALID_ARGUMENT_TYPE", "Invalid type for parameter {0} of function {1}.\nexpected : {2}\nfound    : {3}\n");
    static final DiagnosticType CROSS_SCOPE_GOTCHA = DiagnosticType.warning("JSC_NTI_CROSS_SCOPE_GOTCHA", "Variable {0} typed inconsistently across scopes.\nIn outer scope : {1}\nIn inner scope : {2}\n");
    static final DiagnosticType POSSIBLY_INEXISTENT_PROPERTY = DiagnosticType.warning("JSC_NTI_POSSIBLY_INEXISTENT_PROPERTY", "Property {0} may not be present on {1}.");
    static final DiagnosticType NULLABLE_DEREFERENCE = DiagnosticType.disabled("JSC_NTI_NULLABLE_DEREFERENCE", "Attempt to use nullable type {0}.");
    static final DiagnosticType PROPERTY_ACCESS_ON_NONOBJECT = DiagnosticType.warning("JSC_NTI_PROPERTY_ACCESS_ON_NONOBJECT", "Cannot access property {0} of non-object type {1}.");
    static final DiagnosticType NOT_UNIQUE_INSTANTIATION = DiagnosticType.warning("JSC_NTI_NOT_UNIQUE_INSTANTIATION", "Illegal instantiation in function type {0} for the type variable {1}.\n You can only specify one type. Found {2}.");
    static final DiagnosticType FAILED_TO_UNIFY = DiagnosticType.warning("JSC_NTI_FAILED_TO_UNIFY", "Could not instantiate type {0} with {1}.");
    static final DiagnosticType INVALID_INDEX_TYPE = DiagnosticType.warning("JSC_NTI_INVALID_INDEX_TYPE", "Invalid type for index.\nexpected : {0}\nfound    : {1}\n");
    static final DiagnosticType BOTTOM_INDEX_TYPE = DiagnosticType.warning("JSC_NTI_BOTTOM_INDEX_TYPE", "This IObject {0} cannot be accessed with a valid type.\n Usually the result of a bad union type.\n");
    static final DiagnosticType INVALID_OBJLIT_PROPERTY_TYPE = DiagnosticType.warning("JSC_NTI_INVALID_OBJLIT_PROPERTY_TYPE", "Object-literal property declared as {0} but has type {1}.");
    static final DiagnosticType FORIN_EXPECTS_OBJECT = DiagnosticType.warning("JSC_NTI_FORIN_EXPECTS_OBJECT", "For/in expects an object, found type {0}.");
    static final DiagnosticType FORIN_EXPECTS_STRING_KEY = DiagnosticType.warning("JSC_NTI_FORIN_EXPECTS_STRING_KEY", "For/in creates string keys, but variable has declared type {1}.");
    static final DiagnosticType CONST_REASSIGNED = DiagnosticType.warning("JSC_NTI_CONST_REASSIGNED", "Cannot change the value of a constant.");
    static final DiagnosticType CONST_PROPERTY_REASSIGNED = DiagnosticType.warning("JSC_NTI_CONST_PROPERTY_REASSIGNED", "Cannot change the value of a constant property.");
    static final DiagnosticType NOT_A_CONSTRUCTOR = DiagnosticType.warning("JSC_NTI_NOT_A_CONSTRUCTOR", "Expected a constructor but found type {0}.");
    static final DiagnosticType ASSERT_FALSE = DiagnosticType.warning("JSC_NTI_ASSERT_FALSE", "Assertion is always false. Please use a throw or fail() instead.");
    static final DiagnosticType UNKNOWN_ASSERTION_TYPE = DiagnosticType.warning("JSC_NTI_UNKNOWN_ASSERTION_TYPE", "Assert with unknown asserted type.");
    static final DiagnosticType INVALID_THIS_TYPE_IN_BIND = DiagnosticType.warning("JSC_NTI_INVALID_THIS_TYPE_IN_BIND", "The first argument to bind has type {0} which is not a subtype of {1}.");
    static final DiagnosticType CANNOT_BIND_CTOR = DiagnosticType.warning("JSC_NTI_CANNOT_BIND_CTOR", "We do not support using .bind on constructor functions.");
    static final DiagnosticType GOOG_BIND_EXPECTS_FUNCTION = DiagnosticType.warning("JSC_NTI_GOOG_BIND_EXPECTS_FUNCTION", "The first argument to goog.bind/goog.partial must be a function, found: {0}");
    static final DiagnosticType BOTTOM_PROP = DiagnosticType.warning("JSC_NTI_BOTTOM_PROP", "Property {0} of {1} cannot have a valid type.Maybe the result of a union of incompatible types?");
    static final DiagnosticType INVALID_CAST = DiagnosticType.warning("JSC_NTI_INVALID_CAST", "invalid cast - the types do not have a common subtype\nfrom: {0}\nto  : {1}");
    static final DiagnosticType GLOBAL_THIS = DiagnosticType.warning("JSC_NTI_USED_GLOBAL_THIS", "Dangerous use of the global THIS object");
    static final DiagnosticType MISSING_RETURN_STATEMENT = DiagnosticType.warning("JSC_NTI_MISSING_RETURN_STATEMENT", "Missing return statement. Function expected to return {0}.");
    static final DiagnosticType CONSTRUCTOR_NOT_CALLABLE = DiagnosticType.warning("JSC_NTI_CONSTRUCTOR_NOT_CALLABLE", "Constructor {0} should be called with the \"new\" keyword");
    static final DiagnosticType ILLEGAL_OBJLIT_KEY = DiagnosticType.warning("JSC_NTI_ILLEGAL_OBJLIT_KEY", "Illegal key, the object literal is a {0}");
    static final DiagnosticType ILLEGAL_PROPERTY_CREATION = DiagnosticType.warning("JSC_NTI_ILLEGAL_PROPERTY_CREATION", "Cannot add property {0} to a struct instance after it is constructed.");
    static final DiagnosticType IN_USED_WITH_STRUCT = DiagnosticType.warning("JSC_NTI_IN_USED_WITH_STRUCT", "Cannot use the IN operator with structs");
    public static final DiagnosticType INEXISTENT_PROPERTY = DiagnosticType.warning("JSC_NTI_INEXISTENT_PROPERTY", "Property {0} never defined on {1}");
    static final DiagnosticType NOT_CALLABLE = DiagnosticType.warning("JSC_NTI_NOT_FUNCTION_TYPE", "{0} expressions are not callable");
    static final DiagnosticType WRONG_ARGUMENT_COUNT = DiagnosticType.warning("JSC_NTI_WRONG_ARGUMENT_COUNT", "Function {0}: called with {1} argument(s). Function requires at least {2} argument(s){3}.");
    static final DiagnosticType ILLEGAL_PROPERTY_ACCESS = DiagnosticType.warning("JSC_NTI_ILLEGAL_PROPERTY_ACCESS", "Cannot do {0} access on a {1}");
    static final DiagnosticType UNKNOWN_TYPEOF_VALUE = DiagnosticType.warning("JSC_NTI_UNKNOWN_TYPEOF_VALUE", "unknown type: {0}");
    static final DiagnosticType UNKNOWN_NAMESPACE_PROPERTY = DiagnosticType.warning("JSC_NTI_UNKNOWN_NAMESPACE_PROPERTY", "Cannot determine the type of namespace property {0}. Maybe a prefix of the property name has been redefined?");
    static final DiagnosticGroup ALL_DIAGNOSTICS = new DiagnosticGroup(ASSERT_FALSE, BOTTOM_INDEX_TYPE, BOTTOM_PROP, CANNOT_BIND_CTOR, CONST_PROPERTY_REASSIGNED, CONST_REASSIGNED, CONSTRUCTOR_NOT_CALLABLE, CROSS_SCOPE_GOTCHA, FAILED_TO_UNIFY, FORIN_EXPECTS_OBJECT, FORIN_EXPECTS_STRING_KEY, GLOBAL_THIS, GOOG_BIND_EXPECTS_FUNCTION, ILLEGAL_OBJLIT_KEY, ILLEGAL_PROPERTY_ACCESS, ILLEGAL_PROPERTY_CREATION, IN_USED_WITH_STRUCT, INEXISTENT_PROPERTY, INVALID_ARGUMENT_TYPE, INVALID_CAST, INVALID_INFERRED_RETURN_TYPE, INVALID_OBJLIT_PROPERTY_TYPE, INVALID_OPERAND_TYPE, INVALID_THIS_TYPE_IN_BIND, MISSING_RETURN_STATEMENT, MISTYPED_ASSIGN_RHS, INVALID_INDEX_TYPE, NOT_A_CONSTRUCTOR, NOT_CALLABLE, NOT_UNIQUE_INSTANTIATION, POSSIBLY_INEXISTENT_PROPERTY, PROPERTY_ACCESS_ON_NONOBJECT, RETURN_NONDECLARED_TYPE, UNKNOWN_ASSERTION_TYPE, UNKNOWN_NAMESPACE_PROPERTY, UNKNOWN_TYPEOF_VALUE, WRONG_ARGUMENT_COUNT);
    private WarningReporter warnings;
    private final AbstractCompiler compiler;
    private final CodingConvention convention;
    private Map<DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch>, TypeEnv> envs;
    private Map<NTIScope, JSType> summaries;
    private Map<Node, DeferredCheck> deferredChecks;
    private ControlFlowGraph<Node> cfg;
    private NTIScope currentScope;
    private TypeEnv typeEnvFromDeclaredTypes = null;
    private GlobalTypeInfo symbolTable;
    private JSTypes commonTypes;
    private static final String RETVAL_ID = "%return";
    private static final String THIS_ID = "this";
    private static final String GETTER_PREFIX = "%getter_fun";
    private static final String SETTER_PREFIX = "%setter_fun";
    private final String ABSTRACT_METHOD_NAME;
    private final Map<String, CodingConvention.AssertionFunctionSpec> assertionFunctionsMap;
    private static boolean showDebuggingPrints = false;
    static boolean measureMem = false;
    private static long peakMem = 0L;

    NewTypeInference(AbstractCompiler compiler) {
        this.warnings = new WarningReporter(compiler);
        this.compiler = compiler;
        this.convention = compiler.getCodingConvention();
        this.envs = new LinkedHashMap<DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch>, TypeEnv>();
        this.summaries = new LinkedHashMap<NTIScope, JSType>();
        this.deferredChecks = new LinkedHashMap<Node, DeferredCheck>();
        this.ABSTRACT_METHOD_NAME = this.convention.getAbstractMethodName();
        this.assertionFunctionsMap = new LinkedHashMap<String, CodingConvention.AssertionFunctionSpec>();
        for (CodingConvention.AssertionFunctionSpec assertionFunction : this.convention.getAssertionFunctions()) {
            this.assertionFunctionsMap.put(assertionFunction.getFunctionName(), assertionFunction);
        }
    }

    @VisibleForTesting
    public NTIScope processForTesting(Node externs, Node root) {
        this.process(externs, root);
        return this.symbolTable.getGlobalScope();
    }

    @Override
    public void process(Node externs, Node root) {
        try {
            this.symbolTable = this.compiler.getSymbolTable();
            this.commonTypes = this.symbolTable.getTypesUtilObject();
            for (NTIScope scope : this.symbolTable.getScopes()) {
                this.analyzeFunction(scope);
                this.envs.clear();
            }
            for (DeferredCheck check : this.deferredChecks.values()) {
                check.runCheck(this.summaries, this.warnings);
            }
            this.compiler.setSymbolTable(null);
            if (measureMem) {
                System.out.println("Peak mem: " + peakMem + "MB");
            }
        }
        catch (Exception unexpectedException) {
            String message = unexpectedException.getMessage();
            if (this.currentScope != null) {
                message = message + "\nIn scope: " + this.currentScope;
            }
            this.compiler.throwInternalError(message, unexpectedException);
        }
    }

    static void updatePeakMem() {
        Runtime rt = Runtime.getRuntime();
        long currentUsedMem = (rt.totalMemory() - rt.freeMemory()) / 0x100000L;
        if (currentUsedMem > peakMem) {
            peakMem = currentUsedMem;
        }
    }

    private static void println(Object ... objs) {
        if (showDebuggingPrints) {
            StringBuilder b = new StringBuilder();
            for (Object obj : objs) {
                b.append(obj);
            }
            System.out.println(b);
        }
    }

    private TypeEnv getInEnv(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn) {
        List<DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch>> inEdges = dn.getInEdges();
        if (inEdges.size() == 1) {
            return this.envs.get(inEdges.get(0));
        }
        LinkedHashSet<TypeEnv> envSet = new LinkedHashSet<TypeEnv>();
        for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> de : inEdges) {
            TypeEnv env = this.envs.get(de);
            if (env == null) continue;
            envSet.add(env);
        }
        if (envSet.isEmpty()) {
            return null;
        }
        return TypeEnv.join(envSet);
    }

    private TypeEnv getOutEnv(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn) {
        List<DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch>> outEdges = dn.getOutEdges();
        if (outEdges.isEmpty()) {
            Preconditions.checkArgument((boolean)((Node)dn.getValue()).isThrow());
            return this.typeEnvFromDeclaredTypes;
        }
        if (outEdges.size() == 1) {
            return this.envs.get(outEdges.get(0));
        }
        LinkedHashSet<TypeEnv> envSet = new LinkedHashSet<TypeEnv>();
        for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> de : outEdges) {
            TypeEnv env = this.envs.get(de);
            if (env == null) continue;
            envSet.add(env);
        }
        Preconditions.checkState((!envSet.isEmpty() ? 1 : 0) != 0);
        return TypeEnv.join(envSet);
    }

    private TypeEnv setOutEnv(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn, TypeEnv e) {
        for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> de : dn.getOutEdges()) {
            this.envs.put(de, e);
        }
        return e;
    }

    private void initEdgeEnvsFwd(TypeEnv entryEnv) {
        this.envs.clear();
        LinkedHashSet<String> nonLocals = new LinkedHashSet<String>();
        if (this.currentScope.isFunction()) {
            if (this.currentScope.getName() != null) {
                nonLocals.add(this.currentScope.getName());
            }
            nonLocals.addAll(this.currentScope.getOuterVars());
            nonLocals.addAll(this.currentScope.getFormals());
            if (this.currentScope.hasThis()) {
                nonLocals.add(THIS_ID);
            }
            entryEnv = NewTypeInference.envPutType(entryEnv, RETVAL_ID, JSType.UNDEFINED);
        } else {
            nonLocals.addAll(this.currentScope.getExterns());
        }
        for (String name : nonLocals) {
            JSType declType = this.currentScope.getDeclaredTypeOf(name);
            JSType initType = declType == null ? NewTypeInference.envGetType(entryEnv, name) : declType;
            NewTypeInference.println("Adding non-local ", name, " with decltype: ", declType, " and inittype: ", initType);
            entryEnv = NewTypeInference.envPutType(entryEnv, name, initType);
        }
        for (String local : this.currentScope.getLocals()) {
            if (this.currentScope.isFunctionNamespace(local)) continue;
            entryEnv = NewTypeInference.envPutType(entryEnv, local, JSType.UNDEFINED);
        }
        for (String fnName : this.currentScope.getLocalFunDefs()) {
            entryEnv = NewTypeInference.envPutType(entryEnv, fnName, this.getSummaryOfLocalFunDef(fnName));
        }
        NewTypeInference.println("Keeping env: ", entryEnv);
        this.setOutEnv(this.cfg.getEntry(), entryEnv);
    }

    private TypeEnv getTypeEnvFromDeclaredTypes() {
        TypeEnv env = new TypeEnv();
        Set<String> varNames = this.currentScope.getOuterVars();
        Set<String> locals = this.currentScope.getLocals();
        varNames.addAll(locals);
        varNames.addAll(this.currentScope.getExterns());
        if (this.currentScope.isFunction()) {
            DeclaredFunctionType dft;
            if (this.currentScope.getName() != null) {
                varNames.add(this.currentScope.getName());
            }
            varNames.addAll(this.currentScope.getFormals());
            if (this.currentScope.hasThis()) {
                varNames.add(THIS_ID);
            }
            JSType argumentsType = (dft = this.currentScope.getDeclaredFunctionType()).getOptionalArity() == 0 && dft.hasRestFormals() ? dft.getRestFormalsType() : JSType.UNKNOWN;
            env = NewTypeInference.envPutType(env, "arguments", this.commonTypes.getArgumentsArrayType(argumentsType));
        }
        for (String varName : varNames) {
            if (locals.contains(varName) && this.currentScope.isFunctionNamespace(varName)) continue;
            JSType declType = this.currentScope.getDeclaredTypeOf(varName);
            env = NewTypeInference.envPutType(env, varName, declType == null ? JSType.UNKNOWN : declType);
        }
        for (String fnName : this.currentScope.getLocalFunDefs()) {
            env = NewTypeInference.envPutType(env, fnName, this.getSummaryOfLocalFunDef(fnName));
        }
        return env;
    }

    private JSType getSummaryOfLocalFunDef(String name) {
        NTIScope fnScope = this.currentScope.getScope(name);
        JSType fnType = this.summaries.get(fnScope);
        if (fnType != null) {
            return fnType;
        }
        fnType = this.currentScope.getDeclaredTypeOf(name);
        Preconditions.checkState((fnType.getFunType() != null ? 1 : 0) != 0, (String)"Needed function but found %s", (Object[])new Object[]{fnType});
        return this.changeTypeIfFunctionNamespace(fnScope, fnType);
    }

    private void buildWorkset(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn, List<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> workset) {
        this.buildWorksetHelper(dn, workset, new LinkedHashSet<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>>());
    }

    private void buildWorksetHelper(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn, List<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> workset, Set<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> seen) {
        if (seen.contains(dn) || dn == this.cfg.getImplicitReturn()) {
            return;
        }
        switch (((Node)dn.getValue()).getType()) {
            case 113: 
            case 114: 
            case 115: {
                List outEdges = dn.getOutEdges();
                seen.add(dn);
                workset.add(dn);
                for (DiGraph.DiGraphEdge diGraphEdge : outEdges) {
                    if (diGraphEdge.getValue() != ControlFlowGraph.Branch.ON_TRUE) continue;
                    this.buildWorksetHelper(diGraphEdge.getDestination(), workset, seen);
                }
                workset.add(dn);
                for (DiGraph.DiGraphEdge diGraphEdge : outEdges) {
                    if (diGraphEdge.getValue() != ControlFlowGraph.Branch.ON_FALSE) continue;
                    this.buildWorksetHelper(diGraphEdge.getDestination(), workset, seen);
                }
                break;
            }
            default: {
                List succs;
                for (DiGraph.DiGraphEdge diGraphEdge : dn.getInEdges()) {
                    if (seen.contains(diGraphEdge.getSource()) || ((Node)diGraphEdge.getSource().getValue()).isDo()) continue;
                    return;
                }
                seen.add(dn);
                if (this.cfg.getEntry() != dn) {
                    workset.add(dn);
                }
                while ((succs = this.cfg.getDirectedSuccNodes(dn)).size() == 1) {
                    DiGraph.DiGraphNode diGraphNode = succs.get(0);
                    if (diGraphNode == this.cfg.getImplicitReturn()) {
                        return;
                    }
                    if (this.cfg.getDirectedPredNodes(diGraphNode).size() > 1) break;
                    workset.add(diGraphNode);
                    seen.add(diGraphNode);
                    dn = diGraphNode;
                }
                for (DiGraph.DiGraphNode diGraphNode : this.cfg.getDirectedSuccNodes(dn)) {
                    this.buildWorksetHelper(diGraphNode, workset, seen);
                }
            }
        }
    }

    private void analyzeFunction(NTIScope scope) {
        NewTypeInference.println("=== Analyzing function: ", scope.getReadableName(), " ===");
        this.currentScope = scope;
        ControlFlowAnalysis cfa = new ControlFlowAnalysis(this.compiler, false, false);
        cfa.process(null, scope.getRoot());
        this.cfg = cfa.getCfg();
        NewTypeInference.println(this.cfg);
        LinkedList<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> workset = new LinkedList<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>>();
        this.buildWorkset(this.cfg.getEntry(), workset);
        this.typeEnvFromDeclaredTypes = this.getTypeEnvFromDeclaredTypes();
        if (scope.isFunction() && scope.hasUndeclaredFormalsOrOuters()) {
            Collections.reverse(workset);
            for (DiGraph.DiGraphEdge e : this.cfg.getEdges()) {
                this.envs.put(e, this.typeEnvFromDeclaredTypes);
            }
            this.analyzeFunctionBwd(workset);
            Collections.reverse(workset);
            TypeEnv entryEnv = this.getEntryTypeEnv();
            this.initEdgeEnvsFwd(entryEnv);
            if (measureMem) {
                NewTypeInference.updatePeakMem();
            }
        } else {
            TypeEnv entryEnv = this.typeEnvFromDeclaredTypes;
            this.initEdgeEnvsFwd(entryEnv);
        }
        this.typeEnvFromDeclaredTypes = null;
        this.analyzeFunctionFwd(workset);
        if (scope.isFunction()) {
            this.createSummary(scope);
        }
        if (measureMem) {
            NewTypeInference.updatePeakMem();
        }
    }

    private void analyzeFunctionBwd(List<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> workset) {
        for (DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn : workset) {
            TypeEnv inEnv;
            Node n = (Node)dn.getValue();
            TypeEnv outEnv = (TypeEnv)Preconditions.checkNotNull((Object)this.getOutEnv(dn));
            NewTypeInference.println("\tBWD Statment: ", n);
            NewTypeInference.println("\t\toutEnv: ", outEnv);
            switch (n.getType()) {
                case 130: {
                    inEnv = this.analyzeExprBwd((Node)n.getFirstChild(), (TypeEnv)outEnv, (JSType)JSType.UNKNOWN).env;
                    break;
                }
                case 4: {
                    Node retExp = n.getFirstChild();
                    if (retExp == null) {
                        inEnv = outEnv;
                        break;
                    }
                    JSType declRetType = this.currentScope.getDeclaredFunctionType().getReturnType();
                    declRetType = declRetType == null ? JSType.UNKNOWN : declRetType;
                    inEnv = this.analyzeExprBwd((Node)retExp, (TypeEnv)outEnv, (JSType)declRetType).env;
                    break;
                }
                case 118: {
                    if (NodeUtil.isTypedefDecl(n)) {
                        inEnv = outEnv;
                        break;
                    }
                    inEnv = outEnv;
                    for (Node nameNode = n.getFirstChild(); nameNode != null; nameNode = nameNode.getNext()) {
                        JSType requiredType;
                        String varName = nameNode.getString();
                        Node rhs = nameNode.getFirstChild();
                        JSType declType = this.currentScope.getDeclaredTypeOf(varName);
                        inEnv = NewTypeInference.envPutType(inEnv, varName, JSType.UNKNOWN);
                        if (rhs == null || this.currentScope.isLocalFunDef(varName)) continue;
                        JSType inferredType = NewTypeInference.envGetType(outEnv, varName);
                        if (declType == null) {
                            requiredType = inferredType;
                        } else {
                            requiredType = JSType.meet(declType, inferredType);
                            if (requiredType.isBottom()) {
                                requiredType = JSType.UNKNOWN;
                            }
                        }
                        inEnv = this.analyzeExprBwd((Node)rhs, (TypeEnv)inEnv, (JSType)requiredType).env;
                    }
                    break;
                }
                case 77: 
                case 112: 
                case 116: 
                case 117: 
                case 120: 
                case 124: 
                case 125: 
                case 132: 
                case 152: {
                    inEnv = outEnv;
                    break;
                }
                case 108: 
                case 113: 
                case 114: 
                case 115: {
                    Node expr = NodeUtil.isForIn(n) ? n.getFirstChild() : NodeUtil.getConditionExpression(n);
                    inEnv = this.analyzeExprBwd((Node)expr, (TypeEnv)outEnv).env;
                    break;
                }
                case 49: 
                case 110: 
                case 111: {
                    inEnv = this.analyzeExprBwd((Node)n.getFirstChild(), (TypeEnv)outEnv).env;
                    break;
                }
                default: {
                    if (NodeUtil.isStatement(n)) {
                        throw new RuntimeException("Unhandled statement type: " + Token.name(n.getType()));
                    }
                    inEnv = this.analyzeExprBwd((Node)n, (TypeEnv)outEnv).env;
                }
            }
            NewTypeInference.println("\t\tinEnv: ", inEnv);
            for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> de : dn.getInEdges()) {
                this.envs.put(de, inEnv);
            }
        }
    }

    private void analyzeFunctionFwd(List<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> workset) {
        for (DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn : workset) {
            Node n = (Node)dn.getValue();
            Node parent = n.getParent();
            Preconditions.checkState((n != null ? 1 : 0) != 0, (Object)"Implicit return should not be in workset.");
            TypeEnv inEnv = this.getInEnv(dn);
            TypeEnv outEnv = null;
            if (parent.isScript() || parent.isBlock() && parent.getParent().isFunction()) {
                inEnv = inEnv.clearChangeLog();
            }
            NewTypeInference.println("\tFWD Statment: ", n);
            NewTypeInference.println("\t\tinEnv: ", inEnv);
            boolean conditional = false;
            switch (n.getType()) {
                case 77: 
                case 105: 
                case 112: 
                case 116: 
                case 117: 
                case 124: 
                case 125: 
                case 132: 
                case 152: {
                    outEnv = inEnv;
                    break;
                }
                case 120: {
                    String catchVarname = n.getFirstChild().getString();
                    outEnv = NewTypeInference.envPutType(inEnv, catchVarname, JSType.UNKNOWN);
                    break;
                }
                case 130: {
                    NewTypeInference.println("\tsemi ", Token.name(n.getFirstChild().getType()));
                    if (n.getBooleanProp(76)) {
                        n.removeProp(76);
                        outEnv = inEnv;
                        break;
                    }
                    outEnv = this.analyzeExprFwd((Node)n.getFirstChild(), (TypeEnv)inEnv, (JSType)JSType.UNKNOWN).env;
                    break;
                }
                case 4: {
                    JSType actualRetType;
                    Node retExp = n.getFirstChild();
                    JSType declRetType = this.currentScope.getDeclaredFunctionType().getReturnType();
                    JSType jSType = declRetType = declRetType == null ? JSType.UNKNOWN : declRetType;
                    if (retExp == null) {
                        actualRetType = JSType.UNDEFINED;
                        outEnv = NewTypeInference.envPutType(inEnv, RETVAL_ID, actualRetType);
                    } else {
                        EnvTypePair retPair = this.analyzeExprFwd(retExp, inEnv, declRetType);
                        actualRetType = retPair.type;
                        outEnv = NewTypeInference.envPutType(retPair.env, RETVAL_ID, actualRetType);
                    }
                    if (actualRetType.isSubtypeOf(declRetType)) break;
                    this.warnings.add(JSError.make(n, RETURN_NONDECLARED_TYPE, declRetType.toString(), actualRetType.toString()));
                    break;
                }
                case 108: 
                case 113: 
                case 114: 
                case 115: {
                    if (NodeUtil.isForIn(n)) {
                        Node obj = n.getSecondChild();
                        EnvTypePair pair = this.analyzeExprFwd(obj, inEnv, NewTypeInference.pickReqObjType(n));
                        pair = this.mayWarnAboutNullableReferenceAndTighten(n, pair.type, null, inEnv);
                        JSType objType = pair.type;
                        if (!objType.isSubtypeOf(JSType.TOP_OBJECT)) {
                            this.warnings.add(JSError.make(obj, FORIN_EXPECTS_OBJECT, objType.toString()));
                        } else if (objType.isStruct()) {
                            this.warnings.add(JSError.make(obj, IN_USED_WITH_STRUCT, new String[0]));
                        }
                        Node lhs = n.getFirstChild();
                        LValueResultFwd lval = this.analyzeLValueFwd(lhs, inEnv, JSType.STRING);
                        if (lval.declType != null && !this.commonTypes.isStringScalarOrObj(lval.declType)) {
                            this.warnings.add(JSError.make(lhs, FORIN_EXPECTS_STRING_KEY, lval.declType.toString()));
                            outEnv = lval.env;
                            break;
                        }
                        outEnv = this.updateLvalueTypeInEnv(lval.env, lhs, lval.ptr, JSType.STRING);
                        break;
                    }
                    conditional = true;
                    this.analyzeConditionalStmFwd(dn, NodeUtil.getConditionExpression(n), inEnv);
                    break;
                }
                case 111: {
                    conditional = true;
                    this.analyzeConditionalStmFwd(dn, n, inEnv);
                    break;
                }
                case 118: {
                    outEnv = inEnv;
                    if (NodeUtil.isTypedefDecl(n)) break;
                    for (Node nameNode = n.getFirstChild(); nameNode != null; nameNode = nameNode.getNext()) {
                        outEnv = this.processVarDeclaration(nameNode, outEnv);
                    }
                    break;
                }
                case 49: 
                case 110: {
                    outEnv = this.analyzeExprFwd((Node)n.getFirstChild(), (TypeEnv)inEnv).env;
                    break;
                }
                default: {
                    if (NodeUtil.isStatement(n)) {
                        throw new RuntimeException("Unhandled statement type: " + Token.name(n.getType()));
                    }
                    outEnv = this.analyzeExprFwd((Node)n, (TypeEnv)inEnv, (JSType)JSType.UNKNOWN).env;
                }
            }
            if (conditional) continue;
            NewTypeInference.println("\t\toutEnv: ", outEnv);
            this.setOutEnv(dn, outEnv);
        }
    }

    private void analyzeConditionalStmFwd(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> stm, Node cond, TypeEnv inEnv) {
        for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> outEdge : stm.getOutEdges()) {
            JSType specializedType;
            switch ((ControlFlowGraph.Branch)((Object)outEdge.getValue())) {
                case ON_TRUE: {
                    specializedType = JSType.TRUTHY;
                    break;
                }
                case ON_FALSE: {
                    specializedType = JSType.FALSY;
                    break;
                }
                case ON_EX: {
                    specializedType = JSType.UNKNOWN;
                    break;
                }
                default: {
                    throw new RuntimeException("Condition with an unexpected edge type: " + outEdge.getValue());
                }
            }
            this.envs.put(outEdge, this.analyzeExprFwd((Node)cond, (TypeEnv)inEnv, (JSType)JSType.UNKNOWN, (JSType)specializedType).env);
        }
    }

    private void createSummary(NTIScope fn) {
        String formalName;
        Object formalType;
        Node fnRoot = fn.getRoot();
        Preconditions.checkArgument((!fnRoot.isFromExterns() ? 1 : 0) != 0);
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        TypeEnv entryEnv = this.getEntryTypeEnv();
        TypeEnv exitEnv = this.getInEnv(this.cfg.getImplicitReturn());
        if (exitEnv == null) {
            exitEnv = NewTypeInference.envPutType(new TypeEnv(), RETVAL_ID, JSType.BOTTOM);
        }
        DeclaredFunctionType declType = fn.getDeclaredFunctionType();
        int reqArity = declType.getRequiredArity();
        int optArity = declType.getOptionalArity();
        if (declType.isGeneric()) {
            builder.addTypeParameters(declType.getTypeParameters());
        }
        List<String> formals = fn.getFormals();
        for (int i = reqArity - 1; i >= 0 && (formalType = fn.getDeclaredFunctionType().getFormalType(i)) == null && (((JSType)(formalType = this.getTypeAfterFwd(formalName = formals.get(i), entryEnv, exitEnv))).isUnknown() || JSType.UNDEFINED.isSubtypeOf((TypeI)formalType)); --i) {
            --reqArity;
        }
        int formalIndex = 0;
        for (String formal : formals) {
            JSType formalType2 = fn.getDeclaredTypeOf(formal);
            if (formalType2 == null) {
                formalType2 = this.getTypeAfterFwd(formal, entryEnv, exitEnv);
            }
            if (formalIndex < reqArity) {
                builder.addReqFormal(formalType2);
            } else if (formalIndex < optArity) {
                builder.addOptFormal(formalType2);
            }
            ++formalIndex;
        }
        if (declType.hasRestFormals()) {
            builder.addRestFormals(declType.getFormalType(formalIndex));
        }
        for (String outer : fn.getOuterVars()) {
            NewTypeInference.println("Free var ", outer, " going in summary");
            builder.addOuterVarPrecondition(outer, NewTypeInference.envGetType(entryEnv, outer));
        }
        builder.addNominalType(declType.getNominalType());
        builder.addReceiverType(declType.getReceiverType());
        JSType declRetType = declType.getReturnType();
        JSType actualRetType = (JSType)Preconditions.checkNotNull((Object)NewTypeInference.envGetType(exitEnv, RETVAL_ID));
        if (declRetType != null) {
            builder.addRetType(declRetType);
            if (!NewTypeInference.isAllowedToNotReturn(fn) && !JSType.UNDEFINED.isSubtypeOf(declRetType) && NewTypeInference.hasPathWithNoReturn(this.cfg)) {
                this.warnings.add(JSError.make(fnRoot, MISSING_RETURN_STATEMENT, declRetType.toString()));
            }
        } else if (declType.getNominalType() == null) {
            builder.addRetType(actualRetType.isBottom() ? JSType.TOP : actualRetType);
        } else {
            builder.addRetType(JSType.UNKNOWN);
        }
        JSType summary = this.commonTypes.fromFunctionType(builder.buildFunction());
        NewTypeInference.println("Function summary for ", fn.getReadableName());
        NewTypeInference.println("\t", summary);
        summary = this.changeTypeIfFunctionNamespace(fn, summary);
        this.summaries.put(fn, summary);
        this.maybeSetTypeI(fnRoot, summary);
        Node fnNameNode = NodeUtil.getNameNode(fnRoot);
        if (fnNameNode != null) {
            this.maybeSetTypeI(fnNameNode, summary);
        }
    }

    private JSType changeTypeIfFunctionNamespace(NTIScope fnScope, JSType fnType) {
        NTIScope enclosingScope = fnScope.getParent();
        Node fnNameNode = NodeUtil.getNameNode(fnScope.getRoot());
        JSType namespaceType = null;
        if (fnNameNode == null) {
            return fnType;
        }
        if (fnNameNode.isName()) {
            String fnName = fnNameNode.getString();
            if (enclosingScope.isFunctionNamespace(fnName)) {
                namespaceType = enclosingScope.getDeclaredTypeOf(fnName);
            }
        } else if (fnNameNode.isQualifiedName()) {
            QualifiedName qname = QualifiedName.fromNode(fnNameNode);
            JSType rootNs = enclosingScope.getDeclaredTypeOf(qname.getLeftmostName());
            JSType jSType = namespaceType = rootNs == null ? null : rootNs.getProp(qname.getAllButLeftmost());
        }
        if (namespaceType != null && namespaceType.isNamespace()) {
            return namespaceType.withFunction(fnType.getFunTypeIfSingletonObj(), this.commonTypes.getFunctionType());
        }
        return fnType;
    }

    private JSType getTypeAfterFwd(String varName, TypeEnv entryEnv, TypeEnv exitEnv) {
        JSType typeAfterFwd;
        JSType typeAfterBwd = NewTypeInference.envGetType(entryEnv, varName);
        if (!(typeAfterBwd.hasNonScalar() && typeAfterBwd.getFunType() == null || (typeAfterFwd = NewTypeInference.envGetType(exitEnv, varName)) == null)) {
            return typeAfterFwd;
        }
        return typeAfterBwd;
    }

    private static boolean isAllowedToNotReturn(NTIScope methodScope) {
        QualifiedName ntQname;
        JSType rootNamespace;
        Node fn = methodScope.getRoot();
        if (fn.isFromExterns()) {
            return true;
        }
        if (!NodeUtil.isPrototypeMethod(fn)) {
            return false;
        }
        Node ntQnameNode = NodeUtil.getPrototypeClassName(fn.getParent().getFirstChild());
        JSType maybeInterface = ntQnameNode.isName() ? methodScope.getDeclaredTypeOf(ntQnameNode.getString()) : ((rootNamespace = methodScope.getDeclaredTypeOf((ntQname = QualifiedName.fromNode(ntQnameNode)).getLeftmostName())) == null ? null : rootNamespace.getProp(ntQname.getAllButLeftmost()));
        return maybeInterface != null && maybeInterface.isInterfaceDefinition();
    }

    private static boolean hasPathWithNoReturn(ControlFlowGraph<Node> cfg) {
        for (DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn : cfg.getDirectedPredNodes(cfg.getImplicitReturn())) {
            Node cond;
            Node stm = (Node)dn.getValue();
            if (!(NodeUtil.isLoopStructure(stm) ? (cond = NodeUtil.getConditionExpression(stm)) == null || !NodeUtil.isImpureTrue(cond) : !stm.isReturn())) continue;
            return true;
        }
        return false;
    }

    private TypeEnv processVarDeclaration(Node nameNode, TypeEnv inEnv) {
        JSType rhsType;
        String varName = nameNode.getString();
        JSType declType = this.currentScope.getDeclaredTypeOf(varName);
        if (this.currentScope.isLocalFunDef(varName)) {
            return inEnv;
        }
        if (NodeUtil.isNamespaceDecl(nameNode)) {
            this.maybeSetTypeI(nameNode, declType);
            return NewTypeInference.envPutType(inEnv, varName, declType);
        }
        Node rhs = nameNode.getFirstChild();
        TypeEnv outEnv = inEnv;
        if (rhs == null) {
            rhsType = JSType.UNDEFINED;
        } else {
            EnvTypePair pair = this.analyzeExprFwd(rhs, inEnv, declType != null ? declType : JSType.UNKNOWN);
            outEnv = pair.env;
            rhsType = pair.type;
        }
        if (declType != null && rhs != null) {
            if (!rhsType.isSubtypeOf(declType)) {
                this.warnings.add(JSError.make(rhs, MISTYPED_ASSIGN_RHS, declType.toString(), rhsType.toString()));
                rhsType = declType;
            } else {
                rhsType = declType.specialize(rhsType);
            }
        }
        this.maybeSetTypeI(nameNode, rhsType);
        return NewTypeInference.envPutType(outEnv, varName, rhsType);
    }

    private EnvTypePair analyzeExprFwd(Node expr, TypeEnv inEnv) {
        return this.analyzeExprFwd(expr, inEnv, JSType.UNKNOWN, JSType.UNKNOWN);
    }

    private EnvTypePair analyzeExprFwd(Node expr, TypeEnv inEnv, JSType requiredType) {
        return this.analyzeExprFwd(expr, inEnv, requiredType, requiredType);
    }

    private EnvTypePair analyzeExprFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        Preconditions.checkArgument((requiredType != null && !requiredType.isBottom() ? 1 : 0) != 0);
        EnvTypePair resultPair = null;
        switch (expr.getType()) {
            case 124: {
                resultPair = new EnvTypePair(inEnv, JSType.UNKNOWN);
                break;
            }
            case 105: {
                String fnName = this.symbolTable.getFunInternalName(expr);
                JSType fnType = NewTypeInference.envGetType(inEnv, fnName);
                Preconditions.checkState((fnType != null ? 1 : 0) != 0, (String)"Could not find type for %s", (Object[])new Object[]{fnName});
                TypeEnv outEnv = this.collectTypesForFreeVarsFwd(expr, inEnv);
                resultPair = new EnvTypePair(outEnv, fnType);
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: {
                resultPair = new EnvTypePair(inEnv, NewTypeInference.scalarValueToType(expr.getType()));
                break;
            }
            case 64: {
                resultPair = this.analyzeObjLitFwd(expr, inEnv, requiredType, specializedType);
                break;
            }
            case 42: {
                if (!this.currentScope.hasThis()) {
                    this.mayWarnAboutGlobalThis(expr, this.currentScope);
                    resultPair = new EnvTypePair(inEnv, JSType.UNKNOWN);
                    break;
                }
                JSType inferredType = NewTypeInference.envGetType(inEnv, THIS_ID);
                if (!inferredType.isSubtypeOf(requiredType)) {
                    return new EnvTypePair(inEnv, inferredType);
                }
                JSType preciseType = inferredType.specialize(specializedType);
                resultPair = EnvTypePair.addBinding(inEnv, THIS_ID, preciseType);
                break;
            }
            case 38: {
                resultPair = this.analyzeNameFwd(expr, inEnv, requiredType, specializedType);
                break;
            }
            case 100: 
            case 101: {
                resultPair = this.analyzeLogicalOpFwd(expr, inEnv, requiredType, specializedType);
                break;
            }
            case 102: 
            case 103: {
                resultPair = this.analyzeIncDecFwd(expr, inEnv, requiredType);
                break;
            }
            case 27: 
            case 29: {
                resultPair = this.analyzeUnaryNumFwd(expr, inEnv);
                break;
            }
            case 28: {
                resultPair = this.analyzeExprFwd(expr.getFirstChild(), inEnv);
                resultPair.type = JSType.NUMBER;
                break;
            }
            case 32: {
                resultPair = this.analyzeExprFwd(expr.getFirstChild(), inEnv);
                resultPair.type = JSType.STRING;
                break;
            }
            case 52: {
                resultPair = this.analyzeInstanceofFwd(expr, inEnv, specializedType);
                break;
            }
            case 21: {
                resultPair = this.analyzeAddFwd(expr, inEnv, requiredType);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                resultPair = this.analyzeBinaryNumericOpFwd(expr, inEnv);
                break;
            }
            case 86: {
                resultPair = this.analyzeAssignFwd(expr, inEnv, requiredType, specializedType);
                break;
            }
            case 93: {
                resultPair = this.analyzeAssignAddFwd(expr, inEnv, requiredType);
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                resultPair = this.analyzeAssignNumericOpFwd(expr, inEnv);
                break;
            }
            case 45: 
            case 46: {
                resultPair = this.analyzeStrictComparisonFwd(expr.getType(), expr.getFirstChild(), expr.getLastChild(), inEnv, specializedType);
                break;
            }
            case 12: 
            case 13: {
                resultPair = this.analyzeNonStrictComparisonFwd(expr, inEnv, specializedType);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                resultPair = this.analyzeLtGtFwd(expr, inEnv);
                break;
            }
            case 33: {
                Preconditions.checkState((!NodeUtil.isAssignmentOp(expr.getParent()) || !NodeUtil.isLValue(expr) ? 1 : 0) != 0);
                if (expr.getBooleanProp(76)) {
                    expr.removeProp(76);
                    resultPair = new EnvTypePair(inEnv, requiredType);
                    break;
                }
                resultPair = this.analyzePropAccessFwd(expr.getFirstChild(), expr.getLastChild().getString(), inEnv, requiredType, specializedType);
                break;
            }
            case 98: {
                resultPair = this.analyzeHookFwd(expr, inEnv, requiredType, specializedType);
                break;
            }
            case 30: 
            case 37: {
                resultPair = this.analyzeCallNewFwd(expr, inEnv, requiredType, specializedType);
                break;
            }
            case 85: {
                resultPair = this.analyzeExprFwd(expr.getLastChild(), this.analyzeExprFwd((Node)expr.getFirstChild(), (TypeEnv)inEnv).env, requiredType, specializedType);
                break;
            }
            case 26: {
                resultPair = this.analyzeExprFwd(expr.getFirstChild(), inEnv, JSType.UNKNOWN, specializedType.negate());
                resultPair.type = resultPair.type.negate().toBoolean();
                break;
            }
            case 35: {
                resultPair = this.analyzeGetElemFwd(expr, inEnv, requiredType, specializedType);
                break;
            }
            case 122: {
                resultPair = this.analyzeExprFwd(expr.getFirstChild(), inEnv);
                resultPair.type = JSType.UNDEFINED;
                break;
            }
            case 51: {
                resultPair = this.analyzeInFwd(expr, inEnv, specializedType);
                break;
            }
            case 31: {
                resultPair = this.analyzeExprFwd(expr.getFirstChild(), inEnv);
                resultPair.type = JSType.BOOLEAN;
                break;
            }
            case 47: {
                resultPair = new EnvTypePair(inEnv, this.commonTypes.getRegexpType());
                break;
            }
            case 63: {
                resultPair = this.analyzeArrayLitFwd(expr, inEnv);
                break;
            }
            case 155: {
                resultPair = this.analyzeCastFwd(expr, inEnv);
                break;
            }
            case 111: {
                resultPair = this.analyzeStrictComparisonFwd(45, expr.getParent().getFirstChild(), expr.getFirstChild(), inEnv, specializedType);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled expression type: " + Token.name(expr.getType()));
            }
        }
        this.maybeSetTypeI(expr, resultPair.type);
        if (this.currentScope.isFunction()) {
            NewTypeInference.println("AnalyzeExprFWD: ", expr, " ::reqtype: ", requiredType, " ::spectype: ", specializedType, " ::resulttype: ", resultPair.type);
        }
        return resultPair;
    }

    private EnvTypePair analyzeNameFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        String varName = expr.getString();
        if (varName.equals("undefined")) {
            return new EnvTypePair(inEnv, JSType.UNDEFINED);
        }
        JSType inferredType = NewTypeInference.envGetType(inEnv, varName);
        if (inferredType == null) {
            NewTypeInference.println("Found global variable ", varName);
            return new EnvTypePair(inEnv, JSType.UNKNOWN);
        }
        if (this.currentScope.isKnownFunction(varName) || this.maybeIsNamespace(varName, inferredType)) {
            return new EnvTypePair(inEnv, inferredType);
        }
        NewTypeInference.println(varName, "'s inferredType: ", inferredType, " requiredType:  ", requiredType, " specializedType:  ", specializedType);
        if (!inferredType.isSubtypeOf(requiredType)) {
            JSType declType = this.currentScope.getDeclaredTypeOf(varName);
            if (this.tightenTypeAndDontWarn(varName, expr, declType, inferredType, requiredType)) {
                inferredType = inferredType.specialize(requiredType);
            } else {
                return new EnvTypePair(inEnv, inferredType);
            }
        }
        JSType preciseType = inferredType.specialize(specializedType);
        NewTypeInference.println(varName, "'s preciseType: ", preciseType);
        if (!preciseType.isBottom() && (this.currentScope.isUndeclaredFormal(varName) || this.currentScope.isUndeclaredOuterVar(varName)) && preciseType.hasNonScalar()) {
            preciseType = preciseType.withLoose();
        }
        return EnvTypePair.addBinding(inEnv, varName, preciseType);
    }

    private boolean maybeIsNamespace(String varName, JSType inferredType) {
        return this.currentScope.isConstVar(varName) && inferredType.isSubtypeOf(JSType.TOP_OBJECT);
    }

    private EnvTypePair analyzeLogicalOpFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        int exprKind = expr.getType();
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        if (specializedType.isTrueOrTruthy() && exprKind == 101 || specializedType.isFalseOrFalsy() && exprKind == 100) {
            EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.UNKNOWN, specializedType);
            EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.UNKNOWN, specializedType);
            return rhsPair;
        }
        if (specializedType.isFalseOrFalsy() && exprKind == 101 || specializedType.isTrueOrTruthy() && exprKind == 100) {
            EnvTypePair shortCircuitPair = this.analyzeExprFwd(lhs, inEnv, JSType.UNKNOWN, specializedType);
            EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.UNKNOWN, specializedType.negate());
            EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.UNKNOWN, specializedType);
            JSType lhsUnspecializedType = JSType.join(shortCircuitPair.type, lhsPair.type);
            return this.combineLhsAndRhsForLogicalOps(exprKind, lhsUnspecializedType, shortCircuitPair, rhsPair);
        }
        JSType stopAfterLhsType = exprKind == 101 ? JSType.FALSY : JSType.TRUTHY;
        EnvTypePair shortCircuitPair = this.analyzeExprFwd(lhs, inEnv, JSType.UNKNOWN, stopAfterLhsType);
        EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.UNKNOWN, stopAfterLhsType.negate());
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, requiredType, specializedType);
        JSType lhsUnspecializedType = JSType.join(shortCircuitPair.type, lhsPair.type);
        return this.combineLhsAndRhsForLogicalOps(exprKind, lhsUnspecializedType, shortCircuitPair, rhsPair);
    }

    private EnvTypePair combineLhsAndRhsForLogicalOps(int logicalOp, JSType lhsUnspecializedType, EnvTypePair lhsPair, EnvTypePair rhsPair) {
        if (logicalOp == 100) {
            if (lhsUnspecializedType.isAnyTruthyType()) {
                return lhsPair;
            }
            if (lhsUnspecializedType.isAnyFalsyType()) {
                return rhsPair;
            }
            return EnvTypePair.join(lhsPair, rhsPair);
        }
        Preconditions.checkState((logicalOp == 101 ? 1 : 0) != 0);
        if (lhsUnspecializedType.isAnyFalsyType()) {
            return lhsPair;
        }
        if (lhsUnspecializedType.isAnyTruthyType()) {
            return rhsPair;
        }
        return EnvTypePair.join(lhsPair, rhsPair);
    }

    private EnvTypePair analyzeIncDecFwd(Node expr, TypeEnv inEnv, JSType requiredType) {
        this.mayWarnAboutConst(expr);
        Node ch = expr.getFirstChild();
        if (ch.isGetProp() || ch.isGetElem() && ch.getLastChild().isString()) {
            Node recv = ch.getFirstChild();
            String pname = ch.getLastChild().getString();
            EnvTypePair pair = this.analyzeExprFwd(recv, inEnv);
            JSType recvType = pair.type;
            if (this.mayWarnAboutConstProp(ch, recvType, new QualifiedName(pname))) {
                pair.type = requiredType;
                return pair;
            }
        }
        return this.analyzeUnaryNumFwd(expr, inEnv);
    }

    private EnvTypePair analyzeUnaryNumFwd(Node expr, TypeEnv inEnv) {
        Node child = expr.getFirstChild();
        EnvTypePair pair = this.analyzeExprFwd(child, inEnv, JSType.NUMBER);
        if (!this.commonTypes.isNumberScalarOrObj(pair.type)) {
            this.warnInvalidOperand(child, expr.getType(), JSType.NUMBER, pair.type);
        }
        pair.type = JSType.NUMBER;
        return pair;
    }

    private EnvTypePair analyzeInstanceofFwd(Node expr, TypeEnv inEnv, JSType specializedType) {
        JSType instanceSpecType;
        Node obj = expr.getFirstChild();
        Node ctor = expr.getLastChild();
        EnvTypePair objPair = this.analyzeExprFwd(obj, inEnv);
        JSType objType = objPair.type;
        if (!(objType.isTop() || objType.isUnknown() || objType.hasNonScalar() || objType.hasTypeVariable())) {
            this.warnInvalidOperand(obj, 52, "an object or a union type that includes an object", objPair.type);
        }
        EnvTypePair ctorPair = this.analyzeExprFwd(ctor, objPair.env, this.commonTypes.topFunction());
        JSType ctorType = ctorPair.type;
        FunctionType ctorFunType = ctorType.getFunType();
        if (!(ctorType.isUnknown() || ctorType.isSubtypeOf(this.commonTypes.topFunction()) && (ctorFunType.isQmarkFunction() || ctorFunType.isSomeConstructorOrInterface()))) {
            this.warnInvalidOperand(ctor, 52, "a constructor function", ctorType);
        }
        if (ctorFunType == null || !ctorFunType.isUniqueConstructor() || !specializedType.isTrueOrTruthy() && !specializedType.isFalseOrFalsy()) {
            ctorPair.type = JSType.BOOLEAN;
            return ctorPair;
        }
        JSType instanceType = ctorFunType.getInstanceTypeOfCtor();
        JSType jSType = instanceSpecType = specializedType.isTrueOrTruthy() ? objType.specialize(instanceType) : objType.removeType(instanceType);
        if (!instanceSpecType.isBottom()) {
            objPair = this.analyzeExprFwd(obj, inEnv, JSType.UNKNOWN, instanceSpecType);
            ctorPair = this.analyzeExprFwd(ctor, objPair.env, this.commonTypes.topFunction());
        }
        ctorPair.type = JSType.BOOLEAN;
        return ctorPair;
    }

    private EnvTypePair analyzeAddFwd(Node expr, TypeEnv inEnv, JSType requiredType) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        JSType operandType = requiredType.isNumber() ? JSType.NUMBER : JSType.UNKNOWN;
        EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv, operandType);
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, operandType);
        JSType lhsType = lhsPair.type;
        JSType rhsType = rhsPair.type;
        if (lhsType.isString() || rhsType.isString()) {
            rhsPair.type = JSType.STRING;
            return rhsPair;
        }
        if (!this.commonTypes.isNumStrScalarOrObj(lhsType)) {
            this.warnInvalidOperand(lhs, expr.getType(), JSType.NUM_OR_STR, lhsType);
        }
        if (!this.commonTypes.isNumStrScalarOrObj(rhsType)) {
            this.warnInvalidOperand(rhs, expr.getType(), JSType.NUM_OR_STR, rhsType);
        }
        return new EnvTypePair(rhsPair.env, JSType.plus(lhsType, rhsType));
    }

    private EnvTypePair analyzeBinaryNumericOpFwd(Node expr, TypeEnv inEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.NUMBER);
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.NUMBER);
        if (!this.commonTypes.isNumberScalarOrObj(lhsPair.type)) {
            this.warnInvalidOperand(lhs, expr.getType(), JSType.NUMBER, lhsPair.type);
        }
        if (!this.commonTypes.isNumberScalarOrObj(rhsPair.type)) {
            this.warnInvalidOperand(rhs, expr.getType(), JSType.NUMBER, rhsPair.type);
        }
        rhsPair.type = JSType.NUMBER;
        return rhsPair;
    }

    private EnvTypePair analyzeAssignFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        if (expr.getBooleanProp(76)) {
            expr.removeProp(76);
            return new EnvTypePair(inEnv, requiredType);
        }
        this.mayWarnAboutConst(expr);
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        if (lhs.getBooleanProp(76)) {
            lhs.removeProp(76);
            JSType declType = this.markAndGetTypeOfPreanalyzedNode(lhs, inEnv, true);
            if (rhs.matchesQualifiedName(this.ABSTRACT_METHOD_NAME)) {
                return new EnvTypePair(inEnv, requiredType);
            }
            EnvTypePair rhsPair = this.analyzeExprFwd(rhs, inEnv, declType);
            if (!rhsPair.type.isSubtypeOf(declType) && !NodeUtil.isPrototypeAssignment(lhs)) {
                this.warnings.add(JSError.make(expr, MISTYPED_ASSIGN_RHS, declType.toString(), rhsPair.type.toString()));
            }
            return rhsPair;
        }
        LValueResultFwd lvalue = this.analyzeLValueFwd(lhs, inEnv, requiredType);
        JSType declType = lvalue.declType;
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lvalue.env, requiredType, specializedType);
        if (declType != null && !rhsPair.type.isSubtypeOf(declType)) {
            this.warnings.add(JSError.make(expr, MISTYPED_ASSIGN_RHS, declType.toString(), rhsPair.type.toString()));
        } else {
            rhsPair.env = this.updateLvalueTypeInEnv(rhsPair.env, lhs, lvalue.ptr, rhsPair.type);
        }
        return rhsPair;
    }

    private EnvTypePair analyzeAssignAddFwd(Node expr, TypeEnv inEnv, JSType requiredType) {
        this.mayWarnAboutConst(expr);
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        JSType lhsReqType = NewTypeInference.specializeKeep2ndWhenBottom(requiredType, JSType.NUM_OR_STR);
        LValueResultFwd lvalue = this.analyzeLValueFwd(lhs, inEnv, lhsReqType);
        JSType lhsType = lvalue.type;
        if (!lhsType.isSubtypeOf(JSType.NUM_OR_STR)) {
            this.warnInvalidOperand(lhs, 93, JSType.NUM_OR_STR, lhsType);
        }
        JSType rhsReqType = lhsType.isNumber() ? JSType.NUMBER : JSType.NUM_OR_STR;
        EnvTypePair pair = this.analyzeExprFwd(rhs, lvalue.env, rhsReqType);
        if (!pair.type.isSubtypeOf(rhsReqType)) {
            this.warnInvalidOperand(rhs, 93, rhsReqType, pair.type);
        }
        return pair;
    }

    private EnvTypePair analyzeAssignNumericOpFwd(Node expr, TypeEnv inEnv) {
        this.mayWarnAboutConst(expr);
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        LValueResultFwd lvalue = this.analyzeLValueFwd(lhs, inEnv, JSType.NUMBER);
        JSType lhsType = lvalue.type;
        boolean lhsWarned = false;
        if (!this.commonTypes.isNumberScalarOrObj(lhsType)) {
            this.warnInvalidOperand(lhs, expr.getType(), JSType.NUMBER, lhsType);
            lhsWarned = true;
        }
        EnvTypePair pair = this.analyzeExprFwd(rhs, lvalue.env, JSType.NUMBER);
        if (!this.commonTypes.isNumberScalarOrObj(pair.type)) {
            this.warnInvalidOperand(rhs, expr.getType(), JSType.NUMBER, pair.type);
        }
        if (!lhsWarned) {
            pair.env = this.updateLvalueTypeInEnv(pair.env, lhs, lvalue.ptr, JSType.NUMBER);
        }
        pair.type = JSType.NUMBER;
        return pair;
    }

    private EnvTypePair analyzeLtGtFwd(Node expr, TypeEnv inEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv);
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
        if (lhsPair.type.isScalar() && !rhsPair.type.isScalar()) {
            rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, lhsPair.type);
        } else if (rhsPair.type.isScalar()) {
            lhsPair = this.analyzeExprFwd(lhs, inEnv, rhsPair.type);
            rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, rhsPair.type);
        }
        JSType lhsType = lhsPair.type;
        JSType rhsType = rhsPair.type;
        if (!(lhsType.isSubtypeOf(rhsType) || rhsType.isSubtypeOf(lhsType) || lhsType.isBoolean() && rhsType.isBoolean())) {
            this.warnInvalidOperand(expr, expr.getType(), "matching types", lhsType + ", " + rhsType);
        }
        rhsPair.type = JSType.BOOLEAN;
        return rhsPair;
    }

    private EnvTypePair analyzeHookFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        Node cond = expr.getFirstChild();
        Node thenBranch = cond.getNext();
        Node elseBranch = thenBranch.getNext();
        TypeEnv trueEnv = this.analyzeExprFwd((Node)cond, (TypeEnv)inEnv, (JSType)JSType.UNKNOWN, (JSType)JSType.TRUTHY).env;
        TypeEnv falseEnv = this.analyzeExprFwd((Node)cond, (TypeEnv)inEnv, (JSType)JSType.UNKNOWN, (JSType)JSType.FALSY).env;
        EnvTypePair thenPair = this.analyzeExprFwd(thenBranch, trueEnv, requiredType, specializedType);
        EnvTypePair elsePair = this.analyzeExprFwd(elseBranch, falseEnv, requiredType, specializedType);
        return EnvTypePair.join(thenPair, elsePair);
    }

    private EnvTypePair analyzeCallNewFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        JSType retType;
        String calleeName;
        FunctionType funType;
        if (this.isPropertyTestCall(expr)) {
            return this.analyzePropertyTestCallFwd(expr, inEnv, specializedType);
        }
        Node callee = expr.getFirstChild();
        if (this.isFunctionBind(callee, inEnv, true)) {
            return this.analyzeFunctionBindFwd(expr, inEnv);
        }
        CodingConvention.AssertionFunctionSpec assertionFunctionSpec = this.assertionFunctionsMap.get(callee.getQualifiedName());
        if (assertionFunctionSpec != null) {
            return this.analyzeAssertionCall(expr, inEnv, assertionFunctionSpec);
        }
        EnvTypePair calleePair = this.analyzeExprFwd(callee, inEnv, this.commonTypes.topFunction());
        TypeEnv envAfterCallee = calleePair.env;
        calleePair = this.mayWarnAboutNullableReferenceAndTighten(callee, calleePair.type, null, envAfterCallee);
        JSType calleeType = calleePair.type;
        if (calleeType.isBottom() || !calleeType.isSubtypeOf(this.commonTypes.topFunction())) {
            this.warnings.add(JSError.make(expr, NOT_CALLABLE, calleeType.toString()));
        }
        if ((funType = calleeType.getFunTypeIfSingletonObj()) == null || funType.isTopFunction() || funType.isQmarkFunction()) {
            return this.analyzeCallNodeArgsFwdWhenError(expr, envAfterCallee);
        }
        if (funType.isLoose()) {
            return this.analyzeLooseCallNodeFwd(expr, envAfterCallee, requiredType);
        }
        if (expr.isCall() && funType.isSomeConstructorOrInterface() && funType.getReturnType().isUnknown()) {
            this.warnings.add(JSError.make(expr, CONSTRUCTOR_NOT_CALLABLE, funType.toString()));
            return this.analyzeCallNodeArgsFwdWhenError(expr, envAfterCallee);
        }
        if (expr.isNew() && (!funType.isSomeConstructorOrInterface() || funType.isInterfaceDefinition())) {
            this.warnings.add(JSError.make(expr, NOT_A_CONSTRUCTOR, funType.toString()));
            return this.analyzeCallNodeArgsFwdWhenError(expr, envAfterCallee);
        }
        int maxArity = funType.getMaxArity();
        int minArity = funType.getMinArity();
        int numArgs = expr.getChildCount() - 1;
        if (numArgs < minArity || numArgs > maxArity) {
            this.warnings.add(JSError.make(expr, WRONG_ARGUMENT_COUNT, NewTypeInference.getReadableCalleeName(callee), Integer.toString(numArgs), Integer.toString(minArity), " and at most " + maxArity));
            return this.analyzeCallNodeArgsFwdWhenError(expr, envAfterCallee);
        }
        FunctionType origFunType = funType;
        if (funType.isGeneric()) {
            Map<String, JSType> typeMap = this.calcTypeInstantiationFwd(expr, callee.isGetProp() ? callee.getFirstChild() : null, expr.getSecondChild(), funType, envAfterCallee);
            funType = funType.instantiateGenerics(typeMap);
            NewTypeInference.println("Instantiated function type: " + funType);
        }
        ArrayList<JSType> argTypes = new ArrayList<JSType>();
        TypeEnv tmpEnv = this.analyzeCallNodeArgumentsFwd(expr, expr.getSecondChild(), funType, argTypes, envAfterCallee);
        if (callee.isName() && this.currentScope.isKnownFunction(calleeName = callee.getString()) && !this.currentScope.isExternalFunction(calleeName)) {
            if (this.currentScope.isLocalFunDef(calleeName)) {
                tmpEnv = this.collectTypesForFreeVarsFwd(callee, tmpEnv);
            } else if (!origFunType.isGeneric()) {
                DeferredCheck dc;
                JSType expectedRetType = requiredType;
                NewTypeInference.println("Updating deferred check with ret: ", expectedRetType, " and args: ", argTypes);
                if (expr.isCall()) {
                    dc = this.deferredChecks.get(expr);
                    if (dc != null) {
                        dc.updateReturn(expectedRetType);
                    } else {
                        Preconditions.checkState((!this.currentScope.hasUndeclaredFormalsOrOuters() ? 1 : 0) != 0, (String)"No deferred check created in backward direction for %s", (Object[])new Object[]{expr});
                    }
                } else {
                    dc = new DeferredCheck(expr, null, this.currentScope, this.currentScope.getScope(calleeName));
                    this.deferredChecks.put(expr, dc);
                }
                if (dc != null) {
                    dc.updateArgTypes(argTypes);
                }
            }
        }
        JSType jSType = retType = expr.isNew() ? funType.getThisType() : funType.getReturnType();
        if (retType.isSubtypeOf(requiredType)) {
            retType = retType.specialize(specializedType);
        }
        return new EnvTypePair(tmpEnv, retType);
    }

    private EnvTypePair analyzeFunctionBindFwd(Node call, TypeEnv inEnv) {
        Preconditions.checkArgument((boolean)call.isCall());
        CodingConvention.Bind bindComponents = this.convention.describeFunctionBind(call, true, false);
        Node boundFunNode = bindComponents.target;
        EnvTypePair pair = this.analyzeExprFwd(boundFunNode, inEnv);
        TypeEnv env = pair.env;
        FunctionType boundFunType = pair.type.getFunTypeIfSingletonObj();
        if (!pair.type.isSubtypeOf(this.commonTypes.topFunction())) {
            this.warnings.add(JSError.make(boundFunNode, GOOG_BIND_EXPECTS_FUNCTION, pair.type.toString()));
        }
        if (boundFunType == null || boundFunType.isTopFunction() || boundFunType.isQmarkFunction() || boundFunType.isLoose()) {
            return this.analyzeCallNodeArgsFwdWhenError(call, env);
        }
        if (boundFunType.isSomeConstructorOrInterface()) {
            this.warnings.add(JSError.make(call, CANNOT_BIND_CTOR, new String[0]));
            return new EnvTypePair(env, JSType.UNKNOWN);
        }
        if (NodeUtil.isGoogBind(call.getFirstChild()) && call.getChildCount() <= 2 || !NodeUtil.isGoogPartial(call.getFirstChild()) && call.getChildCount() == 1) {
            this.warnings.add(JSError.make(call, WRONG_ARGUMENT_COUNT, NewTypeInference.getReadableCalleeName(call.getFirstChild()), "0", "1", ""));
        }
        int maxArity = boundFunType.hasRestFormals() ? Integer.MAX_VALUE : boundFunType.getMaxArity();
        int numArgs = bindComponents.getBoundParameterCount();
        if (numArgs > maxArity) {
            this.warnings.add(JSError.make(call, WRONG_ARGUMENT_COUNT, NewTypeInference.getReadableCalleeName(call.getFirstChild()), Integer.toString(numArgs), "0", " and at most " + maxArity));
            return this.analyzeCallNodeArgsFwdWhenError(call, inEnv);
        }
        Node receiver = bindComponents.thisValue;
        if (boundFunType.isGeneric()) {
            Map<String, JSType> typeMap = this.calcTypeInstantiationFwd(call, receiver, bindComponents.parameters, boundFunType, env);
            boundFunType = boundFunType.instantiateGenerics(typeMap);
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        if (receiver != null) {
            JSType reqThisType = boundFunType.getThisType();
            if (reqThisType == null || boundFunType.isSomeConstructorOrInterface()) {
                reqThisType = JSType.join(JSType.NULL, JSType.TOP_OBJECT);
            }
            pair = this.analyzeExprFwd(receiver, env, reqThisType);
            env = pair.env;
            if (!pair.type.isSubtypeOf(reqThisType)) {
                this.warnings.add(JSError.make(call, INVALID_THIS_TYPE_IN_BIND, pair.type.toString(), reqThisType.toString()));
            }
        }
        env = this.analyzeCallNodeArgumentsFwd(call, bindComponents.parameters, boundFunType, new ArrayList<JSType>(), env);
        for (int j = numArgs; j < boundFunType.getMaxArityWithoutRestFormals(); ++j) {
            JSType formalType = boundFunType.getFormalType(j);
            if (boundFunType.isRequiredArg(j)) {
                builder.addReqFormal(formalType);
                continue;
            }
            builder.addOptFormal(formalType);
        }
        if (boundFunType.hasRestFormals()) {
            builder.addRestFormals(boundFunType.getRestFormalsType());
        }
        return new EnvTypePair(env, this.commonTypes.fromFunctionType(builder.addRetType(boundFunType.getReturnType()).buildFunction()));
    }

    private TypeEnv analyzeCallNodeArgumentsFwd(Node call, Node firstArg, FunctionType funType, List<JSType> argTypesForDeferredCheck, TypeEnv inEnv) {
        TypeEnv env = inEnv;
        Node arg = firstArg;
        int i = 0;
        while (arg != null) {
            JSType formalType = funType.getFormalType(i);
            Preconditions.checkState((!formalType.isBottom() ? 1 : 0) != 0);
            EnvTypePair pair = this.analyzeExprFwd(arg, env, formalType);
            JSType argTypeForDeferredCheck = pair.type;
            if (funType.isOptionalArg(i) && pair.type.equals(JSType.UNDEFINED)) {
                argTypeForDeferredCheck = null;
            } else if (!pair.type.isSubtypeOf(formalType)) {
                String fnName = NewTypeInference.getReadableCalleeName(call.getFirstChild());
                this.warnings.add(JSError.make(arg, INVALID_ARGUMENT_TYPE, Integer.toString(i + 1), fnName, formalType.toString(), pair.type.toString()));
                argTypeForDeferredCheck = null;
            }
            argTypesForDeferredCheck.add(argTypeForDeferredCheck);
            env = pair.env;
            arg = arg.getNext();
            ++i;
        }
        return env;
    }

    private EnvTypePair analyzeAssertionCall(Node callNode, TypeEnv env, CodingConvention.AssertionFunctionSpec assertionFunctionSpec) {
        Node firstParam = callNode.getSecondChild();
        if (firstParam == null) {
            return new EnvTypePair(env, JSType.UNKNOWN);
        }
        Node assertedNode = assertionFunctionSpec.getAssertedParam(firstParam);
        if (assertedNode == null) {
            return new EnvTypePair(env, JSType.UNKNOWN);
        }
        JSType assertedType = assertionFunctionSpec.getAssertedNewType(callNode, this.currentScope);
        if (assertedType.isUnknown()) {
            this.warnings.add(JSError.make(callNode, UNKNOWN_ASSERTION_TYPE, new String[0]));
        }
        EnvTypePair pair = this.analyzeExprFwd(assertedNode, env, JSType.UNKNOWN, assertedType);
        if (pair.type.isBottom()) {
            JSType t = this.analyzeExprFwd((Node)assertedNode, (TypeEnv)env).type.substituteGenericsWithUnknown();
            if (t.isSubtypeOf(assertedType)) {
                pair.type = t;
            } else {
                this.warnings.add(JSError.make(assertedNode, ASSERT_FALSE, new String[0]));
                pair.type = JSType.UNKNOWN;
                pair.env = env;
            }
        }
        return pair;
    }

    private EnvTypePair analyzeGetElemFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        Node receiver = expr.getFirstChild();
        Node index = expr.getLastChild();
        JSType reqObjType = NewTypeInference.pickReqObjType(expr);
        EnvTypePair pair = this.analyzeExprFwd(receiver, inEnv, reqObjType);
        pair = this.mayWarnAboutNullableReferenceAndTighten(receiver, pair.type, null, pair.env);
        JSType recvType = pair.type.autobox();
        if (!this.mayWarnAboutNonObject(receiver, recvType, specializedType) && !this.mayWarnAboutStructPropAccess(receiver, recvType)) {
            JSType indexType = recvType.getIndexType();
            if (indexType != null) {
                pair = this.analyzeExprFwd(index, pair.env, indexType.isBottom() ? JSType.UNKNOWN : indexType);
                this.mayWarnAboutBadIObjectIndex(index, recvType, pair.type, indexType);
                pair.type = recvType.getIndexedType();
                return pair;
            }
            if (index.isString()) {
                return this.analyzePropAccessFwd(receiver, index.getString(), inEnv, requiredType, specializedType);
            }
        }
        pair = this.analyzeExprFwd(index, pair.env);
        pair.type = JSType.UNKNOWN;
        return pair;
    }

    private EnvTypePair analyzeInFwd(Node expr, TypeEnv inEnv, JSType specializedType) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        JSType reqObjType = NewTypeInference.pickReqObjType(expr);
        EnvTypePair pair = this.analyzeExprFwd(lhs, inEnv, JSType.NUM_OR_STR);
        if (!pair.type.isSubtypeOf(JSType.NUM_OR_STR)) {
            this.warnInvalidOperand(lhs, 51, JSType.NUM_OR_STR, pair.type);
        }
        pair = this.analyzeExprFwd(rhs, pair.env, reqObjType);
        if (!pair.type.isSubtypeOf(JSType.TOP_OBJECT)) {
            this.warnInvalidOperand(rhs, 51, "Object", pair.type);
            pair.type = JSType.BOOLEAN;
            return pair;
        }
        if (pair.type.isStruct()) {
            this.warnings.add(JSError.make(rhs, IN_USED_WITH_STRUCT, new String[0]));
            pair.type = JSType.BOOLEAN;
            return pair;
        }
        JSType resultType = JSType.BOOLEAN;
        if (lhs.isString()) {
            QualifiedName pname = new QualifiedName(lhs.getString());
            if (specializedType.isTrueOrTruthy()) {
                pair = this.analyzeExprFwd(rhs, inEnv, reqObjType, reqObjType.withPropertyRequired(pname.getLeftmostName()));
                resultType = JSType.TRUE_TYPE;
            } else if (specializedType.isFalseOrFalsy()) {
                pair = this.analyzeExprFwd(rhs, inEnv, reqObjType);
                pair = this.analyzeExprFwd(rhs, inEnv, reqObjType, pair.type.withoutProperty(pname));
                resultType = JSType.FALSE_TYPE;
            }
        }
        pair.type = resultType;
        return pair;
    }

    private EnvTypePair analyzeArrayLitFwd(Node expr, TypeEnv inEnv) {
        TypeEnv env = inEnv;
        JSType elementType = JSType.BOTTOM;
        for (Node arrayElm = expr.getFirstChild(); arrayElm != null; arrayElm = arrayElm.getNext()) {
            EnvTypePair pair = this.analyzeExprFwd(arrayElm, env);
            env = pair.env;
            elementType = JSType.join(elementType, pair.type);
        }
        if (elementType.isBottom()) {
            elementType = JSType.UNKNOWN;
        }
        return new EnvTypePair(env, this.commonTypes.getArrayInstance(elementType));
    }

    private EnvTypePair analyzeCastFwd(Node expr, TypeEnv inEnv) {
        EnvTypePair pair = this.analyzeExprFwd(expr.getFirstChild(), inEnv);
        JSType fromType = pair.type;
        JSType toType = this.symbolTable.getCastType(expr);
        if (!JSType.haveCommonSubtype(fromType, toType) && !fromType.hasTypeVariable()) {
            this.warnings.add(JSError.make(expr, INVALID_CAST, fromType.toString(), toType.toString()));
        }
        pair.type = toType;
        return pair;
    }

    private EnvTypePair analyzeCallNodeArgsFwdWhenError(Node callNode, TypeEnv inEnv) {
        TypeEnv env = inEnv;
        for (Node arg = callNode.getSecondChild(); arg != null; arg = arg.getNext()) {
            env = this.analyzeExprFwd((Node)arg, (TypeEnv)env).env;
        }
        return new EnvTypePair(env, JSType.UNKNOWN);
    }

    private EnvTypePair analyzeStrictComparisonFwd(int comparisonOp, Node lhs, Node rhs, TypeEnv inEnv, JSType specializedType) {
        if (specializedType.isTrueOrTruthy() || specializedType.isFalseOrFalsy()) {
            if (lhs.isTypeOf()) {
                return this.analyzeSpecializedTypeof(lhs, rhs, comparisonOp, inEnv, specializedType);
            }
            if (rhs.isTypeOf()) {
                return this.analyzeSpecializedTypeof(rhs, lhs, comparisonOp, inEnv, specializedType);
            }
            if (this.isGoogTypeof(lhs)) {
                return this.analyzeGoogTypeof(lhs, rhs, inEnv, specializedType);
            }
            if (this.isGoogTypeof(rhs)) {
                return this.analyzeGoogTypeof(rhs, lhs, inEnv, specializedType);
            }
        }
        EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv);
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
        TypeEnv preciseEnv = rhsPair.env;
        if (comparisonOp == 45 && specializedType.isTrueOrTruthy() || comparisonOp == 46 && specializedType.isFalseOrFalsy()) {
            JSType meetType = JSType.meet(lhsPair.type, rhsPair.type);
            lhsPair = this.analyzeExprFwd(lhs, preciseEnv, JSType.UNKNOWN, meetType);
            rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.UNKNOWN, meetType);
        } else if (comparisonOp == 45 && specializedType.isFalseOrFalsy() || comparisonOp == 46 && specializedType.isTrueOrTruthy()) {
            JSType lhsType = lhsPair.type;
            JSType rhsType = rhsPair.type;
            if (lhsType.isNullOrUndef()) {
                rhsType = rhsType.removeType(lhsType);
            } else if (rhsType.isNullOrUndef()) {
                lhsType = lhsType.removeType(rhsType);
            }
            lhsPair = this.analyzeExprFwd(lhs, preciseEnv, JSType.UNKNOWN, lhsType);
            rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.UNKNOWN, rhsType);
        }
        rhsPair.type = JSType.BOOLEAN;
        return rhsPair;
    }

    private EnvTypePair analyzeSpecializedTypeof(Node typeof, Node typeString, int comparisonOp, TypeEnv inEnv, JSType specializedType) {
        EnvTypePair pair;
        Node typeofRand = typeof.getFirstChild();
        JSType comparedType = this.getTypeFromString(typeString);
        this.checkInvalidTypename(typeString);
        if (comparedType.isUnknown()) {
            pair = this.analyzeExprFwd(typeofRand, inEnv);
            pair = this.analyzeExprFwd(typeString, pair.env);
        } else if (specializedType.isTrueOrTruthy() && (comparisonOp == 45 || comparisonOp == 12) || specializedType.isFalseOrFalsy() && (comparisonOp == 46 || comparisonOp == 13)) {
            pair = this.analyzeExprFwd(typeofRand, inEnv, JSType.UNKNOWN, comparedType);
        } else {
            pair = this.analyzeExprFwd(typeofRand, inEnv);
            JSType rmType = pair.type.removeType(comparedType);
            if (!rmType.isBottom()) {
                pair = this.analyzeExprFwd(typeofRand, inEnv, JSType.UNKNOWN, rmType);
            }
        }
        pair.type = specializedType.toBoolean();
        return pair;
    }

    private JSType getTypeFromString(Node typeString) {
        if (!typeString.isString()) {
            return JSType.UNKNOWN;
        }
        switch (typeString.getString()) {
            case "number": {
                return JSType.NUMBER;
            }
            case "string": {
                return JSType.STRING;
            }
            case "boolean": {
                return JSType.BOOLEAN;
            }
            case "undefined": {
                return JSType.UNDEFINED;
            }
            case "function": {
                return this.commonTypes.looseTopFunction();
            }
            case "object": {
                return JSType.join(JSType.NULL, JSType.TOP_OBJECT);
            }
        }
        return JSType.UNKNOWN;
    }

    private void checkInvalidTypename(Node typeString) {
        String typeName;
        if (!typeString.isString()) {
            return;
        }
        switch (typeName = typeString.getString()) {
            case "number": 
            case "string": 
            case "boolean": 
            case "undefined": 
            case "function": 
            case "object": 
            case "unknown": {
                break;
            }
            default: {
                this.warnings.add(JSError.make(typeString, UNKNOWN_TYPEOF_VALUE, typeName));
            }
        }
    }

    private Map<String, JSType> calcTypeInstantiationFwd(Node callNode, Node receiver, Node firstArg, FunctionType funType, TypeEnv typeEnv) {
        return this.calcTypeInstantiation(callNode, receiver, firstArg, funType, typeEnv, true);
    }

    private Map<String, JSType> calcTypeInstantiationBwd(Node callNode, FunctionType funType, TypeEnv typeEnv) {
        return this.calcTypeInstantiation(callNode, null, callNode.getSecondChild(), funType, typeEnv, false);
    }

    private ImmutableMap<String, JSType> calcTypeInstantiation(Node callNode, Node receiver, Node firstArg, FunctionType funType, TypeEnv typeEnv, boolean isFwd) {
        Preconditions.checkState((receiver == null || isFwd ? 1 : 0) != 0);
        List<String> typeParameters = funType.getTypeParameters();
        LinkedHashMultimap typeMultimap = LinkedHashMultimap.create();
        JSType funRecvType = funType.getThisType();
        if (receiver != null && funRecvType != null && !funRecvType.isSingletonObj()) {
            EnvTypePair pair = this.analyzeExprFwd(receiver, typeEnv);
            this.unifyWithSubtypeWarnIfFail(funRecvType, pair.type, typeParameters, (Multimap<String, JSType>)typeMultimap, receiver, isFwd);
            typeEnv = pair.env;
        }
        Node arg = firstArg;
        int i = 0;
        while (arg != null) {
            EnvTypePair pair = isFwd ? this.analyzeExprFwd(arg, typeEnv) : this.analyzeExprBwd(arg, typeEnv);
            this.unifyWithSubtypeWarnIfFail(funType.getFormalType(i), pair.type, typeParameters, (Multimap<String, JSType>)typeMultimap, arg, isFwd);
            arg = arg.getNext();
            typeEnv = pair.env;
            ++i;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String typeParam : typeParameters) {
            Collection types = typeMultimap.get((Object)typeParam);
            if (types.size() > 1) {
                if (isFwd) {
                    this.warnings.add(JSError.make(callNode, NOT_UNIQUE_INSTANTIATION, funType.toString(), UniqueNameGenerator.getOriginalName(typeParam), types.toString()));
                }
                builder.put((Object)typeParam, (Object)JSType.UNKNOWN);
                continue;
            }
            if (types.size() == 1) {
                JSType t = (JSType)Iterables.getOnlyElement((Iterable)types);
                builder.put((Object)typeParam, (Object)(t.isBottom() ? JSType.UNKNOWN : t));
                continue;
            }
            builder.put((Object)typeParam, (Object)JSType.UNKNOWN);
        }
        return builder.build();
    }

    private void unifyWithSubtypeWarnIfFail(JSType genericType, JSType concreteType, List<String> typeParameters, Multimap<String, JSType> typeMultimap, Node toWarnOn, boolean isFwd) {
        JSType afterInstantiation;
        if (!genericType.unifyWith(concreteType, typeParameters, typeMultimap) && isFwd && !genericType.equals(afterInstantiation = genericType.substituteGenericsWithUnknown()) && concreteType.isSubtypeOf(afterInstantiation)) {
            this.warnings.add(JSError.make(toWarnOn, FAILED_TO_UNIFY, genericType.toString(), concreteType.toString()));
        }
    }

    private EnvTypePair analyzeNonStrictComparisonFwd(Node expr, TypeEnv inEnv, JSType specializedType) {
        int tokenType = expr.getType();
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        if (specializedType.isTrueOrTruthy() || specializedType.isFalseOrFalsy()) {
            if (lhs.isTypeOf()) {
                return this.analyzeSpecializedTypeof(lhs, rhs, tokenType, inEnv, specializedType);
            }
            if (rhs.isTypeOf()) {
                return this.analyzeSpecializedTypeof(rhs, lhs, tokenType, inEnv, specializedType);
            }
            if (this.isGoogTypeof(lhs)) {
                return this.analyzeGoogTypeof(lhs, rhs, inEnv, specializedType);
            }
            if (this.isGoogTypeof(rhs)) {
                return this.analyzeGoogTypeof(rhs, lhs, inEnv, specializedType);
            }
        }
        EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv);
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
        TypeEnv preciseEnv = rhsPair.env;
        JSType lhsType = lhsPair.type;
        JSType rhsType = rhsPair.type;
        if (tokenType == 12 && specializedType.isTrueOrTruthy() || tokenType == 13 && specializedType.isFalseOrFalsy()) {
            if (lhsType.isNullOrUndef()) {
                rhsPair = this.analyzeExprFwd(rhs, preciseEnv, JSType.UNKNOWN, JSType.NULL_OR_UNDEF);
            } else if (rhsType.isNullOrUndef()) {
                lhsPair = this.analyzeExprFwd(lhs, preciseEnv, JSType.UNKNOWN, JSType.NULL_OR_UNDEF);
                rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
            } else if (!JSType.NULL.isSubtypeOf(lhsType) && !JSType.UNDEFINED.isSubtypeOf(lhsType)) {
                rhsType = rhsType.removeType(JSType.NULL_OR_UNDEF);
                rhsPair = this.analyzeExprFwd(rhs, preciseEnv, JSType.UNKNOWN, rhsType);
            } else if (!JSType.NULL.isSubtypeOf(rhsType) && !JSType.UNDEFINED.isSubtypeOf(rhsType)) {
                lhsType = lhsType.removeType(JSType.NULL_OR_UNDEF);
                lhsPair = this.analyzeExprFwd(lhs, preciseEnv, JSType.UNKNOWN, lhsType);
                rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
            }
        } else if (tokenType == 12 && specializedType.isFalseOrFalsy() || tokenType == 13 && specializedType.isTrueOrTruthy()) {
            if (lhsType.isNullOrUndef()) {
                rhsType = rhsType.removeType(JSType.NULL_OR_UNDEF);
                rhsPair = this.analyzeExprFwd(rhs, preciseEnv, JSType.UNKNOWN, rhsType);
            } else if (rhsType.isNullOrUndef()) {
                lhsType = lhsType.removeType(JSType.NULL_OR_UNDEF);
                lhsPair = this.analyzeExprFwd(lhs, preciseEnv, JSType.UNKNOWN, lhsType);
                rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
            }
        }
        rhsPair.type = JSType.BOOLEAN;
        return rhsPair;
    }

    private EnvTypePair analyzeObjLitFwd(Node objLit, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        if (NodeUtil.isEnumDecl(objLit.getParent())) {
            return this.analyzeEnumObjLitFwd(objLit, inEnv, requiredType);
        }
        JSDocInfo jsdoc = objLit.getJSDocInfo();
        boolean isStruct = jsdoc != null && jsdoc.makesStructs();
        boolean isDict = jsdoc != null && jsdoc.makesDicts();
        TypeEnv env = inEnv;
        JSType result = NewTypeInference.pickReqObjType(objLit);
        for (Node prop : objLit.children()) {
            JSType reqPtype;
            JSType specPtype;
            if (isStruct && prop.isQuotedString()) {
                this.warnings.add(JSError.make(prop, ILLEGAL_OBJLIT_KEY, "struct"));
            } else if (isDict && !prop.isQuotedString()) {
                this.warnings.add(JSError.make(prop, ILLEGAL_OBJLIT_KEY, "dict"));
            }
            String pname = NodeUtil.getObjectLitKeyName(prop);
            if (prop.isGetterDef() || prop.isSetterDef()) {
                JSType propType;
                String specialPropName;
                EnvTypePair pair = this.analyzeExprFwd(prop.getFirstChild(), env);
                FunctionType funType = pair.type.getFunType();
                Preconditions.checkNotNull((Object)funType);
                if (prop.isGetterDef()) {
                    specialPropName = GETTER_PREFIX + pname;
                    propType = funType.getReturnType();
                } else {
                    specialPropName = SETTER_PREFIX + pname;
                    propType = pair.type;
                }
                result = result.withProperty(new QualifiedName(specialPropName), propType);
                env = pair.env;
                continue;
            }
            QualifiedName qname = new QualifiedName(pname);
            JSType jsdocType = this.symbolTable.getPropDeclaredType(prop);
            if (jsdocType != null) {
                reqPtype = specPtype = jsdocType;
            } else if (requiredType.mayHaveProp(qname)) {
                reqPtype = specPtype = requiredType.getProp(qname);
                if (specializedType.mayHaveProp(qname)) {
                    specPtype = specializedType.getProp(qname);
                }
            } else {
                reqPtype = specPtype = JSType.UNKNOWN;
            }
            EnvTypePair pair = this.analyzeExprFwd(prop.getFirstChild(), env, reqPtype, specPtype);
            if (jsdocType != null) {
                result = result.withDeclaredProperty(qname, jsdocType, false);
                if (!pair.type.isSubtypeOf(jsdocType)) {
                    this.warnings.add(JSError.make(prop, INVALID_OBJLIT_PROPERTY_TYPE, jsdocType.toString(), pair.type.toString()));
                    pair.type = jsdocType;
                }
            }
            result = result.withProperty(qname, pair.type);
            env = pair.env;
        }
        return new EnvTypePair(env, result);
    }

    private EnvTypePair analyzeEnumObjLitFwd(Node objLit, TypeEnv inEnv, JSType requiredType) {
        if (objLit.getFirstChild() == null) {
            return new EnvTypePair(inEnv, requiredType);
        }
        String pname = NodeUtil.getObjectLitKeyName(objLit.getFirstChild());
        JSType enumeratedType = requiredType.getProp(new QualifiedName(pname)).getEnumeratedType();
        if (enumeratedType == null) {
            return new EnvTypePair(inEnv, requiredType);
        }
        TypeEnv env = inEnv;
        for (Node prop : objLit.children()) {
            EnvTypePair pair = this.analyzeExprFwd(prop.getFirstChild(), env, enumeratedType);
            if (!pair.type.isSubtypeOf(enumeratedType)) {
                this.warnings.add(JSError.make(prop, INVALID_OBJLIT_PROPERTY_TYPE, enumeratedType.toString(), pair.type.toString()));
            }
            env = pair.env;
        }
        return new EnvTypePair(env, requiredType);
    }

    private EnvTypePair analyzeTypePredicate(Node call, String typeHint, TypeEnv inEnv, JSType specializedType) {
        int numArgs = call.getChildCount() - 1;
        if (numArgs != 1) {
            this.warnings.add(JSError.make(call, WRONG_ARGUMENT_COUNT, call.getFirstChild().getQualifiedName(), Integer.toString(numArgs), "1", "1"));
            return this.analyzeCallNodeArgsFwdWhenError(call, inEnv);
        }
        EnvTypePair pair = this.analyzeExprFwd(call.getLastChild(), inEnv);
        if (specializedType.isTrueOrTruthy() || specializedType.isFalseOrFalsy()) {
            pair = this.analyzeExprFwd(call.getLastChild(), inEnv, JSType.UNKNOWN, this.predicateTransformType(typeHint, specializedType, pair.type));
        }
        pair.type = JSType.BOOLEAN;
        return pair;
    }

    private EnvTypePair analyzeGoogTypeof(Node typeof, Node typeString, TypeEnv inEnv, JSType specializedType) {
        return this.analyzeTypePredicate(typeof, typeString.isString() ? typeString.getString() : "", inEnv, specializedType);
    }

    private EnvTypePair analyzePropertyTestCallFwd(Node call, TypeEnv inEnv, JSType specializedType) {
        return this.analyzeTypePredicate(call, call.getFirstChild().getLastChild().getString(), inEnv, specializedType);
    }

    private JSType predicateTransformType(String typeHint, JSType booleanContext, JSType beforeType) {
        switch (typeHint) {
            case "array": 
            case "isArray": {
                JSType arrayType = this.commonTypes.getArrayInstance();
                if (arrayType.isUnknown()) {
                    return JSType.UNKNOWN;
                }
                return booleanContext.isTrueOrTruthy() ? arrayType : beforeType.removeType(arrayType);
            }
            case "isArrayLike": {
                return JSType.TOP_OBJECT.withProperty(new QualifiedName("length"), JSType.NUMBER);
            }
            case "boolean": 
            case "isBoolean": {
                return booleanContext.isTrueOrTruthy() ? JSType.BOOLEAN : beforeType.removeType(JSType.BOOLEAN);
            }
            case "function": 
            case "isFunction": {
                return booleanContext.isTrueOrTruthy() ? this.commonTypes.looseTopFunction() : beforeType.removeType(this.commonTypes.topFunction());
            }
            case "null": 
            case "isNull": {
                return booleanContext.isTrueOrTruthy() ? JSType.NULL : beforeType.removeType(JSType.NULL);
            }
            case "number": 
            case "isNumber": {
                return booleanContext.isTrueOrTruthy() ? JSType.NUMBER : beforeType.removeType(JSType.NUMBER);
            }
            case "string": 
            case "isString": {
                return booleanContext.isTrueOrTruthy() ? JSType.STRING : beforeType.removeType(JSType.STRING);
            }
            case "isDef": {
                return booleanContext.isTrueOrTruthy() ? beforeType.removeType(JSType.UNDEFINED) : JSType.UNDEFINED;
            }
            case "isDefAndNotNull": {
                return booleanContext.isTrueOrTruthy() ? beforeType.removeType(JSType.NULL_OR_UNDEF) : JSType.NULL_OR_UNDEF;
            }
            case "isObject": {
                return booleanContext.isTrueOrTruthy() ? JSType.TOP_OBJECT : beforeType.removeType(JSType.TOP_OBJECT);
            }
            case "object": {
                return JSType.UNKNOWN;
            }
            case "undefined": {
                return booleanContext.isTrueOrTruthy() ? JSType.UNDEFINED : beforeType.removeType(JSType.UNDEFINED);
            }
        }
        return JSType.UNKNOWN;
    }

    private boolean tightenTypeAndDontWarn(String varName, Node n, JSType declared, JSType inferred, JSType required) {
        boolean isSpecializableTop = declared != null && declared.isTop() && (!inferred.isTop() || NodeUtil.isPropertyTest(this.compiler, n.getParent()));
        boolean fuzzyDeclaration = declared == null || declared.isUnknown() || isSpecializableTop;
        return fuzzyDeclaration && (varName == null || this.currentScope.isFormalParam(varName) || this.currentScope.isOuterVar(varName)) && required.isNonLooseSubtypeOf(inferred);
    }

    private boolean mayWarnAboutNonObject(Node receiver, JSType recvType, JSType specializedType) {
        boolean mayNotBeAnObject;
        if (recvType.isBottom()) {
            return true;
        }
        boolean isNotAnObject = !JSType.haveCommonSubtype(recvType, JSType.TOP_OBJECT);
        boolean bl = mayNotBeAnObject = !recvType.isSubtypeOf(JSType.TOP_OBJECT);
        if (isNotAnObject || !specializedType.isTrueOrTruthy() && !specializedType.isFalseOrFalsy() && mayNotBeAnObject) {
            this.warnings.add(JSError.make(receiver, PROPERTY_ACCESS_ON_NONOBJECT, this.getPropNameForErrorMsg(receiver.getParent()), recvType.toString()));
            return true;
        }
        return false;
    }

    private String getPropNameForErrorMsg(Node propAccessNode) {
        Preconditions.checkArgument((propAccessNode.isGetProp() || propAccessNode.isGetElem() ? 1 : 0) != 0);
        Node propNode = propAccessNode.getLastChild();
        if (propNode.isString()) {
            return propNode.getString();
        }
        if (propNode.isQualifiedName()) {
            return "[" + propNode.getQualifiedName() + "]";
        }
        return "[unknown property]";
    }

    private boolean mayWarnAboutStructPropAccess(Node obj, JSType type) {
        if (type.mayBeStruct()) {
            this.warnings.add(JSError.make(obj, ILLEGAL_PROPERTY_ACCESS, "'[]'", "struct"));
            return true;
        }
        return false;
    }

    private boolean mayWarnAboutDictPropAccess(Node obj, JSType type) {
        if (type.mayBeDict()) {
            this.warnings.add(JSError.make(obj, ILLEGAL_PROPERTY_ACCESS, "'.'", "dict"));
            return true;
        }
        return false;
    }

    private boolean mayWarnAboutPropCreation(QualifiedName pname, Node getProp, JSType recvType) {
        Preconditions.checkArgument((boolean)getProp.isGetProp());
        if (recvType.mayBeStruct() && !recvType.hasProp(pname)) {
            this.warnings.add(JSError.make(getProp, ILLEGAL_PROPERTY_CREATION, pname.toString()));
            return true;
        }
        return false;
    }

    private boolean isPropertyAbsentTest(Node propAccessNode) {
        Node parent = propAccessNode.getParent();
        if (parent.getType() == 12 || parent.getType() == 45) {
            Node other = parent.getFirstChild() == propAccessNode ? parent.getSecondChild() : parent.getFirstChild();
            return NodeUtil.isUndefined(other);
        }
        return false;
    }

    private boolean mayWarnAboutInexistentProp(Node propAccessNode, JSType recvType, QualifiedName propQname, TypeEnv env) {
        if (!propAccessNode.isGetProp() || this.isPropertyAbsentTest(propAccessNode) || recvType.hasProp(propQname)) {
            return false;
        }
        Node recv = propAccessNode.getFirstChild();
        if (recvType.isLoose()) {
            this.updateLvalueTypeInEnv(env, recv, QualifiedName.fromNode(recv), JSType.UNKNOWN);
            return false;
        }
        String recvTypeAsString = recvType.toString();
        String pname = propQname.toString();
        String errorMsg = !recv.isQualifiedName() ? recvTypeAsString : (recvTypeAsString.length() > 100 ? recv.getQualifiedName() : recv.getQualifiedName() + " of type " + recvTypeAsString);
        DiagnosticType warningType = recvType.mayHaveProp(propQname) ? POSSIBLY_INEXISTENT_PROPERTY : INEXISTENT_PROPERTY;
        this.warnings.add(JSError.make(propAccessNode, warningType, pname, errorMsg));
        return true;
    }

    private boolean mayWarnAboutConst(Node n) {
        Node lhs = n.getFirstChild();
        if (lhs.isName() && this.currentScope.isConstVar(lhs.getString())) {
            this.warnings.add(JSError.make(n, CONST_REASSIGNED, new String[0]));
            return true;
        }
        return false;
    }

    private boolean mayWarnAboutConstProp(Node propAccess, JSType recvType, QualifiedName pname) {
        if (recvType.hasConstantProp(pname) && !propAccess.getBooleanProp(77)) {
            this.warnings.add(JSError.make(propAccess, CONST_PROPERTY_REASSIGNED, new String[0]));
            return true;
        }
        return false;
    }

    private boolean mayWarnAboutGlobalThis(Node thisExpr, NTIScope currentScope) {
        Preconditions.checkArgument((boolean)thisExpr.isThis());
        Preconditions.checkState((!currentScope.hasThis() ? 1 : 0) != 0);
        Node parent = thisExpr.getParent();
        if ((parent.isGetProp() || parent.isGetElem()) && !NodeUtil.isCallOrNewArgument(currentScope.getRoot())) {
            this.warnings.add(JSError.make(thisExpr, GLOBAL_THIS, new String[0]));
            return true;
        }
        return false;
    }

    private boolean mayWarnAboutBadIObjectIndex(Node n, JSType iobjectType, JSType foundIndexType, JSType requiredIndexType) {
        if (requiredIndexType.isBottom()) {
            this.warnings.add(JSError.make(n, BOTTOM_INDEX_TYPE, iobjectType.toString()));
            return true;
        }
        if (!foundIndexType.isSubtypeOf(requiredIndexType)) {
            this.warnings.add(JSError.make(n, INVALID_INDEX_TYPE, requiredIndexType.toString(), foundIndexType.toString()));
            return true;
        }
        return false;
    }

    private EnvTypePair analyzePropAccessFwd(Node receiver, String pname, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        QualifiedName getterPname;
        JSType recvSpecType;
        JSType recvReqType;
        QualifiedName propQname = new QualifiedName(pname);
        Node propAccessNode = receiver.getParent();
        JSType reqObjType = NewTypeInference.pickReqObjType(propAccessNode);
        if (NodeUtil.isPropertyTest(this.compiler, propAccessNode) && !specializedType.isFalseOrFalsy() || specializedType.isTrueOrTruthy()) {
            recvReqType = reqObjType;
            recvSpecType = specializedType.isTrueOrTruthy() ? reqObjType.withLoose().withProperty(propQname, specializedType) : reqObjType.withProperty(propQname, specializedType);
        } else if (specializedType.isFalseOrFalsy()) {
            recvReqType = recvSpecType = reqObjType;
        } else {
            recvReqType = reqObjType.withProperty(propQname, requiredType);
            recvSpecType = reqObjType.withProperty(propQname, specializedType);
        }
        EnvTypePair pair = this.analyzeExprFwd(receiver, inEnv, recvReqType, recvSpecType);
        pair = this.mayWarnAboutNullableReferenceAndTighten(receiver, pair.type, recvSpecType, pair.env);
        JSType recvType = pair.type.autobox();
        if (recvType.isUnknown() || this.mayWarnAboutNonObject(receiver, recvType, specializedType)) {
            return new EnvTypePair(pair.env, requiredType);
        }
        FunctionType ft = recvType.getFunTypeIfSingletonObj();
        if (ft != null && pname.equals("call")) {
            return new EnvTypePair(pair.env, this.commonTypes.fromFunctionType(ft.transformByCallProperty()));
        }
        if (ft != null && pname.equals("apply")) {
            return new EnvTypePair(pair.env, this.commonTypes.fromFunctionType(ft.transformByApplyProperty(this.commonTypes)));
        }
        if (this.convention.isSuperClassReference(pname) && ft != null && ft.isUniqueConstructor()) {
            JSType result = ft.getSuperPrototype();
            pair.type = result != null ? result : JSType.UNDEFINED;
            return pair;
        }
        if (propAccessNode.isGetProp() && this.mayWarnAboutDictPropAccess(receiver, recvType)) {
            return new EnvTypePair(pair.env, requiredType);
        }
        if (recvType.isTop()) {
            recvType = JSType.TOP_OBJECT;
        }
        if (recvType.hasProp(getterPname = new QualifiedName(GETTER_PREFIX + pname))) {
            return new EnvTypePair(pair.env, recvType.getProp(getterPname));
        }
        JSType resultType = recvType.getProp(propQname);
        if (resultType != null && resultType.isBottom()) {
            this.warnings.add(JSError.make(propAccessNode, BOTTOM_PROP, pname, recvType.toString()));
            return new EnvTypePair(pair.env, JSType.UNKNOWN);
        }
        if (!(propAccessNode.getParent().isExprResult() || specializedType.isTrueOrTruthy() || specializedType.isFalseOrFalsy() || recvType.mayBeDict() || this.mayWarnAboutInexistentProp(propAccessNode, recvType, propQname, pair.env) || !recvType.hasProp(propQname) || resultType.isSubtypeOf(requiredType) || !this.tightenTypeAndDontWarn(receiver.isName() ? receiver.getString() : null, receiver, recvType.getDeclaredProp(propQname), resultType, requiredType))) {
            resultType = resultType.specialize(requiredType);
            LValueResultFwd lvr = this.analyzeLValueFwd(propAccessNode, inEnv, resultType);
            TypeEnv updatedEnv = this.updateLvalueTypeInEnv(lvr.env, propAccessNode, lvr.ptr, resultType);
            return new EnvTypePair(updatedEnv, resultType);
        }
        if (resultType == null) {
            resultType = JSType.UNKNOWN;
        }
        return new EnvTypePair(pair.env, resultType);
    }

    private TypeEnv updateLvalueTypeInEnv(TypeEnv env, Node lvalue, QualifiedName qname, JSType type) {
        Preconditions.checkNotNull((Object)type);
        switch (lvalue.getType()) {
            case 38: {
                return NewTypeInference.envPutType(env, lvalue.getString(), type);
            }
            case 42: {
                JSType t = NewTypeInference.envGetType(env, THIS_ID);
                return t == null ? env : NewTypeInference.envPutType(env, THIS_ID, type);
            }
            case 118: {
                Preconditions.checkState((boolean)NodeUtil.isForIn(lvalue.getParent()));
                return NewTypeInference.envPutType(env, lvalue.getFirstChild().getString(), type);
            }
            case 33: 
            case 35: {
                if (qname != null) {
                    String objName = qname.getLeftmostName();
                    QualifiedName props = qname.getAllButLeftmost();
                    JSType objType = NewTypeInference.envGetType(env, objName);
                    env = NewTypeInference.envPutType(env, objName, objType.withProperty(props, type));
                }
                return env;
            }
        }
        return env;
    }

    private TypeEnv collectTypesForFreeVarsFwd(Node n, TypeEnv env) {
        Preconditions.checkArgument((n.isFunction() || n.isName() && NodeUtil.isCallOrNewTarget(n) ? 1 : 0) != 0);
        String fnName = n.isFunction() ? this.symbolTable.getFunInternalName(n) : n.getString();
        NTIScope innerScope = this.currentScope.getScope(fnName);
        for (String freeVar : innerScope.getOuterVars()) {
            JSType innerType;
            if (innerScope.getDeclaredTypeOf(freeVar) != null) continue;
            FunctionType summary = this.summaries.get(innerScope).getFunType();
            JSType outerType = NewTypeInference.envGetType(env, freeVar);
            if (outerType == null) {
                outerType = JSType.UNKNOWN;
            }
            if (!(innerType = summary.getOuterVarPrecondition(freeVar)).isLoose() && (n.isName() || n.isFunction() && !outerType.isUndefined()) && !JSType.haveCommonSubtype(outerType, innerType)) {
                this.warnings.add(JSError.make(n, CROSS_SCOPE_GOTCHA, freeVar, outerType.toString(), innerType.toString()));
            }
            env = NewTypeInference.envPutType(env, freeVar, n.isFunction() ? JSType.join(innerType, outerType) : innerType);
        }
        return env;
    }

    private EnvTypePair analyzeLooseCallNodeFwd(Node callNode, TypeEnv inEnv, JSType requiredType) {
        Preconditions.checkArgument((callNode.isCall() || callNode.isNew() ? 1 : 0) != 0);
        Node callee = callNode.getFirstChild();
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        TypeEnv tmpEnv = inEnv;
        for (Node arg = callee.getNext(); arg != null; arg = arg.getNext()) {
            EnvTypePair pair = this.analyzeExprFwd(arg, tmpEnv);
            tmpEnv = pair.env;
            builder.addReqFormal(pair.type);
        }
        JSType looseRetType = requiredType.isUnknown() ? JSType.BOTTOM : requiredType;
        JSType looseFunctionType = this.commonTypes.fromFunctionType(builder.addRetType(looseRetType).addLoose().buildFunction());
        EnvTypePair calleePair = this.analyzeExprFwd(callee, tmpEnv, this.commonTypes.topFunction(), looseFunctionType);
        JSType result = calleePair.type.getFunTypeIfSingletonObj().getReturnType();
        return new EnvTypePair(calleePair.env, NewTypeInference.isImpreciseType(result) ? requiredType : result);
    }

    private static boolean isImpreciseType(JSType t) {
        return t.isBottom() || t.isTop() || t.isUnknown() || t.isUnion() || t.isTrueOrTruthy() || t.isFalseOrFalsy() || t.isLoose() || t.isNonClassyObject();
    }

    private EnvTypePair analyzeLooseCallNodeBwd(Node callNode, TypeEnv outEnv, JSType retType) {
        Preconditions.checkArgument((callNode.isCall() || callNode.isNew() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)retType);
        Node callee = callNode.getFirstChild();
        TypeEnv tmpEnv = outEnv;
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        for (int i = callNode.getChildCount() - 2; i >= 0; --i) {
            Node arg = callNode.getChildAtIndex(i + 1);
            EnvTypePair pair = this.analyzeExprBwd(arg, tmpEnv);
            JSType argType = pair.type;
            tmpEnv = pair.env;
            builder.addReqFormal(NewTypeInference.isImpreciseType(argType) ? JSType.BOTTOM : argType);
        }
        JSType looseRetType = retType.isUnknown() ? JSType.BOTTOM : retType;
        JSType looseFunctionType = this.commonTypes.fromFunctionType(builder.addRetType(looseRetType).addLoose().buildFunction());
        NewTypeInference.println("loose function type is ", looseFunctionType);
        EnvTypePair calleePair = this.analyzeExprBwd(callee, tmpEnv, looseFunctionType);
        return new EnvTypePair(calleePair.env, retType);
    }

    private EnvTypePair analyzeExprBwd(Node expr, TypeEnv outEnv) {
        return this.analyzeExprBwd(expr, outEnv, JSType.UNKNOWN);
    }

    private EnvTypePair analyzeExprBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        Preconditions.checkArgument((requiredType != null ? 1 : 0) != 0, (String)"Required type null at: %s", (Object[])new Object[]{expr});
        Preconditions.checkArgument((!requiredType.isBottom() ? 1 : 0) != 0);
        switch (expr.getType()) {
            case 124: {
                return new EnvTypePair(outEnv, JSType.UNKNOWN);
            }
            case 105: {
                String fnName = this.symbolTable.getFunInternalName(expr);
                return new EnvTypePair(outEnv, NewTypeInference.envGetType(outEnv, fnName));
            }
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: {
                return new EnvTypePair(outEnv, NewTypeInference.scalarValueToType(expr.getType()));
            }
            case 64: {
                return this.analyzeObjLitBwd(expr, outEnv, requiredType);
            }
            case 42: {
                if (!this.currentScope.hasThis()) {
                    return new EnvTypePair(outEnv, JSType.UNKNOWN);
                }
                JSType thisType = this.currentScope.getDeclaredTypeOf(THIS_ID);
                return new EnvTypePair(outEnv, thisType);
            }
            case 38: {
                return this.analyzeNameBwd(expr, outEnv, requiredType);
            }
            case 27: 
            case 29: 
            case 102: 
            case 103: {
                return this.analyzeExprBwd(expr.getFirstChild(), outEnv, JSType.NUMBER);
            }
            case 28: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = JSType.NUMBER;
                return pair;
            }
            case 32: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = JSType.STRING;
                return pair;
            }
            case 52: {
                TypeEnv env = this.analyzeExprBwd((Node)expr.getLastChild(), (TypeEnv)outEnv, (JSType)this.commonTypes.topFunction()).env;
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), env);
                pair.type = JSType.BOOLEAN;
                return pair;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return this.analyzeBinaryNumericOpBwd(expr, outEnv);
            }
            case 21: {
                return this.analyzeAddBwd(expr, outEnv, requiredType);
            }
            case 100: 
            case 101: {
                return this.analyzeLogicalOpBwd(expr, outEnv);
            }
            case 12: 
            case 13: 
            case 45: 
            case 46: {
                return this.analyzeEqNeBwd(expr, outEnv);
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return this.analyzeLtGtBwd(expr, outEnv);
            }
            case 86: {
                return this.analyzeAssignBwd(expr, outEnv, requiredType);
            }
            case 93: {
                return this.analyzeAssignAddBwd(expr, outEnv, requiredType);
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                return this.analyzeAssignNumericOpBwd(expr, outEnv);
            }
            case 33: {
                Preconditions.checkState((!NodeUtil.isAssignmentOp(expr.getParent()) || !NodeUtil.isLValue(expr) ? 1 : 0) != 0);
                if (expr.getBooleanProp(76)) {
                    return new EnvTypePair(outEnv, requiredType);
                }
                return this.analyzePropAccessBwd(expr.getFirstChild(), expr.getLastChild().getString(), outEnv, requiredType);
            }
            case 98: {
                return this.analyzeHookBwd(expr, outEnv, requiredType);
            }
            case 30: 
            case 37: {
                return this.analyzeCallNewBwd(expr, outEnv, requiredType);
            }
            case 85: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getLastChild(), outEnv, requiredType);
                pair.env = this.analyzeExprBwd((Node)expr.getFirstChild(), (TypeEnv)pair.env).env;
                return pair;
            }
            case 26: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = pair.type.negate();
                return pair;
            }
            case 35: {
                return this.analyzeGetElemBwd(expr, outEnv, requiredType);
            }
            case 122: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = JSType.UNDEFINED;
                return pair;
            }
            case 51: {
                return this.analyzeInBwd(expr, outEnv);
            }
            case 31: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = JSType.BOOLEAN;
                return pair;
            }
            case 118: {
                Node vdecl = expr.getFirstChild();
                String name = vdecl.getString();
                Preconditions.checkState((!vdecl.hasChildren() ? 1 : 0) != 0);
                return new EnvTypePair(NewTypeInference.envPutType(outEnv, name, JSType.UNKNOWN), JSType.UNKNOWN);
            }
            case 47: {
                return new EnvTypePair(outEnv, this.commonTypes.getRegexpType());
            }
            case 63: {
                return this.analyzeArrayLitBwd(expr, outEnv);
            }
            case 155: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = this.symbolTable.getCastType(expr);
                return pair;
            }
        }
        throw new RuntimeException("BWD: Unhandled expression type: " + Token.name(expr.getType()) + " with parent: " + expr.getParent());
    }

    private EnvTypePair analyzeNameBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        String varName = expr.getString();
        if (varName.equals("undefined")) {
            return new EnvTypePair(outEnv, JSType.UNDEFINED);
        }
        JSType inferredType = NewTypeInference.envGetType(outEnv, varName);
        NewTypeInference.println(varName, "'s inferredType: ", inferredType, " requiredType:  ", requiredType);
        if (inferredType == null) {
            return new EnvTypePair(outEnv, JSType.UNKNOWN);
        }
        if (this.currentScope.isKnownFunction(varName) || this.maybeIsNamespace(varName, inferredType)) {
            return new EnvTypePair(outEnv, inferredType);
        }
        JSType preciseType = inferredType.specialize(requiredType);
        if ((this.currentScope.isUndeclaredFormal(varName) || this.currentScope.isUndeclaredOuterVar(varName)) && preciseType.hasNonScalar()) {
            preciseType = preciseType.withLoose();
        }
        NewTypeInference.println(varName, "'s preciseType: ", preciseType);
        if (preciseType.isBottom()) {
            JSType declType = this.currentScope.getDeclaredTypeOf(varName);
            preciseType = declType == null ? requiredType : declType;
        }
        return EnvTypePair.addBinding(outEnv, varName, preciseType);
    }

    private EnvTypePair analyzeBinaryNumericOpBwd(Node expr, TypeEnv outEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        TypeEnv rhsEnv = this.analyzeExprBwd((Node)rhs, (TypeEnv)outEnv, (JSType)JSType.NUMBER).env;
        EnvTypePair pair = this.analyzeExprBwd(lhs, rhsEnv, JSType.NUMBER);
        pair.type = JSType.NUMBER;
        return pair;
    }

    private EnvTypePair analyzeAddBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        JSType operandType = requiredType.isNumber() ? JSType.NUMBER : JSType.UNKNOWN;
        EnvTypePair rhsPair = this.analyzeExprBwd(rhs, outEnv, operandType);
        EnvTypePair lhsPair = this.analyzeExprBwd(lhs, rhsPair.env, operandType);
        lhsPair.type = JSType.plus(lhsPair.type, rhsPair.type);
        return lhsPair;
    }

    private EnvTypePair analyzeLogicalOpBwd(Node expr, TypeEnv outEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair rhsPair = this.analyzeExprBwd(rhs, outEnv);
        EnvTypePair lhsPair = this.analyzeExprBwd(lhs, rhsPair.env);
        lhsPair.type = JSType.join(rhsPair.type, lhsPair.type);
        return lhsPair;
    }

    private EnvTypePair analyzeEqNeBwd(Node expr, TypeEnv outEnv) {
        TypeEnv rhsEnv = this.analyzeExprBwd((Node)expr.getLastChild(), (TypeEnv)outEnv).env;
        EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), rhsEnv);
        pair.type = JSType.BOOLEAN;
        return pair;
    }

    private EnvTypePair analyzeLtGtBwd(Node expr, TypeEnv outEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair rhsPair = this.analyzeExprBwd(rhs, outEnv);
        EnvTypePair lhsPair = this.analyzeExprBwd(lhs, rhsPair.env);
        JSType meetType = JSType.meet(lhsPair.type, rhsPair.type);
        if (meetType.isBottom()) {
            lhsPair.type = JSType.BOOLEAN;
            return lhsPair;
        }
        rhsPair = this.analyzeExprBwd(rhs, outEnv, meetType);
        lhsPair = this.analyzeExprBwd(lhs, rhsPair.env, meetType);
        lhsPair.type = JSType.BOOLEAN;
        return lhsPair;
    }

    private EnvTypePair analyzeAssignBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        if (expr.getBooleanProp(76)) {
            return new EnvTypePair(outEnv, requiredType);
        }
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        if (lhs.getBooleanProp(76)) {
            return this.analyzeExprBwd(rhs, outEnv, this.markAndGetTypeOfPreanalyzedNode(lhs, outEnv, false));
        }
        LValueResultBwd lvalue = this.analyzeLValueBwd(lhs, outEnv, requiredType, true);
        TypeEnv slicedEnv = lvalue.env;
        JSType rhsReqType = NewTypeInference.specializeKeep2ndWhenBottom(lvalue.type, requiredType);
        EnvTypePair pair = this.analyzeExprBwd(rhs, slicedEnv, rhsReqType);
        pair.env = this.analyzeLValueBwd((Node)lhs, (TypeEnv)pair.env, (JSType)requiredType, (boolean)true).env;
        return pair;
    }

    private EnvTypePair analyzeAssignAddBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        JSType lhsReqType = NewTypeInference.specializeKeep2ndWhenBottom(requiredType, JSType.NUM_OR_STR);
        LValueResultBwd lvalue = this.analyzeLValueBwd(lhs, outEnv, lhsReqType, false);
        JSType rhsReqType = lvalue.type.isNumber() ? JSType.NUMBER : JSType.NUM_OR_STR;
        EnvTypePair pair = this.analyzeExprBwd(rhs, outEnv, rhsReqType);
        pair.env = this.analyzeLValueBwd((Node)lhs, (TypeEnv)pair.env, (JSType)lhsReqType, (boolean)false).env;
        return pair;
    }

    private EnvTypePair analyzeAssignNumericOpBwd(Node expr, TypeEnv outEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair pair = this.analyzeExprBwd(rhs, outEnv, JSType.NUMBER);
        LValueResultBwd lvalue = this.analyzeLValueBwd(lhs, pair.env, JSType.NUMBER, false);
        return new EnvTypePair(lvalue.env, JSType.NUMBER);
    }

    private EnvTypePair analyzeHookBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        Node cond = expr.getFirstChild();
        Node thenBranch = cond.getNext();
        Node elseBranch = thenBranch.getNext();
        EnvTypePair thenPair = this.analyzeExprBwd(thenBranch, outEnv, requiredType);
        EnvTypePair elsePair = this.analyzeExprBwd(elseBranch, outEnv, requiredType);
        return this.analyzeExprBwd(cond, TypeEnv.join(thenPair.env, elsePair.env));
    }

    private EnvTypePair analyzeCallNewBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        int numArgs;
        Preconditions.checkArgument((expr.isNew() || expr.isCall() ? 1 : 0) != 0);
        Node callee = expr.getFirstChild();
        EnvTypePair pair = this.analyzeExprBwd(callee, outEnv, this.commonTypes.topFunction());
        TypeEnv envAfterCallee = pair.env;
        FunctionType funType = pair.type.getFunType();
        if (funType == null) {
            return this.analyzeCallNodeArgumentsBwd(expr, envAfterCallee);
        }
        if (funType.isLoose()) {
            return this.analyzeLooseCallNodeBwd(expr, envAfterCallee, requiredType);
        }
        if (expr.isCall() && funType.isSomeConstructorOrInterface() || expr.isNew() && !funType.isSomeConstructorOrInterface()) {
            return this.analyzeCallNodeArgumentsBwd(expr, envAfterCallee);
        }
        if (funType.isTopFunction()) {
            return this.analyzeCallNodeArgumentsBwd(expr, envAfterCallee);
        }
        if (callee.isName() && !funType.isGeneric() && expr.isCall()) {
            this.createDeferredCheckBwd(expr, requiredType);
        }
        if ((numArgs = expr.getChildCount() - 1) < funType.getMinArity() || numArgs > funType.getMaxArity()) {
            return this.analyzeCallNodeArgumentsBwd(expr, envAfterCallee);
        }
        if (funType.isGeneric()) {
            Map<String, JSType> typeMap = this.calcTypeInstantiationBwd(expr, funType, envAfterCallee);
            funType = funType.instantiateGenerics(typeMap);
        }
        TypeEnv tmpEnv = envAfterCallee;
        for (int i = expr.getChildCount() - 2; i >= 0; --i) {
            JSType formalType = funType.getFormalType(i);
            if (formalType.isBottom()) {
                formalType = JSType.UNKNOWN;
            }
            Node arg = expr.getChildAtIndex(i + 1);
            tmpEnv = this.analyzeExprBwd((Node)arg, (TypeEnv)tmpEnv, (JSType)formalType).env;
        }
        JSType retType = expr.isNew() ? funType.getThisType() : funType.getReturnType();
        return new EnvTypePair(tmpEnv, retType);
    }

    private EnvTypePair analyzeGetElemBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        Node receiver = expr.getFirstChild();
        Node index = expr.getLastChild();
        JSType reqObjType = NewTypeInference.pickReqObjType(expr);
        EnvTypePair pair = this.analyzeExprBwd(receiver, outEnv, reqObjType);
        JSType recvType = pair.type;
        JSType indexType = recvType.getIndexType();
        if (indexType != null) {
            pair = this.analyzeExprBwd(index, pair.env, indexType);
            pair.type = recvType.getIndexedType();
            return pair;
        }
        if (index.isString()) {
            return this.analyzePropAccessBwd(receiver, index.getString(), outEnv, requiredType);
        }
        pair = this.analyzeExprBwd(index, outEnv);
        pair = this.analyzeExprBwd(receiver, pair.env, reqObjType);
        pair.type = requiredType;
        return pair;
    }

    private EnvTypePair analyzeInBwd(Node expr, TypeEnv outEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair pair = this.analyzeExprBwd(rhs, outEnv, NewTypeInference.pickReqObjType(expr));
        pair = this.analyzeExprBwd(lhs, pair.env, JSType.NUM_OR_STR);
        pair.type = JSType.BOOLEAN;
        return pair;
    }

    private EnvTypePair analyzeArrayLitBwd(Node expr, TypeEnv outEnv) {
        TypeEnv env = outEnv;
        JSType elementType = JSType.BOTTOM;
        for (int i = expr.getChildCount() - 1; i >= 0; --i) {
            Node arrayElm = expr.getChildAtIndex(i);
            EnvTypePair pair = this.analyzeExprBwd(arrayElm, env);
            env = pair.env;
            elementType = JSType.join(elementType, pair.type);
        }
        if (elementType.isBottom()) {
            elementType = JSType.UNKNOWN;
        }
        return new EnvTypePair(env, this.commonTypes.getArrayInstance(elementType));
    }

    private EnvTypePair analyzeCallNodeArgumentsBwd(Node callNode, TypeEnv outEnv) {
        TypeEnv env = outEnv;
        for (int i = callNode.getChildCount() - 1; i > 0; --i) {
            Node arg = callNode.getChildAtIndex(i);
            env = this.analyzeExprBwd((Node)arg, (TypeEnv)env).env;
        }
        return new EnvTypePair(env, JSType.UNKNOWN);
    }

    private void createDeferredCheckBwd(Node expr, JSType requiredType) {
        Preconditions.checkArgument((boolean)expr.isCall());
        Preconditions.checkArgument((boolean)expr.getFirstChild().isName());
        String calleeName = expr.getFirstChild().getString();
        if (this.currentScope.isKnownFunction(calleeName) && !this.currentScope.isLocalFunDef(calleeName) && !this.currentScope.isExternalFunction(calleeName)) {
            NTIScope s = this.currentScope.getScope(calleeName);
            JSType expectedRetType = s.getDeclaredFunctionType().getReturnType() == null ? requiredType : null;
            NewTypeInference.println("Putting deferred check of function: ", calleeName, " with ret: ", expectedRetType);
            DeferredCheck dc = new DeferredCheck(expr, expectedRetType, this.currentScope, s);
            this.deferredChecks.put(expr, dc);
        }
    }

    private EnvTypePair analyzePropAccessBwd(Node receiver, String pname, TypeEnv outEnv, JSType requiredType) {
        JSType propAccessType;
        Node propAccessNode = receiver.getParent();
        QualifiedName qname = new QualifiedName(pname);
        JSType reqObjType = NewTypeInference.pickReqObjType(propAccessNode);
        if (!NodeUtil.isPropertyTest(this.compiler, propAccessNode)) {
            reqObjType = reqObjType.withProperty(qname, requiredType);
        }
        EnvTypePair pair = this.analyzeExprBwd(receiver, outEnv, reqObjType);
        JSType receiverType = pair.type;
        pair.type = propAccessType = receiverType.mayHaveProp(qname) ? receiverType.getProp(qname) : requiredType;
        return pair;
    }

    private EnvTypePair analyzeObjLitBwd(Node objLit, TypeEnv outEnv, JSType requiredType) {
        if (NodeUtil.isEnumDecl(objLit.getParent())) {
            return this.analyzeEnumObjLitBwd(objLit, outEnv, requiredType);
        }
        TypeEnv env = outEnv;
        JSType result = NewTypeInference.pickReqObjType(objLit);
        Node prop = objLit.getLastChild();
        while (prop != null) {
            QualifiedName pname = new QualifiedName(NodeUtil.getObjectLitKeyName(prop));
            if (prop.isGetterDef() || prop.isSetterDef()) {
                env = this.analyzeExprBwd((Node)prop.getFirstChild(), (TypeEnv)env).env;
            } else {
                JSType jsdocType = this.symbolTable.getPropDeclaredType(prop);
                JSType reqPtype = jsdocType != null ? jsdocType : (requiredType.mayHaveProp(pname) ? requiredType.getProp(pname) : JSType.UNKNOWN);
                EnvTypePair pair = this.analyzeExprBwd(prop.getFirstChild(), env, reqPtype);
                result = result.withProperty(pname, pair.type);
                env = pair.env;
            }
            prop = objLit.getChildBefore(prop);
        }
        return new EnvTypePair(env, result);
    }

    private EnvTypePair analyzeEnumObjLitBwd(Node objLit, TypeEnv outEnv, JSType requiredType) {
        if (objLit.getFirstChild() == null) {
            return new EnvTypePair(outEnv, requiredType);
        }
        String pname = NodeUtil.getObjectLitKeyName(objLit.getFirstChild());
        JSType enumeratedType = requiredType.getProp(new QualifiedName(pname)).getEnumeratedType();
        if (enumeratedType == null) {
            return new EnvTypePair(outEnv, requiredType);
        }
        TypeEnv env = outEnv;
        Node prop = objLit.getLastChild();
        while (prop != null) {
            env = this.analyzeExprBwd((Node)prop.getFirstChild(), (TypeEnv)env, (JSType)enumeratedType).env;
            prop = objLit.getChildBefore(prop);
        }
        return new EnvTypePair(env, requiredType);
    }

    private boolean isPropertyTestCall(Node expr) {
        if (!expr.isCall()) {
            return false;
        }
        return expr.getFirstChild().isQualifiedName() && this.convention.isPropertyTestFunction(expr);
    }

    private boolean isFunctionBind(Node expr, TypeEnv env, boolean isFwd) {
        if (NodeUtil.isFunctionBind(expr)) {
            return true;
        }
        if (!(expr.isGetProp() && expr.isQualifiedName() && expr.getLastChild().getString().equals("bind"))) {
            return false;
        }
        Node recv = expr.getFirstChild();
        JSType recvType = isFwd ? this.analyzeExprFwd((Node)recv, (TypeEnv)env).type : this.analyzeExprBwd((Node)recv, (TypeEnv)env).type;
        return !recvType.isUnknown() && recvType.isSubtypeOf(this.commonTypes.topFunction());
    }

    private boolean isGoogTypeof(Node expr) {
        if (!expr.isCall()) {
            return false;
        }
        return (expr = expr.getFirstChild()).isGetProp() && expr.getFirstChild().isName() && expr.getFirstChild().getString().equals("goog") && expr.getLastChild().getString().equals("typeOf");
    }

    private static JSType scalarValueToType(int token) {
        switch (token) {
            case 39: {
                return JSType.NUMBER;
            }
            case 40: {
                return JSType.STRING;
            }
            case 44: {
                return JSType.TRUE_TYPE;
            }
            case 43: {
                return JSType.FALSE_TYPE;
            }
            case 41: {
                return JSType.NULL;
            }
        }
        throw new RuntimeException("The token isn't a scalar value " + Token.name(token));
    }

    private void warnInvalidOperand(Node expr, int operatorType, Object expected, Object actual) {
        Preconditions.checkArgument((expected instanceof String || expected instanceof JSType ? 1 : 0) != 0);
        Preconditions.checkArgument((actual instanceof String || actual instanceof JSType ? 1 : 0) != 0);
        this.warnings.add(JSError.make(expr, INVALID_OPERAND_TYPE, Token.name(operatorType), expected.toString(), actual.toString()));
    }

    private static JSType envGetType(TypeEnv env, String pname) {
        Preconditions.checkArgument((!pname.contains(".") ? 1 : 0) != 0);
        return env.getType(pname);
    }

    private static TypeEnv envPutType(TypeEnv env, String varName, JSType type) {
        Preconditions.checkArgument((!varName.contains(".") ? 1 : 0) != 0);
        return env.putType(varName, type);
    }

    private JSType markAndGetTypeOfPreanalyzedNode(Node qnameNode, TypeEnv env, boolean isFwd) {
        switch (qnameNode.getType()) {
            case 38: {
                JSType result = NewTypeInference.envGetType(env, qnameNode.getString());
                Preconditions.checkNotNull((Object)result, (String)"Null declared type@%s", (Object[])new Object[]{qnameNode});
                if (isFwd) {
                    this.maybeSetTypeI(qnameNode, result);
                }
                return result;
            }
            case 33: {
                JSType recvType = this.markAndGetTypeOfPreanalyzedNode(qnameNode.getFirstChild(), env, isFwd);
                String pname = qnameNode.getLastChild().getString();
                JSType result = null;
                if (recvType.isSubtypeOf(JSType.TOP_OBJECT)) {
                    result = recvType.getProp(new QualifiedName(pname));
                }
                if (pname.equals("prototype") && (recvType.isConstructor() || recvType.isInterfaceDefinition())) {
                    FunctionType ft = recvType.getFunTypeIfSingletonObj();
                    result = ft.getInstanceTypeOfCtor();
                }
                if (result == null) {
                    this.warnings.add(JSError.make(qnameNode, UNKNOWN_NAMESPACE_PROPERTY, qnameNode.getQualifiedName()));
                    return JSType.UNKNOWN;
                }
                Preconditions.checkNotNull((Object)result, (String)"Null declared type@%s", (Object[])new Object[]{qnameNode});
                if (isFwd) {
                    this.maybeSetTypeI(qnameNode, result);
                }
                return result;
            }
        }
        throw new RuntimeException("markAndGetTypeOfPreanalyzedNode: unexpected node " + Token.name(qnameNode.getType()));
    }

    private void maybeSetTypeI(Node n, JSType t) {
        JSType oldType;
        TypeI ti = n.getTypeI();
        JSType jSType = oldType = ti instanceof JSType ? (JSType)ti : null;
        if (oldType == null) {
            n.setTypeI(t);
        }
    }

    private LValueResultFwd analyzeLValueFwd(Node expr, TypeEnv inEnv, JSType type) {
        return this.analyzeLValueFwd(expr, inEnv, type, false);
    }

    private LValueResultFwd analyzeLValueFwd(Node expr, TypeEnv inEnv, JSType type, boolean insideQualifiedName) {
        LValueResultFwd lvalResult = null;
        switch (expr.getType()) {
            case 42: {
                if (this.currentScope.hasThis()) {
                    lvalResult = new LValueResultFwd(inEnv, NewTypeInference.envGetType(inEnv, THIS_ID), this.currentScope.getDeclaredTypeOf(THIS_ID), new QualifiedName(THIS_ID));
                    break;
                }
                this.mayWarnAboutGlobalThis(expr, this.currentScope);
                lvalResult = new LValueResultFwd(inEnv, JSType.UNKNOWN, null, null);
                break;
            }
            case 38: {
                String varName = expr.getString();
                JSType varType = this.analyzeExprFwd((Node)expr, (TypeEnv)inEnv).type;
                lvalResult = new LValueResultFwd(inEnv, varType, this.currentScope.getDeclaredTypeOf(varName), varType.hasNonScalar() ? new QualifiedName(varName) : null);
                break;
            }
            case 33: 
            case 35: {
                Node obj = expr.getFirstChild();
                Node prop = expr.getLastChild();
                QualifiedName pname = expr.isGetProp() || prop.isString() ? new QualifiedName(prop.getString()) : null;
                LValueResultFwd recvLvalue = this.analyzeReceiverLvalFwd(obj, pname, inEnv, type);
                if (!recvLvalue.type.isSubtypeOf(JSType.TOP_OBJECT)) {
                    EnvTypePair pair = this.analyzeExprFwd(prop, recvLvalue.env, type);
                    lvalResult = new LValueResultFwd(pair.env, type, null, null);
                    break;
                }
                JSType indexType = recvLvalue.type.getIndexType();
                if (expr.isGetElem() && indexType != null) {
                    lvalResult = this.analyzeIObjectElmLvalFwd(prop, recvLvalue, indexType);
                    break;
                }
                if (expr.isGetProp() || prop.isString()) {
                    lvalResult = this.analyzePropLValFwd(obj, pname, recvLvalue, type, insideQualifiedName);
                    break;
                }
                EnvTypePair pair = this.analyzeExprFwd(expr, recvLvalue.env, type);
                lvalResult = new LValueResultFwd(pair.env, pair.type, null, null);
                break;
            }
            case 118: {
                Preconditions.checkState((boolean)NodeUtil.isForIn(expr.getParent()));
                Node vdecl = expr.getFirstChild();
                String name = vdecl.getString();
                Preconditions.checkState((!vdecl.hasChildren() ? 1 : 0) != 0);
                return new LValueResultFwd(inEnv, JSType.STRING, null, new QualifiedName(name));
            }
            default: {
                Preconditions.checkState((boolean)insideQualifiedName);
                EnvTypePair pair = this.analyzeExprFwd(expr, inEnv, type);
                return new LValueResultFwd(pair.env, pair.type, null, null);
            }
        }
        this.maybeSetTypeI(expr, lvalResult.type);
        return lvalResult;
    }

    private LValueResultFwd analyzeIObjectElmLvalFwd(Node prop, LValueResultFwd recvLvalue, JSType indexType) {
        EnvTypePair pair = this.analyzeExprFwd(prop, recvLvalue.env, indexType.isBottom() ? JSType.UNKNOWN : indexType);
        if (this.mayWarnAboutBadIObjectIndex(prop, recvLvalue.type, pair.type, indexType)) {
            return new LValueResultFwd(pair.env, JSType.UNKNOWN, null, null);
        }
        JSType inferred = recvLvalue.type.getIndexedType();
        JSType declared = null;
        if (recvLvalue.declType != null) {
            JSType receiverAdjustedDeclType = recvLvalue.declType.removeType(JSType.NULL_OR_UNDEF);
            declared = receiverAdjustedDeclType.getIndexedType();
        }
        return new LValueResultFwd(pair.env, inferred, declared, null);
    }

    private EnvTypePair mayWarnAboutNullableReferenceAndTighten(Node obj, JSType recvType, JSType maybeSpecType, TypeEnv inEnv) {
        JSType minusNull;
        if (!(recvType.isUnknown() || recvType.isTop() || !JSType.NULL.isSubtypeOf(recvType) && !JSType.UNDEFINED.isSubtypeOf(recvType) || (minusNull = recvType.removeType(JSType.NULL_OR_UNDEF)).isBottom())) {
            this.warnings.add(JSError.make(obj, NULLABLE_DEREFERENCE, recvType.toString()));
            TypeEnv outEnv = inEnv;
            if (obj.isQualifiedName()) {
                QualifiedName qname = QualifiedName.fromNode(obj);
                if (maybeSpecType != null && maybeSpecType.isSubtypeOf(minusNull)) {
                    minusNull = maybeSpecType;
                }
                outEnv = this.updateLvalueTypeInEnv(inEnv, obj, qname, minusNull);
            }
            return new EnvTypePair(outEnv, minusNull);
        }
        return new EnvTypePair(inEnv, recvType);
    }

    private LValueResultFwd analyzePropLValFwd(Node obj, QualifiedName pname, LValueResultFwd recvLvalue, JSType requiredType, boolean insideQualifiedName) {
        Node propAccessNode;
        Preconditions.checkArgument((boolean)pname.isIdentifier());
        TypeEnv inEnv = recvLvalue.env;
        JSType recvType = recvLvalue.type;
        if (!recvType.isUnion() && !recvType.isSingletonObj()) {
            recvType = JSType.TOP_OBJECT.withLoose();
        }
        if ((propAccessNode = obj.getParent()).isGetProp() && propAccessNode.getParent().isAssign() && this.mayWarnAboutPropCreation(pname, propAccessNode, recvType)) {
            return new LValueResultFwd(inEnv, requiredType, null, null);
        }
        if (!insideQualifiedName && this.mayWarnAboutConstProp(propAccessNode, recvType, pname)) {
            return new LValueResultFwd(inEnv, requiredType, null, null);
        }
        if (!recvType.hasProp(pname)) {
            if (recvType.isLoose()) {
                recvType = recvType.withProperty(pname, JSType.TOP_OBJECT.withLoose());
                inEnv = this.updateLvalueTypeInEnv(inEnv, obj, recvLvalue.ptr, recvType);
            } else {
                boolean warnForInexistentProp;
                boolean bl = warnForInexistentProp = insideQualifiedName || propAccessNode.getParent().getType() != 86;
                if (warnForInexistentProp && !recvType.isUnknown() && !recvType.mayBeDict()) {
                    this.mayWarnAboutInexistentProp(propAccessNode, recvType, pname, inEnv);
                    return new LValueResultFwd(inEnv, requiredType, null, null);
                }
            }
        }
        if (propAccessNode.isGetElem()) {
            this.mayWarnAboutStructPropAccess(obj, recvType);
        } else if (propAccessNode.isGetProp()) {
            this.mayWarnAboutDictPropAccess(obj, recvType);
        }
        QualifiedName setterPname = new QualifiedName(SETTER_PREFIX + pname.getLeftmostName());
        if (recvType.hasProp(setterPname)) {
            FunctionType funType = recvType.getProp(setterPname).getFunType();
            Preconditions.checkNotNull((Object)funType);
            JSType formalType = funType.getFormalType(0);
            Preconditions.checkState((!formalType.isBottom() ? 1 : 0) != 0);
            return new LValueResultFwd(inEnv, formalType, formalType, null);
        }
        QualifiedName ptr = recvLvalue.ptr == null ? null : QualifiedName.join(recvLvalue.ptr, pname);
        return recvType.mayHaveProp(pname) ? new LValueResultFwd(inEnv, recvType.getProp(pname), recvType.getDeclaredProp(pname), ptr) : new LValueResultFwd(inEnv, JSType.UNKNOWN, null, ptr);
    }

    private LValueResultFwd analyzeReceiverLvalFwd(Node obj, QualifiedName pname, TypeEnv inEnv, JSType propType) {
        Preconditions.checkArgument((pname == null || pname.isIdentifier() ? 1 : 0) != 0);
        JSType reqObjType = NewTypeInference.pickReqObjType(obj.getParent());
        if (pname != null) {
            reqObjType = reqObjType.withProperty(pname, propType);
        }
        LValueResultFwd lvalue = this.analyzeLValueFwd(obj, inEnv, reqObjType, true);
        EnvTypePair pair = this.mayWarnAboutNullableReferenceAndTighten(obj, lvalue.type, null, lvalue.env);
        JSType lvalueType = pair.type.autobox();
        if (!lvalueType.isSubtypeOf(JSType.TOP_OBJECT)) {
            this.warnings.add(JSError.make(obj, PROPERTY_ACCESS_ON_NONOBJECT, this.getPropNameForErrorMsg(obj.getParent()), lvalueType.toString()));
        }
        lvalue.type = lvalueType;
        lvalue.env = pair.env;
        return lvalue;
    }

    private LValueResultBwd analyzeLValueBwd(Node expr, TypeEnv outEnv, JSType type, boolean doSlicing) {
        return this.analyzeLValueBwd(expr, outEnv, type, doSlicing, false);
    }

    private LValueResultBwd analyzeLValueBwd(Node expr, TypeEnv outEnv, JSType type, boolean doSlicing, boolean insideQualifiedName) {
        switch (expr.getType()) {
            case 38: 
            case 42: {
                EnvTypePair pair = this.analyzeExprBwd(expr, outEnv, type);
                String name = expr.getQualifiedName();
                JSType declType = this.currentScope.getDeclaredTypeOf(name);
                if (doSlicing) {
                    pair.env = NewTypeInference.envPutType(pair.env, name, declType != null ? declType : JSType.UNKNOWN);
                }
                return new LValueResultBwd(pair.env, pair.type, pair.type.hasNonScalar() ? new QualifiedName(name) : null);
            }
            case 33: {
                Node obj = expr.getFirstChild();
                QualifiedName pname = new QualifiedName(expr.getLastChild().getString());
                return this.analyzePropLValBwd(obj, pname, outEnv, type, doSlicing);
            }
            case 35: {
                if (expr.getLastChild().isString()) {
                    Node obj = expr.getFirstChild();
                    QualifiedName pname = new QualifiedName(expr.getLastChild().getString());
                    return this.analyzePropLValBwd(obj, pname, outEnv, type, doSlicing);
                }
                EnvTypePair pair = this.analyzeExprBwd(expr, outEnv, type);
                return new LValueResultBwd(pair.env, pair.type, null);
            }
        }
        Preconditions.checkState((boolean)insideQualifiedName);
        EnvTypePair pair = this.analyzeExprBwd(expr, outEnv, type);
        return new LValueResultBwd(pair.env, pair.type, null);
    }

    private LValueResultBwd analyzePropLValBwd(Node obj, QualifiedName pname, TypeEnv outEnv, JSType type, boolean doSlicing) {
        Preconditions.checkArgument((boolean)pname.isIdentifier());
        JSType reqObjType = NewTypeInference.pickReqObjType(obj.getParent()).withProperty(pname, type);
        LValueResultBwd lvalue = this.analyzeLValueBwd(obj, outEnv, reqObjType, false, true);
        if (lvalue.ptr != null) {
            lvalue.ptr = QualifiedName.join(lvalue.ptr, pname);
            if (doSlicing) {
                String objName = lvalue.ptr.getLeftmostName();
                QualifiedName props = lvalue.ptr.getAllButLeftmost();
                JSType objType = NewTypeInference.envGetType(lvalue.env, objName);
                JSType slicedObjType = objType.withoutProperty(props);
                lvalue.env = NewTypeInference.envPutType(lvalue.env, objName, slicedObjType);
            }
        }
        lvalue.type = lvalue.type.mayHaveProp(pname) ? lvalue.type.getProp(pname) : JSType.UNKNOWN;
        return lvalue;
    }

    private static JSType pickReqObjType(Node expr) {
        int exprKind = expr.getType();
        switch (exprKind) {
            case 64: {
                JSDocInfo jsdoc = expr.getJSDocInfo();
                if (jsdoc != null && jsdoc.makesStructs()) {
                    return JSType.TOP_STRUCT;
                }
                if (jsdoc != null && jsdoc.makesDicts()) {
                    return JSType.TOP_DICT;
                }
                return JSType.TOP_OBJECT;
            }
            case 115: {
                Preconditions.checkState((boolean)NodeUtil.isForIn(expr));
                return JSType.TOP_OBJECT;
            }
            case 33: 
            case 35: 
            case 51: {
                return JSType.TOP_OBJECT;
            }
        }
        throw new RuntimeException("Unhandled node for pickReqObjType: " + Token.name(exprKind));
    }

    private static String getReadableCalleeName(Node expr) {
        return expr.isQualifiedName() ? expr.getQualifiedName() : "";
    }

    private static JSType specializeKeep2ndWhenBottom(JSType toBeSpecialized, JSType fallback) {
        JSType specializedType = toBeSpecialized.specialize(fallback);
        return specializedType.isBottom() ? fallback : specializedType;
    }

    TypeEnv getEntryTypeEnv() {
        return this.getOutEnv(this.cfg.getEntry());
    }

    private static class DeferredCheck {
        final Node callSite;
        final NTIScope callerScope;
        final NTIScope calleeScope;
        JSType expectedRetType;
        List<JSType> argTypes;

        DeferredCheck(Node callSite, JSType expectedRetType, NTIScope callerScope, NTIScope calleeScope) {
            this.callSite = callSite;
            this.expectedRetType = expectedRetType;
            this.callerScope = callerScope;
            this.calleeScope = calleeScope;
        }

        void updateReturn(JSType expectedRetType) {
            if (this.expectedRetType != null) {
                this.expectedRetType = JSType.meet(this.expectedRetType, expectedRetType);
            }
        }

        void updateArgTypes(List<JSType> argTypes) {
            this.argTypes = argTypes;
        }

        private void runCheck(Map<NTIScope, JSType> summaries, WarningReporter warnings) {
            FunctionType fnSummary = summaries.get(this.calleeScope).getFunType();
            NewTypeInference.println(new Object[]{"Running deferred check of function: ", this.calleeScope.getReadableName(), " with FunctionSummary of: ", fnSummary, " and callsite ret: ", this.expectedRetType, " args: ", this.argTypes});
            if (this.expectedRetType != null && !fnSummary.getReturnType().isSubtypeOf(this.expectedRetType)) {
                warnings.add(JSError.make(this.callSite, INVALID_INFERRED_RETURN_TYPE, this.expectedRetType.toString(), fnSummary.getReturnType().toString()));
            }
            int i = 0;
            Node argNode = this.callSite.getSecondChild();
            if (this.argTypes == null) {
                return;
            }
            for (JSType argType : this.argTypes) {
                JSType formalType = fnSummary.getFormalType(i);
                if (argNode.isName() && this.callerScope.isKnownFunction(argNode.getString())) {
                    argType = summaries.get(this.callerScope.getScope(argNode.getString()));
                }
                if (argType != null && !argType.isSubtypeOf(formalType)) {
                    warnings.add(JSError.make(argNode, INVALID_ARGUMENT_TYPE, Integer.toString(i + 1), this.calleeScope.getReadableName(), formalType.toString(), argType.toString()));
                }
                ++i;
                argNode = argNode.getNext();
            }
        }

        public boolean equals(Object o) {
            Preconditions.checkArgument((boolean)(o instanceof DeferredCheck));
            DeferredCheck dc2 = (DeferredCheck)o;
            return this.callSite == dc2.callSite && this.callerScope == dc2.callerScope && this.calleeScope == dc2.calleeScope && Objects.equals(this.expectedRetType, dc2.expectedRetType) && Objects.equals(this.argTypes, dc2.argTypes);
        }

        public int hashCode() {
            return Objects.hash(this.callSite, this.callerScope, this.calleeScope, this.expectedRetType, this.argTypes);
        }
    }

    private static class LValueResultBwd {
        TypeEnv env;
        JSType type;
        QualifiedName ptr;

        LValueResultBwd(TypeEnv env, JSType type, QualifiedName ptr) {
            Preconditions.checkNotNull((Object)type);
            this.env = env;
            this.type = type;
            this.ptr = ptr;
        }
    }

    private static class LValueResultFwd {
        TypeEnv env;
        JSType type;
        JSType declType;
        QualifiedName ptr;

        LValueResultFwd(TypeEnv env, JSType type, JSType declType, QualifiedName ptr) {
            Preconditions.checkNotNull((Object)type);
            this.env = env;
            this.type = type;
            this.declType = declType;
            this.ptr = ptr;
        }
    }

    private static class EnvTypePair {
        TypeEnv env;
        JSType type;

        EnvTypePair(TypeEnv env, JSType type) {
            this.env = env;
            this.type = type;
        }

        static EnvTypePair addBinding(TypeEnv env, String varName, JSType type) {
            return new EnvTypePair(NewTypeInference.envPutType(env, varName, type), type);
        }

        static EnvTypePair join(EnvTypePair p1, EnvTypePair p2) {
            return new EnvTypePair(TypeEnv.join(p1.env, p2.env), JSType.join(p1.type, p2.type));
        }
    }

    public static class WarningReporter {
        AbstractCompiler compiler;

        WarningReporter(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        void add(JSError warning) {
            String filename = warning.node.getSourceFileName();
            if (filename != null && filename.startsWith(" [synthetic") || JSType.mockToString) {
                return;
            }
            this.compiler.report(warning);
        }
    }
}

