/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class CollapseVariableDeclarations
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final List<Collapse> collapses = new ArrayList<Collapse>();
    private final Set<Node> nodesToCollapse = new HashSet<Node>();

    CollapseVariableDeclarations(AbstractCompiler compiler) {
        Preconditions.checkState((!compiler.getLifeCycleStage().isNormalized() ? 1 : 0) != 0);
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        this.collapses.clear();
        this.nodesToCollapse.clear();
        NodeTraversal.traverseEs6(this.compiler, root, new GatherCollapses());
        if (!this.collapses.isEmpty()) {
            this.applyCollapses();
            this.compiler.reportCodeChange();
        }
    }

    private static boolean isNamedParameter(Var v) {
        return v.isParam();
    }

    private void applyCollapses() {
        for (Collapse collapse : this.collapses) {
            Node var = new Node(118);
            var.useSourceInfoIfMissingFrom(collapse.startNode);
            collapse.parent.addChildBefore(var, collapse.startNode);
            boolean redeclaration = false;
            Node n = collapse.startNode;
            while (n != collapse.endNode) {
                Node next = n.getNext();
                Preconditions.checkState((var.getNext() == n ? 1 : 0) != 0);
                collapse.parent.removeChildAfter(var);
                if (n.isVar()) {
                    while (n.hasChildren()) {
                        var.addChildToBack(n.removeFirstChild());
                    }
                } else {
                    Node assign = n.getFirstChild();
                    Node lhs = assign.getFirstChild();
                    Preconditions.checkState((boolean)lhs.isName());
                    Node rhs = assign.getLastChild();
                    lhs.addChildToBack(rhs.detachFromParent());
                    var.addChildToBack(lhs.detachFromParent());
                    redeclaration = true;
                }
                n = next;
            }
            if (!redeclaration) continue;
            JSDocInfoBuilder builder = new JSDocInfoBuilder(false);
            builder.recordSuppressions((Set<String>)ImmutableSet.of((Object)"duplicate"));
            JSDocInfo info = builder.build();
            var.setJSDocInfo(info);
        }
    }

    private class GatherCollapses
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Set<Var> blacklistedVars = new HashSet<Var>();

        private GatherCollapses() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isVar()) {
                this.blacklistStubVars(t, n);
            }
            if (!n.isVar() && !this.canBeRedeclared(n, t.getScope())) {
                return;
            }
            if (CollapseVariableDeclarations.this.nodesToCollapse.contains(n)) {
                return;
            }
            if (parent.isIf()) {
                return;
            }
            Node varNode = n;
            boolean hasVar = n.isVar();
            boolean hasNodesToCollapse = false;
            for (n = n.getNext(); n != null && (n.isVar() || this.canBeRedeclared(n, t.getScope())); n = n.getNext()) {
                if (n.isVar()) {
                    this.blacklistStubVars(t, n);
                    hasVar = true;
                }
                CollapseVariableDeclarations.this.nodesToCollapse.add(n);
                hasNodesToCollapse = true;
            }
            if (hasNodesToCollapse && hasVar) {
                CollapseVariableDeclarations.this.nodesToCollapse.add(varNode);
                CollapseVariableDeclarations.this.collapses.add(new Collapse(varNode, n, parent));
            }
        }

        private void blacklistStubVars(NodeTraversal t, Node varNode) {
            for (Node child = varNode.getFirstChild(); child != null; child = child.getNext()) {
                if (child.getFirstChild() != null) continue;
                this.blacklistedVars.add(t.getScope().getVar(child.getString()));
            }
        }

        private boolean canBeRedeclared(Node n, Scope s) {
            if (!NodeUtil.isExprAssign(n)) {
                return false;
            }
            Node assign = n.getFirstChild();
            Node lhs = assign.getFirstChild();
            if (!lhs.isName()) {
                return false;
            }
            Var var = s.getVar(lhs.getString());
            return var != null && NodeUtil.getEnclosingFunction(var.getScope().getRootNode()) == NodeUtil.getEnclosingFunction(s.getRootNode()) && !CollapseVariableDeclarations.isNamedParameter(var) && !this.blacklistedVars.contains(var);
        }
    }

    private static class Collapse {
        final Node startNode;
        final Node endNode;
        final Node parent;

        Collapse(Node startNode, Node endNode, Node parent) {
            this.startNode = startNode;
            this.endNode = endNode;
            this.parent = parent;
        }
    }
}

