/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.util;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.util.Iterables;
import java.util.TreeMap;

@Invariant(value={"root != null"})
public class PatternMap<R> {
    protected TernaryNode root;

    public PatternMap() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            this.root = new TernaryNode(null, false);
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == PatternMap.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == PatternMap.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$util$PatternMap();
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"isValidPattern(pattern)"})
    public R get(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            TernaryNode next;
            void pattern;
            String canon;
            boolean exact;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$get(string);
                contractContext.leaveContract();
            }
            boolean bl2 = exact = !(canon = pattern.replace('/', '.')).endsWith(".*");
            if (!exact) {
                canon = canon.substring(0, canon.length() - 2);
            }
            String[] parts = canon.split("\\.");
            TernaryNode current = this.root;
            R best = null;
            for (int i = 0; i < parts.length && (next = current.children.get(parts[i])) != null; ++i) {
                if (next.rule != null) {
                    if (next.exact) {
                        if (exact && i == parts.length - 1) {
                            best = next.rule;
                        }
                    } else {
                        best = next.rule;
                    }
                }
                current = next;
            }
            R r = best;
            if (contractContext.tryEnterContract()) {
                R r2;
                r = r2 = r;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return r;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="get")
    private /* synthetic */ void com$google$java$contract$P$get(String pattern) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$util$PatternMap$get(pattern, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"isValidPattern(pattern)"})
    public boolean isOverriden(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void pattern;
            String canon;
            boolean exact;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$isOverriden(string);
                contractContext.leaveContract();
            }
            boolean bl2 = exact = !(canon = pattern.replace('/', '.')).endsWith(".*");
            if (exact) {
                boolean bl3 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl4;
                    bl3 = bl4 = bl3;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl3;
            }
            canon = canon.substring(0, canon.length() - 2);
            String[] parts = canon.split("\\.");
            TernaryNode current = this.root;
            for (int i = 0; i < parts.length; ++i) {
                TernaryNode next = current.children.get(parts[i]);
                if (next == null) {
                    boolean bl5 = false;
                    if (contractContext.tryEnterContract()) {
                        boolean bl6;
                        bl5 = bl6 = bl5;
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return bl5;
                }
                current = next;
            }
            boolean bl7 = !current.children.isEmpty();
            if (contractContext.tryEnterContract()) {
                boolean bl8;
                bl7 = bl8 = bl7;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl7;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="isOverriden")
    private /* synthetic */ void com$google$java$contract$P$isOverriden(String pattern) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$util$PatternMap$isOverriden(pattern, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"isValidPattern(pattern)", "rule != null"})
    @Ensures(value={"rule.equals(get(pattern))", "!isOverriden(pattern)"})
    public void put(String string, R r) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void rule;
            TernaryNode next;
            int i;
            void pattern;
            String canon;
            boolean exact;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$put(string, r);
                contractContext.leaveContract();
            }
            boolean bl2 = exact = !(canon = pattern.replace('/', '.')).endsWith(".*");
            if (!exact) {
                canon = canon.substring(0, canon.length() - 2);
            }
            String[] parts = canon.split("\\.");
            TernaryNode current = this.root;
            TernaryNode parent = this.root;
            int parentIndex = -1;
            for (i = 0; i < parts.length; ++i) {
                next = current.children.get(parts[i]);
                if (next == null) {
                    next = new TernaryNode(null, false);
                    current.children.put(parts[i], next);
                }
                if (next.rule != null && !next.exact) {
                    parent = next;
                    parentIndex = i;
                }
                current = next;
            }
            if (!exact) {
                current.children.clear();
            }
            if (!rule.equals(parent.rule)) {
                current.rule = rule;
                current.exact = exact;
            } else {
                current = parent;
                for (i = parentIndex + 1; i < parts.length; ++i) {
                    next = current.children.get(parts[i]);
                    if (next.rule != null) continue;
                    current.children.remove(parts[i]);
                    break;
                }
            }
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$put((String)pattern, rule);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="put")
    private /* synthetic */ void com$google$java$contract$P$put(String pattern, R rule) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$util$PatternMap$put(pattern, rule, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="put")
    private /* synthetic */ void com$google$java$contract$Q$put(String pattern, R rule) {
        this.com$google$java$contract$QH$com$google$java$contract$core$util$PatternMap$put(pattern, rule);
    }

    public static boolean isValidPattern(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(PatternMap.class);
        try {
            String pattern;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (pattern == null) {
                boolean bl2 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl3;
                    bl2 = bl3 = bl2;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(PatternMap.class);
                }
                return bl2;
            }
            String canon = pattern.replace('/', '.');
            boolean bl4 = ClassName.isQualifiedName(canon) || ClassName.isStarQualifiedName(canon);
            if (contractContext.tryEnterContract()) {
                boolean bl5;
                bl4 = bl5 = bl4;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(PatternMap.class);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(PatternMap.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={50L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$util$PatternMap() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.root != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("root != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="get", lines={81L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$PatternMap$get(String pattern, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = PatternMap.isValidPattern(pattern);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("isValidPattern(pattern)", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="isOverriden", lines={124L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$PatternMap$isOverriden(String pattern, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = PatternMap.isValidPattern(pattern);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("isValidPattern(pattern)", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="put", lines={149L, 150L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$PatternMap$put(String pattern, R rule, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = PatternMap.isValidPattern(pattern);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("isValidPattern(pattern)", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = rule != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("rule != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="put", lines={153L, 154L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$util$PatternMap$put(String pattern, R rule) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = rule.equals(this.get(pattern));
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("rule.equals(get(pattern))", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = !this.isOverriden(pattern);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("!isOverriden(pattern)", com$google$java$contract$local$exception$3));
        }
    }

    @Invariant(value={"children != null", "Iterables.all(children.keySet(), ClassName.isSimpleName())", "!children.values().contains(null)"})
    protected class TernaryNode {
        protected TreeMap<String, TernaryNode> children;
        protected R rule;
        protected boolean exact;

        protected TernaryNode(R rule, boolean exact) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                this.children = new TreeMap();
                this.rule = rule;
                this.exact = exact;
                if (contractContext.tryEnterContract()) {
                    if (this.getClass() == TernaryNode.class) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (this.getClass() == TernaryNode.class) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.INVARIANT)
        private /* synthetic */ void com$google$java$contract$I() {
            this.com$google$java$contract$IH$com$google$java$contract$core$util$PatternMap$TernaryNode();
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, lines={56L, 57L, 58L})
        protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$util$PatternMap$TernaryNode() {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = this.children != null;
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                ContractRuntime.raise(new InvariantError("children != null", com$google$java$contract$local$exception$1));
            }
            boolean com$google$java$contract$local$success$1 = false;
            Throwable com$google$java$contract$local$exception$3 = null;
            try {
                com$google$java$contract$local$success$1 = Iterables.all(this.children.keySet(), ClassName.isSimpleName());
            }
            catch (Throwable com$google$java$contract$local$exception$2) {
                com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
            }
            if (!com$google$java$contract$local$success$1) {
                ContractRuntime.raise(new InvariantError("Iterables.all(children.keySet(), ClassName.isSimpleName())", com$google$java$contract$local$exception$3));
            }
            boolean com$google$java$contract$local$success$2 = false;
            Throwable com$google$java$contract$local$exception$5 = null;
            try {
                com$google$java$contract$local$success$2 = !this.children.values().contains(null);
            }
            catch (Throwable com$google$java$contract$local$exception$4) {
                com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
            }
            if (!com$google$java$contract$local$success$2) {
                ContractRuntime.raise(new InvariantError("!children.values().contains(null)", com$google$java$contract$local$exception$5));
            }
        }
    }
}

