/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.util;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;

@Invariant(value={"reader != null"})
public class JavaTokenizer
implements Iterator<Token> {
    protected PushbackReader reader;
    protected Token nextToken;
    protected boolean hasErrors_;
    protected String errorMessage;
    protected int currentOffset;

    @Requires(value={"reader != null"})
    public JavaTokenizer(Reader reader) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$JavaTokenizer(reader);
                contractContext.leaveContract();
            }
            this.reader = new PushbackReader(reader);
            this.nextToken = null;
            this.hasErrors_ = false;
            this.currentOffset = 0;
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == JavaTokenizer.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == JavaTokenizer.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$JavaTokenizer(Reader reader) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$util$JavaTokenizer$JavaTokenizer(reader, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$util$JavaTokenizer();
    }

    /*
     * WARNING - void declaration
     */
    @Ensures(value={"!allowEOF ? result >= 0 : result >= -1"})
    protected int readChar(boolean bl) throws IOException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl2 = contractContext.tryEnter(this);
        try {
            void allowEOF;
            int c;
            if (contractContext.tryEnterContract()) {
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if ((c = this.reader.read()) != -1) {
                ++this.currentOffset;
            } else if (allowEOF == false) {
                throw new IOException();
            }
            int n = c;
            if (contractContext.tryEnterContract()) {
                int n2;
                n = n2 = n;
                this.com$google$java$contract$Q$readChar((boolean)allowEOF, n2);
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            return n;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="readChar")
    private /* synthetic */ void com$google$java$contract$Q$readChar(boolean allowEOF, int result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$util$JavaTokenizer$readChar(allowEOF, result);
    }

    /*
     * WARNING - void declaration
     */
    protected void unreadChar(int n) throws IOException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void c;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (c == -1) {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            --this.currentOffset;
            this.reader.unread((int)c);
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Requires(value={"nextToken == null"})
    @Ensures(value={"result == (nextToken != null)"})
    protected boolean lex() throws IOException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$lex();
                contractContext.leaveContract();
            }
            int startOffset = this.currentOffset;
            StringBuilder buffer = new StringBuilder();
            int c = this.readChar(true);
            if (c == -1) {
                boolean bl2 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl3;
                    bl2 = bl3 = bl2;
                    this.com$google$java$contract$Q$lex(bl3);
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl2;
            }
            buffer.append((char)c);
            block1 : switch (c) {
                case 47: {
                    c = this.readChar(true);
                    switch (c) {
                        case 47: {
                            buffer.append((char)c);
                            do {
                                c = this.readChar(false);
                                buffer.append((char)c);
                            } while (c != 10);
                            this.nextToken = new Token(TokenKind.COMMENT, buffer.toString(), startOffset);
                            break block1;
                        }
                        case 42: {
                            buffer.append((char)c);
                            while (true) {
                                c = this.readChar(false);
                                buffer.append((char)c);
                                if (c != 42) continue;
                                c = this.readChar(false);
                                buffer.append((char)c);
                                if (c == 47) break;
                            }
                            this.nextToken = new Token(TokenKind.COMMENT, buffer.toString(), startOffset);
                            break block1;
                        }
                    }
                    this.unreadChar(c);
                    this.nextToken = new Token(TokenKind.SYMBOL, buffer.toString(), startOffset);
                    break;
                }
                case 34: 
                case 39: {
                    int delim = c;
                    while (true) {
                        c = this.readChar(false);
                        buffer.append((char)c);
                        if (c == delim) break;
                        if (c != 92) continue;
                        buffer.append((char)this.readChar(false));
                    }
                    this.nextToken = new Token(TokenKind.QUOTE, buffer.toString(), startOffset);
                    break;
                }
                default: {
                    if (Character.isJavaIdentifierStart(c)) {
                        while ((c = this.readChar(true)) != -1 && Character.isJavaIdentifierPart(c)) {
                            buffer.append((char)c);
                        }
                        this.unreadChar(c);
                        this.nextToken = new Token(TokenKind.WORD, buffer.toString(), startOffset);
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        while ((c = this.readChar(true)) != -1 && Character.isWhitespace(c)) {
                            buffer.append((char)c);
                        }
                        this.unreadChar(c);
                        this.nextToken = new Token(TokenKind.SPACE, buffer.toString(), startOffset);
                        break;
                    }
                    this.nextToken = new Token(TokenKind.SYMBOL, buffer.toString(), startOffset);
                }
            }
            boolean bl4 = true;
            if (contractContext.tryEnterContract()) {
                boolean bl5;
                bl4 = bl5 = bl4;
                this.com$google$java$contract$Q$lex(bl5);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="lex")
    private /* synthetic */ void com$google$java$contract$P$lex() {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$util$JavaTokenizer$lex(com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="lex")
    private /* synthetic */ void com$google$java$contract$Q$lex(boolean result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$util$JavaTokenizer$lex(result);
    }

    public Token getNextToken() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (this.nextToken == null) {
                try {
                    if (!this.lex()) {
                        throw new NoSuchElementException();
                    }
                }
                catch (IOException e) {
                    this.errorMessage = e.getMessage();
                    this.hasErrors_ = true;
                    throw new NoSuchElementException();
                }
            }
            Token token = this.nextToken;
            if (contractContext.tryEnterContract()) {
                Token token2;
                token = token2 = token;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return token;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public int getCurrentOffset() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            int n = this.currentOffset;
            if (contractContext.tryEnterContract()) {
                int n2;
                n = n2 = n;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return n;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public boolean hasErrors() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            boolean bl2 = this.hasErrors_;
            if (contractContext.tryEnterContract()) {
                boolean bl3;
                bl2 = bl3 = bl2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Requires(value={"hasErrors()"})
    public String getErrorMessage() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getErrorMessage();
                contractContext.leaveContract();
            }
            String string = this.errorMessage;
            if (contractContext.tryEnterContract()) {
                String string2;
                string = string2 = string;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getErrorMessage")
    private /* synthetic */ void com$google$java$contract$P$getErrorMessage() {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$util$JavaTokenizer$getErrorMessage(com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Override
    public boolean hasNext() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            boolean bl2;
            block18: {
                boolean bl3;
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (this.nextToken != null) {
                    boolean bl4 = true;
                    if (contractContext.tryEnterContract()) {
                        boolean bl5;
                        bl4 = bl5 = bl4;
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return bl4;
                }
                try {
                    bl2 = this.lex();
                    if (!contractContext.tryEnterContract()) break block18;
                }
                catch (IOException e) {
                    this.errorMessage = e.getMessage();
                    this.hasErrors_ = true;
                    boolean bl6 = false;
                    if (contractContext.tryEnterContract()) {
                        boolean bl7;
                        bl6 = bl7 = bl6;
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return bl6;
                }
                bl2 = bl3 = bl2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Override
    public Token next() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            Token token = this.getNextToken();
            this.nextToken = null;
            Token token2 = token;
            if (contractContext.tryEnterContract()) {
                Token token3;
                token2 = token3 = token2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return token2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Override
    public void remove() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            throw new UnsupportedOperationException();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={37L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$util$JavaTokenizer() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.reader != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("reader != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={114L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$JavaTokenizer$JavaTokenizer(Reader reader, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = reader != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("reader != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="readChar", lines={130L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$util$JavaTokenizer$readChar(boolean allowEOF, int result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = !allowEOF ? result >= 0 : result >= -1;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("!allowEOF ? result >= 0 : result >= -1", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="lex", lines={162L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$JavaTokenizer$lex(PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.nextToken == null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("nextToken == null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="lex", lines={163L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$util$JavaTokenizer$lex(boolean result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result == (this.nextToken != null);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result == (nextToken != null)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getErrorMessage", lines={281L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$JavaTokenizer$getErrorMessage(PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.hasErrors();
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("hasErrors()", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    public class Token {
        public final TokenKind kind;
        public final String text;
        public final int offset;

        protected Token(TokenKind kind, String text, int offset) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                this.kind = kind;
                this.text = text;
                this.offset = offset;
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }
    }

    public static final class TokenKind
    extends Enum<TokenKind> {
        public static final /* enum */ TokenKind WORD;
        public static final /* enum */ TokenKind QUOTE;
        public static final /* enum */ TokenKind SYMBOL;
        public static final /* enum */ TokenKind COMMENT;
        public static final /* enum */ TokenKind SPACE;
        private static final /* synthetic */ TokenKind[] $VALUES;

        public static TokenKind[] values() {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(TokenKind.class);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                TokenKind[] tokenKindArray = (TokenKind[])$VALUES.clone();
                if (contractContext.tryEnterContract()) {
                    TokenKind[] tokenKindArray2;
                    tokenKindArray = tokenKindArray2 = tokenKindArray;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(TokenKind.class);
                }
                return tokenKindArray;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(TokenKind.class);
                }
                throw throwable2;
            }
        }

        public static TokenKind valueOf(String string) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(TokenKind.class);
            try {
                String name;
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                TokenKind tokenKind = Enum.valueOf(TokenKind.class, name);
                if (contractContext.tryEnterContract()) {
                    TokenKind tokenKind2;
                    tokenKind = tokenKind2 = tokenKind;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(TokenKind.class);
                }
                return tokenKind;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(TokenKind.class);
                }
                throw throwable2;
            }
        }

        private TokenKind() {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter((Object)this);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave((Object)this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave((Object)this);
                }
                throw throwable2;
            }
        }

        static {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(TokenKind.class);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                WORD = new TokenKind();
                QUOTE = new TokenKind();
                SYMBOL = new TokenKind();
                COMMENT = new TokenKind();
                SPACE = new TokenKind();
                $VALUES = new TokenKind[]{WORD, QUOTE, SYMBOL, COMMENT, SPACE};
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(TokenKind.class);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(TokenKind.class);
                }
                throw throwable2;
            }
        }
    }
}

