/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.util;

import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModel;
import com.google.java.contract.core.model.MethodModel;
import com.google.java.contract.core.model.TypeModel;
import com.google.java.contract.core.model.VariableModel;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.tools.JavaFileObject;

public class Elements {
    public Elements() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"method != null", "parameters != null", "!parameters.contains(null)"})
    public static void copyParameters(MethodModel methodModel, List<? extends VariableModel> list) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(Elements.class);
        try {
            void parameters;
            if (contractContext.tryEnterContract()) {
                Elements.com$google$java$contract$P$copyParameters(methodModel, list);
                contractContext.leaveContract();
            }
            ArrayList list2 = new ArrayList(parameters);
            for (VariableModel param : list2) {
                MethodModel method;
                method.addParameter(new VariableModel(param));
            }
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(Elements.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(Elements.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="copyParameters")
    private static /* synthetic */ void com$google$java$contract$P$copyParameters(MethodModel method, List<? extends VariableModel> parameters) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = Elements.com$google$java$contract$PH$com$google$java$contract$core$util$Elements$copyParameters(method, parameters, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"elements != null", "!elements.contains(null)", "clazz != null", "kinds != null"})
    public static <T extends ElementModel> List<? extends T> filter(List<? extends ElementModel> list, Class<T> clazz, ElementKind ... elementKindArray) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(Elements.class);
        try {
            List<? extends ElementModel> elements;
            void kinds;
            if (contractContext.tryEnterContract()) {
                Elements.com$google$java$contract$P$filter(list, clazz, elementKindArray);
                contractContext.leaveContract();
            }
            ArrayList<ElementModel> result = new ArrayList<ElementModel>();
            List list2 = Arrays.asList(kinds);
            for (ElementModel elementModel : elements) {
                void clazz2;
                if (!list2.contains((Object)elementModel.getKind()) || !clazz2.isAssignableFrom(elementModel.getClass())) continue;
                result.add(elementModel);
            }
            List list3 = Collections.unmodifiableList(result);
            if (contractContext.tryEnterContract()) {
                List list4;
                list3 = list4 = list3;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(Elements.class);
            }
            return list3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(Elements.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="filter")
    private static /* synthetic */ <T extends ElementModel> void com$google$java$contract$P$filter(List<? extends ElementModel> elements, Class<T> clazz, ElementKind[] kinds) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = Elements.com$google$java$contract$PH$com$google$java$contract$core$util$Elements$filter(elements, clazz, kinds, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"element != null", "clazz != null", "kinds != null"})
    public static <T extends ElementModel> T findEnclosingElement(ElementModel elementModel, Class<T> clazz, ElementKind ... elementKindArray) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(Elements.class);
        try {
            void clazz2;
            ElementModel element;
            void kinds;
            if (contractContext.tryEnterContract()) {
                Elements.com$google$java$contract$P$findEnclosingElement(elementModel, clazz, elementKindArray);
                contractContext.leaveContract();
            }
            List list = Arrays.asList(kinds);
            do {
                if ((element = element.getEnclosingElement()) != null) continue;
                T t = null;
                if (contractContext.tryEnterContract()) {
                    T t2;
                    t = t2 = t;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(Elements.class);
                }
                return t;
            } while (!list.contains((Object)element.getKind()) || !clazz2.isAssignableFrom(element.getClass()));
            ElementModel elementModel2 = element;
            if (contractContext.tryEnterContract()) {
                ElementModel elementModel3;
                elementModel2 = elementModel3 = elementModel2;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(Elements.class);
            }
            return (T)elementModel2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(Elements.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="findEnclosingElement")
    private static /* synthetic */ <T extends ElementModel> void com$google$java$contract$P$findEnclosingElement(ElementModel element, Class<T> clazz, ElementKind[] kinds) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = Elements.com$google$java$contract$PH$com$google$java$contract$core$util$Elements$findEnclosingElement(element, clazz, kinds, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Requires(value={"element != null"})
    public static TypeModel getTypeOf(ElementModel elementModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(Elements.class);
        try {
            ElementModel element;
            if (contractContext.tryEnterContract()) {
                Elements.com$google$java$contract$P$getTypeOf(elementModel);
                contractContext.leaveContract();
            }
            TypeModel typeModel = Elements.findEnclosingElement(element, TypeModel.class, ElementKind.CLASS, ElementKind.ENUM, ElementKind.INTERFACE);
            if (contractContext.tryEnterContract()) {
                TypeModel typeModel2;
                typeModel = typeModel2 = typeModel;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(Elements.class);
            }
            return typeModel;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(Elements.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getTypeOf")
    private static /* synthetic */ void com$google$java$contract$P$getTypeOf(ElementModel element) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = Elements.com$google$java$contract$PH$com$google$java$contract$core$util$Elements$getTypeOf(element, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"name != null", "!name.isEmpty()", "kind != null"})
    public static URI getUriForClass(String string, JavaFileObject.Kind kind) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(Elements.class);
        try {
            URI uRI;
            block8: {
                URI uRI2;
                if (contractContext.tryEnterContract()) {
                    Elements.com$google$java$contract$P$getUriForClass(string, kind);
                    contractContext.leaveContract();
                }
                try {
                    void kind2;
                    String name;
                    uRI = new URI("com.google.java.contract://com.google.java.contract/" + name + kind2.extension);
                    if (!contractContext.tryEnterContract()) break block8;
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException();
                }
                uRI = uRI2 = uRI;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(Elements.class);
            }
            return uRI;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(Elements.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getUriForClass")
    private static /* synthetic */ void com$google$java$contract$P$getUriForClass(String name, JavaFileObject.Kind kind) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = Elements.com$google$java$contract$PH$com$google$java$contract$core$util$Elements$getUriForClass(name, kind, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="copyParameters", lines={47L, 48L, 49L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$Elements$copyParameters(MethodModel method, List<? extends VariableModel> parameters, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = method != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("method != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = parameters != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("parameters != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = !parameters.contains(null);
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("!parameters.contains(null)", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="filter", lines={63L, 64L, 65L, 66L})
    protected static /* synthetic */ <T extends ElementModel> PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$Elements$filter(List<? extends ElementModel> elements, Class<T> clazz, ElementKind[] kinds, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = elements != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("elements != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = !elements.contains(null);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("!elements.contains(null)", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = clazz != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("clazz != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = kinds != null;
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            return new PreconditionError("kinds != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$7);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="findEnclosingElement", lines={87L, 88L, 89L})
    protected static /* synthetic */ <T extends ElementModel> PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$Elements$findEnclosingElement(ElementModel element, Class<T> clazz, ElementKind[] kinds, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = element != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("element != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = clazz != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("clazz != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = kinds != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("kinds != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getTypeOf", lines={110L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$Elements$getTypeOf(ElementModel element, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = element != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("element != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getUriForClass", lines={121L, 122L, 123L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$Elements$getUriForClass(String name, JavaFileObject.Kind kind, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = name != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("name != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = !name.isEmpty();
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("!name.isEmpty()", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        return null;
    }
}

