/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.runtime;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.DebugUtils;
import com.google.java.contract.core.util.PatternMap;

@Invariant(value={"blacklist != null"})
public class BlacklistManager {
    protected static BlacklistManager instance;
    protected PatternMap<Boolean> blacklist;

    protected BlacklistManager() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            this.blacklist = new PatternMap();
            this.blacklist = new PatternMap();
            this.blacklist.put("java.*", true);
            this.blacklist.put("javax.*", true);
            this.blacklist.put("com.sun.*", true);
            this.blacklist.put("sun.*", true);
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == BlacklistManager.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == BlacklistManager.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$runtime$BlacklistManager();
    }

    public static BlacklistManager getInstance() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(BlacklistManager.class);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (instance == null) {
                instance = new BlacklistManager();
            }
            BlacklistManager blacklistManager = instance;
            if (contractContext.tryEnterContract()) {
                BlacklistManager blacklistManager2;
                blacklistManager = blacklistManager2 = blacklistManager;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(BlacklistManager.class);
            }
            return blacklistManager;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(BlacklistManager.class);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"pattern != null"})
    @Ensures(value={"isIgnored(pattern)"})
    public synchronized void ignore(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void pattern;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$ignore(string);
                contractContext.leaveContract();
            }
            DebugUtils.info("activation", (String)pattern + " +blacklist");
            this.blacklist.put((String)pattern, true);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$ignore((String)pattern);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="ignore")
    private synchronized /* synthetic */ void com$google$java$contract$P$ignore(String pattern) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$runtime$BlacklistManager$ignore(pattern, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="ignore")
    private synchronized /* synthetic */ void com$google$java$contract$Q$ignore(String pattern) {
        this.com$google$java$contract$QH$com$google$java$contract$core$runtime$BlacklistManager$ignore(pattern);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"pattern != null"})
    @Ensures(value={"!isIgnored(pattern)"})
    public synchronized void unignore(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void pattern;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$unignore(string);
                contractContext.leaveContract();
            }
            DebugUtils.info("activation", (String)pattern + " -blacklist");
            this.blacklist.put((String)pattern, false);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$unignore((String)pattern);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="unignore")
    private synchronized /* synthetic */ void com$google$java$contract$P$unignore(String pattern) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$runtime$BlacklistManager$unignore(pattern, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="unignore")
    private synchronized /* synthetic */ void com$google$java$contract$Q$unignore(String pattern) {
        this.com$google$java$contract$QH$com$google$java$contract$core$runtime$BlacklistManager$unignore(pattern);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"pattern != null"})
    public synchronized boolean isIgnored(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void pattern;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$isIgnored(string);
                contractContext.leaveContract();
            }
            if (pattern.endsWith(".*") && this.blacklist.isOverriden((String)pattern)) {
                boolean bl2 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl3;
                    bl2 = bl3 = bl2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl2;
            }
            Boolean rule = this.blacklist.get((String)pattern);
            boolean bl4 = rule != null && rule != false;
            if (contractContext.tryEnterContract()) {
                boolean bl5;
                bl4 = bl5 = bl4;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="isIgnored")
    private synchronized /* synthetic */ void com$google$java$contract$P$isIgnored(String pattern) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$runtime$BlacklistManager$isIgnored(pattern, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    static {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(BlacklistManager.class);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            instance = null;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(BlacklistManager.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(BlacklistManager.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={32L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$runtime$BlacklistManager() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.blacklist != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("blacklist != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="ignore", lines={53L})
    protected synchronized /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$runtime$BlacklistManager$ignore(String pattern, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = pattern != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("pattern != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="ignore", lines={54L})
    protected synchronized /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$runtime$BlacklistManager$ignore(String pattern) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.isIgnored(pattern);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("isIgnored(pattern)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="unignore", lines={60L})
    protected synchronized /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$runtime$BlacklistManager$unignore(String pattern, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = pattern != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("pattern != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="unignore", lines={61L})
    protected synchronized /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$runtime$BlacklistManager$unignore(String pattern) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = !this.isIgnored(pattern);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("!isIgnored(pattern)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="isIgnored", lines={67L})
    protected synchronized /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$runtime$BlacklistManager$isIgnored(String pattern, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = pattern != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("pattern != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }
}

