/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.model;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModel;
import com.google.java.contract.core.model.ElementModifier;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import java.util.EnumSet;

@Invariant(value={"getModifiers() != null"})
public abstract class QualifiedElementModel
extends ElementModel {
    protected EnumSet<ElementModifier> modifiers;

    @Requires(value={"kind != null", "name != null"})
    protected QualifiedElementModel(ElementKind kind, String name) {
        super(kind, name);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$QualifiedElementModel(kind, name);
                contractContext.leaveContract();
            }
            this.modifiers = EnumSet.noneOf(ElementModifier.class);
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == QualifiedElementModel.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == QualifiedElementModel.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$QualifiedElementModel(ElementKind kind, String name) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$QualifiedElementModel$QualifiedElementModel(kind, name, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$model$QualifiedElementModel();
        this.com$google$java$contract$IH$com$google$java$contract$core$model$ElementModel();
    }

    @Requires(value={"that != null"})
    @Ensures(value={"getEnclosingElement() == null"})
    protected QualifiedElementModel(QualifiedElementModel that) {
        super(that);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$QualifiedElementModel(that);
                contractContext.leaveContract();
            }
            this.modifiers = EnumSet.copyOf(that.modifiers);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$QualifiedElementModel(that);
                if (this.getClass() == QualifiedElementModel.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == QualifiedElementModel.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$QualifiedElementModel(QualifiedElementModel that) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$QualifiedElementModel$QualifiedElementModel(that, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="<init>")
    private /* synthetic */ void com$google$java$contract$Q$QualifiedElementModel(QualifiedElementModel that) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$QualifiedElementModel$QualifiedElementModel(that);
    }

    @Override
    protected QualifiedElementModel clone() throws CloneNotSupportedException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            throw new CloneNotSupportedException();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public EnumSet<ElementModifier> getModifiers() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            EnumSet<ElementModifier> enumSet = this.modifiers;
            if (contractContext.tryEnterContract()) {
                EnumSet<ElementModifier> enumSet2;
                enumSet = enumSet2 = enumSet;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return enumSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"modifier != null"})
    @Ensures(value={"getModifiers().contains(modifier)"})
    public void addModifier(ElementModifier elementModifier) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void modifier;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$addModifier(elementModifier);
                contractContext.leaveContract();
            }
            switch (1.$SwitchMap$com$google$java$contract$core$model$ElementModifier[modifier.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.modifiers.remove((Object)ElementModifier.PRIVATE);
                    this.modifiers.remove((Object)ElementModifier.PACKAGE_PRIVATE);
                    this.modifiers.remove((Object)ElementModifier.PROTECTED);
                    this.modifiers.remove((Object)ElementModifier.PUBLIC);
                }
            }
            this.modifiers.add((ElementModifier)modifier);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$addModifier((ElementModifier)modifier);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="addModifier")
    private /* synthetic */ void com$google$java$contract$P$addModifier(ElementModifier modifier) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$QualifiedElementModel$addModifier(modifier, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="addModifier")
    private /* synthetic */ void com$google$java$contract$Q$addModifier(ElementModifier modifier) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$QualifiedElementModel$addModifier(modifier);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"modifier != null"})
    @Ensures(value={"!getModifiers().contains(modifier)"})
    public void removeModifier(ElementModifier elementModifier) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void modifier;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$removeModifier(elementModifier);
                contractContext.leaveContract();
            }
            this.modifiers.remove(modifier);
            switch (1.$SwitchMap$com$google$java$contract$core$model$ElementModifier[modifier.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.modifiers.add(ElementModifier.PACKAGE_PRIVATE);
                }
            }
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$removeModifier((ElementModifier)modifier);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="removeModifier")
    private /* synthetic */ void com$google$java$contract$P$removeModifier(ElementModifier modifier) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$QualifiedElementModel$removeModifier(modifier, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="removeModifier")
    private /* synthetic */ void com$google$java$contract$Q$removeModifier(ElementModifier modifier) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$QualifiedElementModel$removeModifier(modifier);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="clone")
    private /* synthetic */ void com$google$java$contract$Q$clone(QualifiedElementModel result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ElementModel$clone(result);
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={31L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$model$QualifiedElementModel() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getModifiers() != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("getModifiers() != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={43L, 44L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$QualifiedElementModel$QualifiedElementModel(ElementKind kind, String name, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = name != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("name != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={51L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$QualifiedElementModel$QualifiedElementModel(QualifiedElementModel that, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = that != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("that != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={52L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$QualifiedElementModel$QualifiedElementModel(QualifiedElementModel that) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getEnclosingElement() == null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getEnclosingElement() == null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addModifier", lines={75L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$QualifiedElementModel$addModifier(ElementModifier modifier, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = modifier != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("modifier != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addModifier", lines={76L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$QualifiedElementModel$addModifier(ElementModifier modifier) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getModifiers().contains((Object)modifier);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getModifiers().contains(modifier)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="removeModifier", lines={96L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$QualifiedElementModel$removeModifier(ElementModifier modifier, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = modifier != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("modifier != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="removeModifier", lines={97L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$QualifiedElementModel$removeModifier(ElementModifier modifier) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = !this.getModifiers().contains((Object)modifier);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("!getModifiers().contains(modifier)", com$google$java$contract$local$exception$1));
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$com$google$java$contract$core$model$ElementModifier;

        static {
            $SwitchMap$com$google$java$contract$core$model$ElementModifier = new int[ElementModifier.values().length];
            try {
                1.$SwitchMap$com$google$java$contract$core$model$ElementModifier[ElementModifier.PRIVATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$google$java$contract$core$model$ElementModifier[ElementModifier.PACKAGE_PRIVATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$google$java$contract$core$model$ElementModifier[ElementModifier.PROTECTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$google$java$contract$core$model$ElementModifier[ElementModifier.PUBLIC.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

