/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.apt.AbstractTypeBuilder;
import com.google.java.contract.core.apt.AnnotationSourceInfo;
import com.google.java.contract.core.apt.DiagnosticManager;
import com.google.java.contract.core.apt.FactoryUtils;
import com.google.java.contract.core.apt.SuperCallBuilder;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractAnnotationModel;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModel;
import com.google.java.contract.core.model.ElementModifier;
import com.google.java.contract.core.model.MethodModel;
import com.google.java.contract.core.model.TypeModel;
import com.google.java.contract.core.model.VariableModel;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

@Invariant(value={"diagnosticManager != null", "methodMap != null"})
class TypeBuilder
extends AbstractTypeBuilder {
    protected ClassLoader sourceDependencyLoader;
    protected TypeModel type;
    protected TypeElement rootMirror;
    protected Set<String> importNames;
    protected HashMap<String, ArrayList<ContractableMethod>> methodMap;

    TypeBuilder(Set<String> importNames, Iterator<Long> rootLineNumberIterator, FactoryUtils utils, ClassLoader sourceDependencyLoader, DiagnosticManager diagnosticManager) {
        super(utils, diagnosticManager);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            this.sourceDependencyLoader = sourceDependencyLoader;
            this.type = null;
            this.rootMirror = null;
            this.importNames = importNames;
            this.rootLineNumberIterator = rootLineNumberIterator;
            this.methodMap = new HashMap();
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == TypeBuilder.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == TypeBuilder.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$apt$TypeBuilder();
        this.com$google$java$contract$IH$com$google$java$contract$core$apt$AbstractTypeBuilder();
    }

    TypeBuilder(FactoryUtils utils, ClassLoader sourceDependencyLoader, DiagnosticManager diagnosticManager) {
        this(null, null, utils, sourceDependencyLoader, diagnosticManager);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == TypeBuilder.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == TypeBuilder.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    TypeModel getType() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            TypeModel typeModel = this.type;
            if (contractContext.tryEnterContract()) {
                TypeModel typeModel2;
                typeModel = typeModel2 = typeModel;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return typeModel;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Ensures(value={"type != null"})
    public Void visitType(TypeElement typeElement, ElementModel elementModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            TypeMirror superMirror;
            TypeMirror superclass;
            void p;
            void e;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (this.type != null) {
                TypeBuilder builder = new TypeBuilder(this.importNames, this.rootLineNumberIterator, this.utils, this.sourceDependencyLoader, this.diagnosticManager);
                e.accept(builder, p);
                p.addEnclosedElement(builder.type);
                Void void_ = null;
                if (contractContext.tryEnterContract()) {
                    Void void_2;
                    void_ = void_2 = void_;
                    this.com$google$java$contract$Q$visitType((TypeElement)e, (ElementModel)p, void_2);
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return void_;
            }
            this.rootMirror = e;
            ElementKind kind = null;
            switch (e.getKind()) {
                case INTERFACE: {
                    kind = ElementKind.INTERFACE;
                    break;
                }
                case ENUM: {
                    kind = ElementKind.ENUM;
                    break;
                }
                case CLASS: {
                    kind = ElementKind.CLASS;
                    break;
                }
                case ANNOTATION_TYPE: {
                    kind = ElementKind.ANNOTATION_TYPE;
                    break;
                }
                default: {
                    Void void_ = null;
                    if (contractContext.tryEnterContract()) {
                        Void void_3;
                        void_ = void_3 = void_;
                        this.com$google$java$contract$Q$visitType((TypeElement)e, (ElementModel)p, void_3);
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return void_;
                }
            }
            this.type = new TypeModel(kind, this.utils.getClassNameForType(e.asType()));
            this.utils.copyModifiers((Element)e, this.type);
            if (kind == ElementKind.ENUM) {
                this.type.removeModifier(ElementModifier.FINAL);
            }
            if (this.importNames == null) {
                if (this.sourceDependencyLoader != null) {
                    try {
                        this.fetchSourceDependency();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                if (this.importNames == null) {
                    this.importNames = this.getImportNames((Element)e);
                }
                for (String importName : this.importNames) {
                    this.type.addImportName(importName);
                }
            }
            if ((superclass = e.getSuperclass()).getKind() == TypeKind.DECLARED) {
                this.type.setSuperclass(this.utils.getClassNameForType(superclass));
            }
            List<? extends TypeMirror> interfaces = e.getInterfaces();
            for (TypeMirror typeMirror : interfaces) {
                this.type.addInterface(this.utils.getClassNameForType(typeMirror));
            }
            if (kind != ElementKind.ENUM && (superMirror = e.getSuperclass()).getKind() == TypeKind.DECLARED) {
                TypeElement typeElement2 = (TypeElement)this.utils.typeUtils.asElement(superMirror);
                SuperCallBuilder superCallBuilder = new SuperCallBuilder((DeclaredType)superMirror, this.type, this.utils);
                typeElement2.accept(superCallBuilder, null);
            }
            List<? extends TypeParameterElement> typeParams = e.getTypeParameters();
            for (TypeParameterElement typeParameterElement : typeParams) {
                this.type.addTypeParameter(this.utils.getGenericTypeName(typeParameterElement));
            }
            this.scanAnnotations((Element)e, true, this.type.getName(), this.type);
            this.scan(e.getEnclosedElements(), this.type);
            this.scanSuper((TypeElement)e);
            Void void_ = null;
            if (contractContext.tryEnterContract()) {
                Void void_2;
                void_ = void_2 = void_;
                this.com$google$java$contract$Q$visitType((TypeElement)e, (ElementModel)p, void_2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return void_;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="visitType")
    private /* synthetic */ void com$google$java$contract$Q$visitType(TypeElement e, ElementModel p, Void result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$TypeBuilder$visitType(e, p, result);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void visitAnnotation(Element element, AnnotationMirror annotationMirror, boolean bl, ClassName className, ElementModel elementModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl2 = contractContext.tryEnter(this);
        try {
            void annotation;
            if (contractContext.tryEnterContract()) {
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$visitAnnotation(element, annotationMirror, bl, className, elementModel);
                contractContext.leaveContract();
            }
            if (this.utils.isContractAnnotation((AnnotationMirror)annotation)) {
                void owner;
                void primary;
                void parent;
                ContractAnnotationModel model = this.createContractModel((Element)parent, (AnnotationMirror)annotation, (boolean)primary, (ClassName)owner);
                if (model == null) {
                    if (contractContext.tryEnterContract()) {
                        if (bl2) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl2) {
                        contractContext.leave(this);
                    }
                    return;
                }
                if (this.type.getKind() == ElementKind.ANNOTATION_TYPE) {
                    AnnotationSourceInfo asi = (AnnotationSourceInfo)model.getSourceInfo();
                    this.diagnosticManager.warning("Contracts can't be applied to annotations. The following annotation will not perform any contract check: " + this.type.toString(), ((Object)asi.getAnnotationValue()).toString(), 0, 0, 0, asi);
                } else {
                    void p;
                    p.addEnclosedElement(model);
                }
            }
            if (contractContext.tryEnterContract()) {
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="visitAnnotation")
    private /* synthetic */ void com$google$java$contract$P$visitAnnotation(Element parent, AnnotationMirror annotation, boolean primary, ClassName owner, ElementModel p) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$AbstractTypeBuilder$visitAnnotation(parent, annotation, primary, owner, p, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Requires(value={"sourceDependencyLoader != null", "type != null"})
    @Ensures(value={"importNames != null", "rootLineNumberIterator != null"})
    protected void fetchSourceDependency() throws IOException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            String fileName;
            InputStream in;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$fetchSourceDependency();
                contractContext.leaveContract();
            }
            if ((in = this.sourceDependencyLoader.getResourceAsStream(fileName = this.type.getName().getBinaryName() + ".java.d")) == null) {
                throw new FileNotFoundException();
            }
            ObjectInputStream oin = new ObjectInputStream(in);
            try {
                this.importNames = (Set)oin.readObject();
                this.rootLineNumberIterator = ((List)oin.readObject()).iterator();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            oin.close();
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$fetchSourceDependency();
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="fetchSourceDependency")
    private /* synthetic */ void com$google$java$contract$P$fetchSourceDependency() {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$TypeBuilder$fetchSourceDependency(com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="fetchSourceDependency")
    private /* synthetic */ void com$google$java$contract$Q$fetchSourceDependency() {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$TypeBuilder$fetchSourceDependency();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitVariable(VariableElement variableElement, ElementModel elementModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void p;
            void e;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            ElementKind kind = null;
            switch (e.getKind()) {
                case ENUM_CONSTANT: {
                    kind = ElementKind.CONSTANT;
                    break;
                }
                default: {
                    kind = p.getKind().isType() ? ElementKind.FIELD : ElementKind.PARAMETER;
                }
            }
            VariableModel variable = new VariableModel(kind, e.getSimpleName().toString(), this.utils.getTypeNameForType(e.asType()));
            this.utils.copyModifiers((Element)e, variable);
            this.scanAnnotations((Element)e, true, this.type.getName(), variable);
            p.addEnclosedElement(variable);
            Void void_ = null;
            if (contractContext.tryEnterContract()) {
                Void void_2;
                void_ = void_2 = void_;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return void_;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitExecutable(ExecutableElement executableElement, ElementModel elementModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void p;
            void e;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            MethodModel exec = null;
            String name = e.getSimpleName().toString();
            if (p.getKind() == ElementKind.ENUM) {
                ExecutableType t = (ExecutableType)e.asType();
                if (name.equals("values")) {
                    if (t.getParameterTypes().isEmpty()) {
                        Void void_ = null;
                        if (contractContext.tryEnterContract()) {
                            Void void_2;
                            void_ = void_2 = void_;
                            if (bl) {
                                this.com$google$java$contract$I();
                            }
                            contractContext.leaveContract();
                        }
                        if (bl) {
                            contractContext.leave(this);
                        }
                        return void_;
                    }
                } else if (name.equals("valueOf")) {
                    List<TypeMirror> valueOfParameterTypes = Collections.singletonList(this.utils.elementUtils.getTypeElement("java.lang.String").asType());
                    if (((Object)t.getParameterTypes()).equals(valueOfParameterTypes)) {
                        Void void_ = null;
                        if (contractContext.tryEnterContract()) {
                            Void void_3;
                            void_ = void_3 = void_;
                            if (bl) {
                                this.com$google$java$contract$I();
                            }
                            contractContext.leaveContract();
                        }
                        if (bl) {
                            contractContext.leave(this);
                        }
                        return void_;
                    }
                }
            }
            exec = name.toString().equals("<init>") ? new MethodModel() : new MethodModel(ElementKind.METHOD, name, this.utils.getTypeNameForType(e.getReturnType()));
            this.utils.copyModifiers((Element)e, exec);
            List<? extends TypeParameterElement> genericTypes = e.getTypeParameters();
            for (TypeParameterElement typeParameterElement : genericTypes) {
                exec.addTypeParameter(this.utils.getGenericTypeName(typeParameterElement));
            }
            this.scan(e.getParameters(), exec);
            exec.setVariadic(e.isVarArgs());
            for (TypeMirror typeMirror : e.getThrownTypes()) {
                exec.addException(this.utils.getTypeNameForType(typeMirror));
            }
            this.scanAnnotations((Element)e, true, this.type.getName(), exec);
            p.addEnclosedElement(exec);
            this.addMethod(name, (ExecutableElement)e, exec);
            Void void_ = null;
            if (contractContext.tryEnterContract()) {
                Void void_2;
                void_ = void_2 = void_;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return void_;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addMethod(String string, ExecutableElement executableElement, MethodModel methodModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void exec;
            void e;
            void k;
            ArrayList<ContractableMethod> list;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if ((list = this.methodMap.get(k)) == null) {
                list = new ArrayList();
                this.methodMap.put((String)k, list);
            }
            list.add(new ContractableMethod((ExecutableElement)e, (MethodModel)exec));
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void scanSuper(TypeElement typeElement) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void e;
            TypeElement superElement;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if ((superElement = (TypeElement)this.utils.typeUtils.asElement(e.getSuperclass())) != null) {
                superElement.accept(new ContractExtensionBuilder(), this.type);
            }
            for (TypeMirror typeMirror : e.getInterfaces()) {
                TypeElement ifaceElement = (TypeElement)this.utils.typeUtils.asElement(typeMirror);
                ifaceElement.accept(new ContractExtensionBuilder(), this.type);
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={66L, 67L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$apt$TypeBuilder() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.diagnosticManager != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("diagnosticManager != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.methodMap != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("methodMap != null", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="visitType", lines={174L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$TypeBuilder$visitType(TypeElement e, ElementModel p, Void result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.type != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("type != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="fetchSourceDependency", lines={304L, 305L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$TypeBuilder$fetchSourceDependency(PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.sourceDependencyLoader != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("sourceDependencyLoader != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.type != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("type != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="fetchSourceDependency", lines={308L, 309L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$TypeBuilder$fetchSourceDependency() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.importNames != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("importNames != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.rootLineNumberIterator != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("rootLineNumberIterator != null", com$google$java$contract$local$exception$3));
        }
    }

    protected class ContractExtensionBuilder
    extends AbstractTypeBuilder {
        protected TypeElement mirror;

        public ContractExtensionBuilder() {
            super(TypeBuilder.this.utils, TypeBuilder.this.diagnosticManager);
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (contractContext.tryEnterContract()) {
                    if (this.getClass() == ContractExtensionBuilder.class) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (this.getClass() == ContractExtensionBuilder.class) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.INVARIANT)
        private /* synthetic */ void com$google$java$contract$I() {
            this.com$google$java$contract$IH$com$google$java$contract$core$apt$AbstractTypeBuilder();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Void visitType(TypeElement typeElement, ElementModel elementModel) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                void e;
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (this.mirror != null) {
                    throw new IllegalStateException();
                }
                this.mirror = e;
                this.scanAnnotations((Element)e, false, this.utils.getClassNameForType(e.asType()), TypeBuilder.this.type);
                this.scan(ElementFilter.methodsIn(e.getEnclosedElements()), TypeBuilder.this.type);
                TypeBuilder.this.scanSuper((TypeElement)e);
                Void void_ = null;
                if (contractContext.tryEnterContract()) {
                    Void void_2;
                    void_ = void_2 = void_;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return void_;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Void visitExecutable(ExecutableElement executableElement, ElementModel elementModel) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                void e;
                String name;
                ArrayList<ContractableMethod> candidates;
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if ((candidates = TypeBuilder.this.methodMap.get(name = e.getSimpleName().toString())) == null) {
                    Void void_ = null;
                    if (contractContext.tryEnterContract()) {
                        Void void_2;
                        void_ = void_2 = void_;
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return void_;
                }
                for (ContractableMethod overrider : candidates) {
                    if (!this.utils.elementUtils.overrides(overrider.mirror, (ExecutableElement)e, TypeBuilder.this.rootMirror)) continue;
                    this.scanAnnotations((Element)e, false, this.utils.getClassNameForType(this.mirror.asType()), overrider.element);
                }
                Void void_ = null;
                if (contractContext.tryEnterContract()) {
                    Void void_3;
                    void_ = void_3 = void_;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return void_;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }
    }

    protected class ContractableMethod {
        protected ExecutableElement mirror;
        protected MethodModel element;

        public ContractableMethod(ExecutableElement mirror, MethodModel element) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                this.mirror = mirror;
                this.element = element;
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }
    }
}

