/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModifier;
import com.google.java.contract.core.model.QualifiedElementModel;
import com.google.java.contract.core.model.TypeName;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import java.util.Iterator;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Invariant(value={"processingEnv != null", "elementUtils != null", "typeUtils != null"})
class FactoryUtils {
    ProcessingEnvironment processingEnv;
    Elements elementUtils;
    Types typeUtils;

    @Requires(value={"processingEnv != null"})
    @Ensures(value={"this.processingEnv == processingEnv", "elementUtils == processingEnv.getElementUtils()", "typeUtils == processingEnv.getTypeUtils()"})
    FactoryUtils(ProcessingEnvironment processingEnv) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$FactoryUtils(processingEnv);
                contractContext.leaveContract();
            }
            this.processingEnv = processingEnv;
            this.elementUtils = processingEnv.getElementUtils();
            this.typeUtils = processingEnv.getTypeUtils();
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$FactoryUtils(processingEnv);
                if (this.getClass() == FactoryUtils.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == FactoryUtils.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$FactoryUtils(ProcessingEnvironment processingEnv) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$FactoryUtils$FactoryUtils(processingEnv, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="<init>")
    private /* synthetic */ void com$google$java$contract$Q$FactoryUtils(ProcessingEnvironment processingEnv) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$FactoryUtils$FactoryUtils(processingEnv);
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$apt$FactoryUtils();
    }

    /*
     * WARNING - void declaration
     */
    void copyModifiers(Element element, QualifiedElementModel qualifiedElementModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void e;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            for (ElementModifier modifier : ElementModifier.forModifiers(e.getModifiers())) {
                void model;
                model.addModifier(modifier);
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"type != null", "type.getKind() == javax.lang.model.type.TypeKind.DECLARED"})
    @Ensures(value={"result == null || result.getDeclaredName().equals(type.toString())"})
    ClassName getClassNameForType(TypeMirror typeMirror) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void type;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getClassNameForType(typeMirror);
                contractContext.leaveContract();
            }
            DeclaredType tmp = (DeclaredType)type;
            TypeElement element = (TypeElement)tmp.asElement();
            String binaryName = this.elementUtils.getBinaryName(element).toString().replace('.', '/');
            ClassName className = new ClassName(binaryName, type.toString());
            if (contractContext.tryEnterContract()) {
                ClassName className2;
                className = className2 = className;
                this.com$google$java$contract$Q$getClassNameForType((TypeMirror)type, className2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return className;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getClassNameForType")
    private /* synthetic */ void com$google$java$contract$P$getClassNameForType(TypeMirror type) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$FactoryUtils$getClassNameForType(type, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getClassNameForType")
    private /* synthetic */ void com$google$java$contract$Q$getClassNameForType(TypeMirror type, ClassName result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$FactoryUtils$getClassNameForType(type, result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"type != null"})
    @Ensures(value={"result == null || result.getDeclaredName().equals(type.toString())"})
    TypeName getTypeNameForType(TypeMirror typeMirror) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void type;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getTypeNameForType(typeMirror);
                contractContext.leaveContract();
            }
            switch (type.getKind()) {
                case NONE: {
                    TypeName typeName = null;
                    if (contractContext.tryEnterContract()) {
                        TypeName typeName2;
                        typeName = typeName2 = typeName;
                        this.com$google$java$contract$Q$getTypeNameForType((TypeMirror)type, typeName2);
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return typeName;
                }
            }
            TypeName typeName = new TypeName(type.toString());
            if (contractContext.tryEnterContract()) {
                TypeName typeName3;
                typeName = typeName3 = typeName;
                this.com$google$java$contract$Q$getTypeNameForType((TypeMirror)type, typeName3);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return typeName;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getTypeNameForType")
    private /* synthetic */ void com$google$java$contract$P$getTypeNameForType(TypeMirror type) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$FactoryUtils$getTypeNameForType(type, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getTypeNameForType")
    private /* synthetic */ void com$google$java$contract$Q$getTypeNameForType(TypeMirror type, TypeName result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$FactoryUtils$getTypeNameForType(type, result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"element != null"})
    @Ensures(value={"result != null"})
    TypeName getGenericTypeName(TypeParameterElement typeParameterElement) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void element;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getGenericTypeName(typeParameterElement);
                contractContext.leaveContract();
            }
            String name = element.getSimpleName().toString();
            List<? extends TypeMirror> bounds = element.getBounds();
            if (bounds.isEmpty() || bounds.size() == 1 && ((Object)bounds.get(0)).toString().equals("java.lang.Object")) {
                TypeName typeName = new TypeName(name);
                if (contractContext.tryEnterContract()) {
                    TypeName typeName2;
                    typeName = typeName2 = typeName;
                    this.com$google$java$contract$Q$getGenericTypeName((TypeParameterElement)element, typeName2);
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return typeName;
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append(name);
            buffer.append(" extends ");
            Iterator<? extends TypeMirror> iter = bounds.iterator();
            while (true) {
                buffer.append(((Object)iter.next()).toString());
                if (!iter.hasNext()) break;
                buffer.append(" & ");
            }
            TypeName typeName = new TypeName(buffer.toString());
            if (contractContext.tryEnterContract()) {
                TypeName typeName3;
                typeName = typeName3 = typeName;
                this.com$google$java$contract$Q$getGenericTypeName((TypeParameterElement)element, typeName3);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return typeName;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getGenericTypeName")
    private /* synthetic */ void com$google$java$contract$P$getGenericTypeName(TypeParameterElement element) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$FactoryUtils$getGenericTypeName(element, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getGenericTypeName")
    private /* synthetic */ void com$google$java$contract$Q$getGenericTypeName(TypeParameterElement element, TypeName result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$FactoryUtils$getGenericTypeName(element, result);
    }

    /*
     * WARNING - void declaration
     */
    ElementKind getAnnotationKindForName(AnnotationMirror annotationMirror) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void annotation;
            String annotationName;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            ElementKind kind = (annotationName = annotation.getAnnotationType().toString()).equals("com.google.java.contract.Invariant") ? ElementKind.INVARIANT : (annotationName.equals("com.google.java.contract.Requires") ? ElementKind.REQUIRES : (annotationName.equals("com.google.java.contract.Ensures") ? ElementKind.ENSURES : (annotationName.equals("com.google.java.contract.ThrowEnsures") ? ElementKind.THROW_ENSURES : null)));
            ElementKind elementKind = kind;
            if (contractContext.tryEnterContract()) {
                ElementKind elementKind2;
                elementKind = elementKind2 = elementKind;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return elementKind;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isContractAnnotation(AnnotationMirror annotationMirror) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void annotation;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            boolean bl2 = this.getAnnotationKindForName((AnnotationMirror)annotation) != null;
            if (contractContext.tryEnterContract()) {
                boolean bl3;
                bl2 = bl3 = bl2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={49L, 50L, 51L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$apt$FactoryUtils() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.processingEnv != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("processingEnv != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.elementUtils != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("elementUtils != null", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = this.typeUtils != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new InvariantError("typeUtils != null", com$google$java$contract$local$exception$5));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={58L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$FactoryUtils$FactoryUtils(ProcessingEnvironment processingEnv, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = processingEnv != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("processingEnv != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={60L, 61L, 62L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$FactoryUtils$FactoryUtils(ProcessingEnvironment processingEnv) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.processingEnv == processingEnv;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("this.processingEnv == processingEnv", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.elementUtils == processingEnv.getElementUtils();
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("elementUtils == processingEnv.getElementUtils()", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = this.typeUtils == processingEnv.getTypeUtils();
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new PostconditionError("typeUtils == processingEnv.getTypeUtils()", com$google$java$contract$local$exception$5));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getClassNameForType", lines={82L, 83L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$FactoryUtils$getClassNameForType(TypeMirror type, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = type != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("type != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = type.getKind() == TypeKind.DECLARED;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("type.getKind() == javax.lang.model.type.TypeKind.DECLARED", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getClassNameForType", lines={85L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$FactoryUtils$getClassNameForType(TypeMirror type, ClassName result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result == null || result.getDeclaredName().equals(((Object)type).toString());
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result == null || result.getDeclaredName().equals(type.toString())", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getTypeNameForType", lines={97L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$FactoryUtils$getTypeNameForType(TypeMirror type, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = type != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("type != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getTypeNameForType", lines={98L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$FactoryUtils$getTypeNameForType(TypeMirror type, TypeName result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result == null || result.getDeclaredName().equals(((Object)type).toString());
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result == null || result.getDeclaredName().equals(type.toString())", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getGenericTypeName", lines={112L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$FactoryUtils$getGenericTypeName(TypeParameterElement element, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = element != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("element != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getGenericTypeName", lines={113L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$FactoryUtils$getGenericTypeName(TypeParameterElement element, TypeName result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }
}

