/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.Elements;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;

public class ContractJavaFileManager
extends ForwardingJavaFileManager<StandardJavaFileManager> {
    @Requires(value={"fileManager != null"})
    public ContractJavaFileManager(StandardJavaFileManager fileManager) {
        super(fileManager);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$ContractJavaFileManager(fileManager);
                contractContext.leaveContract();
            }
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$ContractJavaFileManager(StandardJavaFileManager fileManager) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractJavaFileManager$ContractJavaFileManager(fileManager, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void sibling;
            void location2;
            void className;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            String binaryName = className.replace('.', '/');
            String relativeName = ClassName.getRelativeName((String)className);
            relativeName = relativeName.endsWith("$com$google$java$contract$H") ? relativeName + JavaFileObject.Kind.CLASS.extension : relativeName + ".contracts";
            FileObject file = ((StandardJavaFileManager)this.fileManager).getFileForOutput((JavaFileManager.Location)location2, ClassName.getPackageName((String)className), relativeName, (FileObject)sibling);
            SimpleOutputJavaFileObject simpleOutputJavaFileObject = new SimpleOutputJavaFileObject(binaryName, file);
            if (contractContext.tryEnterContract()) {
                SimpleOutputJavaFileObject simpleOutputJavaFileObject2;
                simpleOutputJavaFileObject = simpleOutputJavaFileObject2 = simpleOutputJavaFileObject;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return simpleOutputJavaFileObject;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"location != null"})
    public List<? extends File> getLocation(JavaFileManager.Location location) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void location2;
            Iterable<? extends File> path;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$getLocation(location);
                contractContext.leaveContract();
            }
            if ((path = ((StandardJavaFileManager)this.fileManager).getLocation((JavaFileManager.Location)location2)) == null) {
                List<? extends File> list = null;
                if (contractContext.tryEnterContract()) {
                    List<? extends File> list2;
                    list = list2 = list;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return list;
            }
            ArrayList<File> locations = new ArrayList<File>();
            for (File file : path) {
                locations.add(file);
            }
            ArrayList<File> arrayList = locations;
            if (contractContext.tryEnterContract()) {
                ArrayList<File> arrayList2;
                arrayList = arrayList2 = arrayList;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getLocation")
    private /* synthetic */ void com$google$java$contract$P$getLocation(JavaFileManager.Location location) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractJavaFileManager$getLocation(location, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"location != null"})
    public void setLocation(JavaFileManager.Location location, List<? extends File> list) throws IOException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void path;
            void location2;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$setLocation(location, list);
                contractContext.leaveContract();
            }
            ((StandardJavaFileManager)this.fileManager).setLocation((JavaFileManager.Location)location2, (Iterable<? extends File>)path);
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="setLocation")
    private /* synthetic */ void com$google$java$contract$P$setLocation(JavaFileManager.Location location, List<? extends File> path) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractJavaFileManager$setLocation(location, path, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={75L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractJavaFileManager$ContractJavaFileManager(StandardJavaFileManager fileManager, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = fileManager != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("fileManager != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getLocation", lines={102L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractJavaFileManager$getLocation(JavaFileManager.Location location, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = location != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("location != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="setLocation", lines={122L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractJavaFileManager$setLocation(JavaFileManager.Location location, List<? extends File> path, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = location != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("location != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @Invariant(value={"file != null"})
    protected class SimpleOutputJavaFileObject
    extends SimpleJavaFileObject {
        protected FileObject file;

        @Requires(value={"binaryName != null", "file != null"})
        public SimpleOutputJavaFileObject(String binaryName, FileObject file) {
            super(Elements.getUriForClass(binaryName, JavaFileObject.Kind.CLASS), JavaFileObject.Kind.CLASS);
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                this.file = file;
                if (contractContext.tryEnterContract()) {
                    if (this.getClass() == SimpleOutputJavaFileObject.class) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (this.getClass() == SimpleOutputJavaFileObject.class) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.INVARIANT)
        private /* synthetic */ void com$google$java$contract$I() {
            this.com$google$java$contract$IH$com$google$java$contract$core$apt$ContractJavaFileManager$SimpleOutputJavaFileObject();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                OutputStream outputStream = this.file.openOutputStream();
                if (contractContext.tryEnterContract()) {
                    OutputStream outputStream2;
                    outputStream = outputStream2 = outputStream;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return outputStream;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, lines={52L})
        protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$apt$ContractJavaFileManager$SimpleOutputJavaFileObject() {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = this.file != null;
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                ContractRuntime.raise(new InvariantError("file != null", com$google$java$contract$local$exception$1));
            }
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={57L, 58L})
        protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractJavaFileManager$SimpleOutputJavaFileObject$SimpleOutputJavaFileObject(String binaryName, FileObject file, PreconditionError com$google$java$contract$local$error) {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = binaryName != null;
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                return new PreconditionError("binaryName != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
            }
            boolean com$google$java$contract$local$success$1 = false;
            Throwable com$google$java$contract$local$exception$3 = null;
            try {
                com$google$java$contract$local$success$1 = file != null;
            }
            catch (Throwable com$google$java$contract$local$exception$2) {
                com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
            }
            if (!com$google$java$contract$local$success$1) {
                return new PreconditionError("file != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
            }
            return null;
        }
    }
}

