/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.apt.ContractJavaFileManager;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

@Invariant(value={"javaCompiler != null", "fileManager != null"})
public class ContractJavaCompiler {
    protected static final List<String> OPTIONS;
    protected JavaCompiler javaCompiler;
    protected ContractJavaFileManager fileManager;

    public ContractJavaCompiler(String sourcePath, String classPath, String outputDirectory) throws IOException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            this.javaCompiler = ToolProvider.getSystemJavaCompiler();
            if (this.javaCompiler == null) {
                throw new IOException("no system JavaCompiler found; are you using a JRE instead of a JDK?");
            }
            this.fileManager = new ContractJavaFileManager(this.javaCompiler.getStandardFileManager(null, null, null));
            if (sourcePath != null) {
                this.setPath(StandardLocation.SOURCE_PATH, sourcePath);
            }
            if (classPath != null) {
                this.setPath(StandardLocation.CLASS_PATH, classPath);
            }
            if (outputDirectory != null) {
                this.setClassOutputDirectory(outputDirectory);
            }
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == ContractJavaCompiler.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == ContractJavaCompiler.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$apt$ContractJavaCompiler();
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"files != null", "diagnostics != null"})
    @Ensures(value={"result != null"})
    public JavaCompiler.CompilationTask getTask(List<? extends JavaFileObject> list, DiagnosticListener<JavaFileObject> diagnosticListener) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void files;
            void diagnostics;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getTask(list, diagnosticListener);
                contractContext.leaveContract();
            }
            JavaCompiler.CompilationTask compilationTask = this.javaCompiler.getTask(null, this.fileManager, (DiagnosticListener<? super JavaFileObject>)diagnostics, OPTIONS, null, (Iterable<? extends JavaFileObject>)files);
            if (contractContext.tryEnterContract()) {
                JavaCompiler.CompilationTask compilationTask2;
                compilationTask = compilationTask2 = compilationTask;
                this.com$google$java$contract$Q$getTask((List<? extends JavaFileObject>)files, (DiagnosticListener<JavaFileObject>)diagnostics, compilationTask2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return compilationTask;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getTask")
    private /* synthetic */ void com$google$java$contract$P$getTask(List<? extends JavaFileObject> files, DiagnosticListener<JavaFileObject> diagnostics) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractJavaCompiler$getTask(files, diagnostics, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getTask")
    private /* synthetic */ void com$google$java$contract$Q$getTask(List<? extends JavaFileObject> files, DiagnosticListener<JavaFileObject> diagnostics, JavaCompiler.CompilationTask result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractJavaCompiler$getTask(files, diagnostics, result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"location != null", "path != null"})
    protected void setPath(JavaFileManager.Location location, String string) throws IOException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void location2;
            void path;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$setPath(location, string);
                contractContext.leaveContract();
            }
            String[] parts = path.split(Pattern.quote(File.pathSeparator));
            ArrayList<File> dirs = new ArrayList<File>(parts.length);
            for (String part : parts) {
                dirs.add(new File(part));
            }
            this.fileManager.setLocation((JavaFileManager.Location)location2, dirs);
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="setPath")
    private /* synthetic */ void com$google$java$contract$P$setPath(JavaFileManager.Location location, String path) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractJavaCompiler$setPath(location, path, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"outputDirectory != null"})
    protected void setClassOutputDirectory(String string) throws IOException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void outputDirectory;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$setClassOutputDirectory(string);
                contractContext.leaveContract();
            }
            this.fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singletonList(new File((String)outputDirectory)));
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="setClassOutputDirectory")
    private /* synthetic */ void com$google$java$contract$P$setClassOutputDirectory(String outputDirectory) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractJavaCompiler$setClassOutputDirectory(outputDirectory, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    static {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractJavaCompiler.class);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            OPTIONS = Arrays.asList("-g:source,vars", "-proc:none", "-implicit:none");
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractJavaCompiler.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractJavaCompiler.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={47L, 48L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$apt$ContractJavaCompiler() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.javaCompiler != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("javaCompiler != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.fileManager != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("fileManager != null", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getTask", lines={95L, 96L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractJavaCompiler$getTask(List<? extends JavaFileObject> files, DiagnosticListener<JavaFileObject> diagnostics, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = files != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("files != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = diagnostics != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("diagnostics != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getTask", lines={98L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractJavaCompiler$getTask(List<? extends JavaFileObject> files, DiagnosticListener<JavaFileObject> diagnostics, JavaCompiler.CompilationTask result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="setPath", lines={106L, 107L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractJavaCompiler$setPath(JavaFileManager.Location location, String path, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = location != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("location != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = path != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("path != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="setClassOutputDirectory", lines={118L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractJavaCompiler$setClassOutputDirectory(String outputDirectory, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = outputDirectory != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("outputDirectory != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }
}

