/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.apt.FactoryUtils;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.BlacklistManager;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner6;

@Invariant(value={"this.contractedElements != null"})
public class ContractFinder
extends ElementScanner6<Boolean, Void> {
    private FactoryUtils utils;
    private Map<TypeElement, Boolean> contractedElements;
    private BlacklistManager blackList;

    @Requires(value={"utils != null"})
    public ContractFinder(FactoryUtils utils) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$ContractFinder(utils);
                contractContext.leaveContract();
            }
            this.utils = utils;
            this.contractedElements = new HashMap<TypeElement, Boolean>();
            this.blackList = BlacklistManager.getInstance();
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == ContractFinder.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == ContractFinder.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$ContractFinder(FactoryUtils utils) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractFinder$ContractFinder(utils, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$apt$ContractFinder();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Ensures(value={"result != null"})
    public Boolean visitType(TypeElement typeElement, Void void_) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void v;
            void e;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (this.contractedElements.containsKey(e)) {
                Boolean bl2 = this.contractedElements.get(e);
                if (contractContext.tryEnterContract()) {
                    Boolean bl3;
                    bl2 = bl3 = bl2;
                    this.com$google$java$contract$Q$visitType((TypeElement)e, (Void)v, bl3);
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl2;
            }
            if (this.blackList.isIgnored(e.getQualifiedName().toString())) {
                this.contractedElements.put((TypeElement)e, Boolean.FALSE);
                Boolean bl4 = Boolean.FALSE;
                if (contractContext.tryEnterContract()) {
                    Boolean bl5;
                    bl4 = bl5 = bl4;
                    this.com$google$java$contract$Q$visitType((TypeElement)e, (Void)v, bl5);
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl4;
            }
            this.contractedElements.put((TypeElement)e, Boolean.FALSE);
            Boolean contracted = this.isContractedType((TypeElement)e);
            this.contractedElements.put((TypeElement)e, contracted);
            Boolean bl6 = contracted;
            if (contractContext.tryEnterContract()) {
                Boolean bl7;
                bl6 = bl7 = bl6;
                this.com$google$java$contract$Q$visitType((TypeElement)e, (Void)v, bl7);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="visitType")
    private /* synthetic */ void com$google$java$contract$Q$visitType(TypeElement e, Void v, Boolean result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractFinder$visitType(e, v, result);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Ensures(value={"result != null"})
    public Boolean visitExecutable(ExecutableElement executableElement, Void void_) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void e;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            Boolean bl2 = this.hasContracts(e.getAnnotationMirrors());
            if (contractContext.tryEnterContract()) {
                void p;
                Boolean bl3;
                bl2 = bl3 = bl2;
                this.com$google$java$contract$Q$visitExecutable((ExecutableElement)e, (Void)p, bl3);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="visitExecutable")
    private /* synthetic */ void com$google$java$contract$Q$visitExecutable(ExecutableElement e, Void p, Boolean result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractFinder$visitExecutable(e, p, result);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Ensures(value={"result != null"})
    public Boolean visitVariable(VariableElement variableElement, Void void_) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            Boolean bl2 = Boolean.FALSE;
            if (contractContext.tryEnterContract()) {
                void p;
                void e;
                Boolean bl3;
                bl2 = bl3 = bl2;
                this.com$google$java$contract$Q$visitVariable((VariableElement)e, (Void)p, bl3);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="visitVariable")
    private /* synthetic */ void com$google$java$contract$Q$visitVariable(VariableElement e, Void p, Boolean result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractFinder$visitVariable(e, p, result);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Ensures(value={"result != null"})
    public Boolean visitPackage(PackageElement packageElement, Void void_) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            Boolean bl2 = Boolean.FALSE;
            if (contractContext.tryEnterContract()) {
                void p;
                void e;
                Boolean bl3;
                bl2 = bl3 = bl2;
                this.com$google$java$contract$Q$visitPackage((PackageElement)e, (Void)p, bl3);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="visitPackage")
    private /* synthetic */ void com$google$java$contract$Q$visitPackage(PackageElement e, Void p, Boolean result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractFinder$visitPackage(e, p, result);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Ensures(value={"result != null"})
    public Boolean visitTypeParameter(TypeParameterElement typeParameterElement, Void void_) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            Boolean bl2 = Boolean.FALSE;
            if (contractContext.tryEnterContract()) {
                void p;
                void e;
                Boolean bl3;
                bl2 = bl3 = bl2;
                this.com$google$java$contract$Q$visitTypeParameter((TypeParameterElement)e, (Void)p, bl3);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="visitTypeParameter")
    private /* synthetic */ void com$google$java$contract$Q$visitTypeParameter(TypeParameterElement e, Void p, Boolean result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractFinder$visitTypeParameter(e, p, result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"e != null"})
    @Ensures(value={"result != null"})
    private Boolean isContractedType(TypeElement typeElement) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            Iterator<Object> i$;
            Element superclass;
            void e;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$isContractedType(typeElement);
                contractContext.leaveContract();
            }
            Boolean result = Boolean.FALSE;
            result = this.hasContracts(e.getAnnotationMirrors());
            if (!result.booleanValue() && (superclass = this.utils.typeUtils.asElement(e.getSuperclass())) != null) {
                result = superclass.accept(this, null);
            }
            if (!result.booleanValue()) {
                TypeMirror i;
                Element iface;
                List<? extends TypeMirror> interfaces = e.getInterfaces();
                i$ = interfaces.iterator();
                while (i$.hasNext() && !(result = (iface = this.utils.typeUtils.asElement(i = (TypeMirror)i$.next())).accept(this, null)).booleanValue()) {
                }
            }
            if (!result.booleanValue()) {
                Element element;
                List<? extends Element> enclosed = e.getEnclosedElements();
                i$ = enclosed.iterator();
                while (i$.hasNext() && !(result = (element = (Element)i$.next()).accept(this, null)).booleanValue()) {
                }
            }
            Boolean bl2 = result;
            if (contractContext.tryEnterContract()) {
                Boolean bl3;
                bl2 = bl3 = bl2;
                this.com$google$java$contract$Q$isContractedType((TypeElement)e, bl3);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="isContractedType")
    private /* synthetic */ void com$google$java$contract$P$isContractedType(TypeElement e) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractFinder$isContractedType(e, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="isContractedType")
    private /* synthetic */ void com$google$java$contract$Q$isContractedType(TypeElement e, Boolean result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractFinder$isContractedType(e, result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"annotations != null"})
    @Ensures(value={"result != null"})
    private Boolean hasContracts(Collection<? extends AnnotationMirror> collection) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void annotations;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$hasContracts(collection);
                contractContext.leaveContract();
            }
            for (AnnotationMirror a : annotations) {
                if (!this.utils.isContractAnnotation(a)) continue;
                Boolean bl2 = Boolean.TRUE;
                if (contractContext.tryEnterContract()) {
                    Boolean bl3;
                    bl2 = bl3 = bl2;
                    this.com$google$java$contract$Q$hasContracts((Collection<? extends AnnotationMirror>)annotations, bl3);
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl2;
            }
            Boolean bl4 = Boolean.FALSE;
            if (contractContext.tryEnterContract()) {
                Boolean bl5;
                bl4 = bl5 = bl4;
                this.com$google$java$contract$Q$hasContracts((Collection<? extends AnnotationMirror>)annotations, bl5);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="hasContracts")
    private /* synthetic */ void com$google$java$contract$P$hasContracts(Collection<? extends AnnotationMirror> annotations) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractFinder$hasContracts(annotations, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="hasContracts")
    private /* synthetic */ void com$google$java$contract$Q$hasContracts(Collection<? extends AnnotationMirror> annotations, Boolean result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractFinder$hasContracts(annotations, result);
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={46L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$apt$ContractFinder() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.contractedElements != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("this.contractedElements != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={53L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractFinder$ContractFinder(FactoryUtils utils, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = utils != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("utils != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="visitType", lines={61L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractFinder$visitType(TypeElement e, Void v, Boolean result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="visitExecutable", lines={86L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractFinder$visitExecutable(ExecutableElement e, Void p, Boolean result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="visitVariable", lines={92L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractFinder$visitVariable(VariableElement e, Void p, Boolean result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="visitPackage", lines={99L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractFinder$visitPackage(PackageElement e, Void p, Boolean result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="visitTypeParameter", lines={106L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractFinder$visitTypeParameter(TypeParameterElement e, Void p, Boolean result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="isContractedType", lines={120L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractFinder$isContractedType(TypeElement e, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = e != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("e != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="isContractedType", lines={121L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractFinder$isContractedType(TypeElement e, Boolean result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="hasContracts", lines={164L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractFinder$hasContracts(Collection<? extends AnnotationMirror> annotations, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = annotations != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("annotations != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="hasContracts", lines={165L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractFinder$hasContracts(Collection<? extends AnnotationMirror> annotations, Boolean result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }
}

