/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.apt.ContractCreation;
import com.google.java.contract.core.apt.ContractExpressionCreationTrait;
import com.google.java.contract.core.apt.ContractExpressionTransformer;
import com.google.java.contract.core.apt.DiagnosticManager;
import com.google.java.contract.core.apt.MethodContractCreator;
import com.google.java.contract.core.model.ContractAnnotationModel;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.ContractMethodModel;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementVisitor$com$google$java$contract$H;
import com.google.java.contract.core.model.HelperTypeModel;
import com.google.java.contract.core.model.MethodModel;
import com.google.java.contract.core.model.TypeModel;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.ElementScanner;

@Invariant(value={"diagnosticManager != null", "transformer != null"})
public class ClassContractCreator
extends ElementScanner {
    protected DiagnosticManager diagnosticManager;
    protected TypeModel type;
    protected TypeModel helperType;
    protected ContractMethodModel invariant;
    protected ContractExpressionTransformer transformer;

    @Requires(value={"diagnosticManager != null"})
    public ClassContractCreator(DiagnosticManager diagnosticManager) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$ClassContractCreator(diagnosticManager);
                contractContext.leaveContract();
            }
            this.diagnosticManager = diagnosticManager;
            this.type = null;
            this.helperType = null;
            this.invariant = null;
            this.transformer = new ContractExpressionTransformer(diagnosticManager, false);
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == ClassContractCreator.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == ClassContractCreator.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$ClassContractCreator(DiagnosticManager diagnosticManager) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ClassContractCreator$ClassContractCreator(diagnosticManager, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$apt$ClassContractCreator();
    }

    public TypeModel getHelperType() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            TypeModel typeModel = this.helperType;
            if (contractContext.tryEnterContract()) {
                TypeModel typeModel2;
                typeModel = typeModel2 = typeModel;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return typeModel;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitType(TypeModel typeModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void type;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$visitType(typeModel);
                contractContext.leaveContract();
            }
            if (this.type != null) {
                ClassContractCreator creator = new ClassContractCreator(this.diagnosticManager);
                type.accept(creator);
                if (creator.getHelperType() != null) {
                    this.type.addEnclosedElement(creator.getHelperType());
                }
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            this.type = type;
            if (type.getKind() == ElementKind.INTERFACE) {
                this.helperType = new HelperTypeModel((TypeModel)type);
                super.visitType(this.helperType);
            } else {
                super.visitType((TypeModel)type);
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="visitType")
    private /* synthetic */ void com$google$java$contract$P$visitType(TypeModel type) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ElementVisitor$com$google$java$contract$H.com$google$java$contract$PH$com$google$java$contract$core$model$ElementVisitor$visitType(type, this, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitMethod(MethodModel methodModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void method;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$visitMethod(methodModel);
                contractContext.leaveContract();
            }
            method.accept(new MethodContractCreator(this.diagnosticManager));
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="visitMethod")
    private /* synthetic */ void com$google$java$contract$P$visitMethod(MethodModel method) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ElementVisitor$com$google$java$contract$H.com$google$java$contract$PH$com$google$java$contract$core$model$ElementVisitor$visitMethod(method, this, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitContractAnnotation(ContractAnnotationModel contractAnnotationModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void annotation;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$visitContractAnnotation(contractAnnotationModel);
                contractContext.leaveContract();
            }
            if (!annotation.getKind().equals((Object)ElementKind.INVARIANT)) {
                throw new IllegalArgumentException();
            }
            ContractExpressionCreationTrait trait = new ContractExpressionCreationTrait(this.transformer){

                @Override
                public String getExceptionName() {
                    return "com.google.java.contract.InvariantError";
                }
            };
            this.invariant = ContractCreation.createContractMethods(trait, this.invariant, (ContractAnnotationModel)annotation);
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="visitContractAnnotation")
    private /* synthetic */ void com$google$java$contract$P$visitContractAnnotation(ContractAnnotationModel annotation) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ElementVisitor$com$google$java$contract$H.com$google$java$contract$PH$com$google$java$contract$core$model$ElementVisitor$visitContractAnnotation(annotation, this, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={54L, 55L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$apt$ClassContractCreator() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.diagnosticManager != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("diagnosticManager != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.transformer != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("transformer != null", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={69L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ClassContractCreator$ClassContractCreator(DiagnosticManager diagnosticManager, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = diagnosticManager != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("diagnosticManager != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }
}

