/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ActivationRuleManager;
import com.google.java.contract.core.agent.ClassContractHandle;
import com.google.java.contract.core.agent.ContractAnalyzer;
import com.google.java.contract.core.agent.ContractFixingClassAdapter;
import com.google.java.contract.core.agent.ContractHandle;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.agent.LineNumberingClassAdapter;
import com.google.java.contract.core.agent.MethodContractHandle;
import com.google.java.contract.core.agent.SpecificationClassAdapter;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.DebugUtils;
import com.google.java.contract.util.Iterables;
import com.google.java.contract.util.Predicates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.MethodNode;

@Invariant(value={"methodStart != null", "methodEnd != null", "contracts != null", "ClassName.isBinaryName(className)", "methodName != null", "methodDesc != null", "Iterables.all(oldValueLocals, Predicates.between(0, null))", "Iterables.all(signalOldValueLocals, Predicates.between(0, null))"})
public class SpecificationMethodAdapter
extends AdviceAdapter {
    private static final Type CLASS_TYPE;
    private static final Type EXCEPTION_TYPE;
    private static final Type CONTRACT_RUNTIME_TYPE;
    private static final Type CONTRACT_CONTEXT_TYPE;
    private static final Method GET_CLASS_METHOD;
    private static final Method GET_CONTEXT_METHOD;
    private static final Method TRY_ENTER_CONTRACT_METHOD;
    private static final Method LEAVE_CONTRACT_METHOD;
    private static final Method TRY_ENTER_METHOD;
    private static final Method LEAVE_METHOD;
    protected Label methodStart;
    protected Label methodEnd;
    protected ContractAnalyzer contracts;
    protected String className;
    protected String methodName;
    protected String methodDesc;
    protected Type thisType;
    protected boolean statik;
    protected boolean isConstructor;
    protected boolean isStaticInit;
    protected int contextLocal;
    protected int checkInvariantsLocal;
    protected List<Integer> oldValueLocals;
    protected List<Integer> signalOldValueLocals;
    protected SpecificationClassAdapter classAdapter;
    protected boolean withPreconditions;
    protected boolean withPostconditions;
    protected boolean withInvariants;

    @Requires(value={"ca != null", "mv != null", "methodName != null", "methodDesc != null"})
    public SpecificationMethodAdapter(SpecificationClassAdapter ca, MethodVisitor mv, int access, String methodName, String methodDesc) {
        super(262144, mv, access, methodName, methodDesc);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$SpecificationMethodAdapter(ca, mv, access, methodName, methodDesc);
                contractContext.leaveContract();
            }
            this.methodStart = new Label();
            this.methodEnd = new Label();
            this.contracts = ca.getContracts();
            this.className = ca.getClassName();
            this.methodName = methodName;
            this.methodDesc = methodDesc;
            this.thisType = Type.getType("L" + this.className + ";");
            this.statik = (access & 8) != 0;
            this.isConstructor = methodName.equals("<init>");
            this.isStaticInit = methodName.endsWith("<clinit>");
            this.contextLocal = -1;
            this.checkInvariantsLocal = -1;
            this.oldValueLocals = new ArrayList<Integer>();
            this.signalOldValueLocals = new ArrayList<Integer>();
            this.classAdapter = ca;
            ActivationRuleManager am = ActivationRuleManager.getInstance();
            this.withPreconditions = am.hasPreconditionsEnabled(this.className);
            this.withPostconditions = am.hasPostconditionsEnabled(this.className);
            this.withInvariants = am.hasInvariantsEnabled(this.className);
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == SpecificationMethodAdapter.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == SpecificationMethodAdapter.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$SpecificationMethodAdapter(SpecificationClassAdapter ca, MethodVisitor mv, int access, String methodName, String methodDesc) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$SpecificationMethodAdapter(ca, mv, access, methodName, methodDesc, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$agent$SpecificationMethodAdapter();
    }

    @Requires(value={"label != null"})
    protected static boolean labelIsResolved(Label label) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(SpecificationMethodAdapter.class);
        try {
            if (contractContext.tryEnterContract()) {
                SpecificationMethodAdapter.com$google$java$contract$P$labelIsResolved(label);
                contractContext.leaveContract();
            }
            try {
                Label label2;
                label2.getOffset();
            }
            catch (IllegalStateException e) {
                boolean bl2 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl3;
                    bl2 = bl3 = bl2;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(SpecificationMethodAdapter.class);
                }
                return bl2;
            }
            boolean bl4 = true;
            if (contractContext.tryEnterContract()) {
                boolean bl5;
                bl4 = bl5 = bl4;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(SpecificationMethodAdapter.class);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(SpecificationMethodAdapter.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="labelIsResolved")
    private static /* synthetic */ void com$google$java$contract$P$labelIsResolved(Label label) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = SpecificationMethodAdapter.com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$labelIsResolved(label, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void index;
            void signature;
            void desc;
            void name;
            void end;
            void start;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (!SpecificationMethodAdapter.labelIsResolved((Label)start)) {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            if (!SpecificationMethodAdapter.labelIsResolved((Label)end)) {
                end = start;
            }
            super.visitLocalVariable((String)name, (String)desc, (String)signature, (Label)start, (Label)end, (int)index);
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Override
    protected void onMethodEnter() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (this.withPreconditions || this.withPostconditions || this.withInvariants) {
                this.enterContractedMethod();
                if (this.withPostconditions) {
                    this.allocateOldValues(ContractKind.OLD, this.oldValueLocals);
                    this.allocateOldValues(ContractKind.SIGNAL_OLD, this.signalOldValueLocals);
                }
                this.mark(this.methodStart);
                Label skip = this.enterBusySection();
                if (this.withInvariants && !this.statik && !this.isConstructor && !this.isStaticInit) {
                    this.invokeInvariants();
                }
                if (this.withPreconditions) {
                    this.invokePreconditions();
                }
                if (this.withPostconditions) {
                    this.invokeOldValues(ContractKind.OLD, this.oldValueLocals);
                    this.invokeOldValues(ContractKind.SIGNAL_OLD, this.signalOldValueLocals);
                }
                this.leaveBusySection(skip);
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onMethodExit(int n) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void opcode;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if ((this.withPreconditions || this.withPostconditions || this.withInvariants) && opcode != 191) {
                if (this.withPostconditions || this.withInvariants) {
                    Label skip = this.enterBusySection();
                    if (this.withPostconditions) {
                        Type returnType = Type.getReturnType(this.methodDesc);
                        int returnIndex = -1;
                        if (returnType.getSort() != 0) {
                            if (returnType.getSize() == 2) {
                                this.dup2();
                            } else {
                                this.dup();
                            }
                            returnIndex = this.newLocal(returnType);
                            this.storeLocal(returnIndex);
                        }
                        this.invokeCommonPostconditions(ContractKind.POST, this.oldValueLocals, returnIndex);
                    }
                    if (this.withInvariants && !this.statik) {
                        this.invokeInvariants();
                    }
                    this.leaveBusySection(skip);
                }
                this.leaveContractedMethod();
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitMaxs(int n, int n2) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void maxLocals;
            void maxStack;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (this.withPreconditions || this.withPostconditions || this.withInvariants) {
                this.mark(this.methodEnd);
                this.catchException(this.methodStart, this.methodEnd, null);
                if (this.withPostconditions) {
                    Label skipEx = new Label();
                    this.dup();
                    this.instanceOf(EXCEPTION_TYPE);
                    this.ifZCmp(153, skipEx);
                    Label skip = this.enterBusySection();
                    int throwIndex = this.newLocal(EXCEPTION_TYPE);
                    this.checkCast(EXCEPTION_TYPE);
                    this.storeLocal(throwIndex);
                    this.invokeCommonPostconditions(ContractKind.SIGNAL, this.signalOldValueLocals, throwIndex);
                    if (this.withInvariants && !this.statik) {
                        this.invokeInvariants();
                    }
                    this.loadLocal(throwIndex);
                    this.leaveBusySection(skip);
                    this.mark(skipEx);
                }
                this.leaveContractedMethod();
                this.throwException();
            }
            super.visitMaxs((int)maxStack, (int)maxLocals);
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"kind != null", "kind.isOld()", "list != null"})
    protected void allocateOldValues(ContractKind contractKind, List<Integer> list) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void list2;
            void kind;
            List<MethodContractHandle> olds;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$allocateOldValues(contractKind, list);
                contractContext.leaveContract();
            }
            if ((olds = this.contracts.getMethodHandles((ContractKind)kind, this.methodName, this.methodDesc, 0)).isEmpty()) {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            Integer[] locals = new Integer[olds.size()];
            for (MethodContractHandle h : olds) {
                int k = h.getKey();
                locals[k] = this.newLocal(Type.getReturnType(h.getContractMethod().desc));
                this.push((String)null);
                this.storeLocal(locals[k]);
            }
            list2.addAll(Arrays.asList(locals));
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="allocateOldValues")
    private /* synthetic */ void com$google$java$contract$P$allocateOldValues(ContractKind kind, List<Integer> list) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$allocateOldValues(kind, list, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"kind != null", "kind.isOld()", "list != null"})
    protected void invokeOldValues(ContractKind contractKind, List<Integer> list) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void kind;
            List<MethodContractHandle> olds;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$invokeOldValues(contractKind, list);
                contractContext.leaveContract();
            }
            if ((olds = this.contracts.getMethodHandles((ContractKind)kind, this.methodName, this.methodDesc, 0)).isEmpty()) {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            for (MethodContractHandle h : olds) {
                void list2;
                MethodNode contractMethod = this.injectContractMethod(h);
                int k = h.getKey();
                if (!this.statik) {
                    this.loadThis();
                }
                this.loadArgs();
                this.invokeContractMethod(contractMethod);
                this.storeLocal((Integer)list2.get(k));
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="invokeOldValues")
    private /* synthetic */ void com$google$java$contract$P$invokeOldValues(ContractKind kind, List<Integer> list) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$invokeOldValues(kind, list, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    protected void invokeInvariants() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            ClassContractHandle h;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if ((h = this.contracts.getClassHandle(ContractKind.INVARIANT)) == null) {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            MethodNode contractMethod = this.injectContractMethod(h);
            Label skipInvariants = new Label();
            if (this.isConstructor) {
                this.loadThis();
                this.invokeVirtual(this.thisType, GET_CLASS_METHOD);
                this.loadThisClass();
                this.ifCmp(CLASS_TYPE, 154, skipInvariants);
            } else {
                this.loadLocal(this.checkInvariantsLocal);
                this.ifZCmp(153, skipInvariants);
            }
            if (!this.statik) {
                this.loadThis();
            }
            this.invokeContractMethod(contractMethod);
            this.mark(skipInvariants);
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    protected void invokePreconditions() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            MethodContractHandle h;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if ((h = this.contracts.getMethodHandle(ContractKind.PRE, this.methodName, this.methodDesc, 0)) == null) {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            MethodNode contractMethod = this.injectContractMethod(h);
            if (!this.statik) {
                this.loadThis();
            }
            this.loadArgs();
            this.invokeContractMethod(contractMethod);
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"kind != null", "kind.isPostcondition()", "oldLocals != null", "extraIndex >= -1"})
    protected void invokeCommonPostconditions(ContractKind contractKind, List<Integer> list, int n) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void extraIndex;
            void oldLocals;
            void kind;
            MethodContractHandle h;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$invokeCommonPostconditions(contractKind, list, n);
                contractContext.leaveContract();
            }
            if ((h = this.contracts.getMethodHandle((ContractKind)kind, this.methodName, this.methodDesc, this.getPostDescOffset((List<Integer>)oldLocals, (int)extraIndex))) == null) {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            MethodNode contractMethod = this.injectContractMethod(h);
            if (!this.statik) {
                this.loadThis();
            }
            this.loadArgs();
            if (extraIndex != -1) {
                this.loadLocal((int)extraIndex);
            }
            for (Integer oldIndex : oldLocals) {
                this.loadLocal(oldIndex);
            }
            this.invokeContractMethod(contractMethod);
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="invokeCommonPostconditions")
    private /* synthetic */ void com$google$java$contract$P$invokeCommonPostconditions(ContractKind kind, List<Integer> oldLocals, int extraIndex) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$invokeCommonPostconditions(kind, oldLocals, extraIndex, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"oldLocals != null", "extraIndex >= -1"})
    @Ensures(value={"result >= 0"})
    protected int getPostDescOffset(List<Integer> list, int n) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void oldLocals;
            void extraIndex;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getPostDescOffset(list, n);
                contractContext.leaveContract();
            }
            int off = 0;
            if (extraIndex != -1) {
                ++off;
            }
            int n2 = off += oldLocals.size();
            if (contractContext.tryEnterContract()) {
                int n3;
                n2 = n3 = n2;
                this.com$google$java$contract$Q$getPostDescOffset((List<Integer>)oldLocals, (int)extraIndex, n3);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getPostDescOffset")
    private /* synthetic */ void com$google$java$contract$P$getPostDescOffset(List<Integer> oldLocals, int extraIndex) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$getPostDescOffset(oldLocals, extraIndex, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getPostDescOffset")
    private /* synthetic */ void com$google$java$contract$Q$getPostDescOffset(List<Integer> oldLocals, int extraIndex, int result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$agent$SpecificationMethodAdapter$getPostDescOffset(oldLocals, extraIndex, result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"handle != null"})
    @Ensures(value={"result != null"})
    protected MethodNode injectContractMethod(ContractHandle contractHandle) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void handle;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$injectContractMethod(contractHandle);
                contractContext.leaveContract();
            }
            MethodNode methodNode = handle.getContractMethod();
            if (!handle.isInjected()) {
                DebugUtils.info("instrument", "contract method " + this.className + "." + methodNode.name + methodNode.desc);
                ClassVisitor cv = this.classAdapter.getParent();
                List<Long> lineNumbers = handle.getLineNumbers();
                if (lineNumbers != null) {
                    cv = new LineNumberingClassAdapter(cv, lineNumbers);
                }
                methodNode.accept(new ContractFixingClassAdapter(cv));
                handle.setInjected(true);
            }
            MethodNode methodNode2 = methodNode;
            if (contractContext.tryEnterContract()) {
                MethodNode methodNode3;
                methodNode2 = methodNode3 = methodNode2;
                this.com$google$java$contract$Q$injectContractMethod((ContractHandle)handle, methodNode3);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return methodNode2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="injectContractMethod")
    private /* synthetic */ void com$google$java$contract$P$injectContractMethod(ContractHandle handle) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$injectContractMethod(handle, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="injectContractMethod")
    private /* synthetic */ void com$google$java$contract$Q$injectContractMethod(ContractHandle handle, MethodNode result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$agent$SpecificationMethodAdapter$injectContractMethod(handle, result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"contractMethod != null"})
    protected void invokeContractMethod(MethodNode methodNode) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void contractMethod;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$invokeContractMethod(methodNode);
                contractContext.leaveContract();
            }
            if (!this.statik) {
                this.mv.visitMethodInsn(183, this.className, contractMethod.name, contractMethod.desc);
            } else {
                this.mv.visitMethodInsn(184, this.className, contractMethod.name, contractMethod.desc);
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="invokeContractMethod")
    private /* synthetic */ void com$google$java$contract$P$invokeContractMethod(MethodNode contractMethod) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$invokeContractMethod(contractMethod, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Requires(value={"contextLocal >= 0", "checkInvariantsLocal >= 0"})
    @Ensures(value={"result != null"})
    protected Label enterBusySection() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$enterBusySection();
                contractContext.leaveContract();
            }
            Label skip = new Label();
            this.loadLocal(this.contextLocal);
            this.invokeVirtual(CONTRACT_CONTEXT_TYPE, TRY_ENTER_CONTRACT_METHOD);
            this.ifZCmp(153, skip);
            Label label = skip;
            if (contractContext.tryEnterContract()) {
                Label label2;
                label = label2 = label;
                this.com$google$java$contract$Q$enterBusySection(label2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return label;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="enterBusySection")
    private /* synthetic */ void com$google$java$contract$P$enterBusySection() {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$enterBusySection(com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="enterBusySection")
    private /* synthetic */ void com$google$java$contract$Q$enterBusySection(Label result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$agent$SpecificationMethodAdapter$enterBusySection(result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"contextLocal >= 0", "skip != null"})
    protected void leaveBusySection(Label label) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void skip;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$leaveBusySection(label);
                contractContext.leaveContract();
            }
            this.loadLocal(this.contextLocal);
            this.invokeVirtual(CONTRACT_CONTEXT_TYPE, LEAVE_CONTRACT_METHOD);
            this.mark((Label)skip);
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="leaveBusySection")
    private /* synthetic */ void com$google$java$contract$P$leaveBusySection(Label skip) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$leaveBusySection(skip, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    protected void loadThisClass() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.visitLdcInsn(this.thisType);
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Ensures(value={"contextLocal >= 0", "checkInvariantsLocal >= 0"})
    protected void enterContractedMethod() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.contextLocal = this.newLocal(CONTRACT_CONTEXT_TYPE);
            this.checkInvariantsLocal = this.newLocal(Type.BOOLEAN_TYPE);
            this.invokeStatic(CONTRACT_RUNTIME_TYPE, GET_CONTEXT_METHOD);
            this.dup();
            this.storeLocal(this.contextLocal);
            if (this.statik) {
                this.loadThisClass();
            } else {
                this.loadThis();
            }
            this.invokeVirtual(CONTRACT_CONTEXT_TYPE, TRY_ENTER_METHOD);
            this.storeLocal(this.checkInvariantsLocal);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$enterContractedMethod();
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="enterContractedMethod")
    private /* synthetic */ void com$google$java$contract$Q$enterContractedMethod() {
        this.com$google$java$contract$QH$com$google$java$contract$core$agent$SpecificationMethodAdapter$enterContractedMethod();
    }

    @Requires(value={"contextLocal >= 0"})
    protected void leaveContractedMethod() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$leaveContractedMethod();
                contractContext.leaveContract();
            }
            Label skip = new Label();
            this.loadLocal(this.checkInvariantsLocal);
            this.ifZCmp(153, skip);
            this.loadLocal(this.contextLocal);
            if (this.statik) {
                this.loadThisClass();
            } else {
                this.loadThis();
            }
            this.invokeVirtual(CONTRACT_CONTEXT_TYPE, LEAVE_METHOD);
            this.mark(skip);
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="leaveContractedMethod")
    private /* synthetic */ void com$google$java$contract$P$leaveContractedMethod() {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$leaveContractedMethod(com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    static {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(SpecificationMethodAdapter.class);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            CLASS_TYPE = Type.getObjectType("java/lang/Class");
            EXCEPTION_TYPE = Type.getObjectType("java/lang/Exception");
            CONTRACT_RUNTIME_TYPE = Type.getObjectType("com/google/java/contract/core/runtime/ContractRuntime");
            CONTRACT_CONTEXT_TYPE = Type.getObjectType("com/google/java/contract/core/runtime/ContractContext");
            GET_CLASS_METHOD = Method.getMethod("java.lang.Class getClass()");
            GET_CONTEXT_METHOD = Method.getMethod("com.google.java.contract.core.runtime.ContractContext getContext()");
            TRY_ENTER_CONTRACT_METHOD = Method.getMethod("boolean tryEnterContract()");
            LEAVE_CONTRACT_METHOD = Method.getMethod("void leaveContract()");
            TRY_ENTER_METHOD = Method.getMethod("boolean tryEnter(Object)");
            LEAVE_METHOD = Method.getMethod("void leave(Object)");
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(SpecificationMethodAdapter.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(SpecificationMethodAdapter.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={54L, 55L, 56L, 57L, 58L, 59L, 60L, 61L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$agent$SpecificationMethodAdapter() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.methodStart != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("methodStart != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.methodEnd != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("methodEnd != null", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = this.contracts != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new InvariantError("contracts != null", com$google$java$contract$local$exception$5));
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = ClassName.isBinaryName(this.className);
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            ContractRuntime.raise(new InvariantError("ClassName.isBinaryName(className)", com$google$java$contract$local$exception$7));
        }
        boolean com$google$java$contract$local$success$4 = false;
        Throwable com$google$java$contract$local$exception$9 = null;
        try {
            com$google$java$contract$local$success$4 = this.methodName != null;
        }
        catch (Throwable com$google$java$contract$local$exception$8) {
            com$google$java$contract$local$exception$9 = com$google$java$contract$local$exception$8;
        }
        if (!com$google$java$contract$local$success$4) {
            ContractRuntime.raise(new InvariantError("methodName != null", com$google$java$contract$local$exception$9));
        }
        boolean com$google$java$contract$local$success$5 = false;
        Throwable com$google$java$contract$local$exception$11 = null;
        try {
            com$google$java$contract$local$success$5 = this.methodDesc != null;
        }
        catch (Throwable com$google$java$contract$local$exception$10) {
            com$google$java$contract$local$exception$11 = com$google$java$contract$local$exception$10;
        }
        if (!com$google$java$contract$local$success$5) {
            ContractRuntime.raise(new InvariantError("methodDesc != null", com$google$java$contract$local$exception$11));
        }
        boolean com$google$java$contract$local$success$6 = false;
        Throwable com$google$java$contract$local$exception$13 = null;
        try {
            com$google$java$contract$local$success$6 = Iterables.all(this.oldValueLocals, Predicates.between(0, null));
        }
        catch (Throwable com$google$java$contract$local$exception$12) {
            com$google$java$contract$local$exception$13 = com$google$java$contract$local$exception$12;
        }
        if (!com$google$java$contract$local$success$6) {
            ContractRuntime.raise(new InvariantError("Iterables.all(oldValueLocals, Predicates.between(0, null))", com$google$java$contract$local$exception$13));
        }
        boolean com$google$java$contract$local$success$7 = false;
        Throwable com$google$java$contract$local$exception$15 = null;
        try {
            com$google$java$contract$local$success$7 = Iterables.all(this.signalOldValueLocals, Predicates.between(0, null));
        }
        catch (Throwable com$google$java$contract$local$exception$14) {
            com$google$java$contract$local$exception$15 = com$google$java$contract$local$exception$14;
        }
        if (!com$google$java$contract$local$success$7) {
            ContractRuntime.raise(new InvariantError("Iterables.all(signalOldValueLocals, Predicates.between(0, null))", com$google$java$contract$local$exception$15));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={127L, 128L, 129L, 130L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$SpecificationMethodAdapter(SpecificationClassAdapter ca, MethodVisitor mv, int access, String methodName, String methodDesc, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = ca != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("ca != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = mv != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("mv != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = methodName != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("methodName != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = methodDesc != null;
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            return new PreconditionError("methodDesc != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$7);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="labelIsResolved", lines={168L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$labelIsResolved(Label label, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = label != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("label != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="allocateOldValues", lines={321L, 322L, 323L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$allocateOldValues(ContractKind kind, List<Integer> list, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = kind.isOld();
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("kind.isOld()", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = list != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("list != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="invokeOldValues", lines={356L, 357L, 358L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$invokeOldValues(ContractKind kind, List<Integer> list, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = kind.isOld();
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("kind.isOld()", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = list != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("list != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="invokeCommonPostconditions", lines={455L, 456L, 457L, 458L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$invokeCommonPostconditions(ContractKind kind, List<Integer> oldLocals, int extraIndex, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = kind.isPostcondition();
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("kind.isPostcondition()", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = oldLocals != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("oldLocals != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = extraIndex >= -1;
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            return new PreconditionError("extraIndex >= -1", com$google$java$contract$local$error, com$google$java$contract$local$exception$7);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getPostDescOffset", lines={498L, 499L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$getPostDescOffset(List<Integer> oldLocals, int extraIndex, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = oldLocals != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("oldLocals != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = extraIndex >= -1;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("extraIndex >= -1", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getPostDescOffset", lines={501L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$SpecificationMethodAdapter$getPostDescOffset(List<Integer> oldLocals, int extraIndex, int result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result >= 0;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result >= 0", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="injectContractMethod", lines={521L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$injectContractMethod(ContractHandle handle, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = handle != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("handle != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="injectContractMethod", lines={522L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$SpecificationMethodAdapter$injectContractMethod(ContractHandle handle, MethodNode result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="invokeContractMethod", lines={542L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$invokeContractMethod(MethodNode contractMethod, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = contractMethod != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("contractMethod != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="enterBusySection", lines={558L, 559L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$enterBusySection(PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.contextLocal >= 0;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("contextLocal >= 0", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.checkInvariantsLocal >= 0;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("checkInvariantsLocal >= 0", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="enterBusySection", lines={561L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$SpecificationMethodAdapter$enterBusySection(Label result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="leaveBusySection", lines={574L, 575L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$leaveBusySection(Label skip, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.contextLocal >= 0;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("contextLocal >= 0", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = skip != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("skip != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="enterContractedMethod", lines={595L, 596L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$SpecificationMethodAdapter$enterContractedMethod() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.contextLocal >= 0;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("contextLocal >= 0", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.checkInvariantsLocal >= 0;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("checkInvariantsLocal >= 0", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="leaveContractedMethod", lines={616L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$SpecificationMethodAdapter$leaveContractedMethod(PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.contextLocal >= 0;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("contextLocal >= 0", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }
}

