/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.agent.ContractMethodSignatures;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import java.util.List;
import org.objectweb.asm.tree.MethodNode;

@Invariant(value={"getKind() != null", "ClassName.isBinaryName(getClassName())", "getKey() >= -1", "getLineNumbers() == null || ContractMethodSignatures.isLineNumberList(getLineNumbers())"})
public class ContractHandle {
    protected ContractKind kind;
    protected String className;
    protected int key;
    protected MethodNode contractMethod;
    protected List<Long> lineNumbers;
    protected boolean injected;

    @Requires(value={"kind != null", "ClassName.isBinaryName(className)", "contractMethod != null", "lineNumbers == null || ContractMethodSignatures.isLineNumberList(lineNumbers)"})
    @Ensures(value={"kind == getKind()", "className.equals(getClassName())", "contractMethod == getContractMethod()", "lineNumbers == getLineNumbers()", "!isInjected()"})
    protected ContractHandle(ContractKind kind, String className, MethodNode contractMethod, List<Long> lineNumbers) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$ContractHandle(kind, className, contractMethod, lineNumbers);
                contractContext.leaveContract();
            }
            this.kind = kind;
            this.className = className;
            this.key = ContractMethodSignatures.getId(contractMethod);
            this.contractMethod = contractMethod;
            if (!contractMethod.name.startsWith("com$google$java$contract$")) {
                contractMethod.name = "com$google$java$contract$S" + contractMethod.name;
            }
            this.lineNumbers = lineNumbers;
            this.injected = false;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$ContractHandle(kind, className, contractMethod, lineNumbers);
                if (this.getClass() == ContractHandle.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == ContractHandle.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$ContractHandle(ContractKind kind, String className, MethodNode contractMethod, List<Long> lineNumbers) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractHandle$ContractHandle(kind, className, contractMethod, lineNumbers, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="<init>")
    private /* synthetic */ void com$google$java$contract$Q$ContractHandle(ContractKind kind, String className, MethodNode contractMethod, List<Long> lineNumbers) {
        this.com$google$java$contract$QH$com$google$java$contract$core$agent$ContractHandle$ContractHandle(kind, className, contractMethod, lineNumbers);
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$agent$ContractHandle();
    }

    public ContractKind getKind() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            ContractKind contractKind = this.kind;
            if (contractContext.tryEnterContract()) {
                ContractKind contractKind2;
                contractKind = contractKind2 = contractKind;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return contractKind;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public String getClassName() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            String string = this.className;
            if (contractContext.tryEnterContract()) {
                String string2;
                string = string2 = string;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public int getKey() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            int n = this.key;
            if (contractContext.tryEnterContract()) {
                int n2;
                n = n2 = n;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return n;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public MethodNode getContractMethod() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            MethodNode methodNode = this.contractMethod;
            if (contractContext.tryEnterContract()) {
                MethodNode methodNode2;
                methodNode = methodNode2 = methodNode;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return methodNode;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public List<Long> getLineNumbers() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            List<Long> list = this.lineNumbers;
            if (contractContext.tryEnterContract()) {
                List<Long> list2;
                list = list2 = list;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return list;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public boolean isInjected() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            boolean bl2 = this.injected;
            if (contractContext.tryEnterContract()) {
                boolean bl3;
                bl2 = bl3 = bl2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Ensures(value={"injected == isInjected()"})
    public void setInjected(boolean bl) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl2 = contractContext.tryEnter(this);
        try {
            void injected;
            if (contractContext.tryEnterContract()) {
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.injected = injected;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$setInjected((boolean)injected);
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="setInjected")
    private /* synthetic */ void com$google$java$contract$Q$setInjected(boolean injected) {
        this.com$google$java$contract$QH$com$google$java$contract$core$agent$ContractHandle$setInjected(injected);
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={44L, 45L, 46L, 47L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$agent$ContractHandle() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getKind() != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("getKind() != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = ClassName.isBinaryName(this.getClassName());
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("ClassName.isBinaryName(getClassName())", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = this.getKey() >= -1;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new InvariantError("getKey() >= -1", com$google$java$contract$local$exception$5));
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = this.getLineNumbers() == null || ContractMethodSignatures.isLineNumberList(this.getLineNumbers());
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            ContractRuntime.raise(new InvariantError("getLineNumbers() == null || ContractMethodSignatures.isLineNumberList(getLineNumbers())", com$google$java$contract$local$exception$7));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={70L, 71L, 72L, 73L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractHandle$ContractHandle(ContractKind kind, String className, MethodNode contractMethod, List<Long> lineNumbers, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = ClassName.isBinaryName(className);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("ClassName.isBinaryName(className)", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = contractMethod != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("contractMethod != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = lineNumbers == null || ContractMethodSignatures.isLineNumberList(lineNumbers);
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            return new PreconditionError("lineNumbers == null || ContractMethodSignatures.isLineNumberList(lineNumbers)", com$google$java$contract$local$error, com$google$java$contract$local$exception$7);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={77L, 78L, 79L, 80L, 81L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$ContractHandle$ContractHandle(ContractKind kind, String className, MethodNode contractMethod, List<Long> lineNumbers) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind == this.getKind();
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("kind == getKind()", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = className.equals(this.getClassName());
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("className.equals(getClassName())", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = contractMethod == this.getContractMethod();
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new PostconditionError("contractMethod == getContractMethod()", com$google$java$contract$local$exception$5));
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = lineNumbers == this.getLineNumbers();
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            ContractRuntime.raise(new PostconditionError("lineNumbers == getLineNumbers()", com$google$java$contract$local$exception$7));
        }
        boolean com$google$java$contract$local$success$4 = false;
        Throwable com$google$java$contract$local$exception$9 = null;
        try {
            com$google$java$contract$local$success$4 = !this.isInjected();
        }
        catch (Throwable com$google$java$contract$local$exception$8) {
            com$google$java$contract$local$exception$9 = com$google$java$contract$local$exception$8;
        }
        if (!com$google$java$contract$local$success$4) {
            ContractRuntime.raise(new PostconditionError("!isInjected()", com$google$java$contract$local$exception$9));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="setInjected", lines={123L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$ContractHandle$setInjected(boolean injected) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = injected == this.isInjected();
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("injected == isInjected()", com$google$java$contract$local$exception$1));
        }
    }
}

