/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.stats;

import com.google.instrumentation.stats.DistributionAggregationDescriptor;
import com.google.instrumentation.stats.MeasurementDescriptor;
import com.google.instrumentation.stats.TagKey;
import com.google.instrumentation.stats.ViewDescriptor;
import java.util.Arrays;
import java.util.List;

public final class RpcConstants {
    public static final TagKey RPC_STATUS = TagKey.create("OpStatus");
    public static final TagKey RPC_CLIENT_METHOD = TagKey.create("method");
    public static final TagKey RPC_SERVER_METHOD = TagKey.create("method");
    private static final List<MeasurementDescriptor.BasicUnit> bytes = Arrays.asList(MeasurementDescriptor.BasicUnit.BYTES);
    private static final List<MeasurementDescriptor.BasicUnit> scalar = Arrays.asList(MeasurementDescriptor.BasicUnit.SCALAR);
    private static final List<MeasurementDescriptor.BasicUnit> seconds = Arrays.asList(MeasurementDescriptor.BasicUnit.SECONDS);
    public static final MeasurementDescriptor RPC_CLIENT_ERROR_COUNT = MeasurementDescriptor.create("/rpc/client/error_count", "RPC Errors", MeasurementDescriptor.MeasurementUnit.create(0, scalar));
    public static final MeasurementDescriptor RPC_CLIENT_REQUEST_BYTES = MeasurementDescriptor.create("/rpc/client/request_bytes", "Request MB", MeasurementDescriptor.MeasurementUnit.create(6, bytes));
    public static final MeasurementDescriptor RPC_CLIENT_RESPONSE_BYTES = MeasurementDescriptor.create("/rpc/client/response_bytes", "Response MB", MeasurementDescriptor.MeasurementUnit.create(6, bytes));
    public static final MeasurementDescriptor RPC_CLIENT_ROUNDTRIP_LATENCY = MeasurementDescriptor.create("/rpc/client/roundtrip_latency", "RPC roundtrip latency us", MeasurementDescriptor.MeasurementUnit.create(-6, seconds));
    public static final MeasurementDescriptor RPC_CLIENT_SERVER_ELAPSED_TIME = MeasurementDescriptor.create("/rpc/client/server_elapsed_time", "Server elapsed time in msecs", MeasurementDescriptor.MeasurementUnit.create(-3, seconds));
    public static final MeasurementDescriptor RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES = MeasurementDescriptor.create("/rpc/client/uncompressed_request_bytes", "Uncompressed Request MB", MeasurementDescriptor.MeasurementUnit.create(6, bytes));
    public static final MeasurementDescriptor RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES = MeasurementDescriptor.create("/rpc/client/uncompressed_response_bytes", "Uncompressed Request MB", MeasurementDescriptor.MeasurementUnit.create(6, bytes));
    public static final MeasurementDescriptor RPC_SERVER_ERROR_COUNT = MeasurementDescriptor.create("/rpc/server/error_count", "RPC Errors", MeasurementDescriptor.MeasurementUnit.create(0, scalar));
    public static final MeasurementDescriptor RPC_SERVER_REQUEST_BYTES = MeasurementDescriptor.create("/rpc/server/request_bytes", "Request MB", MeasurementDescriptor.MeasurementUnit.create(6, bytes));
    public static final MeasurementDescriptor RPC_SERVER_RESPONSE_BYTES = MeasurementDescriptor.create("/rpc/server/response_bytes", "Response MB", MeasurementDescriptor.MeasurementUnit.create(6, bytes));
    public static final MeasurementDescriptor RPC_SERVER_SERVER_ELAPSED_TIME = MeasurementDescriptor.create("/rpc/server/server_elapsed_time", "Server elapsed time in msecs", MeasurementDescriptor.MeasurementUnit.create(-3, seconds));
    public static final MeasurementDescriptor RPC_SERVER_SERVER_LATENCY = MeasurementDescriptor.create("/rpc/server/server_latency", "Latency in msecs", MeasurementDescriptor.MeasurementUnit.create(-3, seconds));
    public static final MeasurementDescriptor RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES = MeasurementDescriptor.create("/rpc/server/uncompressed_request_bytes", "Uncompressed Request MB", MeasurementDescriptor.MeasurementUnit.create(6, bytes));
    public static final MeasurementDescriptor RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES = MeasurementDescriptor.create("/rpc/server/uncompressed_response_bytes", "Uncompressed Request MB", MeasurementDescriptor.MeasurementUnit.create(6, bytes));
    private static final List<Double> RPC_BYTES_BUCKET_BOUNDARIES = Arrays.asList(0.0, 1024.0, 2048.0, 4096.0, 16384.0, 65536.0, 262144.0, 1048576.0, 4194304.0, 1.6777216E7, 6.7108864E7, 2.68435456E8, 1.073741824E9, 4.294967296E9);
    private static final List<Double> RPC_MILLIS_BUCKET_BOUNDARIES = Arrays.asList(0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 8.0, 10.0, 13.0, 16.0, 20.0, 25.0, 30.0, 40.0, 50.0, 65.0, 80.0, 100.0, 130.0, 160.0, 200.0, 250.0, 300.0, 400.0, 500.0, 650.0, 800.0, 1000.0, 2000.0, 5000.0, 10000.0, 20000.0, 50000.0, 100000.0);
    public static final ViewDescriptor.DistributionViewDescriptor RPC_CLIENT_ERROR_COUNT_VIEW = ViewDescriptor.DistributionViewDescriptor.create("rpc client error count", "RPC Errors", RPC_CLIENT_ERROR_COUNT, DistributionAggregationDescriptor.create(), Arrays.asList(RPC_STATUS, RPC_CLIENT_METHOD));
    public static final ViewDescriptor.DistributionViewDescriptor RPC_CLIENT_ROUNDTRIP_LATENCY_VIEW = ViewDescriptor.DistributionViewDescriptor.create("rpc client roundtrip latency", "Latency in msecs", RPC_CLIENT_ROUNDTRIP_LATENCY, DistributionAggregationDescriptor.create(RPC_MILLIS_BUCKET_BOUNDARIES), Arrays.asList(RPC_CLIENT_METHOD));
    public static final ViewDescriptor.DistributionViewDescriptor RPC_CLIENT_SERVER_ELAPSED_TIME_VIEW = ViewDescriptor.DistributionViewDescriptor.create("rpc client server_elapsed_time", "Server elapsed time in msecs", RPC_CLIENT_SERVER_ELAPSED_TIME, DistributionAggregationDescriptor.create(RPC_MILLIS_BUCKET_BOUNDARIES), Arrays.asList(RPC_CLIENT_METHOD));
    public static final ViewDescriptor.DistributionViewDescriptor RPC_CLIENT_REQUEST_BYTES_VIEW = ViewDescriptor.DistributionViewDescriptor.create("rpc client request_bytes", "Request MB", RPC_CLIENT_REQUEST_BYTES, DistributionAggregationDescriptor.create(RPC_BYTES_BUCKET_BOUNDARIES), Arrays.asList(RPC_CLIENT_METHOD));
    public static final ViewDescriptor.DistributionViewDescriptor RPC_CLIENT_RESPONSE_BYTES_VIEW = ViewDescriptor.DistributionViewDescriptor.create("/rpc/client/response_bytes", "Response MB", RPC_CLIENT_RESPONSE_BYTES, DistributionAggregationDescriptor.create(RPC_BYTES_BUCKET_BOUNDARIES), Arrays.asList(RPC_CLIENT_METHOD));
    public static final ViewDescriptor.DistributionViewDescriptor RPC_SERVER_ERROR_COUNT_VIEW = ViewDescriptor.DistributionViewDescriptor.create("rpc server error count", "RPC Errors", RPC_SERVER_ERROR_COUNT, DistributionAggregationDescriptor.create(), Arrays.asList(RPC_STATUS, RPC_SERVER_METHOD));
    public static final ViewDescriptor.DistributionViewDescriptor RPC_SERVER_SERVER_LATENCY_VIEW = ViewDescriptor.DistributionViewDescriptor.create("rpc server latency", "Latency in msecs", RPC_SERVER_SERVER_LATENCY, DistributionAggregationDescriptor.create(RPC_MILLIS_BUCKET_BOUNDARIES), Arrays.asList(RPC_SERVER_METHOD));
    public static final ViewDescriptor.DistributionViewDescriptor RPC_SERVER_SERVER_ELAPSED_TIME_VIEW = ViewDescriptor.DistributionViewDescriptor.create("rpc server elapsed_time", "Server elapsed time in msecs", RPC_SERVER_SERVER_ELAPSED_TIME, DistributionAggregationDescriptor.create(RPC_MILLIS_BUCKET_BOUNDARIES), Arrays.asList(RPC_SERVER_METHOD));
    public static final ViewDescriptor.DistributionViewDescriptor RPC_SERVER_REQUEST_BYTES_VIEW = ViewDescriptor.DistributionViewDescriptor.create("rpc server request_bytes", "Request MB", RPC_SERVER_REQUEST_BYTES, DistributionAggregationDescriptor.create(RPC_BYTES_BUCKET_BOUNDARIES), Arrays.asList(RPC_SERVER_METHOD));
    public static final ViewDescriptor.DistributionViewDescriptor RPC_SERVER_RESPONSE_BYTES_VIEW = ViewDescriptor.DistributionViewDescriptor.create("/rpc/server/response_bytes", "Response MB", RPC_SERVER_RESPONSE_BYTES, DistributionAggregationDescriptor.create(RPC_BYTES_BUCKET_BOUNDARIES), Arrays.asList(RPC_SERVER_METHOD));
    public static final ViewDescriptor.DistributionViewDescriptor RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES_VIEW = ViewDescriptor.DistributionViewDescriptor.create("/rpc/server/uncompressed_request_bytes", "Uncompressed Request MB", RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES, DistributionAggregationDescriptor.create(), Arrays.asList(RPC_SERVER_METHOD));
    public static final ViewDescriptor.DistributionViewDescriptor RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES_VIEW = ViewDescriptor.DistributionViewDescriptor.create("/rpc/server/uncompressed_response_bytes", "Uncompressed Request MB", RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES, DistributionAggregationDescriptor.create(), Arrays.asList(RPC_SERVER_METHOD));

    RpcConstants() {
        throw new AssertionError();
    }
}

