/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.json;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.UriTemplate;
import com.google.api.client.http.json.JsonHttpClient;
import com.google.api.client.util.GenericData;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JsonHttpRequest
extends GenericData {
    private final JsonHttpClient client;
    private final HttpMethod method;
    private final String uriTemplate;
    private final Object content;
    private HttpHeaders requestHeaders = new HttpHeaders();
    private HttpHeaders lastResponseHeaders;

    public JsonHttpRequest(JsonHttpClient client, HttpMethod method, String uriTemplate, Object content) {
        this.client = (JsonHttpClient)Preconditions.checkNotNull((Object)client);
        this.method = (HttpMethod)((Object)Preconditions.checkNotNull((Object)((Object)method)));
        this.uriTemplate = (String)Preconditions.checkNotNull((Object)uriTemplate);
        this.content = content;
    }

    public final HttpMethod getMethod() {
        return this.method;
    }

    public final String getUriTemplate() {
        return this.uriTemplate;
    }

    public final Object getJsonContent() {
        return this.content;
    }

    public final JsonHttpClient getClient() {
        return this.client;
    }

    public JsonHttpRequest setRequestHeaders(HttpHeaders headers) {
        this.requestHeaders = headers;
        return this;
    }

    public final HttpHeaders getRequestHeaders() {
        return this.requestHeaders;
    }

    public final HttpHeaders getLastResponseHeaders() {
        return this.lastResponseHeaders;
    }

    public final GenericUrl buildHttpRequestUrl() {
        return new GenericUrl(UriTemplate.expand(this.getClient().getBaseUrl(), this.uriTemplate, this, true));
    }

    public HttpRequest buildHttpRequest() throws IOException {
        HttpRequest request = this.client.buildHttpRequest(this.method, this.buildHttpRequestUrl(), this.content);
        request.getHeaders().putAll(this.getRequestHeaders());
        return request;
    }

    public HttpResponse executeUnparsed() throws IOException {
        HttpRequest request = this.buildHttpRequest();
        HttpResponse response = this.client.executeUnparsed(request);
        this.lastResponseHeaders = response.getHeaders();
        return response;
    }

    public InputStream executeAsInputStream() throws IOException {
        HttpResponse response = this.executeUnparsed();
        return response.getContent();
    }

    public void download(OutputStream outputStream) throws IOException {
        HttpResponse response = this.executeUnparsed();
        response.download(outputStream);
    }
}

