/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.AbstractHttpContent;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.LogContent;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultipartRelatedContent
extends AbstractHttpContent {
    private String boundary = "END_OF_PART";
    private final Collection<HttpContent> parts;
    private static final byte[] CR_LF = "\r\n".getBytes();
    private static final byte[] CONTENT_TYPE = "Content-Type: ".getBytes();
    private static final byte[] CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding: binary".getBytes();
    private static final byte[] TWO_DASHES = "--".getBytes();

    public MultipartRelatedContent(HttpContent firstPart, HttpContent ... otherParts) {
        ArrayList<HttpContent> parts = new ArrayList<HttpContent>(otherParts.length + 1);
        parts.add(firstPart);
        parts.addAll(Arrays.asList(otherParts));
        this.parts = parts;
    }

    public void forRequest(HttpRequest request) {
        request.setContent(this);
        request.getHeaders().setMimeVersion("1.0");
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        byte[] boundaryBytes = this.boundary.getBytes();
        out.write(TWO_DASHES);
        out.write(boundaryBytes);
        for (HttpContent part : this.parts) {
            String contentType = part.getType();
            if (contentType != null) {
                byte[] typeBytes = contentType.getBytes();
                out.write(CR_LF);
                out.write(CONTENT_TYPE);
                out.write(typeBytes);
            }
            out.write(CR_LF);
            if (!LogContent.isTextBasedContentType(contentType)) {
                out.write(CONTENT_TRANSFER_ENCODING);
                out.write(CR_LF);
            }
            out.write(CR_LF);
            part.writeTo(out);
            out.write(CR_LF);
            out.write(TWO_DASHES);
            out.write(boundaryBytes);
        }
        out.write(TWO_DASHES);
        out.flush();
    }

    @Override
    public long computeLength() throws IOException {
        byte[] boundaryBytes = this.boundary.getBytes();
        long result = TWO_DASHES.length * 2 + boundaryBytes.length;
        for (HttpContent part : this.parts) {
            long length = part.getLength();
            if (length < 0L) {
                return -1L;
            }
            String contentType = part.getType();
            if (contentType != null) {
                byte[] typeBytes = contentType.getBytes();
                result += (long)(CR_LF.length + CONTENT_TYPE.length + typeBytes.length);
            }
            if (!LogContent.isTextBasedContentType(contentType)) {
                result += (long)(CONTENT_TRANSFER_ENCODING.length + CR_LF.length);
            }
            result += (long)(CR_LF.length * 3) + length + (long)TWO_DASHES.length + (long)boundaryBytes.length;
        }
        return result;
    }

    @Override
    public String getType() {
        return "multipart/related; boundary=\"" + this.getBoundary() + "\"";
    }

    @Override
    public boolean retrySupported() {
        for (HttpContent onePart : this.parts) {
            if (onePart.retrySupported()) continue;
            return false;
        }
        return true;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public MultipartRelatedContent setBoundary(String boundary) {
        this.boundary = (String)Preconditions.checkNotNull((Object)boundary);
        return this;
    }

    public Collection<HttpContent> getParts() {
        return Collections.unmodifiableCollection(this.parts);
    }
}

