/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.GZipContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpParser;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.LogContent;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.util.Data;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.Strings;
import com.google.api.client.util.Types;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HttpRequest {
    public static final String USER_AGENT_SUFFIX = "Google-HTTP-Java-Client/1.6.0-beta (gzip)";
    private HttpExecuteInterceptor interceptor;
    private HttpHeaders headers = new HttpHeaders();
    private HttpHeaders responseHeaders = new HttpHeaders();
    private int numRetries = 10;
    private boolean disableContentLogging;
    private HttpContent content;
    private final HttpTransport transport;
    private HttpMethod method;
    private GenericUrl url;
    private int connectTimeout = 20000;
    private int readTimeout = 20000;
    private HttpUnsuccessfulResponseHandler unsuccessfulResponseHandler;
    private final Map<String, HttpParser> contentTypeToParserMap = new HashMap<String, HttpParser>();
    private boolean enableGZipContent;
    private boolean followRedirects = true;

    HttpRequest(HttpTransport transport, HttpMethod method) {
        this.transport = transport;
        this.method = method;
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public HttpRequest setMethod(HttpMethod method) {
        this.method = (HttpMethod)((Object)Preconditions.checkNotNull((Object)((Object)method)));
        return this;
    }

    public GenericUrl getUrl() {
        return this.url;
    }

    public HttpRequest setUrl(GenericUrl url) {
        this.url = (GenericUrl)Preconditions.checkNotNull((Object)url);
        return this;
    }

    public HttpContent getContent() {
        return this.content;
    }

    public HttpRequest setContent(HttpContent content) {
        this.content = content;
        return this;
    }

    public boolean getEnableGZipContent() {
        return this.enableGZipContent;
    }

    public HttpRequest setEnableGZipContent(boolean enableGZipContent) {
        this.enableGZipContent = enableGZipContent;
        return this;
    }

    public boolean getDisableContentLogging() {
        return this.disableContentLogging;
    }

    public HttpRequest setDisableContentLogging(boolean disableContentLogging) {
        this.disableContentLogging = disableContentLogging;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public HttpRequest setConnectTimeout(int connectTimeout) {
        Preconditions.checkArgument((connectTimeout >= 0 ? 1 : 0) != 0);
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public HttpRequest setReadTimeout(int readTimeout) {
        Preconditions.checkArgument((readTimeout >= 0 ? 1 : 0) != 0);
        this.readTimeout = readTimeout;
        return this;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public HttpRequest setHeaders(HttpHeaders headers) {
        this.headers = (HttpHeaders)Preconditions.checkNotNull((Object)headers);
        return this;
    }

    public HttpHeaders getResponseHeaders() {
        return this.responseHeaders;
    }

    public HttpRequest setResponseHeaders(HttpHeaders responseHeaders) {
        this.responseHeaders = (HttpHeaders)Preconditions.checkNotNull((Object)responseHeaders);
        return this;
    }

    public HttpExecuteInterceptor getInterceptor() {
        return this.interceptor;
    }

    public HttpRequest setInterceptor(HttpExecuteInterceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public HttpUnsuccessfulResponseHandler getUnsuccessfulResponseHandler() {
        return this.unsuccessfulResponseHandler;
    }

    public HttpRequest setUnsuccessfulResponseHandler(HttpUnsuccessfulResponseHandler unsuccessfulResponseHandler) {
        this.unsuccessfulResponseHandler = unsuccessfulResponseHandler;
        return this;
    }

    public int getNumberOfRetries() {
        return this.numRetries;
    }

    public HttpRequest setNumberOfRetries(int numRetries) {
        Preconditions.checkArgument((numRetries >= 0 ? 1 : 0) != 0);
        this.numRetries = numRetries;
        return this;
    }

    public void addParser(HttpParser parser) {
        String contentType = HttpRequest.normalizeMediaType(parser.getContentType());
        this.contentTypeToParserMap.put(contentType, parser);
    }

    public final HttpParser getParser(String contentType) {
        contentType = HttpRequest.normalizeMediaType(contentType);
        return this.contentTypeToParserMap.get(contentType);
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public HttpRequest setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public HttpResponse execute() throws IOException {
        boolean requiresRetry = false;
        boolean retrySupported = false;
        Preconditions.checkArgument((this.numRetries >= 0 ? 1 : 0) != 0);
        int retriesRemaining = this.numRetries;
        HttpResponse response = null;
        Preconditions.checkNotNull((Object)((Object)this.method));
        Preconditions.checkNotNull((Object)this.url);
        do {
            LowLevelHttpRequest lowLevelHttpRequest;
            if (response != null) {
                response.ignore();
            }
            if (this.interceptor != null) {
                this.interceptor.intercept(this);
            }
            String urlString = this.url.build();
            switch (this.method) {
                case DELETE: {
                    lowLevelHttpRequest = this.transport.buildDeleteRequest(urlString);
                    break;
                }
                default: {
                    lowLevelHttpRequest = this.transport.buildGetRequest(urlString);
                    break;
                }
                case HEAD: {
                    Preconditions.checkArgument((boolean)this.transport.supportsHead(), (Object)"HTTP transport doesn't support HEAD");
                    lowLevelHttpRequest = this.transport.buildHeadRequest(urlString);
                    break;
                }
                case PATCH: {
                    Preconditions.checkArgument((boolean)this.transport.supportsPatch(), (Object)"HTTP transport doesn't support PATCH");
                    lowLevelHttpRequest = this.transport.buildPatchRequest(urlString);
                    break;
                }
                case POST: {
                    lowLevelHttpRequest = this.transport.buildPostRequest(urlString);
                    break;
                }
                case PUT: {
                    lowLevelHttpRequest = this.transport.buildPutRequest(urlString);
                }
            }
            Logger logger = HttpTransport.LOGGER;
            boolean loggable = logger.isLoggable(Level.CONFIG);
            StringBuilder logbuf = null;
            if (loggable) {
                logbuf = new StringBuilder();
                logbuf.append("-------------- REQUEST  --------------").append(Strings.LINE_SEPARATOR);
                logbuf.append((Object)this.method).append(' ').append(urlString).append(Strings.LINE_SEPARATOR);
            }
            if (this.headers.getUserAgent() == null) {
                this.headers.setUserAgent(USER_AGENT_SUFFIX);
            } else {
                this.headers.setUserAgent(this.headers.getUserAgent() + " " + USER_AGENT_SUFFIX);
            }
            HashSet<String> headerNames = new HashSet<String>();
            for (Map.Entry<String, Object> headerEntry : this.headers.entrySet()) {
                String name = headerEntry.getKey();
                String lowerCase = name.toLowerCase();
                Preconditions.checkArgument((boolean)headerNames.add(lowerCase), (String)"multiple headers of the same name (headers are case insensitive): %s", (Object[])new Object[]{lowerCase});
                Object value = headerEntry.getValue();
                if (value == null) continue;
                Class<?> valueClass = value.getClass();
                if (value instanceof Iterable || valueClass.isArray()) {
                    for (Object repeatedValue : Types.iterableOf(value)) {
                        HttpRequest.addHeader(logger, logbuf, lowLevelHttpRequest, name, repeatedValue);
                    }
                    continue;
                }
                HttpRequest.addHeader(logger, logbuf, lowLevelHttpRequest, name, value);
            }
            HttpContent content = this.content;
            if (content != null) {
                String contentEncoding = content.getEncoding();
                long contentLength = content.getLength();
                String contentType = content.getType();
                if (contentLength != 0L && contentEncoding == null && LogContent.isTextBasedContentType(contentType) && (loggable && !this.disableContentLogging || logger.isLoggable(Level.ALL))) {
                    content = new LogContent(content, contentType, contentEncoding, contentLength);
                }
                if (this.enableGZipContent) {
                    content = new GZipContent(content, contentType);
                    contentEncoding = content.getEncoding();
                    contentLength = content.getLength();
                }
                if (loggable) {
                    if (contentType != null) {
                        logbuf.append("Content-Type: " + contentType).append(Strings.LINE_SEPARATOR);
                    }
                    if (contentEncoding != null) {
                        logbuf.append("Content-Encoding: " + contentEncoding).append(Strings.LINE_SEPARATOR);
                    }
                    if (contentLength >= 0L) {
                        logbuf.append("Content-Length: " + contentLength).append(Strings.LINE_SEPARATOR);
                    }
                }
                lowLevelHttpRequest.setContent(content);
            }
            if (loggable) {
                logger.config(logbuf.toString());
            }
            lowLevelHttpRequest.setTimeout(this.connectTimeout, this.readTimeout);
            response = new HttpResponse(this, lowLevelHttpRequest.execute());
            retrySupported = retriesRemaining > 0 && (content == null || content.retrySupported());
            requiresRetry = false;
            if (response.isSuccessStatusCode()) continue;
            boolean errorHandled = false;
            boolean redirectRequest = false;
            if (this.unsuccessfulResponseHandler != null) {
                errorHandled = this.unsuccessfulResponseHandler.handleResponse(this, response, retrySupported);
            }
            if (!errorHandled && this.getFollowRedirects() && this.isRedirected(response)) {
                this.handleRedirect(response);
                redirectRequest = true;
            }
            requiresRetry = errorHandled || redirectRequest;
            --retriesRemaining;
        } while (requiresRetry && retrySupported);
        if (!response.isSuccessStatusCode()) {
            throw new HttpResponseException(response);
        }
        return response;
    }

    private void handleRedirect(HttpResponse response) {
        String redirectLocation = response.getHeaders().getLocation();
        this.setUrl(new GenericUrl(redirectLocation));
        if (response.getStatusCode() == 303) {
            this.setMethod(HttpMethod.GET);
        }
    }

    private boolean isRedirected(HttpResponse response) {
        int statusCode = response.getStatusCode();
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return response.getHeaders().getLocation() != null;
            }
        }
        return false;
    }

    private static void addHeader(Logger logger, StringBuilder logbuf, LowLevelHttpRequest lowLevelHttpRequest, String name, Object value) {
        String stringValue;
        if (value == null || Data.isNull(value)) {
            return;
        }
        String string = stringValue = value instanceof Enum ? FieldInfo.of((Enum)value).getName() : value.toString();
        if (logbuf != null) {
            logbuf.append(name).append(": ");
            if ("Authorization".equals(name) && !logger.isLoggable(Level.ALL)) {
                logbuf.append("<Not Logged>");
            } else {
                logbuf.append(stringValue);
            }
            logbuf.append(Strings.LINE_SEPARATOR);
        }
        lowLevelHttpRequest.addHeader(name, stringValue);
    }

    public static String normalizeMediaType(String mediaType) {
        if (mediaType == null) {
            return null;
        }
        int semicolon = mediaType.indexOf(59);
        return semicolon == -1 ? mediaType : mediaType.substring(0, semicolon);
    }
}

