/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.json;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.http.json.JsonHttpParser;
import com.google.api.client.http.json.JsonHttpRequest;
import com.google.api.client.http.json.JsonHttpRequestInitializer;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class JsonHttpClient {
    static final Logger LOGGER = Logger.getLogger(JsonHttpClient.class.getName());
    private final HttpRequestFactory requestFactory;
    private final JsonHttpRequestInitializer jsonHttpRequestInitializer;
    @Deprecated
    private final String baseUrl;
    private final String rootUrl;
    private final String servicePath;
    private final String applicationName;
    private final JsonFactory jsonFactory;
    @Deprecated
    private JsonHttpParser jsonHttpParser;
    private final JsonObjectParser jsonObjectParser;
    @Deprecated
    private final boolean baseUrlUsed;

    @Deprecated
    protected final boolean isBaseUrlUsed() {
        return this.baseUrlUsed;
    }

    public final String getBaseUrl() {
        if (this.baseUrlUsed) {
            return this.baseUrl;
        }
        return this.rootUrl + this.servicePath;
    }

    public final String getRootUrl() {
        Preconditions.checkArgument((!this.baseUrlUsed ? 1 : 0) != 0);
        return this.rootUrl;
    }

    public final String getServicePath() {
        Preconditions.checkArgument((!this.baseUrlUsed ? 1 : 0) != 0);
        return this.servicePath;
    }

    public final String getApplicationName() {
        return this.applicationName;
    }

    public final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public final HttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public final JsonHttpRequestInitializer getJsonHttpRequestInitializer() {
        return this.jsonHttpRequestInitializer;
    }

    @Deprecated
    public final JsonHttpParser getJsonHttpParser() {
        if (this.jsonHttpParser == null) {
            this.jsonHttpParser = this.createParser();
        }
        return this.jsonHttpParser;
    }

    @Deprecated
    protected JsonHttpParser createParser() {
        return new JsonHttpParser(this.jsonFactory);
    }

    public final JsonObjectParser getJsonObjectParser() {
        return this.jsonObjectParser;
    }

    protected JsonHttpContent createSerializer(Object body) {
        return new JsonHttpContent(this.getJsonFactory(), body);
    }

    protected void initialize(JsonHttpRequest jsonHttpRequest) throws IOException {
        if (this.getJsonHttpRequestInitializer() != null) {
            this.getJsonHttpRequestInitializer().initialize(jsonHttpRequest);
        }
    }

    @Deprecated
    public JsonHttpClient(HttpTransport transport, JsonFactory jsonFactory, String baseUrl) {
        this(transport, null, null, jsonFactory, baseUrl, null);
    }

    public JsonHttpClient(HttpTransport transport, JsonFactory jsonFactory, String rootUrl, String servicePath, HttpRequestInitializer httpRequestInitializer) {
        this(transport, null, httpRequestInitializer, jsonFactory, null, rootUrl, servicePath, null);
    }

    @Deprecated
    protected JsonHttpClient(HttpTransport transport, JsonHttpRequestInitializer jsonHttpRequestInitializer, HttpRequestInitializer httpRequestInitializer, JsonFactory jsonFactory, String baseUrl, String applicationName) {
        this(transport, jsonHttpRequestInitializer, httpRequestInitializer, jsonFactory, null, baseUrl, applicationName);
    }

    @Deprecated
    protected JsonHttpClient(HttpTransport transport, JsonHttpRequestInitializer jsonHttpRequestInitializer, HttpRequestInitializer httpRequestInitializer, JsonFactory jsonFactory, JsonObjectParser jsonObjectParser, String baseUrl, String applicationName) {
        this.jsonHttpRequestInitializer = jsonHttpRequestInitializer;
        this.baseUrl = (String)Preconditions.checkNotNull((Object)baseUrl);
        Preconditions.checkArgument((boolean)baseUrl.endsWith("/"));
        this.applicationName = applicationName;
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
        this.jsonObjectParser = jsonObjectParser;
        Preconditions.checkNotNull((Object)transport);
        this.requestFactory = httpRequestInitializer == null ? transport.createRequestFactory() : transport.createRequestFactory(httpRequestInitializer);
        this.baseUrlUsed = true;
        this.rootUrl = null;
        this.servicePath = null;
    }

    protected JsonHttpClient(HttpTransport transport, JsonHttpRequestInitializer jsonHttpRequestInitializer, HttpRequestInitializer httpRequestInitializer, JsonFactory jsonFactory, JsonObjectParser jsonObjectParser, String rootUrl, String servicePath, String applicationName) {
        this.jsonHttpRequestInitializer = jsonHttpRequestInitializer;
        this.rootUrl = (String)Preconditions.checkNotNull((Object)rootUrl);
        Preconditions.checkArgument((boolean)rootUrl.endsWith("/"));
        this.servicePath = (String)Preconditions.checkNotNull((Object)servicePath);
        if (servicePath.length() > 0) {
            Preconditions.checkArgument((rootUrl.endsWith("/") && !servicePath.startsWith("/") ? 1 : 0) != 0);
        }
        this.applicationName = applicationName;
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
        Preconditions.checkNotNull((Object)transport);
        this.jsonObjectParser = jsonObjectParser;
        this.requestFactory = httpRequestInitializer == null ? transport.createRequestFactory() : transport.createRequestFactory(httpRequestInitializer);
        this.baseUrl = null;
        this.baseUrlUsed = false;
    }

    protected HttpRequest buildHttpRequest(HttpMethod method, GenericUrl url, Object body) throws IOException {
        HttpRequest httpRequest = this.requestFactory.buildRequest(method, url, null);
        JsonObjectParser parser = this.getJsonObjectParser();
        if (parser != null) {
            httpRequest.setParser(parser);
        } else {
            httpRequest.addParser(this.getJsonHttpParser());
        }
        if (this.getApplicationName() != null) {
            httpRequest.getHeaders().setUserAgent(this.getApplicationName());
        }
        if (body != null) {
            httpRequest.setContent(this.createSerializer(body));
        }
        return httpRequest;
    }

    protected HttpResponse executeUnparsed(HttpMethod method, GenericUrl url, Object body) throws IOException {
        HttpRequest request = this.buildHttpRequest(method, url, body);
        return this.executeUnparsed(request);
    }

    protected HttpResponse executeUnparsed(HttpRequest request) throws IOException {
        return request.execute();
    }

    protected InputStream executeAsInputStream(HttpMethod method, GenericUrl url, Object body) throws IOException {
        HttpResponse response = this.executeUnparsed(method, url, body);
        return response.getContent();
    }

    public static class Builder {
        private final HttpTransport transport;
        private JsonHttpRequestInitializer jsonHttpRequestInitializer;
        private HttpRequestInitializer httpRequestInitializer;
        private final JsonFactory jsonFactory;
        private JsonObjectParser jsonObjectParser;
        @Deprecated
        private GenericUrl baseUrl;
        private String rootUrl;
        private String servicePath;
        private String applicationName;
        @Deprecated
        private boolean baseUrlUsed;

        @Deprecated
        protected Builder(HttpTransport transport, JsonFactory jsonFactory, GenericUrl baseUrl) {
            this.transport = transport;
            this.jsonFactory = jsonFactory;
            this.baseUrlUsed = true;
            this.setBaseUrl(baseUrl);
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, String rootUrl, String servicePath, HttpRequestInitializer httpRequestInitializer) {
            this.transport = transport;
            this.jsonFactory = jsonFactory;
            this.setRootUrl(rootUrl);
            this.setServicePath(servicePath);
            this.httpRequestInitializer = httpRequestInitializer;
        }

        public JsonHttpClient build() {
            if (Strings.isNullOrEmpty((String)this.applicationName)) {
                LOGGER.warning("Application name is not set. Call setApplicationName.");
            }
            if (this.baseUrlUsed) {
                return new JsonHttpClient(this.transport, this.jsonHttpRequestInitializer, this.httpRequestInitializer, this.jsonFactory, this.jsonObjectParser, this.baseUrl.build(), this.applicationName);
            }
            return new JsonHttpClient(this.transport, this.jsonHttpRequestInitializer, this.httpRequestInitializer, this.jsonFactory, this.jsonObjectParser, this.rootUrl, this.servicePath, this.applicationName);
        }

        @Deprecated
        protected final boolean isBaseUrlUsed() {
            return this.baseUrlUsed;
        }

        public final JsonFactory getJsonFactory() {
            return this.jsonFactory;
        }

        public final HttpTransport getTransport() {
            return this.transport;
        }

        public final JsonObjectParser getObjectParser() {
            return this.jsonObjectParser;
        }

        public Builder setObjectParser(JsonObjectParser parser) {
            this.jsonObjectParser = parser;
            return this;
        }

        @Deprecated
        public final GenericUrl getBaseUrl() {
            Preconditions.checkArgument((boolean)this.baseUrlUsed);
            return this.baseUrl;
        }

        @Deprecated
        public Builder setBaseUrl(GenericUrl baseUrl) {
            Preconditions.checkArgument((boolean)this.baseUrlUsed);
            this.baseUrl = (GenericUrl)Preconditions.checkNotNull((Object)baseUrl);
            Preconditions.checkArgument((boolean)baseUrl.build().endsWith("/"));
            return this;
        }

        public final String getRootUrl() {
            Preconditions.checkArgument((!this.baseUrlUsed ? 1 : 0) != 0);
            return this.rootUrl;
        }

        public Builder setRootUrl(String rootUrl) {
            Preconditions.checkArgument((!this.baseUrlUsed ? 1 : 0) != 0);
            Preconditions.checkNotNull((Object)rootUrl);
            Preconditions.checkArgument((boolean)rootUrl.endsWith("/"));
            this.rootUrl = rootUrl;
            return this;
        }

        public final String getServicePath() {
            Preconditions.checkArgument((!this.baseUrlUsed ? 1 : 0) != 0);
            return this.servicePath;
        }

        public Builder setServicePath(String servicePath) {
            Preconditions.checkArgument((!this.baseUrlUsed ? 1 : 0) != 0);
            servicePath = (String)Preconditions.checkNotNull((Object)servicePath);
            if (servicePath.length() > 0) {
                Preconditions.checkArgument((servicePath.endsWith("/") && !servicePath.startsWith("/") ? 1 : 0) != 0);
            }
            this.servicePath = servicePath;
            return this;
        }

        public Builder setJsonHttpRequestInitializer(JsonHttpRequestInitializer jsonHttpRequestInitializer) {
            this.jsonHttpRequestInitializer = jsonHttpRequestInitializer;
            return this;
        }

        public JsonHttpRequestInitializer getJsonHttpRequestInitializer() {
            return this.jsonHttpRequestInitializer;
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            this.httpRequestInitializer = httpRequestInitializer;
            return this;
        }

        public final HttpRequestInitializer getHttpRequestInitializer() {
            return this.httpRequestInitializer;
        }

        public Builder setApplicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }
    }
}

