/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.xml.atom;

import com.google.api.client.util.Beta;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.Types;
import com.google.api.client.xml.Xml;
import com.google.api.client.xml.XmlNamespaceDictionary;
import com.google.api.client.xml.atom.Atom;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Beta
public abstract class AbstractAtomFeedParser<T> {
    private boolean feedParsed;
    private final XmlPullParser parser;
    private final InputStream inputStream;
    private final Class<T> feedClass;
    private final XmlNamespaceDictionary namespaceDictionary;

    protected AbstractAtomFeedParser(XmlNamespaceDictionary namespaceDictionary, XmlPullParser parser, InputStream inputStream, Class<T> feedClass) {
        this.namespaceDictionary = (XmlNamespaceDictionary)Preconditions.checkNotNull((Object)namespaceDictionary);
        this.parser = (XmlPullParser)Preconditions.checkNotNull((Object)parser);
        this.inputStream = (InputStream)Preconditions.checkNotNull((Object)inputStream);
        this.feedClass = (Class)Preconditions.checkNotNull(feedClass);
    }

    public final XmlPullParser getParser() {
        return this.parser;
    }

    public final InputStream getInputStream() {
        return this.inputStream;
    }

    public final Class<T> getFeedClass() {
        return this.feedClass;
    }

    public final XmlNamespaceDictionary getNamespaceDictionary() {
        return this.namespaceDictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T parseFeed() throws IOException, XmlPullParserException {
        boolean close = true;
        try {
            this.feedParsed = true;
            Object result = Types.newInstance(this.feedClass);
            Xml.parseElement(this.parser, result, this.namespaceDictionary, Atom.StopAtAtomEntry.INSTANCE);
            close = false;
            Object object = result;
            return (T)object;
        }
        finally {
            if (close) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parseNextEntry() throws IOException, XmlPullParserException {
        if (!this.feedParsed) {
            this.feedParsed = true;
            Xml.parseElement(this.parser, null, this.namespaceDictionary, Atom.StopAtAtomEntry.INSTANCE);
        }
        boolean close = true;
        try {
            if (this.parser.getEventType() == 2) {
                Object result = this.parseEntryInternal();
                this.parser.next();
                close = false;
                Object object = result;
                return object;
            }
        }
        finally {
            if (close) {
                this.close();
            }
        }
        return null;
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    protected abstract Object parseEntryInternal() throws IOException, XmlPullParserException;
}

