/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.protobuf;

import com.google.api.client.http.AbstractHttpContent;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.util.Preconditions;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.OutputStream;

public class ProtoHttpContent
extends AbstractHttpContent {
    private final MessageLite message;
    private String type = "application/x-protobuf";

    public ProtoHttpContent(MessageLite message) {
        super("application/x-protobuf");
        this.message = (MessageLite)Preconditions.checkNotNull((Object)message);
    }

    public long getLength() throws IOException {
        return this.message.getSerializedSize();
    }

    public String getType() {
        return this.type;
    }

    public void writeTo(OutputStream out) throws IOException {
        this.message.writeTo(out);
        out.flush();
    }

    public ProtoHttpContent setType(String type) {
        this.type = type;
        return this;
    }

    public final MessageLite getMessage() {
        return this.message;
    }

    public ProtoHttpContent setMediaType(HttpMediaType mediaType) {
        super.setMediaType(mediaType);
        return this;
    }
}

