/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.validation.client.impl;

import com.google.gwt.validation.client.impl.GwtValidationContext;
import com.google.gwt.validation.client.impl.metadata.ValidationGroupsMetadata;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.Validator;

public abstract class AbstractGwtValidator
implements Validator {
    private final Set<Class<?>> validGroups;
    private final ValidationGroupsMetadata validationGroupsMetadata;
    private ConstraintValidatorFactory contraintValidatorFactory;
    private MessageInterpolator messageInterpolator;
    private TraversableResolver traversableResolver;

    public AbstractGwtValidator() {
        this(ValidationGroupsMetadata.builder().build());
    }

    public AbstractGwtValidator(ValidationGroupsMetadata validationGroupsMetadata) {
        this.validGroups = validationGroupsMetadata.getAllGroupsAndSequences();
        this.validationGroupsMetadata = validationGroupsMetadata;
    }

    public ValidationGroupsMetadata getValidationGroupsMetadata() {
        return this.validationGroupsMetadata;
    }

    public void init(ConstraintValidatorFactory factory, MessageInterpolator messageInterpolator, TraversableResolver traversableResolver) {
        this.contraintValidatorFactory = factory;
        this.messageInterpolator = messageInterpolator;
        this.traversableResolver = traversableResolver;
    }

    public <T> T unwrap(Class<T> type) {
        throw new ValidationException();
    }

    public abstract <T> Set<ConstraintViolation<T>> validate(GwtValidationContext<T> var1, Object var2, Class<?> ... var3) throws ValidationException;

    protected void checkGroups(Class<?> ... groups) {
        if (!this.validGroups.containsAll(Arrays.asList(groups))) {
            HashSet unknown = new HashSet();
            unknown.addAll(Arrays.asList(groups));
            unknown.removeAll(this.validGroups);
            throw new IllegalArgumentException(this.getClass() + " only processes the following groups " + this.validGroups + ". " + "The following groups could not be processed " + unknown);
        }
    }

    protected void checkNotNull(Object object, String name) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(name + " can not be null.");
        }
    }

    protected ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.contraintValidatorFactory;
    }

    protected MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    protected TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }
}

