/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.client.LeafValueEditor;
import com.google.gwt.editor.client.adapters.TakesValueEditor;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.CommonResources;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.CellBasedWidgetImpl;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasKeyProvider;
import com.google.gwt.view.client.ProvidesKey;
import java.util.Set;

public class CellWidget<C>
extends Widget
implements HasKeyProvider<C>,
HasValue<C>,
IsEditor<LeafValueEditor<C>> {
    private final Cell<C> cell;
    private LeafValueEditor<C> editor;
    private final ProvidesKey<C> keyProvider;
    private C value;
    private final ValueUpdater<C> valueUpdater = new ValueUpdater<C>(){

        @Override
        public void update(C value) {
            CellWidget.this.setValue(value, true, false);
        }
    };

    private static Element createDefaultWrapperElement() {
        DivElement div = Document.get().createDivElement();
        div.setClassName(CommonResources.getInlineBlockStyle());
        return div;
    }

    public CellWidget(Cell<C> cell) {
        this(cell, null, null);
    }

    public CellWidget(Cell<C> cell, ProvidesKey<C> keyProvider) {
        this(cell, null, keyProvider);
    }

    public CellWidget(Cell<C> cell, C initialValue) {
        this(cell, initialValue, null);
    }

    public CellWidget(Cell<C> cell, C initialValue, ProvidesKey<C> keyProvider) {
        this(cell, initialValue, keyProvider, CellWidget.createDefaultWrapperElement());
    }

    protected CellWidget(Cell<C> cell, C initialValue, ProvidesKey<C> keyProvider, Element elem) {
        this.cell = cell;
        this.keyProvider = keyProvider;
        this.setElement(elem);
        CellBasedWidgetImpl.get().sinkEvents(this, cell.getConsumedEvents());
        this.value = initialValue;
        this.redraw();
    }

    @Override
    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<C> handler) {
        return this.addHandler(handler, ValueChangeEvent.getType());
    }

    @Override
    public LeafValueEditor<C> asEditor() {
        if (this.editor == null) {
            this.editor = TakesValueEditor.of(this);
        }
        return this.editor;
    }

    public Cell<C> getCell() {
        return this.cell;
    }

    @Override
    public ProvidesKey<C> getKeyProvider() {
        return this.keyProvider;
    }

    @Override
    public C getValue() {
        return this.value;
    }

    @Override
    public void onBrowserEvent(Event event) {
        CellBasedWidgetImpl.get().onBrowserEvent(this, event);
        super.onBrowserEvent(event);
        String eventType = event.getType();
        Set<String> consumedEvents = this.cell.getConsumedEvents();
        if (consumedEvents != null && consumedEvents.contains(eventType)) {
            this.cell.onBrowserEvent(this.createContext(), this.getElement(), this.value, event, this.valueUpdater);
        }
    }

    public void redraw() {
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        this.cell.render(this.createContext(), this.value, sb);
        this.getElement().setInnerSafeHtml(sb.toSafeHtml());
        Element child = this.getElement().getFirstChildElement();
        if (child != null && child.getNextSiblingElement() == null) {
            child.getStyle().setHeight(100.0, Style.Unit.PCT);
            child.getStyle().setWidth(100.0, Style.Unit.PCT);
        }
    }

    @Override
    public void setValue(C value) {
        this.setValue(value, false, true);
    }

    @Override
    public void setValue(C value, boolean fireEvents) {
        this.setValue(value, fireEvents, true);
    }

    public void setValue(C value, boolean fireEvents, boolean redraw) {
        C oldValue = this.getValue();
        if (!(value == oldValue || oldValue != null && oldValue.equals(value))) {
            this.value = value;
            if (redraw) {
                this.redraw();
            }
            if (fireEvents) {
                ValueChangeEvent.fire(this, value);
            }
        }
    }

    private Cell.Context createContext() {
        return new Cell.Context(0, 0, this.getKey(this.value));
    }

    private Object getKey(C value) {
        return this.keyProvider == null || value == null ? value : this.keyProvider.getKey(value);
    }
}

