/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.apt;

import com.google.gwt.dev.util.Name;
import com.google.web.bindery.requestfactory.apt.Finder;
import com.google.web.bindery.requestfactory.apt.HaltException;
import com.google.web.bindery.requestfactory.apt.Messages;
import com.google.web.bindery.requestfactory.apt.State;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

@SupportedAnnotationTypes(value={"*"})
@SupportedOptions(value={"rootOverride", "suppressErrors", "suppressWarnings", "verbose"})
public class RfValidator
extends AbstractProcessor {
    private boolean clientOnly;
    private boolean mustResolveAllMappings;
    private List<String> rootOverride;
    private boolean forceErrors;
    private State state;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        String option = processingEnv.getOptions().get("rootOverride");
        if (option != null) {
            this.setRootOverride(Arrays.asList(option.split(",")));
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.state = null;
            return false;
        }
        if (this.state == null) {
            State state = this.state = this.forceErrors ? new State.ForTesting(this.processingEnv) : new State(this.processingEnv);
            if (this.state.isPoisoned()) {
                return false;
            }
            this.state.setClientOnly(this.clientOnly);
            this.state.setMustResolveAllMappings(this.mustResolveAllMappings);
        }
        try {
            new Finder().scan(this.getTypesToProcess(this.state, roundEnv), this.state);
            this.state.executeJobs();
        }
        catch (HaltException haltException) {
            // empty catch block
        }
        return false;
    }

    public void setClientOnly(boolean clientOnly) {
        this.clientOnly = clientOnly;
    }

    void setForceErrors(boolean forceErrors) {
        this.forceErrors = forceErrors;
    }

    void setMustResolveAllMappings(boolean requireAll) {
        this.mustResolveAllMappings = requireAll;
    }

    void setRootOverride(List<String> binaryTypeNames) {
        this.rootOverride = binaryTypeNames;
    }

    private Set<TypeElement> getTypesToProcess(State state, RoundEnvironment roundEnv) {
        if (this.rootOverride == null) {
            return ElementFilter.typesIn(roundEnv.getRootElements());
        }
        HashSet<TypeElement> toScan = new HashSet<TypeElement>();
        for (String binaryTypeName : this.rootOverride) {
            TypeElement found = state.elements.getTypeElement(Name.BinaryName.toSourceName(binaryTypeName.trim()));
            if (found == null) {
                state.poison(null, Messages.noSuchType(binaryTypeName));
                continue;
            }
            toScan.add(found);
        }
        this.rootOverride = null;
        return toScan;
    }
}

