/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dom.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.DOMImpl;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NodeList;

public class Node
extends JavaScriptObject {
    public static final short ELEMENT_NODE = 1;
    public static final short TEXT_NODE = 3;
    public static final short DOCUMENT_NODE = 9;

    public static Node as(JavaScriptObject o) {
        assert (Node.is(o));
        return (Node)o;
    }

    public static native boolean is(JavaScriptObject var0);

    protected Node() {
    }

    public final native <T extends Node> T appendChild(T var1);

    public final native Node cloneNode(boolean var1);

    public final Node getChild(int index) {
        assert (index >= 0 && index < this.getChildCount()) : "Child index out of bounds";
        return this.getChildNodes().getItem(index);
    }

    public final int getChildCount() {
        return this.getChildNodes().getLength();
    }

    public final native NodeList<Node> getChildNodes();

    public final native Node getFirstChild();

    public final native Node getLastChild();

    public final native Node getNextSibling();

    public final native String getNodeName();

    public final native short getNodeType();

    public final native String getNodeValue();

    public final native Document getOwnerDocument();

    public final Element getParentElement() {
        return DOMImpl.impl.getParentElement(this);
    }

    public final native Node getParentNode();

    public final native Node getPreviousSibling();

    public final native boolean hasChildNodes();

    public final boolean hasParentElement() {
        return this.getParentElement() != null;
    }

    public final Node insertAfter(Node newChild, Node refChild) {
        Node next;
        assert (newChild != null) : "Cannot add a null child node";
        Node node = next = refChild == null ? null : refChild.getNextSibling();
        if (next == null) {
            return this.appendChild(newChild);
        }
        return this.insertBefore(newChild, next);
    }

    public final native Node insertBefore(Node var1, Node var2);

    public final Node insertFirst(Node child) {
        assert (child != null) : "Cannot add a null child node";
        return this.insertBefore(child, this.getFirstChild());
    }

    public final boolean isOrHasChild(Node child) {
        assert (child != null) : "Child cannot be null";
        return DOMImpl.impl.isOrHasChild(this, child);
    }

    public final native Node removeChild(Node var1);

    public final native Node removeAllChildren();

    public final void removeFromParent() {
        Element parent = this.getParentElement();
        if (parent != null) {
            parent.removeChild(this);
        }
    }

    public final native Node replaceChild(Node var1, Node var2);

    public final native void setNodeValue(String var1);
}

